/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import com.google.api.client.util.ArrayMap;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.MetricUpdate;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.metrics.BoundedTrieData;
import org.apache.beam.runners.dataflow.DataflowClient;
import org.apache.beam.runners.dataflow.DataflowPipelineJob;
import org.apache.beam.sdk.metrics.BoundedTrieResult;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricFiltering;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataflowMetrics
extends MetricResults {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataflowMetrics.class);
    private @UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient;
    private @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob dataflowPipelineJob;
    private @Nullable @UnknownKeyFor @Initialized JobMetrics cachedMetricResults = null;

    public DataflowMetrics(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob dataflowPipelineJob, @UnknownKeyFor @NonNull @Initialized DataflowClient dataflowClient) {
        this.dataflowClient = dataflowClient;
        this.dataflowPipelineJob = dataflowPipelineJob;
    }

    private @UnknownKeyFor @NonNull @Initialized MetricQueryResults populateMetricQueryResults(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetricUpdate> metricUpdates, @UnknownKeyFor @NonNull @Initialized MetricsFilter filter) {
        return DataflowMetricQueryResultsFactory.create(this.dataflowPipelineJob, metricUpdates, filter).build();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricQueryResults queryMetrics(@UnknownKeyFor @NonNull @Initialized MetricsFilter filter) {
        JobMetrics jobMetrics;
        ImmutableList counters = ImmutableList.of();
        ImmutableList distributions = ImmutableList.of();
        ImmutableList gauges = ImmutableList.of();
        ImmutableList stringSets = ImmutableList.of();
        ImmutableList boundedTries = ImmutableList.of();
        try {
            jobMetrics = this.getJobMetrics();
        }
        catch (IOException e) {
            LOG.warn("Unable to query job metrics.\n");
            return MetricQueryResults.create((Iterable)counters, (Iterable)distributions, (Iterable)gauges, (Iterable)stringSets, (Iterable)boundedTries, Collections.emptyList());
        }
        List metricUpdates = (List)MoreObjects.firstNonNull((Object)jobMetrics.getMetrics(), Collections.emptyList());
        return this.populateMetricQueryResults(metricUpdates, filter);
    }

    private @UnknownKeyFor @NonNull @Initialized JobMetrics getJobMetrics() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.cachedMetricResults != null) {
            return this.cachedMetricResults;
        }
        JobMetrics result = this.dataflowClient.getJobMetrics(this.dataflowPipelineJob.getJobId());
        if (this.dataflowPipelineJob.getState().isTerminal()) {
            this.cachedMetricResults = result;
        }
        return result;
    }

    private static class DataflowMetricQueryResultsFactory {
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricUpdate> metricUpdates;
        private final @UnknownKeyFor @NonNull @Initialized MetricsFilter filter;
        private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized MetricUpdate> tentativeByName;
        private final @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized MetricKey, @UnknownKeyFor @NonNull @Initialized MetricUpdate> committedByName;
        private final @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized MetricKey> metricHashKeys;
        private final @UnknownKeyFor @NonNull @Initialized DataflowPipelineJob dataflowPipelineJob;

        public static @UnknownKeyFor @NonNull @Initialized DataflowMetricQueryResultsFactory create(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob dataflowPipelineJob, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricUpdate> metricUpdates, @UnknownKeyFor @NonNull @Initialized MetricsFilter filter) {
            return new DataflowMetricQueryResultsFactory(dataflowPipelineJob, metricUpdates, filter);
        }

        private DataflowMetricQueryResultsFactory(@UnknownKeyFor @NonNull @Initialized DataflowPipelineJob dataflowPipelineJob, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricUpdate> metricUpdates, @UnknownKeyFor @NonNull @Initialized MetricsFilter filter) {
            this.dataflowPipelineJob = dataflowPipelineJob;
            this.metricUpdates = metricUpdates;
            this.filter = filter;
            this.tentativeByName = new HashMap();
            this.committedByName = new HashMap();
            this.metricHashKeys = new HashSet();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isMetricTentative(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            return metricUpdate.getName().getContext().containsKey("tentative") && Objects.equal(metricUpdate.getName().getContext().get("tentative"), (Object)"true");
        }

        private @Nullable @UnknownKeyFor @Initialized String getUserStepName(@UnknownKeyFor @NonNull @Initialized String internalStepName) {
            @Nullable String portableUserStepName = this.getPortableUserStepName(internalStepName);
            if (portableUserStepName != null) {
                return portableUserStepName;
            }
            return this.getNonPortableUserStepName(internalStepName);
        }

        private @Nullable @UnknownKeyFor @Initialized String getPortableUserStepName(@UnknownKeyFor @NonNull @Initialized String internalStepName) {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable RunnerApi.Pipeline pipelineProto = this.dataflowPipelineJob.getPipelineProto();
            if (pipelineProto == null) {
                return null;
            }
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable RunnerApi.PTransform transform = (RunnerApi.PTransform)pipelineProto.getComponents().getTransformsMap().get(internalStepName);
            if (transform == null) {
                return null;
            }
            return transform.getUniqueName();
        }

        private @Nullable @UnknownKeyFor @Initialized String getNonPortableUserStepName(@UnknownKeyFor @NonNull @Initialized String internalStepName) {
            BiMap<AppliedPTransform<?, ?, ?>, String> transformStepNames = this.dataflowPipelineJob.getTransformStepNames();
            if (transformStepNames == null) {
                return null;
            }
            @Nullable AppliedPTransform appliedPTransform = (AppliedPTransform)transformStepNames.inverse().get((Object)internalStepName);
            if (appliedPTransform == null) {
                return null;
            }
            return appliedPTransform.getFullName();
        }

        private @Nullable @UnknownKeyFor @Initialized MetricKey getMetricHashKey(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            @Nullable String internalStepName = (String)metricUpdate.getName().getContext().get("step");
            Preconditions.checkArgumentNotNull((Object)internalStepName, (String)"MetricUpdate has null internal step name: %s", (Object)metricUpdate);
            @Nullable String namespace = (String)metricUpdate.getName().getContext().get("namespace");
            Preconditions.checkArgumentNotNull((Object)namespace, (String)"MetricUpdate has null namespace: %s", (Object)metricUpdate);
            @Nullable String userStepName = this.getUserStepName(internalStepName);
            if (userStepName == null) {
                return null;
            }
            return MetricKey.create((String)userStepName, (MetricName)MetricName.named((String)namespace, (String)metricUpdate.getName().getName()));
        }

        private void buildMetricsIndex() {
            for (MetricUpdate update : this.metricUpdates) {
                MetricUpdate previousUpdate;
                MetricKey updateKey;
                if (update.getName().getOrigin() != null && (!"user".equalsIgnoreCase(update.getName().getOrigin()) || !update.getName().getContext().containsKey("namespace")) || (updateKey = this.getMetricHashKey(update)) == null || !MetricFiltering.matches((MetricsFilter)this.filter, (MetricKey)updateKey)) continue;
                this.metricHashKeys.add(updateKey);
                if (this.isMetricTentative(update)) {
                    previousUpdate = this.tentativeByName.put(updateKey, update);
                    if (previousUpdate == null) continue;
                    LOG.warn("Metric {} already had a tentative value of {}", (Object)updateKey, (Object)previousUpdate);
                    continue;
                }
                previousUpdate = this.committedByName.put(updateKey, update);
                if (previousUpdate == null) continue;
                LOG.warn("Metric {} already had a committed value of {}", (Object)updateKey, (Object)previousUpdate);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized MetricQueryResults build() {
            this.buildMetricsIndex();
            DataflowMetricResultExtractor extractor = new DataflowMetricResultExtractor(this.dataflowPipelineJob.getDataflowOptions().isStreaming());
            for (MetricKey metricKey : this.metricHashKeys) {
                String metricName = metricKey.metricName().getName();
                if (metricName.endsWith("[MIN]") || metricName.endsWith("[MAX]") || metricName.endsWith("[MEAN]") || metricName.endsWith("[COUNT]")) continue;
                extractor.addMetricResult(metricKey, this.committedByName.get(metricKey), this.tentativeByName.get(metricKey));
            }
            return MetricQueryResults.create(extractor.getCounterResults(), extractor.getDistributionResults(), extractor.getGaugeResults(), extractor.getStringSetResults(), extractor.getBoundedTrieResults(), Collections.emptyList());
        }
    }

    @VisibleForTesting
    static class DataflowMetricResultExtractor {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counterResults = ImmutableList.builder();
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributionResults = ImmutableList.builder();
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gaugeResults = ImmutableList.builder();
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized StringSetResult>> stringSetResults = ImmutableList.builder();
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized BoundedTrieResult>> boundedTrieResults = ImmutableList.builder();
        private final @UnknownKeyFor @NonNull @Initialized boolean isStreamingJob;

        DataflowMetricResultExtractor(@UnknownKeyFor @NonNull @Initialized boolean isStreamingJob) {
            this.isStreamingJob = isStreamingJob;
        }

        public void addMetricResult(@UnknownKeyFor @NonNull @Initialized MetricKey metricKey, @Nullable @UnknownKeyFor @Initialized MetricUpdate committed, @Nullable @UnknownKeyFor @Initialized MetricUpdate attempted) {
            if (committed == null || attempted == null) {
                LOG.warn("Metric {} did not have both a committed ({}) and tentative value ({}).", new Object[]{metricKey, committed, attempted});
            } else if (committed.getDistribution() != null && attempted.getDistribution() != null) {
                DistributionResult value = this.getDistributionValue(committed);
                this.distributionResults.add((Object)MetricResult.create((MetricKey)metricKey, (Boolean)(!this.isStreamingJob ? 1 : 0), (Object)value));
            } else if (committed.getScalar() != null && attempted.getScalar() != null) {
                Long value = this.getCounterValue(committed);
                this.counterResults.add((Object)MetricResult.create((MetricKey)metricKey, (Boolean)(!this.isStreamingJob ? 1 : 0), (Object)value));
            } else if (committed.getSet() != null && attempted.getSet() != null) {
                StringSetResult value = this.getStringSetValue(committed);
                this.stringSetResults.add((Object)MetricResult.create((MetricKey)metricKey, (Boolean)(!this.isStreamingJob ? 1 : 0), (Object)value));
            } else if (committed.getBoundedTrie() != null && attempted.getBoundedTrie() != null) {
                BoundedTrieResult value = this.getBoundedTrieValue(committed);
                this.boundedTrieResults.add((Object)MetricResult.create((MetricKey)metricKey, (Boolean)(!this.isStreamingJob ? 1 : 0), (Object)value));
            } else {
                LOG.warn("Unexpected / mismatched metric types. Please report JOB ID to Dataflow Support. Metric key: {}. Committed / attempted Metric updates: {} / {}", new Object[]{metricKey.toString(), committed.toString(), attempted.toString()});
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Long getCounterValue(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            if (metricUpdate.getScalar() == null) {
                return 0L;
            }
            return ((Number)metricUpdate.getScalar()).longValue();
        }

        private @UnknownKeyFor @NonNull @Initialized StringSetResult getStringSetValue(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            if (metricUpdate.getSet() == null) {
                return StringSetResult.empty();
            }
            return StringSetResult.create((Set)ImmutableSet.copyOf((Collection)((Collection)metricUpdate.getSet())));
        }

        private @UnknownKeyFor @NonNull @Initialized BoundedTrieResult getBoundedTrieValue(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            BoundedTrieData trieData = null;
            Object trieFromResponse = metricUpdate.getBoundedTrie();
            if (trieFromResponse instanceof MetricsApi.BoundedTrie) {
                trieData = BoundedTrieData.fromProto((MetricsApi.BoundedTrie)((MetricsApi.BoundedTrie)trieFromResponse));
            } else if (trieFromResponse instanceof ArrayMap) {
                trieData = DataflowMetricResultExtractor.trieFromArrayMap((ArrayMap)trieFromResponse);
            }
            if (trieData != null) {
                return BoundedTrieResult.create((Set)trieData.extractResult().getResult());
            }
            return BoundedTrieResult.empty();
        }

        private @UnknownKeyFor @NonNull @Initialized DistributionResult getDistributionValue(@UnknownKeyFor @NonNull @Initialized MetricUpdate metricUpdate) {
            if (metricUpdate.getDistribution() == null) {
                return DistributionResult.IDENTITY_ELEMENT;
            }
            ArrayMap distributionMap = (ArrayMap)metricUpdate.getDistribution();
            long count = ((Number)Preconditions.checkArgumentNotNull((Object)((Number)distributionMap.get((Object)"count")))).longValue();
            long min = ((Number)Preconditions.checkArgumentNotNull((Object)((Number)distributionMap.get((Object)"min")))).longValue();
            long max = ((Number)Preconditions.checkArgumentNotNull((Object)((Number)distributionMap.get((Object)"max")))).longValue();
            long sum = ((Number)Preconditions.checkArgumentNotNull((Object)((Number)distributionMap.get((Object)"sum")))).longValue();
            return DistributionResult.create((long)sum, (long)count, (long)min, (long)max);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized BoundedTrieData trieFromArrayMap(@UnknownKeyFor @NonNull @Initialized ArrayMap fieldsMap) {
            Object maybeSingleton;
            int bound = 0;
            ImmutableList singleton = null;
            Object maybeBound = fieldsMap.get((Object)"bound");
            if (maybeBound instanceof Number) {
                bound = ((Number)maybeBound).intValue();
            }
            if ((maybeSingleton = fieldsMap.get((Object)"singleton")) instanceof List) {
                List valueList = (List)maybeSingleton;
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Object stringValue : valueList) {
                    builder.add((Object)((String)stringValue));
                }
                singleton = builder.build();
            }
            Object maybeRoot = fieldsMap.get((Object)"root");
            BoundedTrieData.BoundedTrieNode root = null;
            if (maybeRoot instanceof Map) {
                root = DataflowMetricResultExtractor.trieNodeFromMap((Map)maybeRoot);
            }
            return new BoundedTrieData((List)singleton, root, bound);
        }

        private static // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized BoundedTrieData.BoundedTrieNode trieNodeFromMap(@UnknownKeyFor @NonNull @Initialized Map fieldsMap) {
            boolean truncated = false;
            Object mayTruncated = fieldsMap.get("truncated");
            if (mayTruncated instanceof Boolean) {
                truncated = (Boolean)mayTruncated;
            }
            int childrenSize = 0;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Object maybeChildren = fieldsMap.get("children");
            if (maybeChildren instanceof Map) {
                Map allChildren = (Map)maybeChildren;
                for (Map.Entry maybeChildValue : allChildren.entrySet()) {
                    Map.Entry childValue = maybeChildValue;
                    Object maybeChild = childValue.getValue();
                    if (!(maybeChild instanceof Map)) continue;
                    BoundedTrieData.BoundedTrieNode child = DataflowMetricResultExtractor.trieNodeFromMap((Map)maybeChild);
                    Object maybeKey = childValue.getKey();
                    if (maybeKey instanceof String) {
                        builder.put((Object)((String)maybeKey), (Object)child);
                    }
                    childrenSize += child.getSize();
                }
            }
            ImmutableMap children = builder.build();
            return new BoundedTrieData.BoundedTrieNode((Map)children, truncated, Math.max(1, childrenSize));
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> getDistributionResults() {
            return this.distributionResults.build();
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> getCounterResults() {
            return this.counterResults.build();
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> getGaugeResults() {
            return this.gaugeResults.build();
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized StringSetResult>> getStringSetResults() {
            return this.stringSetResults.build();
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized BoundedTrieResult>> getBoundedTrieResults() {
            return this.boundedTrieResults.build();
        }
    }
}

