/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.standardizephonenumber;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Arrays;
import java.util.Set;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneField;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneNumberData;
import org.apache.hop.pipeline.transforms.standardizephonenumber.StandardizePhoneNumberMeta;

public class StandardizePhoneNumber
extends BaseTransform<StandardizePhoneNumberMeta, StandardizePhoneNumberData> {
    private static final Class<?> PKG = StandardizePhoneNumber.class;
    private PhoneNumberUtil phoneNumberService;
    private Set<String> supportedRegions;

    public StandardizePhoneNumber(TransformMeta transformMeta, StandardizePhoneNumberMeta meta, StandardizePhoneNumberData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.StartedProcessing", (String[])new String[0]));
            }
            this.first = false;
            ((StandardizePhoneNumberData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((StandardizePhoneNumberMeta)this.meta).getFields(((StandardizePhoneNumberData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, null);
        }
        IRowMeta inputRowMeta = this.getInputRowMeta();
        Object[] outputRow = Arrays.copyOf(row, ((StandardizePhoneNumberData)this.data).outputRowMeta.size());
        for (StandardizePhoneField standardize : ((StandardizePhoneNumberMeta)this.meta).getFields()) {
            String region = standardize.getDefaultCountry();
            if (!Utils.isEmpty((CharSequence)standardize.getCountryField())) {
                int index = inputRowMeta.indexOfValue(standardize.getCountryField());
                if (index < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.CountryFieldNotFound", (String[])new String[]{standardize.getCountryField()}));
                    this.setErrors(1L);
                    return false;
                }
                String country = inputRowMeta.getString(row, index);
                if (country == null || Utils.isEmpty((CharSequence)country)) {
                    region = standardize.getDefaultCountry();
                } else if (this.supportedRegions.contains(country.toUpperCase())) {
                    region = country.toUpperCase();
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.RegionNotSupported", (String[])new String[]{country}));
                    region = standardize.getDefaultCountry();
                }
            }
            String value = null;
            int index = inputRowMeta.indexOfValue(standardize.getInputField());
            if (index < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.InputFieldNotFound", (String[])new String[]{standardize.getInputField()}));
                this.setErrors(1L);
                return false;
            }
            value = inputRowMeta.getString(row, index);
            if (value != null && !Utils.isEmpty((CharSequence)value)) {
                Phonenumber.PhoneNumber phoneNumber;
                block19: {
                    phoneNumber = null;
                    try {
                        value = value.replace(',', ' ');
                        PhoneNumberUtil.PhoneNumberFormat format = this.getPhoneNumberFormat(standardize.getNumberFormat());
                        phoneNumber = this.phoneNumberService.parse((CharSequence)value, region);
                        if (!Utils.isEmpty((CharSequence)standardize.getOutputField())) {
                            index = ((StandardizePhoneNumberData)this.data).outputRowMeta.indexOfValue(standardize.getOutputField());
                        }
                        outputRow[index] = this.phoneNumberService.format(phoneNumber, format);
                    }
                    catch (NumberParseException e) {
                        if (!this.isRowLevel()) break block19;
                        this.logRowlevel(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.ProcessPhoneNumberError", (String[])new String[]{standardize.getInputField(), value}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)standardize.getNumberTypeField())) {
                    int i = ((StandardizePhoneNumberData)this.data).outputRowMeta.indexOfValue(standardize.getNumberTypeField());
                    outputRow[i] = phoneNumber != null ? this.phoneNumberService.getNumberType(phoneNumber) : "ERROR";
                }
                if (Utils.isEmpty((CharSequence)standardize.getIsValidNumberField())) continue;
                int i = ((StandardizePhoneNumberData)this.data).outputRowMeta.indexOfValue(standardize.getIsValidNumberField());
                if (phoneNumber != null) {
                    outputRow[i] = this.phoneNumberService.isValidNumber(phoneNumber);
                    continue;
                }
                outputRow[i] = false;
                continue;
            }
            if (Utils.isEmpty((CharSequence)standardize.getIsValidNumberField())) continue;
            int i = ((StandardizePhoneNumberData)this.data).outputRowMeta.indexOfValue(standardize.getIsValidNumberField());
            outputRow[i] = false;
        }
        this.putRow(((StandardizePhoneNumberData)this.data).outputRowMeta, outputRow);
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"StandardizePhoneNumber.Log.WroteRowToNextTransform", (Object[])outputRow));
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic("Line nr " + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            this.phoneNumberService = PhoneNumberUtil.getInstance();
            this.supportedRegions = this.phoneNumberService.getSupportedRegions();
            return true;
        }
        return false;
    }

    public PhoneNumberUtil.PhoneNumberFormat getPhoneNumberFormat(String value) {
        try {
            return PhoneNumberUtil.PhoneNumberFormat.valueOf((String)value);
        }
        catch (Exception e) {
            this.logError("Error parsing phone number format", e);
            return PhoneNumberUtil.PhoneNumberFormat.E164;
        }
    }
}

