/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringoperations;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringoperations.StringOperations;
import org.apache.hop.pipeline.transforms.stringoperations.StringOperationsData;
import org.w3c.dom.Node;

@Transform(id="StringOperations", image="stringoperations.svg", name="i18n::StringOperations.Name", description="i18n::StringOperations.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::StringOperationsMeta.keyword"}, documentationUrl="/pipeline/transforms/stringoperations.html")
@InjectionSupported(localizationPrefix="StringOperationsDialog.Injection.")
public class StringOperationsMeta
extends BaseTransformMeta<StringOperations, StringOperationsData> {
    private static final Class<?> PKG = StringOperationsMeta.class;
    public static final String CONST_SPACES = "        ";
    @Injection(name="SOURCEFIELDS")
    private String[] fieldInStream;
    @Injection(name="TARGETFIELDS")
    private String[] fieldOutStream;
    @Injection(name="TRIMTYPE")
    private int[] trimType;
    @Injection(name="LOWERUPPER")
    private int[] lowerUpper;
    @Injection(name="INITCAP")
    private int[] initCap;
    @Injection(name="MASKXML")
    private int[] maskXML;
    @Injection(name="DIGITS")
    private int[] digits;
    @Injection(name="SPECIALCHARS")
    private int[] remove_special_characters;
    @Injection(name="PADDING")
    private int[] paddingType;
    @Injection(name="PADLEN")
    private String[] padLen;
    @Injection(name="PADCHAR")
    private String[] padChar;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final int TRIM_NONE = 0;
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_RIGHT = 2;
    public static final int TRIM_BOTH = 3;
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Both", (String[])new String[0])};
    public static final String[] lowerUpperCode = new String[]{"none", "lower", "upper"};
    public static final int LOWER_UPPER_NONE = 0;
    public static final int LOWER_UPPER_LOWER = 1;
    public static final int LOWER_UPPER_UPPER = 2;
    public static final String[] lowerUpperDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.Lower", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.Upper", (String[])new String[0])};
    public static final String[] initCapDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] initCapCode = new String[]{"no", "yes"};
    public static final int INIT_CAP_NO = 0;
    public static final int INIT_CAP_YES = 1;
    public static final String[] digitsCode = new String[]{"none", "digits_only", "remove_digits"};
    public static final int DIGITS_NONE = 0;
    public static final int DIGITS_ONLY = 1;
    public static final int DIGITS_REMOVE = 2;
    public static final String[] digitsDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Only", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Remove", (String[])new String[0])};
    public static final String[] maskXMLDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.CDATA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.UnEscapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeSQL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeHTML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.UnEscapeHTML", (String[])new String[0])};
    public static final String[] maskXMLCode = new String[]{"none", "escapexml", "cdata", "unescapexml", "escapesql", "escapehtml", "unescapehtml"};
    public static final int MASK_NONE = 0;
    public static final int MASK_ESCAPE_XML = 1;
    public static final int MASK_CDATA = 2;
    public static final int MASK_UNESCAPE_XML = 3;
    public static final int MASK_ESCAPE_SQL = 4;
    public static final int MASK_ESCAPE_HTML = 5;
    public static final int MASK_UNESCAPE_HTML = 6;
    public static final String[] removeSpecialCharactersCode = new String[]{"none", "cr", "lf", "crlf", "tab", "espace"};
    public static final int REMOVE_SPECIAL_CHARACTERS_NONE = 0;
    public static final int REMOVE_SPECIAL_CHARACTERS_CR = 1;
    public static final int REMOVE_SPECIAL_CHARACTERS_LF = 2;
    public static final int REMOVE_SPECIAL_CHARACTERS_CRLF = 3;
    public static final int REMOVE_SPECIAL_CHARACTERS_TAB = 4;
    public static final int REMOVE_SPECIAL_CHARACTERS_ESPACE = 5;
    public static final String[] removeSpecialCharactersDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.CR", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.LF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.CRLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.TAB", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.Space", (String[])new String[0])};
    public static final String[] paddingDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.Right", (String[])new String[0])};
    public static final String[] paddingCode = new String[]{"none", "left", "right"};
    public static final int PADDING_NONE = 0;
    public static final int PADDING_LEFT = 1;
    public static final int PADDING_RIGHT = 2;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    public String[] getPadLen() {
        return this.padLen;
    }

    public void setPadLen(String[] value) {
        this.padLen = value;
    }

    public String[] getPadChar() {
        return this.padChar;
    }

    public void setPadChar(String[] value) {
        this.padChar = value;
    }

    public int[] getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int[] trimType) {
        this.trimType = trimType;
    }

    public int[] getLowerUpper() {
        return this.lowerUpper;
    }

    public void setLowerUpper(int[] lowerUpper) {
        this.lowerUpper = lowerUpper;
    }

    public int[] getInitCap() {
        return this.initCap;
    }

    public void setInitCap(int[] value) {
        this.initCap = value;
    }

    public int[] getMaskXML() {
        return this.maskXML;
    }

    public void setMaskXML(int[] value) {
        this.maskXML = value;
    }

    public int[] getDigits() {
        return this.digits;
    }

    public void setDigits(int[] value) {
        this.digits = value;
    }

    public int[] getRemoveSpecialCharacters() {
        return this.remove_special_characters;
    }

    public void setRemoveSpecialCharacters(int[] value) {
        this.remove_special_characters = value;
    }

    public int[] getPaddingType() {
        return this.paddingType;
    }

    public void setPaddingType(int[] value) {
        this.paddingType = value;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
        this.trimType = new int[nrkeys];
        this.lowerUpper = new int[nrkeys];
        this.paddingType = new int[nrkeys];
        this.padChar = new String[nrkeys];
        this.padLen = new String[nrkeys];
        this.initCap = new int[nrkeys];
        this.maskXML = new int[nrkeys];
        this.digits = new int[nrkeys];
        this.remove_special_characters = new int[nrkeys];
    }

    public Object clone() {
        StringOperationsMeta retval = (StringOperationsMeta)((Object)super.clone());
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.fieldInStream, 0, retval.fieldInStream, 0, nrkeys);
        System.arraycopy(this.fieldOutStream, 0, retval.fieldOutStream, 0, nrkeys);
        System.arraycopy(this.trimType, 0, retval.trimType, 0, nrkeys);
        System.arraycopy(this.lowerUpper, 0, retval.lowerUpper, 0, nrkeys);
        System.arraycopy(this.paddingType, 0, retval.paddingType, 0, nrkeys);
        System.arraycopy(this.padChar, 0, retval.padChar, 0, nrkeys);
        System.arraycopy(this.padLen, 0, retval.padLen, 0, nrkeys);
        System.arraycopy(this.initCap, 0, retval.initCap, 0, nrkeys);
        System.arraycopy(this.maskXML, 0, retval.maskXML, 0, nrkeys);
        System.arraycopy(this.digits, 0, retval.digits, 0, nrkeys);
        System.arraycopy(this.remove_special_characters, 0, retval.remove_special_characters, 0, nrkeys);
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrkeys = XmlHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
                this.trimType[i] = StringOperationsMeta.getTrimTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type"), (String)""));
                this.lowerUpper[i] = StringOperationsMeta.getLowerUpperByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"lower_upper"), (String)""));
                this.paddingType[i] = StringOperationsMeta.getPaddingByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"padding_type"), (String)""));
                this.padChar[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"pad_char"), (String)"");
                this.padLen[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"pad_len"), (String)"");
                this.initCap[i] = StringOperationsMeta.getInitCapByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"init_cap"), (String)""));
                this.maskXML[i] = StringOperationsMeta.getMaskXMLByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"mask_xml"), (String)""));
                this.digits[i] = StringOperationsMeta.getDigitsByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"digits"), (String)""));
                this.remove_special_characters[i] = StringOperationsMeta.getRemoveSpecialCharactersByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"remove_special_characters"), (String)""));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"StringOperationsMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        this.allocate(0);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            String lPadChar = this.padChar.length == 0 || this.padChar.length <= i ? "" : this.padChar[i];
            String lPadLen = this.padLen.length == 0 || this.padLen.length <= i ? "" : this.padLen[i];
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"out_stream_name", (String)(this.fieldOutStream == null || this.fieldOutStream.length == 0 || this.fieldOutStream.length <= i ? "" : (!Utils.isEmpty((CharSequence)this.fieldOutStream[i]) ? this.fieldOutStream[i] : ""))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"trim_type", (String)(this.trimType == null || this.trimType.length == 0 || this.trimType.length <= i ? "" : StringOperationsMeta.getTrimTypeCode(this.trimType[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"lower_upper", (String)(this.lowerUpper == null || this.lowerUpper.length == 0 || this.lowerUpper.length <= i ? "" : StringOperationsMeta.getLowerUpperCode(this.lowerUpper[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"padding_type", (String)(this.paddingType == null || this.paddingType.length == 0 || this.paddingType.length <= i ? "" : StringOperationsMeta.getPaddingCode(this.paddingType[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"pad_char", (String)(this.padChar == null || this.padChar.length == 0 || this.padChar.length <= i ? "" : this.padChar[i])));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"pad_len", (String)(this.padLen == null || this.padLen.length == 0 || this.padLen.length <= i ? "" : this.padLen[i])));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"init_cap", (String)(this.initCap == null || this.initCap.length == 0 || this.initCap.length <= i ? "" : StringOperationsMeta.getInitCapCode(this.initCap[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"mask_xml", (String)(this.maskXML == null || this.maskXML.length == 0 || this.maskXML.length <= i ? "" : StringOperationsMeta.getMaskXMLCode(this.maskXML[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"digits", (String)(this.digits == null || this.digits.length == 0 || this.digits.length <= i ? "" : StringOperationsMeta.getDigitsCode(this.digits[i]))));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"remove_special_characters", (String)(this.remove_special_characters == null || this.remove_special_characters.length == 0 || this.remove_special_characters.length <= i ? "" : StringOperationsMeta.getRemoveSpecialCharactersCode(this.remove_special_characters[i]))));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldOutStream.length; ++i) {
            int padLen;
            ValueMetaString v;
            String outputField = variables.resolve(this.fieldOutStream[i]);
            if (!Utils.isEmpty((CharSequence)outputField)) {
                v = new ValueMetaString(outputField);
                v.setLength(100, -1);
                v.setOrigin(name);
                inputRowMeta.addValueMeta((IValueMeta)v);
                continue;
            }
            v = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
            if (v == null) continue;
            v.setStorageType(0);
            int paddingType = this.getPaddingType()[i];
            if (paddingType != 1 && paddingType != 2 || (padLen = Const.toInt((String)variables.resolve(this.getPadLen()[i]), (int)0)) <= v.getLength()) continue;
            v.setLength(padLen);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        Object errorMessage = "";
        boolean first = true;
        boolean errorFound = false;
        if (prev == null) {
            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.NoInputReceived", (String[])new String[0]) + Const.CR;
            CheckResult cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            IValueMeta v;
            for (String field : this.fieldInStream) {
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.MissingInStreamFields", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
            }
            CheckResult cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            first = true;
            errorFound = false;
            for (String field : this.fieldInStream) {
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
            }
            cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            if (this.fieldInStream.length > 0) {
                for (int idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Utils.isEmpty((CharSequence)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{Integer.toString(idx + 1)}), (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            }
            for (int idx = 0; idx < this.fieldInStream.length; ++idx) {
                for (int jdx = 0; jdx < this.fieldInStream.length; ++jdx) {
                    if (!this.fieldInStream[idx].equals(this.fieldInStream[jdx]) || idx == jdx || idx >= jdx) continue;
                    errorMessage = BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.FieldInputError", (String[])new String[]{this.fieldInStream[idx]});
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    private static String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    private static String getLowerUpperCode(int i) {
        if (i < 0 || i >= lowerUpperCode.length) {
            return lowerUpperCode[0];
        }
        return lowerUpperCode[i];
    }

    private static String getInitCapCode(int i) {
        if (i < 0 || i >= initCapCode.length) {
            return initCapCode[0];
        }
        return initCapCode[i];
    }

    private static String getMaskXMLCode(int i) {
        if (i < 0 || i >= maskXMLCode.length) {
            return maskXMLCode[0];
        }
        return maskXMLCode[i];
    }

    private static String getDigitsCode(int i) {
        if (i < 0 || i >= digitsCode.length) {
            return digitsCode[0];
        }
        return digitsCode[i];
    }

    private static String getRemoveSpecialCharactersCode(int i) {
        if (i < 0 || i >= removeSpecialCharactersCode.length) {
            return removeSpecialCharactersCode[0];
        }
        return removeSpecialCharactersCode[i];
    }

    private static String getPaddingCode(int i) {
        if (i < 0 || i >= paddingCode.length) {
            return paddingCode[0];
        }
        return paddingCode[i];
    }

    public static String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static String getLowerUpperDesc(int i) {
        if (i < 0 || i >= lowerUpperDesc.length) {
            return lowerUpperDesc[0];
        }
        return lowerUpperDesc[i];
    }

    public static String getInitCapDesc(int i) {
        if (i < 0 || i >= initCapDesc.length) {
            return initCapDesc[0];
        }
        return initCapDesc[i];
    }

    public static String getMaskXMLDesc(int i) {
        if (i < 0 || i >= maskXMLDesc.length) {
            return maskXMLDesc[0];
        }
        return maskXMLDesc[i];
    }

    public static String getDigitsDesc(int i) {
        if (i < 0 || i >= digitsDesc.length) {
            return digitsDesc[0];
        }
        return digitsDesc[i];
    }

    public static String getRemoveSpecialCharactersDesc(int i) {
        if (i < 0 || i >= removeSpecialCharactersDesc.length) {
            return removeSpecialCharactersDesc[0];
        }
        return removeSpecialCharactersDesc[i];
    }

    public static String getPaddingDesc(int i) {
        if (i < 0 || i >= paddingDesc.length) {
            return paddingDesc[0];
        }
        return paddingDesc[i];
    }

    private static int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getLowerUpperByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < lowerUpperCode.length; ++i) {
            if (!lowerUpperCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getInitCapByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < initCapCode.length; ++i) {
            if (!initCapCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getMaskXMLByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < maskXMLCode.length; ++i) {
            if (!maskXMLCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getDigitsByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < digitsCode.length; ++i) {
            if (!digitsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getRemoveSpecialCharactersByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < removeSpecialCharactersCode.length; ++i) {
            if (!removeSpecialCharactersCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getPaddingByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < paddingCode.length; ++i) {
            if (!paddingCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getTrimTypeByCode(tt);
    }

    public static int getLowerUpperByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < lowerUpperDesc.length; ++i) {
            if (!lowerUpperDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getLowerUpperByCode(tt);
    }

    public static int getInitCapByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < initCapDesc.length; ++i) {
            if (!initCapDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getInitCapByCode(tt);
    }

    public static int getMaskXMLByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < maskXMLDesc.length; ++i) {
            if (!maskXMLDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getMaskXMLByCode(tt);
    }

    public static int getDigitsByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < digitsDesc.length; ++i) {
            if (!digitsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getDigitsByCode(tt);
    }

    public static int getRemoveSpecialCharactersByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < removeSpecialCharactersDesc.length; ++i) {
            if (!removeSpecialCharactersDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getRemoveSpecialCharactersByCode(tt);
    }

    public static int getPaddingByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < paddingDesc.length; ++i) {
            if (!paddingDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getPaddingByCode(tt);
    }
}

