/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sendnagiospassivecheck;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.googlecode.jsendnsca.builders.NagiosSettingsBuilder;
import com.googlecode.jsendnsca.encryption.Encryption;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.sendnagiospassivecheck.EncryptionModeEnum;

@Action(id="SEND_NAGIOS_PASSIVE_CHECK", name="i18n::ActionSendNagiosPassiveCheck.Name", description="i18n::ActionSendNagiosPassiveCheck.Description", image="SendNagiosPassiveCheck.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionSendNagiosPassiveCheck.keyword"}, documentationUrl="/workflow/actions/sendnagiospassivecheck.html")
public class ActionSendNagiosPassiveCheck
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSendNagiosPassiveCheck.class;
    public static final String CONST_SPACES = "      ";
    @HopMetadataProperty(key="servername")
    private String serverName = null;
    @HopMetadataProperty(key="port")
    private String port = "5667";
    @HopMetadataProperty(key="responseTimeOut")
    private String responseTimeOut;
    @HopMetadataProperty(key="connectionTimeOut")
    private String connectionTimeOut = String.valueOf(5000);
    @HopMetadataProperty(key="message")
    private String message = null;
    @HopMetadataProperty(key="senderServerName")
    private String senderServerName = null;
    @HopMetadataProperty(key="senderServiceName")
    private String senderServiceName = null;
    @HopMetadataProperty(key="encryptionMode", storeWithCode=true)
    private EncryptionModeEnum encryptionMode;
    @HopMetadataProperty(key="level")
    private int level = 0;
    @HopMetadataProperty(key="password", password=true)
    private String password = null;
    private static final int DEFAULT_RESPONSE_TIME_OUT = 10000;
    public static final int DEFAULT_CONNECTION_TIME_OUT = 5000;
    public static final int DEFAULT_PORT = 5667;
    public static final String[] encryptionModeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.TripleDES", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.XOR", (String[])new String[0])};
    public static final String[] levelTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.LevelType.Unknown", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.OK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.Warning", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.Critical", (String[])new String[0])};
    public static final int LEVEL_TYPE_UNKNOWN = 0;
    public static final int LEVEL_TYPE_OK = 1;
    public static final int LEVEL_TYPE_WARNING = 2;
    public static final int LEVEL_TYPE_CRITICAL = 3;

    public ActionSendNagiosPassiveCheck(String n) {
        super(n, "");
        this.responseTimeOut = String.valueOf(10000);
        this.encryptionMode = EncryptionModeEnum.NONE;
    }

    public ActionSendNagiosPassiveCheck() {
        this("");
    }

    public Object clone() {
        ActionSendNagiosPassiveCheck je = (ActionSendNagiosPassiveCheck)super.clone();
        return je;
    }

    public static String getEncryptionModeDesc(int i) {
        if (i < 0 || i >= encryptionModeDesc.length) {
            return encryptionModeDesc[0];
        }
        return encryptionModeDesc[i];
    }

    public static String getLevelDesc(int i) {
        if (i < 0 || i >= levelTypeDesc.length) {
            return levelTypeDesc[0];
        }
        return levelTypeDesc[i];
    }

    public Result execute(Result previousResult, int nr) {
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Started", (String[])new String[]{this.serverName}));
        }
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String realServername = this.resolve(this.serverName);
        String realPassword = Utils.resolvePassword((IVariables)this.getVariables(), (String)this.password);
        int realPort = Const.toInt((String)this.resolve(this.port), (int)5667);
        int realResponseTimeOut = Const.toInt((String)this.resolve(this.responseTimeOut), (int)10000);
        int realConnectionTimeOut = Const.toInt((String)this.resolve(this.connectionTimeOut), (int)5000);
        String realSenderServerName = this.resolve(this.senderServerName);
        String realSenderServiceName = this.resolve(this.senderServiceName);
        try {
            if (Utils.isEmpty((CharSequence)realServername)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Error.TargetServerMissing", (String[])new String[0]));
            }
            String realMessageString = this.resolve(this.message);
            if (Utils.isEmpty((CharSequence)realMessageString)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Error.MessageMissing", (String[])new String[0]));
            }
            Level level = Level.UNKNOWN;
            switch (this.getLevel()) {
                case 1: {
                    level = Level.OK;
                    break;
                }
                case 3: {
                    level = Level.CRITICAL;
                    break;
                }
                case 2: {
                    level = Level.WARNING;
                    break;
                }
            }
            Encryption encr = Encryption.NONE;
            switch (this.getEncryptionMode()) {
                case TRIPLEDES: {
                    encr = Encryption.TRIPLE_DES;
                    break;
                }
                case XOR: {
                    encr = Encryption.XOR;
                    break;
                }
            }
            NagiosSettingsBuilder ns = new NagiosSettingsBuilder();
            ns.withNagiosHost(realServername);
            ns.withPort(realPort);
            ns.withConnectionTimeout(realConnectionTimeOut);
            ns.withResponseTimeout(realResponseTimeOut);
            ns.withEncryption(encr);
            if (!Utils.isEmpty((CharSequence)realPassword)) {
                ns.withPassword(realPassword);
            } else {
                ns.withNoPassword();
            }
            NagiosSettings settings = ns.create();
            MessagePayloadBuilder pb = new MessagePayloadBuilder();
            if (!Utils.isEmpty((CharSequence)realSenderServerName)) {
                pb.withHostname(realSenderServerName);
            }
            pb.withLevel(level);
            if (!Utils.isEmpty((CharSequence)realSenderServiceName)) {
                pb.withServiceName(realSenderServiceName);
            }
            pb.withMessage(realMessageString);
            MessagePayload payload = pb.create();
            NagiosPassiveCheckSender sender = new NagiosPassiveCheckSender(settings);
            sender.send(payload);
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ErrorGetting", (String[])new String[]{e.toString()}));
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getResponseTimeOut() {
        return this.responseTimeOut;
    }

    @Generated
    public String getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getSenderServerName() {
        return this.senderServerName;
    }

    @Generated
    public String getSenderServiceName() {
        return this.senderServiceName;
    }

    @Generated
    public EncryptionModeEnum getEncryptionMode() {
        return this.encryptionMode;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setResponseTimeOut(String responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    @Generated
    public void setConnectionTimeOut(String connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setSenderServerName(String senderServerName) {
        this.senderServerName = senderServerName;
    }

    @Generated
    public void setSenderServiceName(String senderServiceName) {
        this.senderServiceName = senderServiceName;
    }

    @Generated
    public void setEncryptionMode(EncryptionModeEnum encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }
}

