/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.delay.SyntheticDelay;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.RateLimiter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class SyntheticStep
extends DoFn<KV<byte[], byte[]>, KV<byte[], byte[]>> {
    private static final @UnknownKeyFor @NonNull @Initialized Random RANDOM = new Random();
    private final @UnknownKeyFor @NonNull @Initialized Options options;
    private final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> idAndThroughput;
    private final @UnknownKeyFor @NonNull @Initialized Counter throttlingCounter = Metrics.counter((String)"dataflow-throttling-metrics", (String)"throttling-msecs");
    private static @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long>, @UnknownKeyFor @NonNull @Initialized RateLimiter> rateLimiterCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<KV<Long, Long>, RateLimiter>(){

        public @UnknownKeyFor @NonNull @Initialized RateLimiter load(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> pair) {
            return RateLimiter.create((double)((Long)pair.getValue()).doubleValue());
        }
    });

    public SyntheticStep(@UnknownKeyFor @NonNull @Initialized Options options) {
        options.validate();
        this.options = options;
        this.idAndThroughput = KV.of((Object)RANDOM.nextLong(), (Object)options.maxWorkerThroughput);
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int i;
        byte[] key = (byte[])((KV)c.element()).getKey();
        byte[] val = (byte[])((KV)c.element()).getValue();
        int decimalPart = (int)this.options.outputRecordsPerInputRecord;
        double fractionalPart = this.options.outputRecordsPerInputRecord - (double)decimalPart;
        long hashCodeOfVal = this.options.hashFunction().hashBytes(val).asLong();
        Random random = new Random(hashCodeOfVal);
        for (i = 0; i < decimalPart; ++i) {
            c.output(this.outputElement(key, val, hashCodeOfVal, i, random));
        }
        if (random.nextDouble() < fractionalPart) {
            c.output(this.outputElement(key, val, hashCodeOfVal, i, random));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> outputElement(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] inputKey, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] inputValue, @UnknownKeyFor @NonNull @Initialized long inputValueHashcode, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Random random) {
        long seed = this.options.hashFunction().hashLong(inputValueHashcode + (long)index).asLong();
        Duration delay = Duration.millis((long)this.options.nextDelay(seed));
        long millisecondsSpentSleeping = 0L;
        while (delay.getMillis() > 0L) {
            millisecondsSpentSleeping += SyntheticDelay.delay(delay, this.options.cpuUtilizationInMixedDelay, this.options.delayType, random);
            if (this.isWithinThroughputLimit()) break;
            delay = Duration.millis((long)1L);
        }
        this.reportThrottlingTimeMetrics(millisecondsSpentSleeping);
        if (this.options.preservesInputKeyDistribution) {
            byte[] newValue = new byte[inputValue.length];
            random.nextBytes(newValue);
            return KV.of((Object)inputKey, (Object)newValue);
        }
        return this.options.genKvPair(seed);
    }

    private void reportThrottlingTimeMetrics(@UnknownKeyFor @NonNull @Initialized long milliseconds) {
        if (this.options.reportThrottlingMicros && milliseconds > 0L) {
            this.throttlingCounter.inc(TimeUnit.MILLISECONDS.toMicros(milliseconds));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isWithinThroughputLimit() {
        return this.options.maxWorkerThroughput < 0L || ((RateLimiter)rateLimiterCache.getUnchecked(this.idAndThroughput)).tryAcquire();
    }

    @DoFn.StartBundle
    public void startBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.options.perBundleDelay > 0L) {
            SyntheticDelay.delay(Duration.millis((long)this.options.perBundleDelay), this.options.cpuUtilizationInMixedDelay, this.options.perBundleDelayType, new Random());
        }
    }

    public static class Options
    extends SyntheticOptions {
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized double outputRecordsPerInputRecord;
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized boolean preservesInputKeyDistribution;
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized long maxWorkerThroughput = -1L;
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized long perBundleDelay = 0L;
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized SyntheticOptions.DelayType perBundleDelayType = SyntheticOptions.DelayType.SLEEP;
        @JsonProperty
        public @UnknownKeyFor @NonNull @Initialized boolean reportThrottlingMicros;

        @Override
        public void validate() {
            super.validate();
            Preconditions.checkArgument((this.outputRecordsPerInputRecord >= 0.0 ? 1 : 0) != 0, (String)"outputRecordsPerInputRecord should be a non-negative number, but found %s.", (Object)this.outputRecordsPerInputRecord);
            Preconditions.checkArgument((this.perBundleDelay >= 0L ? 1 : 0) != 0, (String)"perBundleDelay should be a non-negative number, but found %s.", (long)this.perBundleDelay);
            if (this.maxWorkerThroughput >= 0L) {
                Preconditions.checkArgument((this.perBundleDelay == 0L ? 1 : 0) != 0, (Object)"maxWorkerThroughput and perBundleDelay cannot be enabled simultaneously.");
            }
        }
    }
}

