/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc;

import java.util.concurrent.ScheduledExecutorService;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.chunked.OHCacheChunkedImpl;
import org.caffinitas.ohc.linked.OHCacheLinkedImpl;

public class OHCacheBuilder<K, V> {
    private int segmentCount;
    private int hashTableSize = 8192;
    private long capacity;
    private int chunkSize;
    private CacheSerializer<K> keySerializer;
    private CacheSerializer<V> valueSerializer;
    private float loadFactor = 0.75f;
    private int fixedKeySize;
    private int fixedValueSize;
    private long maxEntrySize;
    private ScheduledExecutorService executorService;
    private boolean throwOOME;
    private HashAlgorithm hashAlgorighm = HashAlgorithm.MURMUR3;
    private boolean unlocked;
    private long defaultTTLmillis;
    private int timeoutsSlots;
    private int timeoutsPrecision;
    public static final String SYSTEM_PROPERTY_PREFIX = "org.caffinitas.ohc.";

    private OHCacheBuilder() {
        int cpus = Runtime.getRuntime().availableProcessors();
        this.segmentCount = OHCacheBuilder.roundUpToPowerOf2(cpus * 2, 0x40000000);
        this.capacity = Math.min(cpus * 16, 64) * 1024 * 1024;
        this.segmentCount = OHCacheBuilder.fromSystemProperties("segmentCount", this.segmentCount);
        this.hashTableSize = OHCacheBuilder.fromSystemProperties("hashTableSize", this.hashTableSize);
        this.capacity = OHCacheBuilder.fromSystemProperties("capacity", this.capacity);
        this.chunkSize = OHCacheBuilder.fromSystemProperties("chunkSize", this.chunkSize);
        this.loadFactor = OHCacheBuilder.fromSystemProperties("loadFactor", this.loadFactor);
        this.maxEntrySize = OHCacheBuilder.fromSystemProperties("maxEntrySize", this.maxEntrySize);
        this.throwOOME = OHCacheBuilder.fromSystemProperties("throwOOME", this.throwOOME);
        this.hashAlgorighm = HashAlgorithm.valueOf(OHCacheBuilder.fromSystemProperties("hashAlgorighm", this.hashAlgorighm.name()));
        this.unlocked = OHCacheBuilder.fromSystemProperties("unlocked", this.unlocked);
        this.defaultTTLmillis = OHCacheBuilder.fromSystemProperties("defaultTTLmillis", this.defaultTTLmillis);
        this.timeoutsSlots = OHCacheBuilder.fromSystemProperties("timeoutsSlots", this.timeoutsSlots);
        this.timeoutsPrecision = OHCacheBuilder.fromSystemProperties("timeoutsPrecision", this.timeoutsPrecision);
    }

    private static float fromSystemProperties(String name, float defaultValue) {
        try {
            return Float.parseFloat(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Float.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static long fromSystemProperties(String name, long defaultValue) {
        try {
            return Long.parseLong(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Long.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static int fromSystemProperties(String name, int defaultValue) {
        try {
            return Integer.parseInt(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Integer.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static boolean fromSystemProperties(String name, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY_PREFIX + name, Boolean.toString(defaultValue)));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse system property org.caffinitas.ohc." + name, e);
        }
    }

    private static String fromSystemProperties(String name, String defaultValue) {
        return System.getProperty(SYSTEM_PROPERTY_PREFIX + name, defaultValue);
    }

    static int roundUpToPowerOf2(int number, int max) {
        return number >= max ? max : (number > 1 ? Integer.highestOneBit(number - 1 << 1) : 1);
    }

    public static <K, V> OHCacheBuilder<K, V> newBuilder() {
        return new OHCacheBuilder<K, V>();
    }

    public OHCache<K, V> build() {
        if (this.fixedKeySize > 0 || this.fixedValueSize > 0 || this.chunkSize > 0) {
            return new OHCacheChunkedImpl(this);
        }
        return new OHCacheLinkedImpl(this);
    }

    public int getHashTableSize() {
        return this.hashTableSize;
    }

    public OHCacheBuilder<K, V> hashTableSize(int hashTableSize) {
        if (hashTableSize < -1) {
            throw new IllegalArgumentException("hashTableSize:" + hashTableSize);
        }
        this.hashTableSize = hashTableSize;
        return this;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public OHCacheBuilder<K, V> chunkSize(int chunkSize) {
        if (chunkSize < -1) {
            throw new IllegalArgumentException("chunkSize:" + chunkSize);
        }
        this.chunkSize = chunkSize;
        return this;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public OHCacheBuilder<K, V> capacity(long capacity) {
        if (capacity <= 0L) {
            throw new IllegalArgumentException("capacity:" + capacity);
        }
        this.capacity = capacity;
        return this;
    }

    public CacheSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OHCacheBuilder<K, V> keySerializer(CacheSerializer<K> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public CacheSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OHCacheBuilder<K, V> valueSerializer(CacheSerializer<V> valueSerializer) {
        this.valueSerializer = valueSerializer;
        return this;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public OHCacheBuilder<K, V> segmentCount(int segmentCount) {
        if (segmentCount < -1) {
            throw new IllegalArgumentException("segmentCount:" + segmentCount);
        }
        this.segmentCount = segmentCount;
        return this;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public OHCacheBuilder<K, V> loadFactor(float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor:" + loadFactor);
        }
        this.loadFactor = loadFactor;
        return this;
    }

    public long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public OHCacheBuilder<K, V> maxEntrySize(long maxEntrySize) {
        if (maxEntrySize < 0L) {
            throw new IllegalArgumentException("maxEntrySize:" + maxEntrySize);
        }
        this.maxEntrySize = maxEntrySize;
        return this;
    }

    public int getFixedKeySize() {
        return this.fixedKeySize;
    }

    public int getFixedValueSize() {
        return this.fixedValueSize;
    }

    public OHCacheBuilder<K, V> fixedEntrySize(int fixedKeySize, int fixedValueSize) {
        if (!(fixedKeySize <= 0 && fixedValueSize <= 0 || fixedKeySize > 0 && fixedValueSize > 0)) {
            throw new IllegalArgumentException("fixedKeySize:" + fixedKeySize + ",fixedValueSize:" + fixedValueSize);
        }
        this.fixedKeySize = fixedKeySize;
        this.fixedValueSize = fixedValueSize;
        return this;
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public OHCacheBuilder<K, V> executorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public HashAlgorithm getHashAlgorighm() {
        return this.hashAlgorighm;
    }

    public OHCacheBuilder<K, V> hashMode(HashAlgorithm hashMode) {
        if (hashMode == null) {
            throw new NullPointerException("hashMode");
        }
        this.hashAlgorighm = hashMode;
        return this;
    }

    public boolean isThrowOOME() {
        return this.throwOOME;
    }

    public OHCacheBuilder<K, V> throwOOME(boolean throwOOME) {
        this.throwOOME = throwOOME;
        return this;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public OHCacheBuilder<K, V> unlocked(boolean unlocked) {
        this.unlocked = unlocked;
        return this;
    }

    public long getDefaultTTLmillis() {
        return this.defaultTTLmillis;
    }

    public OHCacheBuilder<K, V> defaultTTLmillis(long defaultTTLmillis) {
        this.defaultTTLmillis = defaultTTLmillis;
        return this;
    }

    public int getTimeoutsSlots() {
        return this.timeoutsSlots;
    }

    public OHCacheBuilder<K, V> timeoutsSlots(int timeoutsSlots) {
        this.timeoutsSlots = timeoutsSlots;
        return this;
    }

    public int getTimeoutsPrecision() {
        return this.timeoutsPrecision;
    }

    public OHCacheBuilder<K, V> timeoutsPrecision(int timeoutsPrecision) {
        this.timeoutsPrecision = timeoutsPrecision;
        return this;
    }
}

