/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrodecode;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hop.avro.transforms.avrodecode.AvroDecodeData;
import org.apache.hop.avro.transforms.avrodecode.AvroDecodeMeta;
import org.apache.hop.avro.transforms.avrodecode.TargetField;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class AvroDecode
extends BaseTransform<AvroDecodeMeta, AvroDecodeData> {
    public AvroDecode(TransformMeta transformMeta, AvroDecodeMeta meta, AvroDecodeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        GenericRecord genericRecord;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AvroDecodeData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AvroDecodeMeta)this.meta).getFields(((AvroDecodeData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            String sourceFieldName = this.resolve(((AvroDecodeMeta)this.meta).getSourceFieldName());
            ((AvroDecodeData)this.data).inputIndex = this.getInputRowMeta().indexOfValue(sourceFieldName);
            if (((AvroDecodeData)this.data).inputIndex < 0) {
                throw new HopException("Unable to find Avro source field: " + sourceFieldName);
            }
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((AvroDecodeData)this.data).inputIndex);
            if (!(valueMeta instanceof ValueMetaAvroRecord)) {
                throw new HopException("We can only decode Avro data types and field " + sourceFieldName + " is of type " + valueMeta.getTypeDesc());
            }
            ((AvroDecodeData)this.data).avroValueMeta = (ValueMetaAvroRecord)valueMeta;
        }
        if ((genericRecord = ((AvroDecodeData)this.data).avroValueMeta.getGenericRecord(row[((AvroDecodeData)this.data).inputIndex])) != null) {
            Schema schema = genericRecord.getSchema();
            int idx = this.getInputRowMeta().size();
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((AvroDecodeData)this.data).outputRowMeta.size());
            for (TargetField targetField : ((AvroDecodeMeta)this.meta).getTargetFields()) {
                String avroFieldName = this.resolve(targetField.getSourceField());
                Schema.Field field = schema.getField(avroFieldName);
                Object avroValue = genericRecord.get(avroFieldName);
                Object hopValue = AvroDecode.getStandardHopObject(field, avroValue);
                IValueMeta standardValueMeta = ValueMetaFactory.createValueMeta((String)"standard", (int)AvroDecode.getStandardHopType(field));
                IValueMeta targetValueMeta = targetField.createTargetValueMeta((IVariables)this);
                standardValueMeta.setConversionMask(targetValueMeta.getConversionMask());
                outputRow[idx++] = targetValueMeta.convertData(standardValueMeta, hopValue);
            }
            this.putRow(((AvroDecodeData)this.data).outputRowMeta, outputRow);
        }
        return true;
    }

    public static final int getStandardHopType(Schema.Field field) throws HopException {
        Schema.Type type = field.schema().getType();
        int basicType = AvroDecode.getBasicType(type);
        if (basicType != 0) {
            return basicType;
        }
        if (type == Schema.Type.UNION) {
            for (Schema subType : field.schema().getTypes()) {
                if (subType.getType() == Schema.Type.NULL || (basicType = AvroDecode.getBasicType(subType.getType())) == 0) continue;
                return basicType;
            }
        }
        throw new HopException("Schema type '" + String.valueOf(type) + " isn't handled");
    }

    private static int getBasicType(Schema.Type type) {
        return switch (type) {
            case Schema.Type.BYTES -> 8;
            case Schema.Type.INT, Schema.Type.LONG -> 5;
            case Schema.Type.FLOAT, Schema.Type.DOUBLE -> 1;
            case Schema.Type.BOOLEAN -> 4;
            case Schema.Type.STRING, Schema.Type.RECORD, Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.FIXED -> 2;
            default -> 0;
        };
    }

    public static final Object getStandardHopObject(Schema.Field field, Object avroValue) throws HopException {
        Object hopValue;
        if (avroValue == null) {
            hopValue = null;
        } else {
            Schema.Type type = field.schema().getType();
            switch (type) {
                case NULL: {
                    hopValue = null;
                    break;
                }
                case ENUM: {
                    hopValue = avroValue.toString();
                    break;
                }
                case STRING: {
                    hopValue = ((Utf8)avroValue).toString();
                    break;
                }
                case BYTES: 
                case LONG: 
                case DOUBLE: {
                    hopValue = avroValue;
                    break;
                }
                case INT: {
                    hopValue = (long)((Integer)avroValue).intValue();
                    break;
                }
                case FLOAT: {
                    hopValue = (double)((Float)avroValue).floatValue();
                    break;
                }
                case BOOLEAN: {
                    hopValue = (boolean)((Boolean)avroValue);
                    break;
                }
                case RECORD: {
                    GenericData.Record record = (GenericData.Record)avroValue;
                    hopValue = record.toString();
                    break;
                }
                case ARRAY: {
                    GenericData.Array array = (GenericData.Array)avroValue;
                    hopValue = array.toString();
                    break;
                }
                case MAP: {
                    Map map = (Map)avroValue;
                    hopValue = map.toString();
                    break;
                }
                case UNION: {
                    if (avroValue instanceof Long || avroValue instanceof Double || avroValue instanceof String || avroValue instanceof Boolean || avroValue instanceof byte[]) {
                        hopValue = avroValue;
                        break;
                    }
                    if (avroValue instanceof Float) {
                        hopValue = (double)((Float)avroValue).floatValue();
                        break;
                    }
                    if (avroValue instanceof Integer) {
                        hopValue = Integer.valueOf((Integer)avroValue).longValue();
                        break;
                    }
                    hopValue = avroValue.toString();
                    break;
                }
                case FIXED: {
                    GenericContainer container = (GenericContainer)avroValue;
                    hopValue = container.toString();
                    break;
                }
                default: {
                    throw new HopException("Schema type " + String.valueOf(type) + " isn't handled yet");
                }
            }
        }
        return hopValue;
    }
}

