/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.graph.ImmutableExecutableStage;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.SideInputReference;
import org.apache.beam.sdk.util.construction.graph.TimerReference;
import org.apache.beam.sdk.util.construction.graph.UserStateReference;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface ExecutableStage {
    public static final @UnknownKeyFor @NonNull @Initialized String URN = "beam:runner:executable_stage:v1";
    public static final @UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting> DEFAULT_WIRE_CODER_SETTINGS = Collections.emptyList();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Components getComponents();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment getEnvironment();

    public @UnknownKeyFor @NonNull @Initialized Collection<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload.WireCoderSetting> getWireCoderSettings();

    public @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode getInputPCollection();

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized SideInputReference> getSideInputs();

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized UserStateReference> getUserStates();

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized TimerReference> getTimers();

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> getOutputPCollections();

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getTransforms();

    default public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform toPTransform(@UnknownKeyFor @NonNull @Initialized String uniqueName) {
        RunnerApi.PTransform.Builder pt = RunnerApi.PTransform.newBuilder().setUniqueName(uniqueName);
        RunnerApi.ExecutableStagePayload.Builder payload = RunnerApi.ExecutableStagePayload.newBuilder();
        payload.setEnvironment(this.getEnvironment());
        payload.addAllWireCoderSettings(this.getWireCoderSettings());
        PipelineNode.PCollectionNode input = this.getInputPCollection();
        pt.putInputs("input", this.getInputPCollection().getId());
        payload.setInput(input.getId());
        for (SideInputReference sideInput : this.getSideInputs()) {
            String outerLocalName = String.format("%s:%s", sideInput.transform().getId(), sideInput.localName());
            pt.putInputs(outerLocalName, sideInput.collection().getId());
            payload.addSideInputs(RunnerApi.ExecutableStagePayload.SideInputId.newBuilder().setTransformId(sideInput.transform().getId()).setLocalName(sideInput.localName()));
        }
        for (UserStateReference userState : this.getUserStates()) {
            payload.addUserStates(RunnerApi.ExecutableStagePayload.UserStateId.newBuilder().setTransformId(userState.transform().getId()).setLocalName(userState.localName()));
        }
        for (TimerReference timer : this.getTimers()) {
            payload.addTimers(RunnerApi.ExecutableStagePayload.TimerId.newBuilder().setTransformId(timer.transform().getId()).setLocalName(timer.localName()));
        }
        int outputIndex = 0;
        for (PipelineNode.PCollectionNode output : this.getOutputPCollections()) {
            pt.putOutputs(String.format("materialized_%d", outputIndex), output.getId());
            payload.addOutputs(output.getId());
            ++outputIndex;
        }
        for (PipelineNode.PTransformNode transform : this.getTransforms()) {
            payload.addTransforms(transform.getId());
        }
        payload.setComponents(this.getComponents().toBuilder().clearTransforms().putAllTransforms(this.getTransforms().stream().collect(Collectors.toMap(PipelineNode.PTransformNode::getId, PipelineNode.PTransformNode::getTransform))));
        pt.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(URN).setPayload(payload.build().toByteString()).build());
        return pt.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ExecutableStage fromPayload(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ExecutableStagePayload payload) {
        RunnerApi.Components components = payload.getComponents();
        RunnerApi.Environment environment = payload.getEnvironment();
        List wireCoderSettings = payload.getWireCoderSettingsList();
        PipelineNode.PCollectionNode input = PipelineNode.pCollection(payload.getInput(), components.getPcollectionsOrThrow(payload.getInput()));
        List<SideInputReference> sideInputs = payload.getSideInputsList().stream().map(sideInputId -> SideInputReference.fromSideInputId(sideInputId, components)).collect(Collectors.toList());
        List<UserStateReference> userStates = payload.getUserStatesList().stream().map(userStateId -> UserStateReference.fromUserStateId(userStateId, components)).collect(Collectors.toList());
        List<TimerReference> timers = payload.getTimersList().stream().map(timerId -> TimerReference.fromTimerId(timerId, components)).collect(Collectors.toList());
        List<PipelineNode.PTransformNode> transforms = payload.getTransformsList().stream().map(id -> PipelineNode.pTransform(id, components.getTransformsOrThrow(id))).collect(Collectors.toList());
        List<PipelineNode.PCollectionNode> outputs = payload.getOutputsList().stream().map(id -> PipelineNode.pCollection(id, components.getPcollectionsOrThrow(id))).collect(Collectors.toList());
        return ImmutableExecutableStage.of(components, environment, input, sideInputs, userStates, timers, transforms, outputs, wireCoderSettings);
    }
}

