/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class ConfigurationDialog
extends Dialog {
    protected AbstractMeta abstractMeta;
    protected IExecutionConfiguration configuration;
    protected TableView wVariables;
    protected boolean retval;
    protected Shell shell;
    protected Label wlLogLevel;
    protected Group gDetails;
    protected CCombo wLogLevel;
    protected Button wClearLog;
    protected int margin;
    protected Composite composite;
    protected Control wRunConfigurationControl;
    private TableView wParams;
    private Shell parent;
    private Button wOk;
    protected FormData fdDetails;
    private Button alwaysShowOption;
    protected HopGui hopGui;
    public static final String LOG_LEVEL = "LOG_LEVEL";

    public ConfigurationDialog(Shell parent, IExecutionConfiguration configuration, AbstractMeta meta) {
        super(parent);
        String[] paramNames;
        this.parent = parent;
        this.configuration = configuration;
        this.abstractMeta = meta;
        this.hopGui = HopGui.getInstance();
        Map params = configuration.getParametersMap();
        params.clear();
        for (String name : paramNames = meta.listParameters()) {
            params.put(name, "");
        }
        this.margin = PropsUi.getMargin();
    }

    protected void getInfoVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wVariables.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wVariables.getNonEmpty(i);
            String varName = tableItem.getText(1);
            String varValue = tableItem.getText(2);
            if (Utils.isEmpty((CharSequence)varName)) continue;
            map.put(varName, varValue);
        }
        this.configuration.setVariablesMap(map);
    }

    protected void getInfoParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        int nrNonEmptyVariables = this.wParams.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyVariables; ++i) {
            TableItem tableItem = this.wParams.getNonEmpty(i);
            String paramName = tableItem.getText(1);
            String defaultValue = tableItem.getText(2);
            String paramValue = tableItem.getText(3);
            if (Utils.isEmpty((CharSequence)paramValue)) {
                paramValue = Const.NVL((String)defaultValue, (String)"");
            }
            map.put(paramName, paramValue);
        }
        this.configuration.setParametersMap(map);
    }

    protected void ok() {
        this.abstractMeta.setAlwaysShowRunOptions(this.alwaysShowOption.getSelection());
        this.abstractMeta.setShowDialog(this.alwaysShowOption.getSelection());
        if (Const.isOSX()) {
            this.wVariables.applyOSXChanges();
            this.wParams.applyOSXChanges();
        }
        if (this.getInfo()) {
            this.retval = true;
            this.dispose();
        }
    }

    private void dispose() {
        PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    protected void cancel() {
        this.dispose();
    }

    public abstract boolean getInfo();

    protected void getParamsData() {
        this.wParams.clearAll(false);
        ArrayList paramNames = new ArrayList(this.configuration.getParametersMap().keySet());
        Collections.sort(paramNames);
        for (int i = 0; i < paramNames.size(); ++i) {
            String description;
            String defaultValue;
            String paramName = (String)paramNames.get(i);
            String paramValue = (String)this.configuration.getParametersMap().get(paramName);
            try {
                defaultValue = this.abstractMeta.getParameterDefault(paramName);
            }
            catch (UnknownParamException e) {
                defaultValue = "";
            }
            try {
                description = this.abstractMeta.getParameterDescription(paramName);
            }
            catch (UnknownParamException e) {
                description = "";
            }
            TableItem tableItem = new TableItem(this.wParams.table, 0);
            tableItem.setText(1, paramName);
            tableItem.setText(2, Const.NVL((String)defaultValue, (String)""));
            tableItem.setText(3, Const.NVL((String)paramValue, (String)""));
            tableItem.setText(4, Const.NVL((String)description, (String)""));
        }
        this.wParams.removeEmptyRows();
        this.wParams.setRowNums();
        this.wParams.optWidth(true);
    }

    public void setConfiguration(IExecutionConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void mainLayout(String shellTitle, Image img) {
        this.shell = new Shell(this.parent, 3184);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(img);
        this.shell.setText(shellTitle);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin() * 2;
        formLayout.marginHeight = PropsUi.getFormMargin() * 2;
        this.shell.setLayout((Layout)formLayout);
    }

    protected void optionsSectionLayout(Class<?> PKG, String prefix) {
        this.gDetails = new Group((Composite)this.shell, 16);
        this.gDetails.setText(BaseMessages.getString(PKG, (String)(prefix + ".DetailsGroup.Label"), (String[])new String[0]));
        PropsUi.setLook((Widget)this.gDetails);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin() * 2;
        formLayout.marginHeight = PropsUi.getFormMargin() * 2;
        this.gDetails.setLayout((Layout)formLayout);
        this.fdDetails = new FormData();
        this.fdDetails.top = new FormAttachment(this.wRunConfigurationControl, 15);
        this.fdDetails.right = new FormAttachment(100, 0);
        this.fdDetails.left = new FormAttachment(0, 0);
        this.gDetails.setBackground(this.shell.getBackground());
        this.gDetails.setLayoutData((Object)this.fdDetails);
        this.optionsSectionControls();
    }

    protected void parametersSectionLayout(Class<?> PKG, String prefix) {
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)tabFolder, 4);
        FormData fdTabFolder = new FormData();
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.gDetails, 15);
        fdTabFolder.bottom = new FormAttachment((Control)this.alwaysShowOption, -15);
        tabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem tbtmParameters = new CTabItem(tabFolder, 0);
        tbtmParameters.setFont(GuiResource.getInstance().getFontDefault());
        tbtmParameters.setText(BaseMessages.getString(PKG, (String)(prefix + ".Params.Label"), (String[])new String[0]));
        Composite parametersComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)parametersComposite);
        parametersComposite.setLayout((Layout)new FormLayout());
        tbtmParameters.setControl((Control)parametersComposite);
        ColumnInfo[] cParams = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Argument"), (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Default"), (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Value"), (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".ParamsColumn.Description"), (String[])new String[0]), 1, false, true)};
        String[] namedParams = this.abstractMeta.listParameters();
        int nrParams = namedParams.length;
        this.wParams = new TableView(this.hopGui.getVariables(), parametersComposite, 65538, cParams, nrParams, false, null, PropsUi.getInstance(), false, null, false, false);
        FormData fdParams = new FormData();
        fdParams.top = new FormAttachment(0, 0);
        fdParams.right = new FormAttachment(100, 0);
        fdParams.bottom = new FormAttachment(100, 0);
        fdParams.left = new FormAttachment(0, 0);
        this.wParams.setLayoutData(fdParams);
        tabFolder.setSelection(0);
        CTabItem tbtmVariables = new CTabItem(tabFolder, 0);
        tbtmVariables.setFont(GuiResource.getInstance().getFontDefault());
        tbtmVariables.setText(BaseMessages.getString(PKG, (String)(prefix + ".Variables.Label"), (String[])new String[0]));
        tbtmVariables.setImage(GuiResource.getInstance().getImageVariable());
        Composite variablesComposite = new Composite((Composite)tabFolder, 0);
        PropsUi.setLook((Widget)variablesComposite);
        variablesComposite.setLayout((Layout)new FormLayout());
        tbtmVariables.setControl((Control)variablesComposite);
        ColumnInfo[] cVariables = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".VariablesColumn.Argument"), (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)(prefix + ".VariablesColumn.Value"), (String[])new String[0]), 1, false, false)};
        int nrVariables = this.configuration.getVariablesMap() != null ? this.configuration.getVariablesMap().size() : 0;
        this.wVariables = new TableView(this.hopGui.getVariables(), variablesComposite, 65538, cVariables, nrVariables, false, null, PropsUi.getInstance(), false, null, true, false);
        FormData fdVariables = new FormData();
        fdVariables.top = new FormAttachment(0, 0);
        fdVariables.right = new FormAttachment(100, 0);
        fdVariables.bottom = new FormAttachment(100, 0);
        fdVariables.left = new FormAttachment(0, 0);
        this.wVariables.setLayoutData(fdVariables);
    }

    protected void buttonsSectionLayout(String alwaysShowOptionLabel, String alwaysShowOptionTooltip, String docTitle, String docUrl, String docHeader) {
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        wCancel.addListener(13, e -> this.cancel());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString((String)"System.Button.Launch"));
        this.wOk.addListener(13, e -> this.ok());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, wCancel}, this.margin, null);
        Button wbHelp = HelpUtils.createHelpButton((Composite)this.shell, docUrl);
        FormData fdbHelp = new FormData();
        fdbHelp.bottom = new FormAttachment(100, 0);
        fdbHelp.left = new FormAttachment(0, 0);
        wbHelp.setLayoutData((Object)fdbHelp);
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.right = new FormAttachment(100, 0);
        fdSeparator.left = new FormAttachment(0, 0);
        fdSeparator.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        separator.setLayoutData((Object)fdSeparator);
        this.alwaysShowOption = new Button((Composite)this.shell, 32);
        this.alwaysShowOption.setText(alwaysShowOptionLabel);
        this.alwaysShowOption.setToolTipText(alwaysShowOptionTooltip);
        PropsUi.setLook((Widget)this.alwaysShowOption);
        this.alwaysShowOption.setSelection(this.abstractMeta.isAlwaysShowRunOptions());
        FormData fdAlwaysShowOption = new FormData();
        fdAlwaysShowOption.left = new FormAttachment(0, 0);
        fdAlwaysShowOption.bottom = new FormAttachment((Control)separator, -15);
        this.alwaysShowOption.setLayoutData((Object)fdAlwaysShowOption);
    }

    protected void openDialog() {
        this.shell.setDefaultButton(this.wOk);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
    }

    protected abstract void optionsSectionControls();
}

