/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl;

import io.github.spannm.jackcess.impl.PageChannel;
import io.github.spannm.jackcess.impl.TempBufferHolder;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class TempPageHolder {
    private int _pageNumber = -1;
    private final TempBufferHolder _buffer;
    private int _bufferModCount;

    private TempPageHolder(TempBufferHolder.Type type) {
        this._buffer = TempBufferHolder.newHolder(type, false);
        this._bufferModCount = this._buffer.getModCount();
    }

    public static TempPageHolder newHolder(TempBufferHolder.Type type) {
        return new TempPageHolder(type);
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public ByteBuffer getPage(PageChannel pageChannel) throws IOException {
        return this.withPage(pageChannel, this._pageNumber, false);
    }

    public ByteBuffer withPage(PageChannel pageChannel, int pageNumber) throws IOException {
        return this.withPage(pageChannel, pageNumber, true);
    }

    private ByteBuffer withPage(PageChannel pageChannel, int pageNumber, boolean rewind) throws IOException {
        ByteBuffer buffer = this._buffer.getPageBuffer(pageChannel);
        int modCount = this._buffer.getModCount();
        if (pageNumber != this._pageNumber || this._bufferModCount != modCount) {
            this._pageNumber = pageNumber;
            this._bufferModCount = modCount;
            pageChannel.readPage(buffer, this._pageNumber);
        } else if (rewind) {
            buffer.rewind();
        }
        return buffer;
    }

    public ByteBuffer withNewPage(PageChannel pageChannel) throws IOException {
        this.clear();
        this._pageNumber = pageChannel.allocateNewPage();
        return this._buffer.getPageBuffer(pageChannel);
    }

    public void invalidate() {
        this.possiblyInvalidate(this._pageNumber, null);
    }

    public void possiblyInvalidate(int modifiedPageNumber, ByteBuffer modifiedBuffer) {
        if (modifiedBuffer == this._buffer.getExistingBuffer()) {
            return;
        }
        if (modifiedPageNumber == this._pageNumber) {
            this._pageNumber = -1;
        }
    }

    public void clear() {
        this.invalidate();
        this._buffer.clear();
    }
}

