/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.CreateFolderBatchError;
import com.dropbox.core.v2.files.CreateFolderBatchResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class CreateFolderBatchJobStatus {
    public static final CreateFolderBatchJobStatus IN_PROGRESS = new CreateFolderBatchJobStatus().withTag(Tag.IN_PROGRESS);
    public static final CreateFolderBatchJobStatus OTHER = new CreateFolderBatchJobStatus().withTag(Tag.OTHER);
    private Tag _tag;
    private CreateFolderBatchResult completeValue;
    private CreateFolderBatchError failedValue;

    private CreateFolderBatchJobStatus() {
    }

    private CreateFolderBatchJobStatus withTag(Tag _tag) {
        CreateFolderBatchJobStatus result = new CreateFolderBatchJobStatus();
        result._tag = _tag;
        return result;
    }

    private CreateFolderBatchJobStatus withTagAndComplete(Tag _tag, CreateFolderBatchResult completeValue) {
        CreateFolderBatchJobStatus result = new CreateFolderBatchJobStatus();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    private CreateFolderBatchJobStatus withTagAndFailed(Tag _tag, CreateFolderBatchError failedValue) {
        CreateFolderBatchJobStatus result = new CreateFolderBatchJobStatus();
        result._tag = _tag;
        result.failedValue = failedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static CreateFolderBatchJobStatus complete(CreateFolderBatchResult value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new CreateFolderBatchJobStatus().withTagAndComplete(Tag.COMPLETE, value);
    }

    public CreateFolderBatchResult getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static CreateFolderBatchJobStatus failed(CreateFolderBatchError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new CreateFolderBatchJobStatus().withTagAndFailed(Tag.FAILED, value);
    }

    public CreateFolderBatchError getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CreateFolderBatchJobStatus) {
            CreateFolderBatchJobStatus other = (CreateFolderBatchJobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals((Object)other.failedValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<CreateFolderBatchJobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CreateFolderBatchJobStatus value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    CreateFolderBatchResult.Serializer.INSTANCE.serialize(value.completeValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    this.writeTag("failed", g);
                    g.writeFieldName("failed");
                    CreateFolderBatchError.Serializer.INSTANCE.serialize(value.failedValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public CreateFolderBatchJobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            CreateFolderBatchJobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                CreateFolderBatchResult fieldValue = null;
                fieldValue = CreateFolderBatchResult.Serializer.INSTANCE.deserialize(p, true);
                value = CreateFolderBatchJobStatus.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                CreateFolderBatchError fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = CreateFolderBatchError.Serializer.INSTANCE.deserialize(p);
                value = CreateFolderBatchJobStatus.failed(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED,
        OTHER;

    }
}

