/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics;

import java.util.List;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedLongUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongMeasurement;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.AbstractInstrument;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentValueType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkDoubleUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkLongUpDownCounter
extends AbstractInstrument
implements ExtendedLongUpDownCounter {
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkLongUpDownCounter(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkLongUpDownCounterBuilder
    implements ExtendedLongUpDownCounterBuilder {
        private final InstrumentBuilder builder;

        SdkLongUpDownCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        public LongUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public LongUpDownCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkLongUpDownCounter(x$0, x$1, x$2));
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return this.builder.swapBuilder(SdkDoubleUpDownCounter.SdkDoubleUpDownCounterBuilder::new);
        }

        @Override
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        @Override
        public ExtendedLongUpDownCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

