/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.monitoring.v3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.PathTemplate;
import net.snowflake.client.jdbc.internal.google.api.pathtemplate.ValidationException;
import net.snowflake.client.jdbc.internal.google.api.resourcenames.ResourceName;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;

public class NotificationChannelDescriptorName
implements ResourceName {
    private static final PathTemplate PROJECT_CHANNEL_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("projects/{project}/notificationChannelDescriptors/{channel_descriptor}");
    private static final PathTemplate ORGANIZATION_CHANNEL_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/notificationChannelDescriptors/{channel_descriptor}");
    private static final PathTemplate FOLDER_CHANNEL_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("folders/{folder}/notificationChannelDescriptors/{channel_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String channelDescriptor;
    private final String organization;
    private final String folder;

    @Deprecated
    protected NotificationChannelDescriptorName() {
        this.project = null;
        this.channelDescriptor = null;
        this.organization = null;
        this.folder = null;
    }

    private NotificationChannelDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.channelDescriptor = Preconditions.checkNotNull(builder.getChannelDescriptor());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_CHANNEL_DESCRIPTOR;
    }

    private NotificationChannelDescriptorName(OrganizationChannelDescriptorBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.channelDescriptor = Preconditions.checkNotNull(builder.getChannelDescriptor());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_CHANNEL_DESCRIPTOR;
    }

    private NotificationChannelDescriptorName(FolderChannelDescriptorBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.channelDescriptor = Preconditions.checkNotNull(builder.getChannelDescriptor());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_CHANNEL_DESCRIPTOR;
    }

    public String getProject() {
        return this.project;
    }

    public String getChannelDescriptor() {
        return this.channelDescriptor;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectChannelDescriptorBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationChannelDescriptorBuilder newOrganizationChannelDescriptorBuilder() {
        return new OrganizationChannelDescriptorBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderChannelDescriptorBuilder newFolderChannelDescriptorBuilder() {
        return new FolderChannelDescriptorBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NotificationChannelDescriptorName of(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationChannelDescriptorName ofProjectChannelDescriptorName(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationChannelDescriptorName ofOrganizationChannelDescriptorName(String organization, String channelDescriptor) {
        return NotificationChannelDescriptorName.newOrganizationChannelDescriptorBuilder().setOrganization(organization).setChannelDescriptor(channelDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static NotificationChannelDescriptorName ofFolderChannelDescriptorName(String folder, String channelDescriptor) {
        return NotificationChannelDescriptorName.newFolderChannelDescriptorBuilder().setFolder(folder).setChannelDescriptor(channelDescriptor).build();
    }

    public static String format(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectChannelDescriptorName(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationChannelDescriptorName(String organization, String channelDescriptor) {
        return NotificationChannelDescriptorName.newOrganizationChannelDescriptorBuilder().setOrganization(organization).setChannelDescriptor(channelDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderChannelDescriptorName(String folder, String channelDescriptor) {
        return NotificationChannelDescriptorName.newFolderChannelDescriptorBuilder().setFolder(folder).setChannelDescriptor(channelDescriptor).build().toString();
    }

    public static NotificationChannelDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CHANNEL_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_CHANNEL_DESCRIPTOR.match(formattedString);
            return NotificationChannelDescriptorName.ofProjectChannelDescriptorName(matchMap.get("project"), matchMap.get("channel_descriptor"));
        }
        if (ORGANIZATION_CHANNEL_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_CHANNEL_DESCRIPTOR.match(formattedString);
            return NotificationChannelDescriptorName.ofOrganizationChannelDescriptorName(matchMap.get("organization"), matchMap.get("channel_descriptor"));
        }
        if (FOLDER_CHANNEL_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_CHANNEL_DESCRIPTOR.match(formattedString);
            return NotificationChannelDescriptorName.ofFolderChannelDescriptorName(matchMap.get("folder"), matchMap.get("channel_descriptor"));
        }
        throw new ValidationException("NotificationChannelDescriptorName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<NotificationChannelDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationChannelDescriptorName> list = new ArrayList<NotificationChannelDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationChannelDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationChannelDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationChannelDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CHANNEL_DESCRIPTOR.matches(formattedString) || ORGANIZATION_CHANNEL_DESCRIPTOR.matches(formattedString) || FOLDER_CHANNEL_DESCRIPTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationChannelDescriptorName notificationChannelDescriptorName = this;
            synchronized (notificationChannelDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.channelDescriptor != null) {
                        fieldMapBuilder.put("channel_descriptor", this.channelDescriptor);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NotificationChannelDescriptorName that = (NotificationChannelDescriptorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.channelDescriptor, that.channelDescriptor) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.fixedValue);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.channelDescriptor);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.organization);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderChannelDescriptorBuilder {
        private String folder;
        private String channelDescriptor;

        protected FolderChannelDescriptorBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public FolderChannelDescriptorBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderChannelDescriptorBuilder setChannelDescriptor(String channelDescriptor) {
            this.channelDescriptor = channelDescriptor;
            return this;
        }

        public NotificationChannelDescriptorName build() {
            return new NotificationChannelDescriptorName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationChannelDescriptorBuilder {
        private String organization;
        private String channelDescriptor;

        protected OrganizationChannelDescriptorBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public OrganizationChannelDescriptorBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationChannelDescriptorBuilder setChannelDescriptor(String channelDescriptor) {
            this.channelDescriptor = channelDescriptor;
            return this;
        }

        public NotificationChannelDescriptorName build() {
            return new NotificationChannelDescriptorName(this);
        }
    }

    public static class Builder {
        private String project;
        private String channelDescriptor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setChannelDescriptor(String channelDescriptor) {
            this.channelDescriptor = channelDescriptor;
            return this;
        }

        private Builder(NotificationChannelDescriptorName notificationChannelDescriptorName) {
            Preconditions.checkArgument(Objects.equals(notificationChannelDescriptorName.pathTemplate, PROJECT_CHANNEL_DESCRIPTOR), "toBuilder is only supported when NotificationChannelDescriptorName has the pattern of projects/{project}/notificationChannelDescriptors/{channel_descriptor}");
            this.project = notificationChannelDescriptorName.project;
            this.channelDescriptor = notificationChannelDescriptorName.channelDescriptor;
        }

        public NotificationChannelDescriptorName build() {
            return new NotificationChannelDescriptorName(this);
        }
    }
}

