/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import net.snowflake.client.core.Event;
import net.snowflake.client.core.EventUtil;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFOCSPException;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.core.URLUtil;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.OCSPErrorCode;
import net.snowflake.client.jdbc.RetryContextManager;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.DecorrelatedJitterBackoff;
import net.snowflake.client.util.SecretDetector;
import net.snowflake.client.util.Stopwatch;

public class RestRequest {
    private static final SFLogger logger = SFLoggerFactory.getLogger(RestRequest.class);
    private static final String SF_REQUEST_GUID = "request_guid";
    private static final long minBackoffInMilli = 1000L;
    private static final long maxBackoffInMilli = 16000L;
    private static final int MIN_RETRY_COUNT = 1;

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403, ExecTimeTelemetryData execTimeTelemetryData) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryHTTP403, false, execTimeTelemetryData, null);
    }

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryHTTP403, noRetry, execTimeData, null);
    }

    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403, ExecTimeTelemetryData execTimeData, RetryContextManager retryContextManager) throws SnowflakeSQLException {
        return RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryHTTP403, false, execTimeData, retryContextManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpResponse execute(CloseableHttpClient httpClient, HttpRequestBase httpRequest, long retryTimeout, long authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryHTTP403, boolean noRetry, ExecTimeTelemetryData execTimeData, RetryContextManager retryManager) throws SnowflakeSQLException {
        long startTime;
        Stopwatch stopwatch = null;
        if (logger.isDebugEnabled()) {
            stopwatch = new Stopwatch();
            stopwatch.start();
        }
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        String requestIdStr = URLUtil.getRequestIdLogStr(httpRequest.getURI());
        logger.debug("{}Executing rest request: {}, retry timeout: {}, socket timeout: {}, max retries: {}, inject socket timeout: {}, canceling: {}, without cookies: {}, include retry parameters: {}, include request guid: {}, retry http 403: {}, no retry: {}", requestIdStr, requestInfoScrubbed, retryTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryHTTP403, noRetry);
        CloseableHttpResponse response = null;
        long startTimePerRequest = startTime = System.currentTimeMillis();
        boolean isLoginRequest = SessionUtil.isNewRetryStrategyRequest(httpRequest);
        if (isLoginRequest) {
            logger.debug("{}Request is a login/auth request. Using new retry strategy", requestIdStr);
        }
        long elapsedMilliForTransientIssues = 0L;
        long retryTimeoutInMilliseconds = retryTimeout * 1000L;
        long backoffInMilli = 1000L;
        long authTimeoutInMilli = authTimeout * 1000L;
        DecorrelatedJitterBackoff backoff = new DecorrelatedJitterBackoff(backoffInMilli, 16000L);
        int origSocketTimeout = 0;
        Exception savedEx = null;
        String breakRetryReason = "";
        String lastStatusCodeForRetry = "";
        int retryCount = 0;
        RestRequest.setRequestConfig(httpRequest, withoutCookies, injectSocketTimeout, requestIdStr, authTimeoutInMilli);
        while (true) {
            logger.debug("{}Retry count: {}, max retries: {}, retry timeout: {} s, backoff: {} ms. Attempting request: {}", requestIdStr, retryCount, maxRetries, retryTimeout, backoffInMilli, requestInfoScrubbed);
            try {
                startTimePerRequest = System.currentTimeMillis();
                RestRequest.setRequestURI(httpRequest, requestIdStr, includeRetryParameters, includeRequestGuid, retryCount, lastStatusCodeForRetry, startTime, requestInfoScrubbed);
                execTimeData.setHttpClientStart();
                response = httpClient.execute(httpRequest);
                execTimeData.setHttpClientEnd();
            }
            catch (IllegalStateException ex) {
                throw new SnowflakeSQLLoggedException(null, ErrorCode.INVALID_STATE, ex, ex.getMessage());
            }
            catch (SSLHandshakeException | SSLKeyException | SSLPeerUnverifiedException | SSLProtocolException ex) {
                String formattedMsg = ex.getMessage() + "\nVerify that the hostnames and portnumbers in SYSTEM$ALLOWLIST are added to your firewall's allowed list.\nTo troubleshoot your connection further, you can refer to this article:\nhttps://docs.snowflake.com/en/user-guide/client-connectivity-troubleshooting/overview";
                throw new SnowflakeSQLLoggedException(null, ErrorCode.NETWORK_ERROR, ex, formattedMsg);
            }
            catch (Exception ex) {
                savedEx = ex;
                long currentMillis = System.currentTimeMillis();
                if (currentMillis - startTimePerRequest > HttpUtil.getSocketTimeout().toMillis()) {
                    logger.warn("{}HTTP request took longer than socket timeout {} ms: {} ms", requestIdStr, HttpUtil.getSocketTimeout().toMillis(), currentMillis - startTimePerRequest);
                }
                StringWriter sw = new StringWriter();
                savedEx.printStackTrace(new PrintWriter(sw));
                Object[] objectArray = new Object[4];
                objectArray[0] = requestIdStr;
                objectArray[1] = requestInfoScrubbed;
                objectArray[2] = ex.getLocalizedMessage();
                objectArray[3] = sw::toString;
                logger.debug("{}Exception encountered for: {}, {}, {}", objectArray);
            }
            finally {
                if (injectSocketTimeout != 0 && retryCount == 0) {
                    httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(origSocketTimeout, withoutCookies));
                }
            }
            if (noRetry || RestRequest.isCertificateRevoked(savedEx) || RestRequest.isNonRetryableHTTPCode(response, retryHTTP403)) {
                String msg = "Unknown cause";
                if (response != null) {
                    logger.debug("{}HTTP response code for request {}: {}", requestIdStr, requestInfoScrubbed, response.getStatusLine().getStatusCode());
                    msg = "StatusCode: " + response.getStatusLine().getStatusCode() + ", Reason: " + response.getStatusLine().getReasonPhrase();
                } else if (savedEx != null) {
                    Throwable rootCause = RestRequest.getRootCause(savedEx);
                    msg = rootCause.getMessage();
                }
                if (response == null || response.getStatusLine().getStatusCode() != 200) {
                    logger.debug("{}Error response not retryable, " + msg + ", request: {}", requestIdStr, requestInfoScrubbed);
                    EventUtil.triggerBasicEvent(Event.EventType.NETWORK_ERROR, msg + ", Request: " + httpRequest, false);
                }
                breakRetryReason = "status code does not need retry";
                if (noRetry) {
                    logger.debug("{}HTTP retry disabled for this request. noRetry: {}", requestIdStr, noRetry);
                    breakRetryReason = "retry is disabled";
                }
                retryCount = 0;
                break;
            }
            if (response != null) {
                logger.debug("{}HTTP response not ok: status code: {}, request: {}", requestIdStr, response.getStatusLine().getStatusCode(), requestInfoScrubbed);
            } else if (savedEx != null) {
                logger.debug("{}Null response for cause: {}, request: {}", requestIdStr, RestRequest.getRootCause(savedEx).getMessage(), requestInfoScrubbed);
            } else {
                logger.debug("{}Null response for request: {}", requestIdStr, requestInfoScrubbed);
            }
            long elapsedMilliForLastCall = System.currentTimeMillis() - startTimePerRequest;
            if (canceling != null && canceling.get()) {
                logger.debug("{}Stop retrying since canceling is requested", requestIdStr);
                breakRetryReason = "canceling is requested";
                break;
            }
            String breakRetryEventName = "";
            if (retryTimeoutInMilliseconds > 0L && (elapsedMilliForTransientIssues += elapsedMilliForLastCall) > retryTimeoutInMilliseconds && retryCount >= 1) {
                logger.error("{}Stop retrying since elapsed time due to network issues has reached timeout. Elapsed: {} ms, timeout: {} ms", requestIdStr, elapsedMilliForTransientIssues, retryTimeoutInMilliseconds);
                breakRetryReason = "retry timeout";
                breakRetryEventName = "HttpRequestRetryTimeout";
            }
            if (maxRetries > 0 && retryCount > maxRetries) {
                logger.error("{}Stop retrying as max retries have been reached for request: {}! Max retry count: {}", requestIdStr, requestInfoScrubbed, maxRetries);
                breakRetryReason = "max retries reached";
                breakRetryEventName = "HttpRequestRetryLimitExceeded";
            }
            if (!breakRetryEventName.isEmpty()) {
                TelemetryService.getInstance().logHttpRequestTelemetryEvent(breakRetryEventName, httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
                if (response == null && savedEx != null) {
                    throw new SnowflakeSQLException((Throwable)savedEx, ErrorCode.NETWORK_ERROR, "Exception encountered for HTTP request: " + savedEx.getMessage());
                }
                retryCount = 0;
                break;
            }
            if (authTimeout > 0L && elapsedMilliForTransientIssues > authTimeoutInMilli && (socketTimeout == 0 || elapsedMilliForTransientIssues < (long)socketTimeout) && String.valueOf(httpRequest.getURI()).contains("login-request")) {
                throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, retryCount, true, elapsedMilliForTransientIssues / 1000L);
            }
            if (backoffInMilli > elapsedMilliForLastCall) {
                try {
                    logger.debug("{}Retry request {}: sleeping for {} ms", requestIdStr, requestInfoScrubbed, backoffInMilli);
                    Thread.sleep(backoffInMilli);
                }
                catch (InterruptedException ex1) {
                    logger.debug("{}Backoff sleep before retrying login got interrupted", requestIdStr);
                }
                backoffInMilli = RestRequest.getNewBackoffInMilli(backoffInMilli, isLoginRequest, backoff, retryCount, retryTimeoutInMilliseconds, elapsedMilliForTransientIssues += backoffInMilli);
            }
            ++retryCount;
            lastStatusCodeForRetry = response == null ? "0" : String.valueOf(response.getStatusLine().getStatusCode());
            RetryContextManager.RetryHook retryManagerHook = null;
            if (retryManager != null) {
                retryManagerHook = retryManager.getRetryHook();
                retryManager.getRetryContext().setElapsedTimeInMillis(elapsedMilliForTransientIssues).setRetryTimeoutInMillis(retryTimeoutInMilliseconds);
            }
            if (retryManagerHook == RetryContextManager.RetryHook.ALWAYS_BEFORE_RETRY) {
                retryManager.executeRetryCallbacks(httpRequest);
            }
            if (authTimeout > 0L && elapsedMilliForTransientIssues >= authTimeoutInMilli) {
                throw new SnowflakeSQLException(ErrorCode.AUTHENTICATOR_REQUEST_TIMEOUT, retryCount, false, elapsedMilliForTransientIssues / 1000L);
            }
            int numOfRetryToTriggerTelemetry = TelemetryService.getInstance().getNumOfRetryToTriggerTelemetry();
            if (retryCount == numOfRetryToTriggerTelemetry) {
                TelemetryService.getInstance().logHttpRequestTelemetryEvent(String.format("HttpRequestRetry%dTimes", numOfRetryToTriggerTelemetry), httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, "58030", ErrorCode.NETWORK_ERROR.getMessageCode());
            }
            savedEx = null;
            httpRequest.releaseConnection();
        }
        if (response == null) {
            if (savedEx != null) {
                logger.error("{}Returning null response. Cause: {}, request: {}", requestIdStr, RestRequest.getRootCause(savedEx), requestInfoScrubbed);
            } else {
                logger.error("{}Returning null response for request: {}", requestIdStr, requestInfoScrubbed);
            }
        } else if (response.getStatusLine().getStatusCode() != 200) {
            logger.error("{}Error response: HTTP Response code: {}, request: {}", requestIdStr, response.getStatusLine().getStatusCode(), requestInfoScrubbed);
        }
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            String eventName = response == null ? "NullResponseHttpError" : (response.getStatusLine() == null ? "NullResponseStatusLine" : String.format("HttpError%d", response.getStatusLine().getStatusCode()));
            TelemetryService.getInstance().logHttpRequestTelemetryEvent(eventName, httpRequest, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, response, savedEx, breakRetryReason, retryTimeout, retryCount, null, 0);
            if (response == null && savedEx != null) {
                throw new SnowflakeSQLException((Throwable)savedEx, ErrorCode.NETWORK_ERROR, "Exception encountered for HTTP request: " + savedEx.getMessage());
            }
        }
        if (logger.isDebugEnabled() && stopwatch != null) {
            stopwatch.stop();
        }
        logger.debug("{}Execution of request {} took {} ms with total of {} retries", requestIdStr, requestInfoScrubbed, stopwatch == null ? "n/a" : Long.valueOf(stopwatch.elapsedMillis()), retryCount);
        return response;
    }

    static long getNewBackoffInMilli(long previousBackoffInMilli, boolean isLoginRequest, DecorrelatedJitterBackoff decorrelatedJitterBackoff, int retryCount, long retryTimeoutInMilliseconds, long elapsedMilliForTransientIssues) {
        long backoffInMilli;
        if (isLoginRequest) {
            long jitteredBackoffInMilli = decorrelatedJitterBackoff.getJitterForLogin(previousBackoffInMilli);
            backoffInMilli = (long)decorrelatedJitterBackoff.chooseRandom(jitteredBackoffInMilli + previousBackoffInMilli, Math.pow(2.0, retryCount) + (double)jitteredBackoffInMilli);
        } else {
            backoffInMilli = decorrelatedJitterBackoff.nextSleepTime(previousBackoffInMilli);
        }
        backoffInMilli = Math.min(16000L, Math.max(previousBackoffInMilli, backoffInMilli));
        if (retryTimeoutInMilliseconds > 0L && elapsedMilliForTransientIssues + backoffInMilli > retryTimeoutInMilliseconds) {
            backoffInMilli = Math.max(0L, Math.min(backoffInMilli, retryTimeoutInMilliseconds - elapsedMilliForTransientIssues));
            logger.debug("We are approaching retry timeout {}ms, setting backoff to {}ms", retryTimeoutInMilliseconds, backoffInMilli);
        }
        return backoffInMilli;
    }

    static boolean isNonRetryableHTTPCode(CloseableHttpResponse response, boolean retryHTTP403) {
        return !(response == null || response.getStatusLine().getStatusCode() >= 500 && response.getStatusLine().getStatusCode() < 600 || response.getStatusLine().getStatusCode() == 408 || response.getStatusLine().getStatusCode() == 429 || retryHTTP403 && response.getStatusLine().getStatusCode() == 403);
    }

    private static boolean isCertificateRevoked(Exception ex) {
        if (ex == null) {
            return false;
        }
        Throwable ex0 = RestRequest.getRootCause(ex);
        if (!(ex0 instanceof SFOCSPException)) {
            return false;
        }
        SFOCSPException cause = (SFOCSPException)ex0;
        return cause.getErrorCode() == OCSPErrorCode.CERTIFICATE_STATUS_REVOKED;
    }

    private static Throwable getRootCause(Throwable ex) {
        Throwable ex0 = ex;
        while (ex0.getCause() != null) {
            ex0 = ex0.getCause();
        }
        return ex0;
    }

    private static void setRequestConfig(HttpRequestBase httpRequest, boolean withoutCookies, int injectSocketTimeout, String requestIdStr, long authTimeoutInMilli) {
        if (withoutCookies) {
            httpRequest.setConfig(HttpUtil.getRequestConfigWithoutCookies());
        }
        if (injectSocketTimeout != 0) {
            logger.debug("{}Injecting socket timeout by setting socket timeout to {} ms", requestIdStr, injectSocketTimeout);
            httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketTimeout(injectSocketTimeout, withoutCookies));
        }
        if (authTimeoutInMilli > 0L) {
            int requestSocketAndConnectTimeout = (int)authTimeoutInMilli;
            logger.debug("{}Setting auth timeout as the socket timeout: {} ms", requestIdStr, authTimeoutInMilli);
            httpRequest.setConfig(HttpUtil.getDefaultRequestConfigWithSocketAndConnectTimeout(requestSocketAndConnectTimeout, withoutCookies));
        }
    }

    private static void setRequestURI(HttpRequestBase httpRequest, String requestIdStr, boolean includeRetryParameters, boolean includeRequestGuid, int retryCount, String lastStatusCodeForRetry, long startTime, String requestInfoScrubbed) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(httpRequest.getURI());
        if ("true".equalsIgnoreCase(System.getenv("HTAP_SIMULATION")) && builder.getPathSegments().contains("query-request")) {
            logger.debug("{}Setting htap simulation", requestIdStr);
            builder.setParameter("target", "htap_simulation");
        }
        if (includeRetryParameters && retryCount > 0) {
            builder.setParameter("retryCount", String.valueOf(retryCount));
            builder.setParameter("retryReason", lastStatusCodeForRetry);
            builder.setParameter("clientStartTime", String.valueOf(startTime));
        }
        if (includeRequestGuid) {
            UUID guid = UUIDUtils.getUUID();
            logger.debug("{}Request {} guid: {}", requestIdStr, requestInfoScrubbed, guid.toString());
            builder.setParameter(SF_REQUEST_GUID, guid.toString());
        }
        httpRequest.setURI(builder.build());
    }
}

