/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.util.Utils;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerObjectEntry;

public class WorkflowMap {
    private final Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> workflowMap = new ConcurrentHashMap<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>>();
    private final Map<HopServerObjectEntry, WorkflowConfiguration> configurationMap = new ConcurrentHashMap<HopServerObjectEntry, WorkflowConfiguration>();
    private HopServerConfig hopServerConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addWorkflow(String workflowName, String serverObjectId, IWorkflowEngine<WorkflowMeta> workflow, WorkflowConfiguration workflowConfiguration) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            if (StringUtils.isEmpty((String)workflowName)) {
                throw new RuntimeException("API usage error: to add a workflow on a server we always need its name.");
            }
            if (serverObjectId == null) {
                throw new RuntimeException("API usage error: to add a workflow on a server we always need a server object ID to uniquely identify it.");
            }
            HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, serverObjectId);
            this.workflowMap.put(entry, workflow);
            this.configurationMap.put(entry, workflowConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceWorkflow(IWorkflowEngine<WorkflowMeta> oldWorkflow, IWorkflowEngine<WorkflowMeta> workflow, WorkflowConfiguration workflowConfiguration) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            HopServerObjectEntry entry = this.getEntry(oldWorkflow);
            if (entry != null) {
                this.workflowMap.put(entry, workflow);
                this.configurationMap.put(entry, workflowConfiguration);
            } else {
                this.addWorkflow(workflow.getWorkflowName(), workflow.getContainerId(), workflow, workflowConfiguration);
            }
        }
    }

    private HopServerObjectEntry getEntry(IWorkflowEngine<WorkflowMeta> workflow) {
        return new HopServerObjectEntry(workflow.getWorkflowName(), workflow.getContainerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IWorkflowEngine<WorkflowMeta> getWorkflow(String workflowName) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            for (HopServerObjectEntry entry : this.workflowMap.keySet()) {
                if (!entry.getName().equals(workflowName)) continue;
                return this.getWorkflow(entry);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IWorkflowEngine<WorkflowMeta> getWorkflow(HopServerObjectEntry entry) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            return this.workflowMap.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WorkflowConfiguration getConfiguration(String workflowName) {
        Map<HopServerObjectEntry, WorkflowConfiguration> map = this.configurationMap;
        synchronized (map) {
            for (HopServerObjectEntry entry : this.configurationMap.keySet()) {
                if (!entry.getName().equals(workflowName)) continue;
                return this.getConfiguration(entry);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized WorkflowConfiguration getConfiguration(HopServerObjectEntry entry) {
        Map<HopServerObjectEntry, WorkflowConfiguration> map = this.configurationMap;
        synchronized (map) {
            return this.configurationMap.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeWorkflow(HopServerObjectEntry entry) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            this.workflowMap.remove(entry);
            this.configurationMap.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<HopServerObjectEntry> getWorkflowObjects() {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            return new ArrayList<HopServerObjectEntry>(this.workflowMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HopServerObjectEntry getFirstHopServerObjectEntry(String workflowName) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            for (HopServerObjectEntry key : this.workflowMap.keySet()) {
                if (!key.getName().equals(workflowName)) continue;
                return key;
            }
            return null;
        }
    }

    public HopServerConfig getHopServerConfig() {
        return this.hopServerConfig;
    }

    public void setHopServerConfig(HopServerConfig hopServerConfig) {
        this.hopServerConfig = hopServerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IWorkflowEngine<WorkflowMeta> findWorkflow(String id) {
        Map<HopServerObjectEntry, IWorkflowEngine<WorkflowMeta>> map = this.workflowMap;
        synchronized (map) {
            for (IWorkflowEngine<WorkflowMeta> workflow : this.workflowMap.values()) {
                if (!workflow.getContainerId().equals(id)) continue;
                return workflow;
            }
        }
        return null;
    }

    public IWorkflowEngine<WorkflowMeta> findWorkflow(String workflowName, String id) {
        IWorkflowEngine<WorkflowMeta> workflow;
        if (Utils.isEmpty((CharSequence)id)) {
            HopServerObjectEntry entry = this.getFirstHopServerObjectEntry(workflowName);
            workflow = entry == null ? null : this.getWorkflow(entry);
        } else {
            HopServerObjectEntry entry = new HopServerObjectEntry(workflowName, id);
            workflow = this.getWorkflow(entry);
        }
        return workflow;
    }
}

