/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.PhaseTracking;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressView;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Status;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StepTracking;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class StartupProgress {
    final Map<Phase, PhaseTracking> phases = new ConcurrentHashMap<Phase, PhaseTracking>();

    public StartupProgress() {
        for (Phase phase : EnumSet.allOf(Phase.class)) {
            this.phases.put(phase, new PhaseTracking());
        }
    }

    public void beginPhase(Phase phase) {
        if (!this.isComplete()) {
            this.phases.get((Object)((Object)phase)).beginTime = Time.monotonicNow();
        }
    }

    public void beginStep(Phase phase, Step step) {
        if (!this.isComplete()) {
            this.lazyInitStep((Phase)phase, (Step)step).beginTime = Time.monotonicNow();
        }
    }

    public void endPhase(Phase phase) {
        if (!this.isComplete()) {
            this.phases.get((Object)((Object)phase)).endTime = Time.monotonicNow();
        }
    }

    public void endStep(Phase phase, Step step) {
        if (!this.isComplete()) {
            this.lazyInitStep((Phase)phase, (Step)step).endTime = Time.monotonicNow();
        }
    }

    public Status getStatus(Phase phase) {
        PhaseTracking tracking = this.phases.get((Object)phase);
        if (tracking.beginTime == Long.MIN_VALUE) {
            return Status.PENDING;
        }
        if (tracking.endTime == Long.MIN_VALUE) {
            return Status.RUNNING;
        }
        return Status.COMPLETE;
    }

    public Counter getCounter(Phase phase, Step step) {
        if (!this.isComplete()) {
            final StepTracking tracking = this.lazyInitStep(phase, step);
            return new Counter(){

                @Override
                public void increment() {
                    tracking.count.incrementAndGet();
                }
            };
        }
        return new Counter(){

            @Override
            public void increment() {
            }
        };
    }

    public void setCount(Phase phase, Step step, long count) {
        this.lazyInitStep((Phase)phase, (Step)step).count.set(count);
    }

    public void setFile(Phase phase, String file) {
        if (!this.isComplete()) {
            this.phases.get((Object)((Object)phase)).file = file;
        }
    }

    public void setSize(Phase phase, long size) {
        if (!this.isComplete()) {
            this.phases.get((Object)((Object)phase)).size = size;
        }
    }

    public void setTotal(Phase phase, Step step, long total) {
        if (!this.isComplete()) {
            this.lazyInitStep((Phase)phase, (Step)step).total = total;
        }
    }

    public StartupProgressView createView() {
        return new StartupProgressView(this);
    }

    private boolean isComplete() {
        for (Phase phase : EnumSet.allOf(Phase.class)) {
            if (this.getStatus(phase) == Status.COMPLETE) continue;
            return false;
        }
        return true;
    }

    private StepTracking lazyInitStep(Phase phase, Step step) {
        ConcurrentMap<Step, StepTracking> steps = this.phases.get((Object)((Object)phase)).steps;
        if (!steps.containsKey(step)) {
            steps.putIfAbsent(step, new StepTracking());
        }
        return (StepTracking)steps.get(step);
    }

    public static interface Counter {
        public void increment();
    }
}

