/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.template.parser.ArrayColumn;
import org.drools.template.parser.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnFactory.class);
    private static final Pattern PATTERN = Pattern.compile("((\\$)*([a-zA-Z0-9_]*))(\\[\\])?(:\\s*([a-zA-Z]*)(\\[\\])?)?");

    public Column getColumn(String value) {
        boolean array;
        Matcher m = PATTERN.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException("value " + value + " is not a valid column definition");
        }
        String name = m.group(1);
        String type = m.group(6);
        type = type == null ? "String" : type;
        boolean bl = array = m.group(4) != null || m.group(7) != null;
        if (array) {
            return new ArrayColumn(name, this.createColumn(name, type));
        }
        return this.createColumn(name, type);
    }

    private Column createColumn(String name, String type) {
        try {
            Class<?> klass = Class.forName(this.getClass().getPackage().getName() + "." + type + "Column");
            Constructor<?> constructor = klass.getConstructor(String.class);
            return (Column)constructor.newInstance(name);
        }
        catch (SecurityException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

