/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.ValueMap;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class ProgramKeys
implements Serializable {
    public static final int BINARY = 0;
    public static final int CHAR = 1;
    private Hashtable map_ = new Hashtable();
    private Hashtable vms_ = new Hashtable();

    ProgramKeys() {
    }

    public void add(Object id, int key, int type) {
        this.add(id, key, type, type == 0 ? 4 : 10, null);
    }

    public void add(Object id, int key, int type, int length) {
        this.add(id, key, type, length, null);
    }

    public void add(Object id, int key, int type, int length, ValueMap valueMap) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (type != 0 && type != 1) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        if (length <= 0) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        Vector v = null;
        if (this.map_.containsKey(id)) {
            v = (Vector)this.map_.get(id);
        } else {
            v = new Vector();
            this.map_.put(id, v);
        }
        v.addElement(new int[]{key, type, length});
        if (valueMap != null) {
            Vector v2 = null;
            if (this.vms_.containsKey(id)) {
                v2 = (Vector)this.vms_.get(id);
            } else {
                v2 = new Vector();
                this.vms_.put(id, v2);
            }
            v2.addElement(valueMap);
        }
    }

    public int[] getKeys(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.map_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        Vector v = (Vector)this.map_.get(id);
        int[] keys = new int[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = ((int[])v.elementAt(i))[0];
        }
        return keys;
    }

    public int[] getLengths(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.map_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        Vector v = (Vector)this.map_.get(id);
        int[] lengths = new int[v.size()];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = ((int[])v.elementAt(i))[2];
        }
        return lengths;
    }

    public int[] getTypes(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.map_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        Vector v = (Vector)this.map_.get(id);
        int[] types = new int[v.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((int[])v.elementAt(i))[1];
        }
        return types;
    }

    public ValueMap[] getValueMaps(Object id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (!this.map_.containsKey(id)) {
            throw new ExtendedIllegalArgumentException("id", 2);
        }
        if (this.vms_.containsKey(id)) {
            Vector v = (Vector)this.vms_.get(id);
            ValueMap[] valueMaps = new ValueMap[v.size()];
            for (int i = 0; i < valueMaps.length; ++i) {
                valueMaps[i] = (ValueMap)v.elementAt(i);
            }
            return valueMaps;
        }
        return null;
    }
}

