/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.list.JobQueueListFilter;
import com.ibm.as400.access.list.JobQueueListItem;
import com.ibm.as400.access.list.OpenList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JobQueueOpenList
extends OpenList {
    private static final long serialVersionUID = 4436839827725754124L;
    public static final String FORMAT_0100 = "OJBQ0100";
    public static final AS400DataType JOB_QUEUE_NAME = new AS400Text(10);
    public static final AS400DataType JOB_QUEUE_LIBRARY_NAME = new AS400Text(10);
    public static final AS400DataType JOB_QUEUE_STATUS = new AS400Text(1);
    public static final AS400DataType SUBSYSTEM_NAME = new AS400Text(10);
    public static final AS400DataType SUBSYSTEM_LIBRARY_NAME = new AS400Text(10);
    private static final AS400DataType RESERVED = new AS400Text(3);
    public static final AS400DataType NUMBER_OF_JOBS_WAITING = new AS400Bin4();
    public static final AS400DataType SEQUENCE = new AS400Bin4();
    public static final AS400DataType MAXIMUM_ACTIVE = new AS400Bin4();
    public static final AS400DataType CURRENT_ACTIVE = new AS400Bin4();
    public static final AS400DataType DESCRIPTION = new AS400Text(50);
    public static final AS400DataType ASP_NAME = new AS400Text(10);
    private static final List<AS400DataType> ITEM_ELEMENTS = Arrays.asList(JOB_QUEUE_NAME, JOB_QUEUE_LIBRARY_NAME, JOB_QUEUE_STATUS, SUBSYSTEM_NAME, SUBSYSTEM_LIBRARY_NAME, RESERVED, NUMBER_OF_JOBS_WAITING, SEQUENCE, MAXIMUM_ACTIVE, CURRENT_ACTIVE, DESCRIPTION, ASP_NAME);
    private static final AS400Structure FILTER_STRUCTURE = new AS400Structure(new AS400DataType[]{new AS400Bin4(), JOB_QUEUE_NAME, JOB_QUEUE_LIBRARY_NAME, SUBSYSTEM_NAME});
    private JobQueueListFilter filter;
    private List<SortField> sortFields = new ArrayList<SortField>(2);

    public JobQueueOpenList(AS400 system) {
        super(system);
        this.setFilter(JobQueueListFilter.DEFAULT);
    }

    public JobQueueListFilter getFilter() {
        return this.filter;
    }

    public void setFilter(JobQueueListFilter filter) {
        this.filter = filter;
        this.resetHandle();
    }

    public void clearSortFields() {
        this.sortFields.clear();
    }

    public void addSortField(AS400DataType sortField, boolean ascending) {
        int ndx = ITEM_ELEMENTS.indexOf(sortField);
        if (ndx < 0) {
            throw new IllegalArgumentException("sortField");
        }
        this.sortFields.add(new SortField(sortField, ascending));
    }

    protected static String padRight(String string, int length) {
        return String.format("%1$-" + length + "s", string == null ? "" : string);
    }

    protected static String trimSafe(String string) {
        return string == null ? "" : string.trim();
    }

    private int getOffset(AS400DataType field) {
        int ndx = ITEM_ELEMENTS.indexOf(field);
        return this.getOffset(ndx);
    }

    private int getRecordLength() {
        return this.getOffset(ITEM_ELEMENTS.size());
    }

    private int getOffset(int ndx) {
        if (ndx < 0 || ndx > ITEM_ELEMENTS.size()) {
            throw new IndexOutOfBoundsException();
        }
        int offset = 0;
        for (int i = 0; i < ndx; ++i) {
            offset += ITEM_ELEMENTS.get(i).getByteLength();
        }
        return offset;
    }

    private short getFieldDataType(AS400DataType field) {
        if (field instanceof AS400Text) {
            return 4;
        }
        return 0;
    }

    private byte[] createSortData() {
        int sortItemSize = 12;
        int numSortKeys = this.sortFields.size();
        byte[] sortData = new byte[4 + numSortKeys * sortItemSize];
        BinaryConverter.intToByteArray(numSortKeys, sortData, 0);
        int sortOffset = 0;
        for (int i = 0; i < numSortKeys; ++i) {
            SortField field = this.sortFields.get(i);
            BinaryConverter.intToByteArray(this.getOffset(field.field), sortData, 4 + sortOffset);
            BinaryConverter.intToByteArray(field.field.getByteLength(), sortData, 8 + sortOffset);
            BinaryConverter.shortToByteArray(this.getFieldDataType(field.field), sortData, 12 + sortOffset);
            sortData[14 + sortOffset] = field.ascending ? -15 : -14;
            sortOffset += sortItemSize;
        }
        return sortData;
    }

    @Override
    protected byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        Object[] filterValues = new Object[]{FILTER_STRUCTURE.getByteLength(), JobQueueOpenList.padRight(this.filter.getJobQueueName(), JOB_QUEUE_NAME.getByteLength()), JobQueueOpenList.padRight(this.filter.getJobQueueLibraryName(), JOB_QUEUE_LIBRARY_NAME.getByteLength()), JobQueueOpenList.padRight(this.filter.getActiveSubsystemName(), SUBSYSTEM_NAME.getByteLength())};
        byte[] filterData = FILTER_STRUCTURE.toBytes(filterValues);
        byte[] sortData = this.createSortData();
        ProgramParameter[] parms = new ProgramParameter[]{new ProgramParameter(1), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(conv.stringToByteArray(FORMAT_0100)), new ProgramParameter(80), new ProgramParameter(filterData), new ProgramParameter(sortData), new ProgramParameter(BinaryConverter.intToByteArray(1)), new ErrorCodeParameter()};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QSPOLJBQ.PGM", parms);
        pc.setThreadSafe(true);
        if (!pc.run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        return parms[3].getOutputData();
    }

    @Override
    protected Object[] formatOutputData(byte[] data, int recordsReturned, int recordLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object[] list = new JobQueueListItem[recordsReturned];
        Converter conv = new Converter(this.system_.getCcsid(), this.system_);
        int offset = 0;
        for (int i = 0; i < recordsReturned; ++i) {
            int localOffset = offset;
            JobQueueListItem item = new JobQueueListItem();
            list[i] = item;
            item.jobQueueName = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, localOffset, 10));
            item.jobQueueLibrary = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, localOffset += 10, 10));
            String statusChar = conv.byteArrayToString(data, localOffset += 10, 1);
            item.jobQueueStatus = JobQueueListItem.JobQueueStatus.fromSystemValue(statusChar);
            item.subsystemName = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, ++localOffset, 10));
            item.subsystemLibrary = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, localOffset += 10, 10));
            localOffset += 10;
            item.numberOfJobsWaitingToRun = BinaryConverter.byteArrayToInt(data, localOffset += 3);
            item.jobQueueSequence = BinaryConverter.byteArrayToInt(data, localOffset += 4);
            item.maximumActiveJobs = BinaryConverter.byteArrayToInt(data, localOffset += 4);
            item.numberOfJobsRunning = BinaryConverter.byteArrayToInt(data, localOffset += 4);
            item.jobQueueDescription = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, localOffset += 4, 50));
            item.aspName = JobQueueOpenList.trimSafe(conv.byteArrayToString(data, localOffset += 50, 10));
            localOffset += 10;
            offset += recordLength;
        }
        return list;
    }

    @Override
    protected int getBestGuessReceiverSize(int number) {
        return this.getRecordLength() * number;
    }

    private class SortField {
        AS400DataType field;
        boolean ascending;

        private SortField(AS400DataType field, boolean ascending) {
            this.field = field;
            this.ascending = ascending;
        }
    }
}

