/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiFlagSet;
import com.ibm.as400.access.BidiOrder;
import com.ibm.as400.access.BidiShape;
import com.ibm.as400.access.BidiTransform;

public class BidiText {
    public BidiFlagSet flags;
    public char[] data;
    public int offset;
    public int count;

    public BidiText() {
        this.flags = new BidiFlagSet();
    }

    public BidiText(BidiFlagSet initFlags) {
        this.flags = initFlags;
    }

    public BidiText(BidiFlagSet initFlags, char[] initData) {
        this(initFlags, initData, 0, initData.length, initData.length);
    }

    public BidiText(BidiFlagSet initFlags, char[] initData, int offset, int length, int capacity) {
        this.flags = new BidiFlagSet(initFlags);
        this.data = new char[capacity];
        System.arraycopy(initData, offset, this.data, 0, length);
        this.count = length;
    }

    public BidiText(BidiFlagSet initFlags, String str) {
        this.flags = new BidiFlagSet(initFlags);
        this.count = str.length();
        this.data = new char[this.count];
        str.getChars(0, this.count, this.data, 0);
    }

    public boolean equals(BidiText other) {
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (this.flags.value != other.flags.value) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof BidiText) {
            return this.equals((BidiText)other);
        }
        return false;
    }

    public void setCharsRef(char[] newData, int newOffset, int newLength) {
        this.data = newData;
        this.offset = newOffset;
        this.count = newLength;
    }

    public char[] toCharArray() {
        char[] copyChars = new char[this.count];
        System.arraycopy(this.data, this.offset, copyChars, 0, this.count);
        return copyChars;
    }

    public String toString() {
        return new String(this.data, this.offset, this.count);
    }

    public BidiText transform(BidiFlagSet dstFlags) {
        BidiTransform bdx = new BidiTransform();
        bdx.flags.setAllFlags(dstFlags);
        return this.transform(bdx);
    }

    public BidiText transform(BidiTransform bdx) {
        BidiText dst = new BidiText();
        dst.flags.setAllFlags(bdx.flags);
        if (bdx.myOrder == null) {
            bdx.myOrder = new BidiOrder();
        }
        bdx.myOrder.order(this, dst, bdx);
        if (this.flags.getText() != dst.flags.getText()) {
            char[] sData;
            if (bdx.myShape == null) {
                bdx.myShape = new BidiShape();
                bdx.flags1 = new BidiFlagSet();
                bdx.flags2 = new BidiFlagSet();
            }
            bdx.flags1.setAllFlags(this.flags);
            bdx.flags2.setAllFlags(dst.flags);
            if (dst.offset == 0 && dst.data.length == dst.count) {
                sData = dst.data;
            } else {
                sData = new char[dst.count];
                System.arraycopy(dst.data, dst.offset, sData, 0, dst.count);
            }
            sData = bdx.myShape.shape(bdx.flags1, bdx.flags2, sData, bdx.options);
            dst.count = sData.length;
            if (dst.offset == 0) {
                dst.data = sData;
            } else if (dst.offset + dst.count <= dst.data.length) {
                System.arraycopy(sData, 0, dst.data, dst.offset, dst.count);
            } else {
                char[] tmp = new char[dst.offset + dst.count];
                System.arraycopy(dst.data, 0, tmp, 0, dst.offset);
                System.arraycopy(sData, 0, tmp, dst.offset, dst.count);
                dst.data = tmp;
            }
        }
        return dst;
    }
}

