/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.util.Arrays;
import org.caffinitas.ohc.linked.Hasher;

final class KeyBuffer {
    private final byte[] array;
    private long hash;

    KeyBuffer(byte[] bytes) {
        this.array = bytes;
    }

    byte[] array() {
        return this.array;
    }

    int size() {
        return this.array.length;
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish(Hasher hasher) {
        this.hash = hasher.hash(this.array);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return Arrays.equals(this.array, keyBuffer.array);
    }

    public int hashCode() {
        return (int)this.hash;
    }

    static String padToEight(int val) {
        String str = Integer.toBinaryString(val & 0xFF);
        while (str.length() < 8) {
            str = '0' + str;
        }
        return str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.array.length; ++ii) {
            if (ii % 8 == 0 && ii != 0) {
                sb.append('\n');
            }
            sb.append(KeyBuffer.padToEight(this.array[ii]));
            sb.append(' ');
        }
        return sb.toString();
    }
}

