/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sqs;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReader;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderData;

@Transform(id="AwsSqSreader", image="aws-sqs.svg", name="i18n::SQSReaderTransform.Name", description="i18n::SQSReaderTransform.TooltipDesc", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={""}, documentationUrl="/pipeline/transforms/aws-sqs-reader.html")
public class SqsReaderMeta
extends BaseTransformMeta<SqsReader, SqsReaderData> {
    @HopMetadataProperty(key="AwsCredChain", injectionKey="AWS_CRED_CHAIN")
    private String awsCredChain;
    @HopMetadataProperty(key="aws_key", injectionKey="AWS_KEY")
    private String awsKey;
    @HopMetadataProperty(key="aws_key_secret", injectionKey="AWS_KEY_SECRET")
    private String awsKeySecret;
    @HopMetadataProperty(key="aws_region", injectionKey="AWS_REGION")
    private String awsRegion;
    @HopMetadataProperty(key="sqs_queue", injectionKey="SQS_QUEUE")
    private String sqsQueue;
    @HopMetadataProperty(key="field_message_id", injectionKey="FIELD_MESSAGE_ID")
    private String tFldMessageID;
    @HopMetadataProperty(key="field_message_body", injectionKey="FIELD_MESSAGE_BODY")
    private String tFldMessageBody;
    @HopMetadataProperty(key="field_receipt_handle", injectionKey="FIELD_RECEIPT_HANDLE")
    private String tFldReceiptHandle;
    @HopMetadataProperty(key="field_body_md5", injectionKey="FIELD_BODY_MD5")
    private String tFldBodyMD5;
    @HopMetadataProperty(key="field_sns_messages", injectionKey="FIELD_SNS_MESSAGE")
    private String tFldSNSMessage;
    @HopMetadataProperty(key="field_message_delete", injectionKey="FIELD_MESSAGE_DELETE")
    private String tFldMessageDelete;
    @HopMetadataProperty(key="field_max_messages", injectionKey="FIELD_MAX_MESSAGES")
    private String tFldMaxMessages;

    public void setDefault() {
    }

    public String getAwsCredChain() {
        this.awsCredChain = this.awsCredChain == null ? "N" : this.awsCredChain;
        return this.awsCredChain;
    }

    public void setAwsCredChain(String awsCredChain) {
        this.awsCredChain = awsCredChain;
    }

    public String getAwsKey() {
        return this.awsKey == null ? "" : this.awsKey;
    }

    public void setAwsKey(String aws_key) {
        this.awsKey = aws_key;
    }

    public String getAwsKeySecret() {
        return this.awsKeySecret == null ? "" : this.awsKeySecret;
    }

    public void setAwsKeySecret(String awsKeySecret) {
        this.awsKeySecret = awsKeySecret;
    }

    public String getAwsRegion() {
        return this.awsRegion == null ? "" : this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getSqsQueue() {
        return this.sqsQueue == null ? "" : this.sqsQueue;
    }

    public void setSqsQueue(String sqsQueue) {
        this.sqsQueue = sqsQueue;
    }

    public String getTFldMessageID() {
        return this.tFldMessageID == null ? "" : this.tFldMessageID;
    }

    public void setTFldMessageID(String tFldMessageID) {
        this.tFldMessageID = tFldMessageID;
    }

    public String getTFldMessageBody() {
        return this.tFldMessageBody == null ? "" : this.tFldMessageBody;
    }

    public void setTFldMessageBody(String tFldMessageBody) {
        this.tFldMessageBody = tFldMessageBody;
    }

    public String getTFldReceiptHandle() {
        return this.tFldReceiptHandle == null ? "" : this.tFldReceiptHandle;
    }

    public void setTFldReceiptHandle(String tFldReceiptHandle) {
        this.tFldReceiptHandle = tFldReceiptHandle;
    }

    public String getTFldBodyMD5() {
        return this.tFldBodyMD5 == null ? "" : this.tFldBodyMD5;
    }

    public void setTFldBodyMD5(String tFldBodyMD5) {
        this.tFldBodyMD5 = tFldBodyMD5;
    }

    public String getTFldSNSMessage() {
        return this.tFldSNSMessage == null ? "" : this.tFldSNSMessage;
    }

    public void setTFldSNSMessage(String tFldSNSMessage) {
        this.tFldSNSMessage = tFldSNSMessage;
    }

    public String getTFldMessageDelete() {
        return this.tFldMessageDelete == null ? "N" : this.tFldMessageDelete;
    }

    public void setTFldMessageDelete(String tFldMessageDelete) {
        this.tFldMessageDelete = tFldMessageDelete;
    }

    public String getTFldMaxMessages() {
        return this.tFldMaxMessages == null ? "0" : this.tFldMaxMessages;
    }

    public void setTFldMaxMessages(String tFldMaxMessages) {
        this.tFldMaxMessages = tFldMaxMessages;
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void getFields(IRowMeta inputRowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            IValueMeta valueMeta;
            if (this.tFldMessageID != null && !this.tFldMessageID.equals("")) {
                String realMessageIDFieldName = variables.resolve(this.tFldMessageID);
                valueMeta = ValueMetaFactory.createValueMeta((String)realMessageIDFieldName, (int)2);
                valueMeta.setName(realMessageIDFieldName.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta(valueMeta);
            }
            if (this.tFldMessageBody != null && !this.tFldMessageBody.equals("")) {
                String realMessageBodyFieldName = variables.resolve(this.tFldMessageBody);
                valueMeta = ValueMetaFactory.createValueMeta((String)realMessageBodyFieldName, (int)2);
                valueMeta.setName(realMessageBodyFieldName.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta(valueMeta);
            }
            if (this.tFldReceiptHandle != null && !this.tFldReceiptHandle.equals("")) {
                String realReceiptHandleFieldName = variables.resolve(this.tFldReceiptHandle);
                valueMeta = ValueMetaFactory.createValueMeta((String)realReceiptHandleFieldName, (int)2);
                valueMeta.setName(realReceiptHandleFieldName.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta(valueMeta);
            }
            if (this.tFldBodyMD5 != null && !this.tFldBodyMD5.equals("")) {
                String realBodyMD5FieldName = variables.resolve(this.tFldBodyMD5);
                valueMeta = ValueMetaFactory.createValueMeta((String)realBodyMD5FieldName, (int)2);
                valueMeta.setName(realBodyMD5FieldName.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta(valueMeta);
            }
            if (this.tFldSNSMessage != null && !this.tFldSNSMessage.equals("")) {
                String realSNSMessageFieldName = variables.resolve(this.tFldSNSMessage);
                valueMeta = ValueMetaFactory.createValueMeta((String)realSNSMessageFieldName, (int)2);
                valueMeta.setName(realSNSMessageFieldName.toUpperCase());
                valueMeta.setTrimType(3);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta(valueMeta);
            }
        }
        catch (HopPluginException e) {
            this.logBasic(e.getMessage());
            throw new HopTransformException((Throwable)e);
        }
    }
}

