/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.attributes.AttributesUtil;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.reflection.StringSearchResult;
import org.apache.hop.core.reflection.StringSearcher;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlFormatter;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceExport;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMetaInfo;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.missing.MissingAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WorkflowMeta
extends AbstractMeta
implements Cloneable,
Comparable<WorkflowMeta>,
IXml,
IResourceExport,
IHasFilename {
    private static final Class<?> PKG = WorkflowMeta.class;
    public static final String WORKFLOW_EXTENSION = ".hwf";
    public static final String XML_TAG = "workflow";
    public static final int BORDER_INDENT = 20;
    private static final String CONST_DESCRIPTION = "description";
    private static final String CONST_PARAMETER = "parameter";
    private static final String CONST_SPACE = "        ";
    @HopMetadataProperty(inline=true)
    protected WorkflowMetaInfo info;
    protected String workflowVersion;
    protected int workflowStatus;
    protected List<ActionMeta> workflowActions;
    protected List<WorkflowHopMeta> workflowHops;
    protected String[] arguments;
    protected boolean changedActions;
    protected boolean changedHops;
    protected String startActionName;
    protected boolean expandingRemoteWorkflow;
    public static final String STRING_SPECIAL_OK = "OK";
    public static final String STRING_SPECIAL_ERROR = "ERROR";
    protected Map<String, Boolean> loopCache;
    public boolean[] max = new boolean[1];
    public static final String XML_TAG_ACTIONS = "actions";
    public static final String XML_TAG_NOTEPADS = "notepads";
    public static final String XML_TAG_HOPS = "hops";
    protected static final String XML_TAG_PARAMETERS = "parameters";
    private List<MissingAction> missingActions;

    public WorkflowMeta() {
        this.clear();
    }

    @Override
    public void clear() {
        this.workflowActions = new ArrayList<ActionMeta>();
        this.workflowHops = new ArrayList<WorkflowHopMeta>();
        this.namedParams = new NamedParameters();
        this.info = new WorkflowMetaInfo();
        this.arguments = null;
        super.clear();
        this.loopCache = new HashMap<String, Boolean>();
        this.addDefaults();
        this.workflowStatus = -1;
        this.workflowVersion = null;
    }

    public void addDefaults() {
        this.clearChanged();
    }

    public ActionMeta getStart() {
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta cge = this.getAction(i);
            if (!cge.isStart()) continue;
            return cge;
        }
        return null;
    }

    public int compare(WorkflowMeta j1, WorkflowMeta j2) {
        return super.compare(j1, j2);
    }

    @Override
    public int compareTo(WorkflowMeta o) {
        return this.compare(this, o);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorkflowMeta)) {
            return false;
        }
        return this.compare(this, (WorkflowMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            WorkflowMeta workflowMeta = (WorkflowMeta)super.clone();
            if (doClear) {
                workflowMeta.clear();
            } else {
                workflowMeta.workflowActions = new ArrayList<ActionMeta>();
                workflowMeta.workflowHops = new ArrayList<WorkflowHopMeta>();
                workflowMeta.notes = new ArrayList();
                workflowMeta.namedParams = new NamedParameters();
            }
            for (ActionMeta action : this.workflowActions) {
                workflowMeta.workflowActions.add((ActionMeta)action.cloneDeep());
            }
            for (WorkflowHopMeta hop : this.workflowHops) {
                workflowMeta.workflowHops.add(hop.clone());
            }
            for (NotePadMeta notePad : this.notes) {
                workflowMeta.notes.add(notePad.clone());
            }
            for (Iterator<Cloneable> iterator : this.listParameters()) {
                workflowMeta.addParameterDefinition((String)((Object)iterator), this.getParameterDefault((String)((Object)iterator)), this.getParameterDescription((String)((Object)iterator)));
            }
            return workflowMeta;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected String getExtension() {
        return WORKFLOW_EXTENSION;
    }

    @Override
    public void clearChanged() {
        this.changedActions = false;
        this.changedHops = false;
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            action.setChanged(false);
        }
        for (WorkflowHopMeta hop : this.workflowHops) {
            hop.setChanged(false);
        }
        super.clearChanged();
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveActionsChanged()) {
            return true;
        }
        return this.haveWorkflowHopsChanged();
    }

    @Override
    public String getXml(IVariables variables) throws HopException {
        StringBuilder xml = new StringBuilder(500);
        xml.append(XmlHandler.getLicenseHeader((IVariables)variables));
        xml.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        xml.append("  ").append(XmlHandler.addTagValue((String)"name_sync_with_filename", (boolean)this.info.isNameSynchronizedWithFilename()));
        xml.append("  ").append(XmlHandler.addTagValue((String)CONST_DESCRIPTION, (String)this.info.getDescription()));
        xml.append("  ").append(XmlHandler.addTagValue((String)"extended_description", (String)this.info.getExtendedDescription()));
        xml.append("  ").append(XmlHandler.addTagValue((String)"workflow_version", (String)this.workflowVersion));
        if (this.workflowStatus >= 0) {
            xml.append("  ").append(XmlHandler.addTagValue((String)"workflow_status", (int)this.workflowStatus));
        }
        xml.append("  ").append(XmlHandler.addTagValue((String)"created_user", (String)this.info.getCreatedUser()));
        xml.append("  ").append(XmlHandler.addTagValue((String)"created_date", (String)XmlHandler.date2string((Date)this.info.getCreatedDate())));
        xml.append("  ").append(XmlHandler.addTagValue((String)"modified_user", (String)this.info.getModifiedUser()));
        xml.append("  ").append(XmlHandler.addTagValue((String)"modified_date", (String)XmlHandler.date2string((Date)this.info.getModifiedDate())));
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        String[] parameters = this.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            xml.append("      ").append(XmlHandler.openTag((String)CONST_PARAMETER)).append(Const.CR);
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"name", (String)parameters[idx]));
            try {
                xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
                xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)CONST_DESCRIPTION, (String)this.getParameterDescription(parameters[idx])));
            }
            catch (UnknownParamException unknownParamException) {
                // empty catch block
            }
            xml.append("      ").append(XmlHandler.closeTag((String)CONST_PARAMETER)).append(Const.CR);
        }
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_ACTIONS)).append(Const.CR);
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta jge = this.getAction(i);
            xml.append(jge.getXml());
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_ACTIONS)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_HOPS)).append(Const.CR);
        for (WorkflowHopMeta hi : this.workflowHops) {
            xml.append(hi.getXml());
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_HOPS)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            xml.append(ni.getXml());
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        xml.append(AttributesUtil.getAttributesXml(this.attributesMap));
        xml.append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return XmlFormatter.format((String)xml.toString());
    }

    public WorkflowMeta(String fname) throws HopXmlException {
        this(null, fname, null);
    }

    public WorkflowMeta(IVariables variables, String fname, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        this.loadXml(variables, fname, metadataProvider);
    }

    public void loadXml(IVariables variables, String fname, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Document doc = XmlHandler.loadXmlFile((FileObject)HopVfs.getFileObject((String)fname));
            if (doc == null) {
                throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowMeta.Exception.ErrorReadingFromXMLFile", (String[])new String[0]) + fname);
            }
            Node workflowNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
            this.loadXml(workflowNode, fname, metadataProvider, variables);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowMeta.Exception.UnableToLoadWorkflowFromXMLFile", (String[])new String[0]) + fname + "]", (Throwable)e);
        }
    }

    public WorkflowMeta(InputStream inputStream, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        this();
        this.metadataProvider = metadataProvider;
        Document doc = XmlHandler.loadXmlFile((InputStream)inputStream, null, (boolean)false, (boolean)false);
        Node subNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
        this.loadXml(subNode, null, metadataProvider, variables);
    }

    public WorkflowMeta(Node workflowNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        this();
        this.metadataProvider = metadataProvider;
        this.loadXml(workflowNode, null, metadataProvider, variables);
    }

    public void loadXml(Node workflowNode, String filename, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            this.clear();
            this.setFilename(filename);
            this.info.setName(XmlHandler.getTagValue((Node)workflowNode, (String)"name"));
            this.info.setNameSynchronizedWithFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)workflowNode, (String)"name_sync_with_filename")));
            this.info.setDescription(XmlHandler.getTagValue((Node)workflowNode, (String)CONST_DESCRIPTION));
            this.info.setExtendedDescription(XmlHandler.getTagValue((Node)workflowNode, (String)"extended_description"));
            this.workflowVersion = XmlHandler.getTagValue((Node)workflowNode, (String)"workflow_version");
            this.workflowStatus = Const.toInt((String)XmlHandler.getTagValue((Node)workflowNode, (String)"workflow_status"), (int)-1);
            this.info.setCreatedUser(XmlHandler.getTagValue((Node)workflowNode, (String)"created_user"));
            String createDate = XmlHandler.getTagValue((Node)workflowNode, (String)"created_date");
            if (createDate != null) {
                this.info.setCreatedDate(XmlHandler.stringToDate((String)createDate));
            }
            this.info.setModifiedUser(XmlHandler.getTagValue((Node)workflowNode, (String)"modified_user"));
            String modDate = XmlHandler.getTagValue((Node)workflowNode, (String)"modified_date");
            if (modDate != null) {
                this.info.setModifiedDate(XmlHandler.stringToDate((String)modDate));
            }
            Node paramsNode = XmlHandler.getSubNode((Node)workflowNode, (String)XML_TAG_PARAMETERS);
            List paramNodes = XmlHandler.getNodes((Node)paramsNode, (String)CONST_PARAMETER);
            for (Node paramNode : paramNodes) {
                String parameterName = XmlHandler.getTagValue((Node)paramNode, (String)"name");
                String defaultValue = XmlHandler.getTagValue((Node)paramNode, (String)"default_value");
                String description = XmlHandler.getTagValue((Node)paramNode, (String)CONST_DESCRIPTION);
                this.addParameterDefinition(parameterName, defaultValue, description);
            }
            Node actionsNode = XmlHandler.getSubNode((Node)workflowNode, (String)XML_TAG_ACTIONS);
            List actionNodes = XmlHandler.getNodes((Node)actionsNode, (String)"action");
            for (Node actionNode : actionNodes) {
                ActionMeta prev;
                ActionMeta actionMeta = new ActionMeta(actionNode, metadataProvider, variables);
                if (actionMeta.isMissing()) {
                    this.addMissingAction((MissingAction)actionMeta.getAction());
                }
                if ((prev = this.findAction(actionMeta.getName())) != null) {
                    int idx = this.indexOfAction(prev);
                    this.removeAction(idx);
                }
                this.addAction(actionMeta);
            }
            Node hopsNode = XmlHandler.getSubNode((Node)workflowNode, (String)XML_TAG_HOPS);
            List hopNodes = XmlHandler.getNodes((Node)hopsNode, (String)"hop");
            for (Node hopNode : hopNodes) {
                WorkflowHopMeta hi = new WorkflowHopMeta(hopNode, this);
                this.workflowHops.add(hi);
            }
            Node notepadsNode = XmlHandler.getSubNode((Node)workflowNode, (String)XML_TAG_NOTEPADS);
            List nodepadNodes = XmlHandler.getNodes((Node)notepadsNode, (String)"notepad");
            for (Node notepadNode : nodepadNodes) {
                NotePadMeta ni = new NotePadMeta(notepadNode);
                this.notes.add(ni);
            }
            this.attributesMap = AttributesUtil.loadAttributes(XmlHandler.getSubNode((Node)workflowNode, (String)"attributes"));
            this.clearChanged();
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.WorkflowMetaLoaded.id, (Object)this);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowMeta.Exception.UnableToLoadWorkflowFromXMLNode", (String[])new String[0]), (Throwable)e);
        }
    }

    public ActionMeta getAction(int x, int y, int iconsize) {
        int s = this.nrActions();
        for (int i = s - 1; i >= 0; --i) {
            ActionMeta action = this.getAction(i);
            Point p = action.getLocation();
            if (p == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize) continue;
            return action;
        }
        return null;
    }

    public int nrActions() {
        return this.workflowActions.size();
    }

    public int nrWorkflowHops() {
        return this.workflowHops.size();
    }

    public WorkflowHopMeta getWorkflowHop(int i) {
        return this.workflowHops.get(i);
    }

    public ActionMeta getAction(int i) {
        return this.workflowActions.get(i);
    }

    public void addAction(ActionMeta action) {
        this.workflowActions.add(action);
        action.setParentWorkflowMeta(this);
        this.setChanged();
    }

    public void addWorkflowHop(WorkflowHopMeta hop) {
        this.workflowHops.add(hop);
        this.setChanged();
    }

    public void addAction(int p, ActionMeta action) {
        this.workflowActions.add(p, action);
        this.changedActions = true;
    }

    public void addWorkflowHop(int p, WorkflowHopMeta hop) {
        try {
            this.workflowHops.add(p, hop);
        }
        catch (IndexOutOfBoundsException e) {
            this.workflowHops.add(hop);
        }
        this.changedHops = true;
    }

    public void removeAction(int i) {
        ActionMeta deleted = this.workflowActions.remove(i);
        if (deleted != null) {
            deleted.setParentWorkflowMeta(null);
            if (deleted.getAction() instanceof MissingAction) {
                this.removeMissingAction((MissingAction)deleted.getAction());
            }
        }
        this.setChanged();
    }

    public void removeWorkflowHop(int i) {
        this.workflowHops.remove(i);
        this.setChanged();
    }

    public void removeWorkflowHop(WorkflowHopMeta hop) {
        this.workflowHops.remove(hop);
        this.setChanged();
    }

    public int indexOfWorkflowHop(WorkflowHopMeta hop) {
        return this.workflowHops.indexOf(hop);
    }

    public int indexOfAction(ActionMeta action) {
        return this.workflowActions.indexOf(action);
    }

    public void setAction(int idx, ActionMeta action) {
        this.workflowActions.set(idx, action);
    }

    public ActionMeta findAction(String name) {
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            if (!action.getName().equalsIgnoreCase(name)) continue;
            return action;
        }
        return null;
    }

    public WorkflowHopMeta findWorkflowHop(String name) {
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.toString().equalsIgnoreCase(name)) continue;
            return hop;
        }
        return null;
    }

    public WorkflowHopMeta findWorkflowHopFrom(ActionMeta action) {
        if (action != null) {
            for (WorkflowHopMeta hop : this.workflowHops) {
                if (hop == null || hop.getFromAction() == null || !hop.getFromAction().equals(action)) continue;
                return hop;
            }
        }
        return null;
    }

    public WorkflowHopMeta findWorkflowHop(ActionMeta from, ActionMeta to) {
        return this.findWorkflowHop(from, to, false);
    }

    public WorkflowHopMeta findWorkflowHop(ActionMeta from, ActionMeta to, boolean includeDisabled) {
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.isEnabled() && !includeDisabled || hop == null || hop.getFromAction() == null || hop.getToAction() == null || !hop.getFromAction().equals(from) || !hop.getToAction().equals(to)) continue;
            return hop;
        }
        return null;
    }

    public WorkflowHopMeta findWorkflowHopTo(ActionMeta actionMeta) {
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (hop == null || hop.getToAction() == null || !hop.getToAction().equals(actionMeta)) continue;
            return hop;
        }
        return null;
    }

    public int findNrPrevActions(ActionMeta from) {
        return this.findNrPrevActions(from, false);
    }

    public ActionMeta findPrevAction(ActionMeta to, int nr) {
        return this.findPrevAction(to, nr, false);
    }

    public int findNrPrevActions(ActionMeta to, boolean info) {
        int count = 0;
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.isEnabled() || !hop.getToAction().equals(to)) continue;
            ++count;
        }
        return count;
    }

    public ActionMeta findPrevAction(ActionMeta to, int nr, boolean info) {
        int count = 0;
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.isEnabled() || !hop.getToAction().equals(to)) continue;
            if (count == nr) {
                return hop.getFromAction();
            }
            ++count;
        }
        return null;
    }

    public int findNrNextActions(ActionMeta from) {
        int count = 0;
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.isEnabled() || hop.getFromAction() == null || !hop.getFromAction().equals(from)) continue;
            ++count;
        }
        return count;
    }

    public ActionMeta findNextAction(ActionMeta from, int cnt) {
        int count = 0;
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (!hop.isEnabled() || hop.getFromAction() == null || !hop.getFromAction().equals(from)) continue;
            if (count == cnt) {
                return hop.getToAction();
            }
            ++count;
        }
        return null;
    }

    public boolean hasLoop(ActionMeta action) {
        this.clearLoopCache();
        return this.hasLoop(action, null);
    }

    public boolean hasLoop(ActionMeta action, ActionMeta lookup) {
        return this.hasLoop(action, lookup, new HashSet<ActionMeta>());
    }

    private boolean hasLoop(ActionMeta action, ActionMeta lookup, HashSet<ActionMeta> checkedActions) {
        String cacheKey = action.getName() + " - " + (lookup != null ? lookup.getName() : "");
        Boolean hasLoop = this.loopCache.get(cacheKey);
        if (hasLoop != null) {
            return hasLoop;
        }
        hasLoop = false;
        checkedActions.add(action);
        int nr = this.findNrPrevActions(action);
        for (int i = 0; i < nr; ++i) {
            ActionMeta prevWorkflowMeta = this.findPrevAction(action, i);
            if (prevWorkflowMeta == null || !prevWorkflowMeta.equals(lookup) && (checkedActions.contains(prevWorkflowMeta) || !this.hasLoop(prevWorkflowMeta, lookup == null ? action : lookup, checkedActions))) continue;
            hasLoop = true;
            break;
        }
        this.loopCache.put(cacheKey, hasLoop);
        return hasLoop;
    }

    private void clearLoopCache() {
        this.loopCache.clear();
    }

    public boolean isEntryUsedInHops(ActionMeta action) {
        WorkflowHopMeta from = this.findWorkflowHopFrom(action);
        WorkflowHopMeta to = this.findWorkflowHopTo(action);
        return from != null || to != null;
    }

    public int countEntries(String name) {
        int count = 0;
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta actionMeta = this.getAction(i);
            if (!actionMeta.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        return count;
    }

    public String getAlternativeActionName(String name) {
        Object newname = name;
        ActionMeta action = this.findAction((String)newname);
        int nr = 1;
        while (action != null) {
            newname = name + " " + ++nr;
            action = this.findAction((String)newname);
        }
        return newname;
    }

    public ActionMeta[] getAllWorkflowGraphActions(String name) {
        int count = 0;
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta actionMeta = this.getAction(i);
            if (!actionMeta.getName().equalsIgnoreCase(name)) continue;
            ++count;
        }
        ActionMeta[] retval = new ActionMeta[count];
        count = 0;
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta actionMeta = this.getAction(i);
            if (!actionMeta.getName().equalsIgnoreCase(name)) continue;
            retval[count] = actionMeta;
            ++count;
        }
        return retval;
    }

    public WorkflowHopMeta[] getAllWorkflowHopsUsing(String name) {
        ArrayList<WorkflowHopMeta> hops = new ArrayList<WorkflowHopMeta>();
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (hop.getFromAction() == null || hop.getToAction() == null || !hop.getFromAction().getName().equalsIgnoreCase(name) && !hop.getToAction().getName().equalsIgnoreCase(name)) continue;
            hops.add(hop);
        }
        return hops.toArray(new WorkflowHopMeta[hops.size()]);
    }

    public boolean isPathExist(IAction from, IAction to) {
        for (WorkflowHopMeta hop : this.workflowHops) {
            if (hop.getFromAction() == null || hop.getToAction() == null || !hop.getFromAction().getName().equalsIgnoreCase(from.getName())) continue;
            if (hop.getToAction().getName().equalsIgnoreCase(to.getName())) {
                return true;
            }
            if (!this.isPathExist(hop.getToAction().getAction(), to)) continue;
            return true;
        }
        return false;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            action.setSelected(true);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            action.setSelected(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            loc = action.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            loc = ni.getLocation();
            if (loc.x + ni.width > maxx) {
                maxx = loc.x + ni.width;
            }
            if (loc.y + ni.height <= maxy) continue;
            maxy = loc.y + ni.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point getMinimum() {
        Point loc;
        int i;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        for (i = 0; i < this.nrActions(); ++i) {
            ActionMeta actionMeta = this.getAction(i);
            loc = actionMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            loc = notePadMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        minx = minx > 20 && minx != Integer.MAX_VALUE ? (minx -= 20) : 0;
        miny = miny > 20 && miny != Integer.MAX_VALUE ? (miny -= 20) : 0;
        return new Point(minx, miny);
    }

    public Point[] getSelectedLocations() {
        List<ActionMeta> actions = this.getSelectedActions();
        Point[] retval = new Point[actions.size()];
        for (int i = 0; i < retval.length; ++i) {
            ActionMeta action = actions.get(i);
            Point p = action.getLocation();
            retval[i] = new Point(p.x, p.y);
        }
        return retval;
    }

    public Point[] getSelectedNoteLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (NotePadMeta ni : this.getSelectedNotes()) {
            Point p = ni.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public List<ActionMeta> getSelectedActions() {
        ArrayList<ActionMeta> selection = new ArrayList<ActionMeta>();
        for (ActionMeta actionMeta : this.workflowActions) {
            if (!actionMeta.isSelected()) continue;
            selection.add(actionMeta);
        }
        return selection;
    }

    public int[] getActionIndexes(List<ActionMeta> actions) {
        int[] retval = new int[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            retval[i] = this.indexOfAction(actions.get(i));
        }
        return retval;
    }

    public ActionMeta findStart() {
        for (int i = 0; i < this.nrActions(); ++i) {
            if (!this.getAction(i).isStart()) continue;
            return this.getAction(i);
        }
        return null;
    }

    public String toString() {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            if (Utils.isEmpty((CharSequence)this.getName())) {
                return this.filename;
            }
            return this.filename + " : " + this.getName();
        }
        if (this.getName() != null) {
            return this.getName();
        }
        return WorkflowMeta.class.getName();
    }

    public List<SqlStatement> getSqlStatements(IProgressMonitor monitor, IVariables variables) throws HopException {
        return this.getSqlStatements(null, monitor, variables);
    }

    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IProgressMonitor monitor, IVariables variables) throws HopException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"WorkflowMeta.Monitor.GettingSQLNeededForThisWorkflow", (String[])new String[0]), this.nrActions() + 1);
        }
        ArrayList<SqlStatement> stats = new ArrayList<SqlStatement>();
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta copy = this.getAction(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"WorkflowMeta.Monitor.GettingSQLForActionCopy", (String[])new String[0]) + copy + "]");
            }
            stats.addAll(copy.getAction().getSqlStatements(metadataProvider, variables));
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    public List<StringSearchResult> getStringList(boolean searchTransforms, boolean searchDatabases, boolean searchNotes) {
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchTransforms) {
            for (i = 0; i < this.nrActions(); ++i) {
                ActionMeta actionMeta = this.getAction(i);
                stringList.add(new StringSearchResult(actionMeta.getName(), actionMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.ActionName", (String[])new String[0])));
                if (actionMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(actionMeta.getDescription(), actionMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.ActionDescription", (String[])new String[0])));
                }
                IAction action = actionMeta.getAction();
                StringSearcher.findMetaData(action, 1, stringList, actionMeta, this);
            }
        }
        if (searchDatabases) {
            for (DatabaseMeta databaseMeta : this.getDatabases()) {
                stringList.add(new StringSearchResult(databaseMeta.getName(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseConnectionName", (String[])new String[0])));
                if (databaseMeta.getHostname() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getHostname(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseHostName", (String[])new String[0])));
                }
                if (databaseMeta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getDatabaseName(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseName", (String[])new String[0])));
                }
                if (databaseMeta.getUsername() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getUsername(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseUsername", (String[])new String[0])));
                }
                if (databaseMeta.getPluginId() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getPluginId(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseTypeDescription", (String[])new String[0])));
                }
                if (databaseMeta.getPort() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getPort(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabasePort", (String[])new String[0])));
                }
                if (databaseMeta.getServername() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getServername(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabaseServer", (String[])new String[0])));
                }
                if (databaseMeta.getPassword() == null) continue;
                stringList.add(new StringSearchResult(databaseMeta.getPassword(), databaseMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.DatabasePassword", (String[])new String[0])));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                NotePadMeta notePadMeta = this.getNote(i);
                if (notePadMeta.getNote() == null) continue;
                stringList.add(new StringSearchResult(notePadMeta.getNote(), notePadMeta, this, BaseMessages.getString(PKG, (String)"WorkflowMeta.SearchMetadata.NotepadText", (String[])new String[0])));
            }
        }
        return stringList;
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false);
        ArrayList<String> varList = new ArrayList<String>();
        for (StringSearchResult result : stringList) {
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    public boolean haveActionsChanged() {
        if (this.changedActions) {
            return true;
        }
        for (int i = 0; i < this.nrActions(); ++i) {
            ActionMeta action = this.getAction(i);
            if (!action.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveWorkflowHopsChanged() {
        if (this.changedHops) {
            return true;
        }
        for (WorkflowHopMeta hi : this.workflowHops) {
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public String getWorkflowVersion() {
        return this.workflowVersion;
    }

    public int getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowVersion(String jobVersion) {
        this.workflowVersion = jobVersion;
    }

    public void setWorkflowStatus(int status) {
        this.workflowStatus = status;
    }

    @Override
    public void setInternalHopVariables(IVariables variables) {
        this.setInternalFilenameHopVariables(variables);
        this.setInternalNameHopVariable(variables);
        this.updateCurrentDir(variables);
    }

    protected void updateCurrentDir(IVariables variables) {
        String prevCurrentDir = variables.getVariable("Internal.Entry.Current.Folder");
        String currentDir = variables.getVariable(this.filename != null ? "Internal.Workflow.Filename.Folder" : "Internal.Entry.Current.Folder");
        variables.setVariable("Internal.Entry.Current.Folder", currentDir);
        this.fireCurrentDirectoryChanged(prevCurrentDir, currentDir);
    }

    @Override
    protected void setInternalNameHopVariable(IVariables variables) {
        variables.setVariable("Internal.Workflow.Name", Const.NVL((String)this.getName(), (String)""));
    }

    @Override
    protected void setInternalFilenameHopVariables(IVariables variables) {
        if (this.filename != null) {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)this.filename);
                FileName fileName = fileObject.getName();
                variables.setVariable("Internal.Workflow.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                variables.setVariable("Internal.Workflow.Filename.Folder", fileDir.getURI());
            }
            catch (Exception e) {
                variables.setVariable("Internal.Workflow.Filename.Folder", "");
                variables.setVariable("Internal.Workflow.Filename.Name", "");
            }
        } else {
            variables.setVariable("Internal.Workflow.Filename.Folder", "");
            variables.setVariable("Internal.Workflow.Filename.Name", "");
        }
        this.setInternalEntryCurrentDirectory(variables);
    }

    protected void setInternalEntryCurrentDirectory(IVariables variables) {
        variables.setVariable("Internal.Entry.Current.Folder", variables.getVariable(this.filename != null ? "Internal.Workflow.Filename.Folder" : "Internal.Entry.Current.Folder"));
    }

    public void checkActions(List<ICheckResult> remarks, boolean onlySelected, IProgressMonitor monitor, IVariables variables, IHopMetadataProvider metadataProvider) {
        remarks.clear();
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"WorkflowMeta.Monitor.VerifyingThisActionTask.Title", (String[])new String[0]), this.workflowActions.size() + 2);
        }
        boolean stopChecking = false;
        for (int i = 0; i < this.workflowActions.size() && !stopChecking; ++i) {
            IAction action;
            ActionMeta copy = this.workflowActions.get(i);
            if ((!onlySelected || onlySelected && copy.isSelected()) && (action = copy.getAction()) != null) {
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"WorkflowMeta.Monitor.VerifyingAction.Title", (String[])new String[]{action.getName()}));
                }
                action.check(remarks, this, variables, metadataProvider);
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        stopChecking = true;
                    }
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables) {
        ArrayList<ResourceReference> resourceReferences = new ArrayList<ResourceReference>();
        ActionMeta copy = null;
        IAction action = null;
        for (int i = 0; i < this.workflowActions.size(); ++i) {
            copy = this.workflowActions.get(i);
            action = copy.getAction();
            resourceReferences.addAll(action.getResourceDependencies(variables, this));
        }
        return resourceReferences;
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        String resourceName = null;
        try {
            String extension = "hwf";
            if (StringUtils.isNotEmpty((String)this.getFilename())) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.getFilename()));
                String originalPath = fileObject.getParent().getName().getPath();
                String baseName = fileObject.getName().getBaseName();
                String fullname = fileObject.getName().getPath();
                resourceName = namingInterface.nameResource(baseName, originalPath, extension, IResourceNaming.FileNamingType.WORKFLOW);
                ResourceDefinition definition = definitions.get(resourceName);
                if (definition == null) {
                    WorkflowMeta workflowMeta = (WorkflowMeta)this.realClone(false);
                    workflowMeta.setNameSynchronizedWithFilename(false);
                    workflowMeta.setName(this.getName());
                    for (ActionMeta actionMeta : workflowMeta.workflowActions) {
                        actionMeta.getAction().exportResources(variables, definitions, namingInterface, metadataProvider);
                    }
                    definition = new ResourceDefinition(resourceName, workflowMeta.getXml(variables));
                    if (Utils.isEmpty((CharSequence)this.getFilename())) {
                        definition.setOrigin(fullname);
                    } else {
                        definition.setOrigin(this.getFilename());
                    }
                    definitions.put(fullname, definition);
                }
            }
        }
        catch (FileSystemException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowMeta.Exception.AnErrorOccuredReadingWorkflow", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        catch (HopFileException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowMeta.Exception.AnErrorOccuredReadingWorkflow", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        return resourceName;
    }

    public void renameActionIfNameCollides(ActionMeta actionMeta) {
        boolean found;
        Object newname = actionMeta.getName();
        int nr = 1;
        do {
            found = false;
            for (ActionMeta action : this.workflowActions) {
                if (action == actionMeta || !action.getName().equalsIgnoreCase((String)newname)) continue;
                found = true;
            }
            if (!found) continue;
            newname = actionMeta.getName() + " (" + ++nr + ")";
        } while (found);
        actionMeta.setName((String)newname);
    }

    public List<ActionMeta> getActions() {
        return this.workflowActions;
    }

    public List<WorkflowHopMeta> getWorkflowHops() {
        return this.workflowHops;
    }

    public List<IAction> composeActionList() {
        ArrayList<IAction> list = new ArrayList<IAction>();
        for (ActionMeta action : this.workflowActions) {
            if (list.contains(action.getAction())) continue;
            list.add(action.getAction());
        }
        return list;
    }

    public String getLogChannelId() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.WORKFLOW_META;
    }

    public boolean containsAction(ActionMeta actionMeta) {
        return this.workflowActions.contains(actionMeta);
    }

    public List<MissingAction> getMissingActions() {
        return this.missingActions;
    }

    public void addMissingAction(MissingAction missingAction) {
        if (this.missingActions == null) {
            this.missingActions = new ArrayList<MissingAction>();
        }
        this.missingActions.add(missingAction);
    }

    public void removeMissingAction(MissingAction missingAction) {
        if (this.missingActions != null && missingAction != null) {
            this.missingActions.remove(missingAction);
        }
    }

    @Override
    public boolean hasMissingPlugins() {
        return this.missingActions != null && !this.missingActions.isEmpty();
    }

    public String getStartActionName() {
        return this.startActionName;
    }

    public void setStartActionName(String name) {
        this.startActionName = name;
    }

    public boolean isExpandingRemoteWorkflow() {
        return this.expandingRemoteWorkflow;
    }

    public void setExpandingRemoteWorkflow(boolean expandingRemoteWorkflow) {
        this.expandingRemoteWorkflow = expandingRemoteWorkflow;
    }

    public boolean isEmpty() {
        return this.nrActions() == 0 && this.nrNotes() == 0;
    }

    public WorkflowMetaInfo getInfo() {
        return this.info;
    }

    public void setInfo(WorkflowMetaInfo info) {
        this.info = info;
    }

    @Override
    public String getName() {
        return WorkflowMeta.extractNameFromFilename(this.isNameSynchronizedWithFilename(), this.info.getName(), this.filename, this.getExtension());
    }

    @Override
    public void setName(String newName) {
        this.fireNameChangedListeners(this.getName(), newName);
        this.info.setName(newName);
    }

    @Override
    public boolean isNameSynchronizedWithFilename() {
        return this.info.isNameSynchronizedWithFilename();
    }

    @Override
    public void setNameSynchronizedWithFilename(boolean nameSynchronizedWithFilename) {
        this.info.setNameSynchronizedWithFilename(nameSynchronizedWithFilename);
    }

    @Override
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.info.setDescription(description);
    }

    @Override
    public String getExtendedDescription() {
        return this.info.getExtendedDescription();
    }

    @Override
    public void setExtendedDescription(String extendedDescription) {
        this.info.setExtendedDescription(extendedDescription);
    }

    @Override
    public Date getCreatedDate() {
        return this.info.getCreatedDate();
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.info.setCreatedDate(createdDate);
    }

    @Override
    public void setCreatedUser(String createdUser) {
        this.info.setCreatedUser(createdUser);
    }

    @Override
    public String getCreatedUser() {
        return this.info.getCreatedUser();
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.info.setModifiedDate(modifiedDate);
    }

    @Override
    public Date getModifiedDate() {
        return this.info.getModifiedDate();
    }

    @Override
    public void setModifiedUser(String modifiedUser) {
        this.info.setModifiedUser(modifiedUser);
    }

    @Override
    public String getModifiedUser() {
        return this.info.getModifiedUser();
    }
}

