/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.script;

import java.math.BigDecimal;
import java.util.Date;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.script.ScriptData;
import org.apache.hop.pipeline.transforms.script.ScriptMeta;
import org.apache.hop.pipeline.transforms.script.ScriptUtils;

public class Script
extends BaseTransform<ScriptMeta, ScriptData>
implements ITransform {
    private static final Class<?> PKG = Script.class;
    public static final int ABORT_PIPELINE = -1;
    public static final int ERROR_PIPELINE = -2;
    public static final int CONTINUE_PIPELINE = 0;
    public static final int SKIP_PIPELINE = 1;
    public static final String CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED = "org.mozilla.javascript.Undefined";
    public static final String CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_NUMBER = "org.mozilla.javascript.NativeNumber";
    public static final String CONST_JAVA_LANG_DOUBLE = "java.lang.Double";
    public static final String CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_JAVA_OBJECT = "org.mozilla.javascript.NativeJavaObject";
    public static final String CONST_PREVIOUS_ROW = "previousRow";
    private boolean bWithPipelineStat = false;
    private boolean bRC = false;
    private boolean bFirstRun = false;
    private int rowNumber = 0;
    private String strTransformScript = "";
    private String strStartScript = "";
    private String strEndScript = "";
    private Bindings bindings;
    private Object[] previousRow = null;

    public Script(TransformMeta transformMeta, ScriptMeta meta, ScriptData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void determineUsedFields(IRowMeta row) {
        String valName;
        int i;
        if (row == null) {
            return;
        }
        int nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valName = row.getValueMeta(i).getName().toUpperCase();
            if (!this.strTransformScript.toUpperCase().contains(valName)) continue;
            ++nr;
        }
        ((ScriptData)this.data).fieldsUsed = new int[nr];
        ((ScriptData)this.data).valuesUsed = new Object[nr];
        nr = 0;
        for (i = 0; i < row.size(); ++i) {
            valName = row.getValueMeta(i).getName();
            if (!this.strTransformScript.contains(valName)) continue;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Script.Log.UsedValueName", (String[])new String[]{String.valueOf(i), valName}));
            }
            ((ScriptData)this.data).fieldsUsed[nr] = i;
            ++nr;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"Script.Log.UsingValuesFromInputStream", (String[])new String[]{String.valueOf(((ScriptData)this.data).fieldsUsed.length)}));
        }
    }

    private boolean addValues(IRowMeta rowMeta, Object[] row) throws HopException {
        if (this.first) {
            int i;
            this.first = false;
            if (rowMeta == null) {
                rowMeta = new RowMeta();
            }
            ((ScriptData)this.data).outputRowMeta = rowMeta.clone();
            ((ScriptMeta)this.meta).getFields(((ScriptData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.determineUsedFields(rowMeta);
            ((ScriptData)this.data).replaceIndex = new int[((ScriptMeta)this.meta).getFields().size()];
            for (i = 0; i < ((ScriptMeta)this.meta).getFields().size(); ++i) {
                ScriptMeta.SField field = ((ScriptMeta)this.meta).getFields().get(i);
                if (field.isReplace()) {
                    ((ScriptData)this.data).replaceIndex[i] = rowMeta.indexOfValue(field.getName());
                    if (((ScriptData)this.data).replaceIndex[i] >= 0) continue;
                    if (StringUtils.isEmpty((String)field.getName())) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{field.getName()}));
                    }
                    ((ScriptData)this.data).replaceIndex[i] = rowMeta.indexOfValue(field.getRename());
                    if (((ScriptData)this.data).replaceIndex[i] >= 0) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{field.getRename()}));
                }
                ((ScriptData)this.data).replaceIndex[i] = -1;
            }
            ((ScriptData)this.data).context = ((ScriptData)this.data).engine.getContext();
            if (((ScriptData)this.data).context == null) {
                ((ScriptData)this.data).context = new SimpleScriptContext();
            }
            this.bindings = ((ScriptData)this.data).engine.getBindings(100);
            this.bFirstRun = true;
            this.bindings.put("transform", (Object)this);
            this.bindings.put("transformName", (Object)this.getTransformName());
            this.bindings.put("pipelineName", (Object)this.getPipelineMeta().getName());
            for (i = 0; i < ((ScriptMeta)this.meta).getScripts().size(); ++i) {
                ScriptMeta.SScript script = ((ScriptMeta)this.meta).getScripts().get(i);
                this.bindings.put(script.getScriptName(), (Object)script.getScript());
            }
            try {
                this.addRowBindings(rowMeta, row);
                this.addConstantBindings();
                try {
                    if (StringUtils.isNotEmpty((String)this.strStartScript)) {
                        if (this.log.isDetailed()) {
                            this.logDetailed("Start compiledScript found!");
                        }
                        if (((ScriptData)this.data).engine instanceof Compilable) {
                            CompiledScript startScript = ((Compilable)((Object)((ScriptData)this.data).engine)).compile(this.strStartScript);
                            startScript.eval(this.bindings);
                        } else {
                            ((ScriptData)this.data).engine.eval(this.strStartScript);
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No starting compiledScript found!");
                    }
                }
                catch (Exception es) {
                    throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.ErrorProcessingStartScript", (String[])new String[0]), (Throwable)es);
                }
                ((ScriptData)this.data).rawScript = this.strTransformScript;
                ((ScriptData)this.data).compiledScript = ((ScriptData)this.data).engine instanceof Compilable ? ((Compilable)((Object)((ScriptData)this.data).engine)).compile(this.strTransformScript) : null;
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.CouldNotCompileScript", (String[])new String[0]), (Throwable)e);
            }
        }
        this.bindings.put("rowNumber", (Object)(++this.rowNumber));
        Object[] outputRow = RowDataUtil.resizeArray((Object[])row, (int)((ScriptData)this.data).outputRowMeta.size());
        int outputIndex = rowMeta == null ? 0 : rowMeta.size();
        try {
            Object statusVariable;
            try {
                this.bindings.put("row", (Object)row);
                try {
                    this.bindings.put(CONST_PREVIOUS_ROW, (Object)this.previousRow);
                }
                catch (Exception t) {
                    this.logError(BaseMessages.getString(PKG, (String)"Script.Exception.ErrorSettingVariable", (String[])new String[]{CONST_PREVIOUS_ROW}), t);
                }
                for (int i = 0; i < ((ScriptData)this.data).fieldsUsed.length; ++i) {
                    IValueMeta valueMeta = rowMeta.getValueMeta(((ScriptData)this.data).fieldsUsed[i]);
                    Object valueData = row[((ScriptData)this.data).fieldsUsed[i]];
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    this.bindings.put(valueMeta.getName(), normalStorageValueData);
                }
                this.bindings.put("rowMeta", (Object)rowMeta);
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.UnexpectedError", (String[])new String[0]), (Throwable)e);
            }
            Object scriptResult = this.evalScript();
            if (this.bFirstRun) {
                this.bFirstRun = false;
                Object statusVariable2 = this.bindings.get("pipeline_status");
                if (statusVariable2 != null) {
                    this.bWithPipelineStat = true;
                    if (this.log.isDetailed()) {
                        this.logDetailed("Value pipeline_status found. Checking pipeline status while compiledScript execution.");
                    }
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed("No pipeline_status value found. Pipeline status checking not available.");
                    }
                    this.bWithPipelineStat = false;
                }
            }
            int pipelineStatus = 0;
            if (this.bWithPipelineStat && Integer.class.isAssignableFrom((statusVariable = this.bindings.get("pipeline_status")).getClass())) {
                pipelineStatus = (Integer)statusVariable;
            }
            if (pipelineStatus == 0) {
                this.bRC = true;
                for (int i = 0; i < ((ScriptMeta)this.meta).getFields().size(); ++i) {
                    ScriptMeta.SField field = ((ScriptMeta)this.meta).getFields().get(i);
                    Object result = this.bindings.get(field.getName());
                    Object valueData = this.getValueFromScript(field.isScriptResult() ? scriptResult : result, i);
                    if (((ScriptData)this.data).replaceIndex[i] < 0) {
                        outputRow[outputIndex++] = valueData;
                        continue;
                    }
                    outputRow[((ScriptData)this.data).replaceIndex[i]] = valueData;
                }
                this.putRow(((ScriptData)this.data).outputRowMeta, outputRow);
            } else {
                switch (pipelineStatus) {
                    case 1: {
                        this.bRC = true;
                        break;
                    }
                    case -1: {
                        if (((ScriptData)this.data).engine != null) {
                            this.stopAll();
                        }
                        this.setOutputDone();
                        this.bRC = false;
                        break;
                    }
                    case -2: {
                        if (((ScriptData)this.data).engine != null) {
                            this.setErrors(1L);
                        }
                        this.stopAll();
                        this.bRC = false;
                        break;
                    }
                }
            }
        }
        catch (ScriptException e) {
            throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.ScriptError", (String[])new String[0]), (Throwable)e);
        }
        return this.bRC;
    }

    private void addRowBindings(IRowMeta rowMeta, Object[] row) {
        try {
            this.bindings.put("row", (Object)row);
            this.bindings.put(CONST_PREVIOUS_ROW, (Object)this.previousRow);
            this.bindings.put("rowMeta", (Object)rowMeta);
            this.bindings.put("outputRowMeta", (Object)((ScriptData)this.data).outputRowMeta);
            if (((ScriptData)this.data).fieldsUsed != null) {
                for (int i = 0; i < ((ScriptData)this.data).fieldsUsed.length; ++i) {
                    IValueMeta valueMeta = rowMeta.getValueMeta(((ScriptData)this.data).fieldsUsed[i]);
                    Object valueData = row[((ScriptData)this.data).fieldsUsed[i]];
                    Object normalStorageValueData = valueMeta.convertToNormalStorageType(valueData);
                    this.bindings.put(valueMeta.getName(), normalStorageValueData);
                }
            }
        }
        catch (Exception t) {
            this.logError(BaseMessages.getString(PKG, (String)"Script.Exception.ErrorSettingVariable", (String[])new String[0]), t);
        }
    }

    private void addConstantBindings() throws HopValueException {
        try {
            this.bindings.put("SKIP_PIPELINE", (Object)1);
            this.bindings.put("ABORT_PIPELINE", (Object)-1);
            this.bindings.put("ERROR_PIPELINE", (Object)-2);
            this.bindings.put("CONTINUE_PIPELINE", (Object)0);
            this.bindings.put("RowDataUtil", (Object)RowDataUtil.class);
        }
        catch (Exception ex) {
            throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.CouldNotAddDefaultConstants", (String[])new String[0]), (Throwable)ex);
        }
    }

    protected Object evalScript() throws ScriptException {
        if (((ScriptData)this.data).compiledScript != null) {
            try {
                return ((ScriptData)this.data).compiledScript.eval(((ScriptData)this.data).context);
            }
            catch (UnsupportedOperationException uoe) {
                return ((ScriptData)this.data).compiledScript.eval(this.bindings);
            }
        }
        if (((ScriptData)this.data).engine != null && ((ScriptData)this.data).rawScript != null) {
            try {
                return ((ScriptData)this.data).engine.eval(((ScriptData)this.data).rawScript, ((ScriptData)this.data).context);
            }
            catch (UnsupportedOperationException uoe) {
                return ((ScriptData)this.data).engine.eval(((ScriptData)this.data).rawScript, this.bindings);
            }
        }
        return null;
    }

    public Object getValueFromScript(Object result, int i) throws HopValueException {
        ScriptMeta.SField field = ((ScriptMeta)this.meta).getFields().get(i);
        if (StringUtils.isNotEmpty((String)field.getName())) {
            try {
                if (result != null) {
                    String classType = result.getClass().getName();
                    switch (field.getHopType()) {
                        case 1: {
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED)) {
                                return null;
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_NUMBER) || Number.class.isAssignableFrom(result.getClass())) {
                                Number nb = (Number)result;
                                return nb.doubleValue();
                            }
                            return Double.parseDouble(result.toString());
                        }
                        case 5: {
                            if (classType.equalsIgnoreCase("java.lang.Byte")) {
                                return ((Byte)result).longValue();
                            }
                            if (classType.equalsIgnoreCase("java.lang.Short")) {
                                return ((Short)result).longValue();
                            }
                            if (classType.equalsIgnoreCase("java.lang.Integer")) {
                                return ((Integer)result).longValue();
                            }
                            if (classType.equalsIgnoreCase("java.lang.Long")) {
                                return result;
                            }
                            if (classType.equalsIgnoreCase(CONST_JAVA_LANG_DOUBLE)) {
                                return ((Double)result).longValue();
                            }
                            if (classType.equalsIgnoreCase("java.lang.String")) {
                                return Long.parseLong((String)result);
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED)) {
                                return null;
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_NUMBER)) {
                                Number nb = (Number)result;
                                return nb.longValue();
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_JAVA_OBJECT)) {
                                try {
                                    return Long.parseLong(result.toString());
                                }
                                catch (Exception e2) {
                                    String string = (String)result;
                                    return Long.parseLong(Const.trim((String)string));
                                }
                            }
                            return Long.parseLong(result.toString());
                        }
                        case 2: {
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_JAVA_OBJECT) || classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED)) {
                                try {
                                    return result.toString();
                                }
                                catch (Exception ev) {
                                    return result;
                                }
                            }
                            return result;
                        }
                        case 3: {
                            double dbl = 0.0;
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED)) {
                                return null;
                            }
                            if (classType.equalsIgnoreCase("org.mozilla.javascript.NativeDate")) {
                                dbl = (Double)result;
                            } else if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_JAVA_OBJECT) || classType.equalsIgnoreCase("java.util.Date")) {
                                try {
                                    Date dat = (Date)result;
                                    dbl = dat.getTime();
                                }
                                catch (Exception e) {
                                    try {
                                        String string = (String)result;
                                        return XmlHandler.stringToDate((String)string);
                                    }
                                    catch (Exception e3) {
                                        throw new HopValueException("Can't convert a string to a date");
                                    }
                                }
                            } else if (classType.equalsIgnoreCase(CONST_JAVA_LANG_DOUBLE)) {
                                dbl = (Double)result;
                            } else {
                                String string = (String)result;
                                dbl = Double.parseDouble(string);
                            }
                            long lng = Math.round(dbl);
                            return new Date(lng);
                        }
                        case 4: {
                            return result;
                        }
                        case 6: {
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_UNDEFINED)) {
                                return null;
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_NUMBER)) {
                                Number nb = (Number)result;
                                return new BigDecimal(nb.longValue());
                            }
                            if (classType.equalsIgnoreCase(CONST_ORG_MOZILLA_JAVASCRIPT_NATIVE_JAVA_OBJECT)) {
                                try {
                                    return (BigDecimal)result;
                                }
                                catch (Exception e) {
                                    String string = (String)result;
                                    return new BigDecimal(string);
                                }
                            }
                            if (classType.equalsIgnoreCase("java.lang.Byte")) {
                                return new BigDecimal(((Byte)result).longValue());
                            }
                            if (classType.equalsIgnoreCase("java.lang.Short")) {
                                return new BigDecimal(((Short)result).longValue());
                            }
                            if (classType.equalsIgnoreCase("java.lang.Integer")) {
                                return new BigDecimal(((Integer)result).longValue());
                            }
                            if (classType.equalsIgnoreCase("java.lang.Long")) {
                                return new BigDecimal((Long)result);
                            }
                            if (classType.equalsIgnoreCase(CONST_JAVA_LANG_DOUBLE)) {
                                return new BigDecimal(((Double)result).longValue());
                            }
                            if (classType.equalsIgnoreCase("java.lang.String")) {
                                return new BigDecimal(Long.parseLong((String)result));
                            }
                            throw new RuntimeException("JavaScript conversion to BigNumber not implemented for " + classType);
                        }
                        case 8: {
                            return result;
                        }
                        case 0: {
                            throw new RuntimeException("No data output data type was specified for new field [" + field.getName() + "]");
                        }
                    }
                    throw new RuntimeException("JavaScript conversion not implemented for type " + field.getHopType() + " (" + field.getType() + ")");
                }
                return null;
            }
            catch (Exception e) {
                throw new HopValueException(BaseMessages.getString(PKG, (String)"Script.Log.ScriptError", (String[])new String[0]), (Throwable)e);
            }
        }
        throw new HopValueException("No name was specified for result value #" + (i + 1));
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null && !this.first) {
            try {
                if (((ScriptData)this.data).engine != null) {
                    if (this.strEndScript != null && this.strEndScript.length() > 0) {
                        ((ScriptData)this.data).engine.eval(this.strEndScript, this.bindings);
                        if (this.log.isDetailed()) {
                            this.logDetailed("End Script found!");
                        }
                    } else if (this.log.isDetailed()) {
                        this.logDetailed("No end Script found!");
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Script.Log.UnexpectedError", (String[])new String[0]) + " : " + e);
                this.logError(BaseMessages.getString(PKG, (String)"Script.Log.ErrorStackTrace", (String[])new String[0]) + Const.CR + Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
            }
            if (((ScriptData)this.data).engine != null) {
                this.setOutputDone();
            }
            return false;
        }
        try {
            this.addValues(this.getInputRowMeta(), r);
        }
        catch (HopValueException e) {
            Object location = "<unknown>";
            Throwable throwable = e.getCause();
            if (throwable instanceof ScriptException) {
                ScriptException ee = (ScriptException)throwable;
                location = "--> " + ee.getLineNumber() + ":" + ee.getColumnNumber();
            }
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.getMessage() + Const.CR + (String)location, null, "SCR-001");
                this.bRC = true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"Script.Exception.CouldNotExecuteScript", (String[])new String[]{location}), e);
            this.setErrors(1L);
            this.bRC = false;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Script.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        this.previousRow = r;
        return this.bRC;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        for (ScriptMeta.SScript script : ((ScriptMeta)this.meta).getScripts()) {
            switch (script.getScriptType()) {
                case TRANSFORM_SCRIPT: {
                    this.strTransformScript = script.getScript();
                    break;
                }
                case START_SCRIPT: {
                    this.strStartScript = script.getScript();
                    break;
                }
                case END_SCRIPT: {
                    this.strEndScript = script.getScript();
                    break;
                }
            }
        }
        try {
            ((ScriptData)this.data).engine = ScriptUtils.getInstance().getScriptEngineByName(((ScriptMeta)this.meta).getLanguageName());
        }
        catch (Exception e) {
            this.log.logError("Error obtaining scripting engine for language " + ((ScriptMeta)this.meta).getLanguageName(), (Throwable)e);
        }
        this.rowNumber = 0;
        this.previousRow = null;
        return true;
    }
}

