/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ServerStreamingCallable;
import net.snowflake.client.jdbc.internal.google.cloud.ReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.RestorableState;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BaseStorageReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteRangeSpec;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicDownloadSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.cloud.storage.LazyReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ReadableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableMedia;
import net.snowflake.client.jdbc.internal.google.storage.v2.Object;
import net.snowflake.client.jdbc.internal.google.storage.v2.ReadObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.ReadObjectResponse;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

final class GrpcBlobReadChannel
extends BaseStorageReadChannel<Object> {
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
    private final ReadObjectRequest request;
    private final boolean autoGzipDecompression;

    GrpcBlobReadChannel(ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ReadObjectRequest request, boolean autoGzipDecompression) {
        super(Conversions.grpc().blobInfo());
        this.read = read;
        this.request = request;
        this.autoGzipDecompression = autoGzipDecompression;
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        return (RestorableState)GrpcStorageImpl.throwHttpJsonOnly(ReadChannel.class, "capture");
    }

    @Override
    protected LazyReadChannel<?, Object> newLazyReadChannel() {
        return new LazyReadChannel(() -> {
            GapicDownloadSessionBuilder.ReadableByteChannelSessionBuilder b = ResumableMedia.gapic().read().byteChannel(this.read).setHasher(Hasher.noop()).setAutoGzipDecompression(this.autoGzipDecompression);
            BufferHandle bufferHandle = this.getBufferHandle();
            ReadableByteChannelSession session = bufferHandle.capacity() > 0 ? b.buffered(this.getBufferHandle()).setReadObjectRequest(this.getReadObjectRequest()).build() : b.unbuffered().setReadObjectRequest(this.getReadObjectRequest()).build();
            return session;
        });
    }

    private @NonNull ReadObjectRequest getReadObjectRequest() {
        Object resolvedObject;
        ByteRangeSpec rangeSpec = this.getByteRangeSpec();
        ReadObjectRequest.Builder b = this.request.toBuilder();
        if (this.request.getGeneration() == 0L && (resolvedObject = (Object)this.getResolvedObject()) != null) {
            b.setGeneration(resolvedObject.getGeneration());
        }
        return rangeSpec.seekReadObjectRequest(b).build();
    }
}

