/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.SQLException;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeSQLException
extends SQLException {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeSQLException.class);
    private static final long serialVersionUID = 1L;
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.jdbc_error_messages");
    private String queryId = "unknown";
    private int retryCount = 0;
    boolean issocketTimeoutNoBackoff;
    long elapsedSeconds;

    public SnowflakeSQLException(String queryId, String reason, String sqlState, int vendorCode) {
        super(reason, sqlState, vendorCode);
        this.queryId = queryId;
        logger.debug("Snowflake exception: {}, sqlState: {}, vendorCode: {}, queryId: {}", reason, sqlState, vendorCode, queryId);
    }

    public SnowflakeSQLException(String reason, String sqlState) {
        super(reason, sqlState);
        logger.debug("Snowflake exception: {}, sqlState: {}", reason, sqlState);
    }

    @Deprecated
    public SnowflakeSQLException(String sqlState, int vendorCode) {
        this((String)null, sqlState, vendorCode);
    }

    public SnowflakeSQLException(String queryId, String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode);
        this.queryId = queryId;
        logger.debug("Snowflake exception: {}, sqlState: {}, vendorCode: {}", errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode);
    }

    @Deprecated
    public SnowflakeSQLException(String sqlState, int vendorCode, Object ... params) {
        this((String)null, sqlState, vendorCode, params);
    }

    public SnowflakeSQLException(String queryId, String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode);
        this.queryId = queryId;
        logger.debug("Snowflake exception: {}, sqlState: {}, vendorCode: {}", errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode);
    }

    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), sqlState, vendorCode, ex);
        logger.debug("Snowflake exception: {}" + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode)), ex);
    }

    public SnowflakeSQLException(Throwable ex, ErrorCode errorCode, Object ... params) {
        this(ex, errorCode.getSqlState(), (int)errorCode.getMessageCode(), params);
    }

    @Deprecated
    public SnowflakeSQLException(Throwable ex, String sqlState, int vendorCode, Object ... params) {
        this(null, ex, sqlState, vendorCode, params);
    }

    public SnowflakeSQLException(String queryId, Throwable ex, String sqlState, int vendorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), sqlState, vendorCode, ex);
        this.queryId = queryId;
        logger.debug("Snowflake exception: " + errorResourceBundleManager.getLocalizedMessage(String.valueOf(vendorCode), params), ex);
    }

    public SnowflakeSQLException(ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), errorCode.getSqlState(), errorCode.getMessageCode());
    }

    public SnowflakeSQLException(String queryId, ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), errorCode.getSqlState(), errorCode.getMessageCode());
        this.queryId = queryId;
    }

    public SnowflakeSQLException(ErrorCode errorCode, int retryCount, boolean issocketTimeoutNoBackoff, long elapsedSeconds) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode())), errorCode.getSqlState(), errorCode.getMessageCode());
        this.retryCount = retryCount;
        this.issocketTimeoutNoBackoff = issocketTimeoutNoBackoff;
        this.elapsedSeconds = elapsedSeconds;
    }

    public SnowflakeSQLException(SFException e) {
        this(e.getQueryId(), e.getMessage(), e.getSqlState(), e.getVendorCode());
    }

    public SnowflakeSQLException(String reason) {
        super(reason);
    }

    public SnowflakeSQLException(Throwable ex, String message) {
        super(message, ex);
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean issocketTimeoutNoBackoff() {
        return this.issocketTimeoutNoBackoff;
    }

    public long getElapsedSeconds() {
        return this.elapsedSeconds;
    }
}

