/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Internal;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.NameResolver;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.NameResolverProvider;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.netty.UdsNameResolver;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.unix.DomainSocketAddress;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    @Override
    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri));
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument(SCHEME.equals(targetUri.getScheme()), "scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = Preconditions.checkNotNull(targetUri.getSchemeSpecificPart(), "targetPath");
        }
        return targetPath;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 3;
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

