/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;

public class Prepared
extends Result {
    public final byte[] preparedQueryId;
    public final byte[] resultMetadataId;
    public final RowsMetadata variablesMetadata;
    public final RowsMetadata resultMetadata;

    public Prepared(byte[] preparedQueryId, byte[] resultMetadataId, RowsMetadata variablesMetadata, RowsMetadata resultMetadata) {
        super(4);
        this.preparedQueryId = preparedQueryId;
        this.resultMetadataId = resultMetadataId;
        this.variablesMetadata = variablesMetadata;
        this.resultMetadata = resultMetadata;
    }

    public String toString() {
        return "PREPARED(" + Bytes.toHexString(this.preparedQueryId) + ')';
    }

    public static class SubCodec
    extends Result.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Prepared prepared = (Prepared)message;
            encoder.writeShortBytes(prepared.preparedQueryId, dest);
            if (this.protocolVersion >= 5) {
                encoder.writeShortBytes(prepared.resultMetadataId, dest);
            }
            boolean hasPkIndices = this.protocolVersion >= 4;
            prepared.variablesMetadata.encode(dest, encoder, hasPkIndices, this.protocolVersion);
            prepared.resultMetadata.encode(dest, encoder, false, this.protocolVersion);
        }

        @Override
        public int encodedSize(Message message) {
            Prepared prepared = (Prepared)message;
            int size = PrimitiveSizes.sizeOfShortBytes(prepared.preparedQueryId);
            if (this.protocolVersion >= 5) {
                assert (prepared.resultMetadataId != null);
                size += PrimitiveSizes.sizeOfShortBytes(prepared.resultMetadataId);
            }
            boolean hasPkIndices = this.protocolVersion >= 4;
            size += prepared.variablesMetadata.encodedSize(hasPkIndices, this.protocolVersion);
            return size += prepared.resultMetadata.encodedSize(false, this.protocolVersion);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            byte[] preparedQueryId = decoder.readShortBytes(source);
            byte[] resultMetadataId = this.protocolVersion >= 5 ? decoder.readShortBytes(source) : null;
            boolean hasPkIndices = this.protocolVersion >= 4;
            RowsMetadata variablesMetadata = RowsMetadata.decode(source, decoder, hasPkIndices, this.protocolVersion);
            RowsMetadata resultMetadata = RowsMetadata.decode(source, decoder, false, this.protocolVersion);
            return new Prepared(preparedQueryId, resultMetadataId, variablesMetadata, resultMetadata);
        }
    }
}

