/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.folderisempty;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="FOLDER_IS_EMPTY", name="i18n::ActionFolderIsEmpty.Name", description="i18n::ActionFolderIsEmpty.Description", image="FolderIsEmpty.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionFolderIsEmpty.keyword"}, documentationUrl="/workflow/actions/folderisempty.html")
public class ActionFolderIsEmpty
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionFolderIsEmpty.class;
    @HopMetadataProperty(key="foldername")
    private String folderName;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includeSubFolders;
    @HopMetadataProperty(key="specify_wildcard")
    private boolean specifyWildcard;
    @HopMetadataProperty(key="wildcard")
    private String wildcard;
    private int filescount;
    private int folderscount;
    private Pattern pattern;

    public ActionFolderIsEmpty(String n) {
        super(n, "");
        this.folderName = null;
        this.wildcard = null;
        this.includeSubFolders = false;
        this.specifyWildcard = false;
    }

    public ActionFolderIsEmpty() {
        this("");
    }

    public ActionFolderIsEmpty(ActionFolderIsEmpty meta) {
        super(meta.getName(), meta.getDescription(), meta.getPluginId());
        this.folderName = meta.folderName;
        this.includeSubFolders = meta.includeSubFolders;
        this.specifyWildcard = meta.specifyWildcard;
        this.wildcard = meta.wildcard;
    }

    public Object clone() {
        return new ActionFolderIsEmpty(this);
    }

    public void setSpecifyWildcard(boolean specifyWildcard) {
        this.specifyWildcard = specifyWildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifyWildcard;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getRealFolderName() {
        return this.resolve(this.getFolderName());
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getRealWildcard() {
        return this.resolve(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(boolean includeSubfolders) {
        this.includeSubFolders = includeSubfolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(0L);
        this.filescount = 0;
        this.folderscount = 0;
        this.pattern = null;
        if (!Utils.isEmpty((CharSequence)this.getWildcard())) {
            this.pattern = Pattern.compile(this.getRealWildcard());
        }
        if (this.folderName != null) {
            String realFoldername = this.getRealFolderName();
            FileObject folderObject = null;
            try {
                folderObject = HopVfs.getFileObject((String)realFoldername, (IVariables)this.getVariables());
                if (folderObject.exists()) {
                    if (folderObject.getType() == FileType.FOLDER) {
                        block20: {
                            try {
                                folderObject.findFiles((FileSelector)new TextFileSelector(folderObject.toString()));
                            }
                            catch (Exception ex) {
                                if (ex.getCause() instanceof ExpectedException) break block20;
                                throw ex;
                            }
                        }
                        if (this.log.isBasic()) {
                            this.log.logBasic("Total files", new Object[]{"We found : " + this.filescount + " file(s)"});
                        }
                        if (this.filescount != 0) return result;
                        result.setResult(true);
                        result.setNrLinesInput((long)this.folderscount);
                        return result;
                    }
                    this.log.logError("[" + realFoldername + "] is not a folder, failing.");
                    result.setNrErrors(1L);
                    return result;
                }
                if (this.log.isBasic()) {
                    this.logBasic("we can not find [" + realFoldername + "] !");
                }
                result.setNrErrors(1L);
                return result;
            }
            catch (Exception e) {
                this.logError("Error checking folder [" + realFoldername + "]", e);
                result.setResult(false);
                result.setNrErrors(1L);
                return result;
            }
            finally {
                if (folderObject != null) {
                    try {
                        folderObject.close();
                        folderObject = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logError("No Foldername is defined.");
        result.setNrErrors(1L);
        return result;
    }

    private boolean GetFileWildcard(String selectedfile) {
        boolean getIt = true;
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    private class TextFileSelector
    implements FileSelector {
        String rootFolder = null;

        public TextFileSelector(String rootfolder) {
            if (rootfolder != null) {
                this.rootFolder = rootfolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean includeFile(FileSelectInfo info) throws ExpectedException {
            boolean returncode;
            block23: {
                returncode = false;
                Object filename = null;
                boolean rethrow = false;
                try {
                    if (!info.getFile().toString().equals(this.rootFolder)) {
                        if (info.getFile().getType() == FileType.FILE) {
                            if (info.getFile().getParent().equals(info.getBaseFolder())) {
                                if (ActionFolderIsEmpty.this.isSpecifyWildcard() && ActionFolderIsEmpty.this.GetFileWildcard(info.getFile().getName().getBaseName()) || !ActionFolderIsEmpty.this.isSpecifyWildcard()) {
                                    if (ActionFolderIsEmpty.this.log.isDetailed()) {
                                        ActionFolderIsEmpty.this.log.logDetailed("We found file : " + info.getFile().toString());
                                    }
                                    ++ActionFolderIsEmpty.this.filescount;
                                }
                            } else if (ActionFolderIsEmpty.this.isIncludeSubFolders() && (ActionFolderIsEmpty.this.isSpecifyWildcard() && ActionFolderIsEmpty.this.GetFileWildcard(info.getFile().getName().getBaseName()) || !ActionFolderIsEmpty.this.isSpecifyWildcard())) {
                                if (ActionFolderIsEmpty.this.log.isDetailed()) {
                                    ActionFolderIsEmpty.this.log.logDetailed("We found file : " + info.getFile().toString());
                                }
                                ++ActionFolderIsEmpty.this.filescount;
                            }
                        } else {
                            ++ActionFolderIsEmpty.this.folderscount;
                        }
                    }
                    if (ActionFolderIsEmpty.this.filescount > 0) {
                        rethrow = true;
                        throw new ExpectedException();
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    if (!rethrow) {
                        ActionFolderIsEmpty.this.log.logError(BaseMessages.getString(PKG, (String)"ActionFolderIsEmpty.Error", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionFolderIsEmpty.Error.Exception", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                        returncode = false;
                        break block23;
                    }
                    throw (ExpectedException)e;
                }
                finally {
                    if (filename != null) {
                        try {
                            filename.close();
                            filename = null;
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }

    private class ExpectedException
    extends Exception {
        private static final long serialVersionUID = -692662556327569162L;

        private ExpectedException() {
        }
    }
}

