/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.getpop;

import jakarta.mail.Flags;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.getpop.MailConnection;
import org.apache.hop.workflow.actions.getpop.MailConnectionMeta;
import org.w3c.dom.Node;

@Action(id="GET_POP", name="i18n::ActionGetPOP.Name", description="i18n::ActionGetPOP.Description", image="GetPOP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Mail", keywords={"i18n::ActionGetPOP.keyword"}, documentationUrl="/workflow/actions/getpop.html")
public class ActionGetPOP
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionGetPOP.class;
    private static final String CONST_SPACE_SHORT = "      ";
    private static final String CONST_PASSWORD = "password";
    private static final String CONST_MESSAGE_DELETED = "ActionGetMailsFromPOP.MessageDeleted";
    static final int FOLDER_OUTPUT = 0;
    static final int FOLDER_ATTACHMENTS = 1;
    public int actiontype = 0;
    public int conditionReceivedDate;
    public int valueimaplist = 0;
    public int aftergetimap = 0;
    private String servername = null;
    private String username = null;
    private String password = null;
    private boolean usessl = false;
    private String sslport = null;
    private boolean usexoauth2 = false;
    private boolean useproxy = false;
    private String proxyusername = null;
    private String outputdirectory = null;
    private String filenamepattern = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    private String firstmails = null;
    public int retrievemails = 0;
    private boolean delete = false;
    private String protocol = "POP3";
    private boolean saveattachment = true;
    private boolean savemessage = true;
    private boolean usedifferentfolderforattachment = false;
    private String attachmentfolder = null;
    private String attachmentwildcard = null;
    private String imapfirstmails = "0";
    private String imapfolder = null;
    private String senderSearch = null;
    private boolean notTermSenderSearch = false;
    private String receipientSearch = null;
    private String subjectSearch = null;
    private String bodySearch = null;
    private boolean notTermBodySearch = false;
    private String receivedDate1 = null;
    private String receivedDate2 = null;
    private boolean notTermSubjectSearch = false;
    private boolean notTermReceipientSearch = false;
    private boolean notTermReceivedDateSearch = false;
    private boolean includesubfolders = false;
    private String moveToIMAPFolder = null;
    private boolean createmovetofolder = false;
    private boolean createlocalfolder = false;
    private static final String DEFAULT_FILE_NAME_PATTERN = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String FILENAME_ID_PATTERN = "#IdFile#";
    private static final String FILENAME_SYS_DATE_OPEN = "{SYS|";
    private static final String FILENAME_SYS_DATE_CLOSE = "|}";
    private Pattern attachementPattern;

    public ActionGetPOP(String n) {
        super(n, "");
    }

    public ActionGetPOP() {
        this("");
    }

    public Object clone() {
        ActionGetPOP je = (ActionGetPOP)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(550);
        retval.append(super.getXml());
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"servername", (String)this.servername));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"username", (String)this.username));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)CONST_PASSWORD, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"usessl", (boolean)this.usessl));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"sslport", (String)this.sslport));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"usexoauth2", (boolean)this.usexoauth2));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"outputdirectory", (String)this.outputdirectory));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"filenamepattern", (String)this.filenamepattern));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"retrievemails", (int)this.retrievemails));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"firstmails", (String)this.firstmails));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"delete", (boolean)this.delete));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"savemessage", (boolean)this.savemessage));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"saveattachment", (boolean)this.saveattachment));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"usedifferentfolderforattachment", (boolean)this.usedifferentfolderforattachment));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"attachmentfolder", (String)this.attachmentfolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"attachmentwildcard", (String)this.attachmentwildcard));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"valueimaplist", (String)MailConnectionMeta.getValueImapListCode(this.valueimaplist)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"imapfirstmails", (String)this.imapfirstmails));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"imapfolder", (String)this.imapfolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"sendersearch", (String)this.senderSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"nottermsendersearch", (boolean)this.notTermSenderSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"receipientsearch", (String)this.receipientSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"nottermreceipientsearch", (boolean)this.notTermReceipientSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"subjectsearch", (String)this.subjectSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"nottermsubjectsearch", (boolean)this.notTermSubjectSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"bodysearch", (String)this.bodySearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"nottermbodysearch", (boolean)this.notTermBodySearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"conditionreceiveddate", (String)MailConnectionMeta.getConditionDateCode(this.conditionReceivedDate)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"nottermreceiveddatesearch", (boolean)this.notTermReceivedDateSearch));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"receiveddate1", (String)this.receivedDate1));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"receiveddate2", (String)this.receivedDate2));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"actiontype", (String)MailConnectionMeta.getActionTypeCode(this.actiontype)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"movetoimapfolder", (String)this.moveToIMAPFolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"createmovetofolder", (boolean)this.createmovetofolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"createlocalfolder", (boolean)this.createlocalfolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"aftergetimap", (String)MailConnectionMeta.getAfterGetIMAPCode(this.aftergetimap)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"includesubfolders", (boolean)this.includesubfolders));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyusername", (String)this.proxyusername));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.servername = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.username = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)CONST_PASSWORD));
            this.usessl = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usessl"));
            this.sslport = XmlHandler.getTagValue((Node)entrynode, (String)"sslport");
            this.usexoauth2 = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usexoauth2"));
            this.outputdirectory = XmlHandler.getTagValue((Node)entrynode, (String)"outputdirectory");
            this.filenamepattern = XmlHandler.getTagValue((Node)entrynode, (String)"filenamepattern");
            if (Utils.isEmpty((CharSequence)this.filenamepattern)) {
                this.filenamepattern = DEFAULT_FILE_NAME_PATTERN;
            }
            this.retrievemails = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"retrievemails"), (int)-1);
            this.firstmails = XmlHandler.getTagValue((Node)entrynode, (String)"firstmails");
            this.delete = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"delete"));
            this.protocol = Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"protocol"), (String)"POP3");
            String sm = XmlHandler.getTagValue((Node)entrynode, (String)"savemessage");
            this.savemessage = Utils.isEmpty((CharSequence)sm) ? true : "Y".equalsIgnoreCase(sm);
            String sa = XmlHandler.getTagValue((Node)entrynode, (String)"saveattachment");
            this.saveattachment = Utils.isEmpty((CharSequence)sa) ? true : "Y".equalsIgnoreCase(sa);
            this.usedifferentfolderforattachment = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usedifferentfolderforattachment"));
            this.attachmentfolder = XmlHandler.getTagValue((Node)entrynode, (String)"attachmentfolder");
            this.attachmentwildcard = XmlHandler.getTagValue((Node)entrynode, (String)"attachmentwildcard");
            this.valueimaplist = MailConnectionMeta.getValueImapListByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"valueimaplist"), (String)""));
            this.imapfirstmails = XmlHandler.getTagValue((Node)entrynode, (String)"imapfirstmails");
            this.imapfolder = XmlHandler.getTagValue((Node)entrynode, (String)"imapfolder");
            this.senderSearch = XmlHandler.getTagValue((Node)entrynode, (String)"sendersearch");
            this.notTermSenderSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"nottermsendersearch"));
            this.receipientSearch = XmlHandler.getTagValue((Node)entrynode, (String)"receipientsearch");
            this.notTermReceipientSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"nottermreceipientsearch"));
            this.subjectSearch = XmlHandler.getTagValue((Node)entrynode, (String)"subjectsearch");
            this.notTermSubjectSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"nottermsubjectsearch"));
            this.bodySearch = XmlHandler.getTagValue((Node)entrynode, (String)"bodysearch");
            this.notTermBodySearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"nottermbodysearch"));
            this.conditionReceivedDate = MailConnectionMeta.getConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"conditionreceiveddate"), (String)""));
            this.notTermReceivedDateSearch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"nottermreceiveddatesearch"));
            this.receivedDate1 = XmlHandler.getTagValue((Node)entrynode, (String)"receivedDate1");
            this.receivedDate2 = XmlHandler.getTagValue((Node)entrynode, (String)"receivedDate2");
            this.actiontype = MailConnectionMeta.getActionTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"actiontype"), (String)""));
            this.moveToIMAPFolder = XmlHandler.getTagValue((Node)entrynode, (String)"movetoimapfolder");
            this.createmovetofolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createmovetofolder"));
            this.createlocalfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createlocalfolder"));
            this.aftergetimap = MailConnectionMeta.getAfterGetIMAPByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"aftergetimap"), (String)""));
            this.includesubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"includesubfolders"));
            this.useproxy = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"useproxy"));
            this.proxyusername = XmlHandler.getTagValue((Node)entrynode, (String)"proxyusername");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'get pop' from XML node", (Throwable)xe);
        }
    }

    public int getValueImapList() {
        return this.valueimaplist;
    }

    public void setValueImapList(int value) {
        this.valueimaplist = value;
    }

    public String getPort() {
        return this.sslport;
    }

    public String getRealPort() {
        return this.resolve(this.getPort());
    }

    public void setPort(String sslport) {
        this.sslport = sslport;
    }

    public void setUseXOAUTH2(boolean usexoauth2) {
        this.usexoauth2 = usexoauth2;
    }

    public boolean isUseXOAUTH2() {
        return this.usexoauth2;
    }

    public void setFirstMails(String firstmails) {
        this.firstmails = firstmails;
    }

    public String getFirstMails() {
        return this.firstmails;
    }

    public boolean isIncludeSubFolders() {
        return this.includesubfolders;
    }

    public void setIncludeSubFolders(boolean includesubfolders) {
        this.includesubfolders = includesubfolders;
    }

    public void setFirstIMAPMails(String firstmails) {
        this.imapfirstmails = firstmails;
    }

    public String getFirstIMAPMails() {
        return this.imapfirstmails;
    }

    public void setSenderSearchTerm(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    public String getSenderSearchTerm() {
        return this.senderSearch;
    }

    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    public void setNotTermBodySearch(boolean notTermBodySearch) {
        this.notTermBodySearch = notTermBodySearch;
    }

    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    public boolean isNotTermBodySearch() {
        return this.notTermBodySearch;
    }

    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    public void setNotTermReceipientSearch(boolean notTermReceipientSearch) {
        this.notTermReceipientSearch = notTermReceipientSearch;
    }

    public boolean isNotTermReceipientSearch() {
        return this.notTermReceipientSearch;
    }

    public void setCreateMoveToFolder(boolean createfolder) {
        this.createmovetofolder = createfolder;
    }

    public boolean isCreateMoveToFolder() {
        return this.createmovetofolder;
    }

    public void setReceipientSearch(String receipientSearch) {
        this.receipientSearch = receipientSearch;
    }

    public String getReceipientSearch() {
        return this.receipientSearch;
    }

    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    public void setBodySearch(String bodySearch) {
        this.bodySearch = bodySearch;
    }

    public String getBodySearch() {
        return this.bodySearch;
    }

    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    public void setReceivedDate1(String inputDate) {
        this.receivedDate1 = inputDate;
    }

    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    public void setReceivedDate2(String inputDate) {
        this.receivedDate2 = inputDate;
    }

    public void setMoveToIMAPFolder(String folderName) {
        this.moveToIMAPFolder = folderName;
    }

    public String getMoveToIMAPFolder() {
        return this.moveToIMAPFolder;
    }

    public void setCreateLocalFolder(boolean createfolder) {
        this.createlocalfolder = createfolder;
    }

    public boolean isCreateLocalFolder() {
        return this.createlocalfolder;
    }

    public void setConditionOnReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    public int getConditionOnReceivedDate() {
        return this.conditionReceivedDate;
    }

    public void setActionType(int actiontype) {
        this.actiontype = actiontype;
    }

    public int getActionType() {
        return this.actiontype;
    }

    public void setAfterGetIMAP(int afterget) {
        this.aftergetimap = afterget;
    }

    public int getAfterGetIMAP() {
        return this.aftergetimap;
    }

    public String getRealFirstMails() {
        return this.resolve(this.getFirstMails());
    }

    public void setServerName(String servername) {
        this.servername = servername;
    }

    public String getServerName() {
        return this.servername;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setOutputDirectory(String outputdirectory) {
        this.outputdirectory = outputdirectory;
    }

    public void setFilenamePattern(String filenamepattern) {
        this.filenamepattern = filenamepattern;
    }

    public void setRetrievemails(int nr) {
        this.retrievemails = nr;
    }

    public int getRetrievemails() {
        return this.retrievemails;
    }

    public String getFilenamePattern() {
        return this.filenamepattern;
    }

    public String getOutputDirectory() {
        return this.outputdirectory;
    }

    public String getRealOutputDirectory() {
        return this.resolve(this.getOutputDirectory());
    }

    public String getRealFilenamePattern() {
        return this.resolve(this.getFilenamePattern());
    }

    public String getRealUsername() {
        return this.resolve(this.getUserName());
    }

    public String getRealServername() {
        return this.resolve(this.getServerName());
    }

    public String getRealProxyUsername() {
        return this.resolve(this.geProxyUsername());
    }

    public String geProxyUsername() {
        return this.proxyusername;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealPassword(String password) {
        return Utils.resolvePassword((IVariables)this.getVariables(), (String)password);
    }

    public String getAttachmentFolder() {
        return this.attachmentfolder;
    }

    public String getRealAttachmentFolder() {
        return this.resolve(this.getAttachmentFolder());
    }

    public void setAttachmentFolder(String folderName) {
        this.attachmentfolder = folderName;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIMAPFolder() {
        return this.imapfolder;
    }

    public void setIMAPFolder(String folder) {
        this.imapfolder = folder;
    }

    public void setAttachmentWildcard(String wildcard) {
        this.attachmentwildcard = wildcard;
    }

    public String getAttachmentWildcard() {
        return this.attachmentwildcard;
    }

    public void setUseSSL(boolean usessl) {
        this.usessl = usessl;
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useprox) {
        this.useproxy = useprox;
    }

    public boolean isSaveAttachment() {
        return this.saveattachment;
    }

    public void setProxyUsername(String username) {
        this.proxyusername = username;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public void setSaveAttachment(boolean saveattachment) {
        this.saveattachment = saveattachment;
    }

    public boolean isSaveMessage() {
        return this.savemessage;
    }

    public void setSaveMessage(boolean savemessage) {
        this.savemessage = savemessage;
    }

    public void setDifferentFolderForAttachment(boolean usedifferentfolder) {
        this.usedifferentfolderforattachment = usedifferentfolder;
    }

    public boolean isDifferentFolderForAttachment() {
        return this.usedifferentfolderforattachment;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setResult(false);
        MailConnection mailConn = null;
        Date beginDate = null;
        Date endDate = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        try {
            String realSearchBody;
            String realSearchSubject;
            String realSearchReceipient;
            String realSearchSender;
            boolean usePOP3 = this.getProtocol().equals("POP3");
            boolean moveafter = false;
            int nbrmailtoretrieve = usePOP3 ? (this.getRetrievemails() == 2 ? Const.toInt((String)this.getFirstMails(), (int)0) : 0) : Const.toInt((String)this.getFirstIMAPMails(), (int)0);
            String realOutputFolder = this.createOutputDirectory(0);
            String targetAttachmentFolder = this.createOutputDirectory(1);
            String realMoveToIMAPFolder = this.resolve(this.getMoveToIMAPFolder());
            if (this.getProtocol().equals("IMAP") && this.getActionType() == 1 || this.getActionType() == 0 && this.getAfterGetIMAP() == 2) {
                if (Utils.isEmpty((CharSequence)realMoveToIMAPFolder)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.MoveToIMAPFolderEmpty", (String[])new String[0]));
                }
                moveafter = true;
            }
            switch (this.getConditionOnReceivedDate()) {
                case 1: 
                case 2: 
                case 3: {
                    String realBeginDate = this.resolve(this.getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    break;
                }
                case 4: {
                    String realBeginDate = this.resolve(this.getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    String realEndDate = this.resolve(this.getReceivedDate2());
                    if (Utils.isEmpty((CharSequence)realEndDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    endDate = df.parse(realEndDate);
                    break;
                }
            }
            String realserver = this.getRealServername();
            String realusername = this.getRealUsername();
            String realpassword = this.getRealPassword(this.getPassword());
            String realFilenamePattern = this.getRealFilenamePattern();
            int realport = Const.toInt((String)this.resolve(this.sslport), (int)-1);
            String realIMAPFolder = this.resolve(this.getIMAPFolder());
            String realProxyUsername = this.getRealProxyUsername();
            this.initVariables();
            mailConn = new MailConnection(this.log, MailConnectionMeta.getProtocolFromString(this.getProtocol(), 1), realserver, realport, realusername, realpassword, this.isUseSSL(), this.isUseXOAUTH2(), this.isUseProxy(), realProxyUsername);
            mailConn.connect();
            if (moveafter) {
                mailConn.setDestinationFolder(realMoveToIMAPFolder, this.isCreateMoveToFolder());
            }
            if (!Utils.isEmpty((CharSequence)(realSearchSender = this.resolve(this.getSenderSearchTerm())))) {
                mailConn.setSenderTerm(realSearchSender, this.isNotTermSenderSearch());
            }
            if (!Utils.isEmpty((CharSequence)(realSearchReceipient = this.resolve(this.getReceipientSearch())))) {
                mailConn.setReceipientTerm(realSearchReceipient);
            }
            if (!Utils.isEmpty((CharSequence)(realSearchSubject = this.resolve(this.getSubjectSearch())))) {
                mailConn.setSubjectTerm(realSearchSubject, this.isNotTermSubjectSearch());
            }
            if (!Utils.isEmpty((CharSequence)(realSearchBody = this.resolve(this.getBodySearch())))) {
                mailConn.setBodyTerm(realSearchBody, this.isNotTermBodySearch());
            }
            switch (this.getConditionOnReceivedDate()) {
                case 1: {
                    mailConn.setReceivedDateTermEQ(beginDate);
                    break;
                }
                case 3: {
                    mailConn.setReceivedDateTermGT(beginDate);
                    break;
                }
                case 2: {
                    mailConn.setReceivedDateTermLT(beginDate);
                    break;
                }
                case 4: {
                    mailConn.setReceivedDateTermBetween(beginDate, endDate);
                    break;
                }
            }
            if (usePOP3) {
                if (this.getRetrievemails() == 1) {
                    mailConn.setFlagTermUnread();
                }
            } else {
                switch (this.getValueImapList()) {
                    case 1: {
                        mailConn.setFlagTermNew();
                        break;
                    }
                    case 2: {
                        mailConn.setFlagTermOld();
                        break;
                    }
                    case 3: {
                        mailConn.setFlagTermRead();
                        break;
                    }
                    case 4: {
                        mailConn.setFlagTermUnread();
                        break;
                    }
                    case 5: {
                        mailConn.setFlagTermFlagged();
                        break;
                    }
                    case 6: {
                        mailConn.setFlagTermNotFlagged();
                        break;
                    }
                    case 7: {
                        mailConn.setFlagTermDraft();
                        break;
                    }
                    case 8: {
                        mailConn.setFlagTermNotDraft();
                        break;
                    }
                }
            }
            this.fetchOneFolder(mailConn, usePOP3, realIMAPFolder, realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
            if (this.isIncludeSubFolders()) {
                String[] subfolders;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetPOP.FetchingSubFolders", (String[])new String[0]));
                }
                if ((subfolders = mailConn.returnAllFolders()).length == 0) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetPOP.NoSubFolders", (String[])new String[0]));
                    }
                } else {
                    for (int i = 0; i < subfolders.length; ++i) {
                        this.fetchOneFolder(mailConn, usePOP3, subfolders[i], realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
                    }
                }
            }
            result.setResult(true);
            result.setNrFilesRetrieved((long)mailConn.getSavedAttachedFilesCounter());
            result.setNrLinesWritten((long)mailConn.getSavedMessagesCounter());
            result.setNrLinesDeleted((long)mailConn.getDeletedMessagesCounter());
            result.setNrLinesUpdated((long)mailConn.getMovedMessagesCounter());
            if (this.isDetailed()) {
                this.logDetailed("=======================================");
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.SavedMessages", (String[])new String[]{"" + mailConn.getSavedMessagesCounter()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.DeletedMessages", (String[])new String[]{"" + mailConn.getDeletedMessagesCounter()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.MovedMessages", (String[])new String[]{"" + mailConn.getMovedMessagesCounter()}));
                if (this.getActionType() == 0 && this.isSaveAttachment()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetPOP.Log.Info.AttachedMessagesSuccess", (String[])new String[]{"" + mailConn.getSavedAttachedFilesCounter()}));
                }
                this.logDetailed("=======================================");
            }
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Unexpected error: " + e.getMessage());
            this.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            try {
                if (mailConn != null) {
                    mailConn.disconnect();
                    mailConn = null;
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    void fetchOneFolder(MailConnection mailConn, boolean usePOP3, String realIMAPFolder, String realOutputFolder, String targetAttachmentFolder, String realMoveToIMAPFolder, String realFilenamePattern, int nbrmailtoretrieve, SimpleDateFormat df) throws HopException {
        block29: {
            try {
                if (!usePOP3 && !Utils.isEmpty((CharSequence)realIMAPFolder)) {
                    mailConn.openFolder(realIMAPFolder, true);
                } else {
                    mailConn.openFolder(true);
                }
                mailConn.retrieveMessages();
                int messagesCount = mailConn.getMessagesCount();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.TotalMessagesFolder.Label", (String[])new String[]{"" + messagesCount, Const.NVL((String)mailConn.getFolderName(), (String)"INBOX")}));
                }
                int n = nbrmailtoretrieve > 0 ? (nbrmailtoretrieve > messagesCount ? messagesCount : nbrmailtoretrieve) : (messagesCount = messagesCount);
                if (messagesCount <= 0) break block29;
                switch (this.getActionType()) {
                    case 2: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                mailConn.fetchNext();
                                mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + i}));
                            }
                        } else {
                            mailConn.deleteMessages(true);
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesDeleted", (String[])new String[]{"" + messagesCount}));
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                                mailConn.fetchNext();
                                mailConn.moveMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + i, realMoveToIMAPFolder}));
                            }
                        } else {
                            mailConn.moveMessages();
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessagesMoved", (String[])new String[]{"" + messagesCount, realMoveToIMAPFolder}));
                            }
                        }
                        break;
                    }
                    default: {
                        block12: for (int i = 0; i < messagesCount && !this.parentWorkflow.isStopped(); ++i) {
                            boolean okIMAP;
                            mailConn.fetchNext();
                            int messagenumber = mailConn.getMessage().getMessageNumber();
                            boolean okPOP3 = usePOP3;
                            boolean bl = okIMAP = !usePOP3;
                            if (!okPOP3 && !okIMAP) continue;
                            if (this.isDebug() && mailConn.getMessage() != null) {
                                this.logDebug("--------------------------------------------------");
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageNumber.Label", (String[])new String[]{"" + messagenumber}));
                                if (mailConn.getMessage().getReceivedDate() != null) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ReceivedDate.Label", (String[])new String[]{df.format(mailConn.getMessage().getReceivedDate())}));
                                }
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.ContentType.Label", (String[])new String[]{mailConn.getMessage().getContentType()}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailFrom.Label", (String[])new String[]{Const.NVL((String)mailConn.getMessage().getFrom()[0].toString(), (String)"")}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.EmailSubject.Label", (String[])new String[]{Const.NVL((String)mailConn.getMessage().getSubject(), (String)"")}));
                            }
                            if (this.isSaveMessage()) {
                                String localfilenameMessage = this.replaceTokens(realFilenamePattern, i);
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.LocalFilename.Label", (String[])new String[]{localfilenameMessage}));
                                }
                                mailConn.saveMessageContentToFile(localfilenameMessage, realOutputFolder);
                                mailConn.getMessage().setFlag(Flags.Flag.SEEN, true);
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageSaved.Label", (String[])new String[]{"" + messagenumber, localfilenameMessage, realOutputFolder}));
                                }
                            }
                            if (this.isSaveAttachment()) {
                                mailConn.saveAttachedFiles(targetAttachmentFolder, this.attachementPattern);
                            }
                            if (usePOP3) {
                                if (!this.getDelete()) continue;
                                mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                continue;
                            }
                            switch (this.getAfterGetIMAP()) {
                                case 1: {
                                    mailConn.deleteMessage();
                                    if (!this.isDebug()) continue block12;
                                    this.logDebug(BaseMessages.getString(PKG, (String)CONST_MESSAGE_DELETED, (String[])new String[]{"" + messagenumber}));
                                    continue block12;
                                }
                                case 2: {
                                    mailConn.moveMessage();
                                    if (!this.isDebug()) continue block12;
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + messagenumber, realMoveToIMAPFolder}));
                                    continue block12;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    private String replaceTokens(String aString, int idfile) {
        String localfilenameMessage = aString;
        localfilenameMessage = localfilenameMessage.replaceAll(FILENAME_ID_PATTERN, "" + (idfile + 1));
        localfilenameMessage = this.substituteDate(localfilenameMessage, FILENAME_SYS_DATE_OPEN, FILENAME_SYS_DATE_CLOSE, new Date());
        return localfilenameMessage;
    }

    private String substituteDate(String aString, String open, String close, Date datetime) {
        if (aString == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String rest = aString;
        int i = rest.indexOf(open);
        while (i > -1) {
            int j = rest.indexOf(close, i + open.length());
            if (j > -1) {
                String varName = rest.substring(i + open.length(), j);
                SimpleDateFormat dateFormat = new SimpleDateFormat(varName);
                String value = dateFormat.format(datetime);
                buffer.append(rest.substring(0, i));
                buffer.append((Object)value);
                rest = rest.substring(j + close.length());
            } else {
                buffer.append(rest);
                rest = "";
            }
            i = rest.indexOf(close);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    private void initVariables() {
        this.attachementPattern = null;
        String realAttachmentWildcard = this.resolve(this.getAttachmentWildcard());
        if (!Utils.isEmpty((CharSequence)realAttachmentWildcard)) {
            this.attachementPattern = Pattern.compile(realAttachmentWildcard);
        }
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "outputDirectory", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "SSLPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.servername)) {
            String realServername = this.resolve(this.servername);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    String createOutputDirectory(int folderType) throws HopException, FileSystemException, IllegalArgumentException {
        FileObject folder;
        if (folderType != 0 && folderType != 1) {
            throw new IllegalArgumentException("Invalid folderType argument");
        }
        String folderName = "";
        switch (folderType) {
            case 0: {
                folderName = this.getRealOutputDirectory();
                break;
            }
            case 1: {
                folderName = this.isSaveAttachment() && this.isDifferentFolderForAttachment() ? this.getRealAttachmentFolder() : this.getRealOutputDirectory();
            }
        }
        if (Utils.isEmpty((CharSequence)folderName)) {
            switch (folderType) {
                case 0: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OutputFolderEmpty", (String[])new String[0]));
                }
                case 1: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderEmpty", (String[])new String[0]));
                }
            }
        }
        if ((folder = HopVfs.getFileObject((String)folderName)).exists()) {
            if (folder.getType() != FileType.FOLDER) {
                switch (folderType) {
                    case 0: {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.NotAFolderNot", (String[])new String[]{folderName}));
                    }
                    case 1: {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderNotAFolder", (String[])new String[]{folderName}));
                    }
                }
            }
            if (this.isDebug()) {
                switch (folderType) {
                    case 0: {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Log.OutputFolderExists", (String[])new String[]{folderName}));
                        break;
                    }
                    case 1: {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Log.AttachmentFolderExists", (String[])new String[]{folderName}));
                    }
                }
            }
        } else if (this.isCreateLocalFolder()) {
            folder.createFolder();
        } else {
            switch (folderType) {
                case 0: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.OutputFolderNotExist", (String[])new String[]{folderName}));
                }
                case 1: {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionGetMailsFromPOP.Error.AttachmentFolderNotExist", (String[])new String[]{folderName}));
                }
            }
        }
        String returnValue = HopVfs.getFilename((FileObject)folder);
        try {
            folder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return returnValue;
    }
}

