/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableByteIntMapFactory;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import org.eclipse.collections.impl.factory.primitive.ByteIntMaps;
import org.eclipse.collections.impl.map.mutable.primitive.ByteIntHashMap;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableByteIntMapFactoryImpl
implements MutableByteIntMapFactory {
    public static final MutableByteIntMapFactory INSTANCE = new MutableByteIntMapFactoryImpl();

    public MutableByteIntMap empty() {
        return new ByteIntHashMap(0);
    }

    public MutableByteIntMap of() {
        return this.empty();
    }

    public MutableByteIntMap with() {
        return this.empty();
    }

    public MutableByteIntMap with(byte key, int value) {
        return ByteIntHashMap.newWithKeysValues(key, value);
    }

    public MutableByteIntMap of(byte key, int value) {
        return this.with(key, value);
    }

    public MutableByteIntMap of(byte key1, int value1, byte key2, int value2) {
        return this.with(key1, value1, key2, value2);
    }

    public MutableByteIntMap with(byte key1, int value1, byte key2, int value2) {
        return ByteIntHashMap.newWithKeysValues(key1, value1, key2, value2);
    }

    public MutableByteIntMap of(byte key1, int value1, byte key2, int value2, byte key3, int value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    public MutableByteIntMap with(byte key1, int value1, byte key2, int value2, byte key3, int value3) {
        return ByteIntHashMap.newWithKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public MutableByteIntMap of(byte key1, int value1, byte key2, int value2, byte key3, int value3, byte key4, int value4) {
        return this.with(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public MutableByteIntMap with(byte key1, int value1, byte key2, int value2, byte key3, int value3, byte key4, int value4) {
        return ByteIntHashMap.newWithKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public MutableByteIntMap ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public MutableByteIntMap withInitialCapacity(int capacity) {
        return new ByteIntHashMap(capacity);
    }

    public MutableByteIntMap ofAll(ByteIntMap map) {
        return this.withAll(map);
    }

    public MutableByteIntMap withAll(ByteIntMap map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new ByteIntHashMap(map);
    }

    public <T> MutableByteIntMap from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, IntFunction<? super T> valueFunction) {
        MutableByteIntMap map = ByteIntMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.byteValueOf(each), valueFunction.intValueOf(each)));
        return map;
    }
}

