/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.resourcehints;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHint;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHintsOptions;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHints {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ResourceHints.class);
    private static final @UnknownKeyFor @NonNull @Initialized String MIN_RAM_URN = "beam:resources:min_ram_bytes:v1";
    private static final @UnknownKeyFor @NonNull @Initialized String ACCELERATOR_URN = "beam:resources:accelerator:v1";
    private static final @UnknownKeyFor @NonNull @Initialized String CPU_COUNT_URN = "beam:resources:cpu_count:v1";
    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> hintNameToUrn;
    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ResourceHint>> parsers;
    private static final @UnknownKeyFor @NonNull @Initialized ResourceHints EMPTY;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ResourceHint> hints;

    private static @UnknownKeyFor @NonNull @Initialized String getUrn(@UnknownKeyFor @NonNull @Initialized ProtocolMessageEnum value) {
        return (String)value.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    }

    private ResourceHints(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ResourceHint> hints) {
        this.hints = hints;
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceHints create() {
        return EMPTY;
    }

    public static @UnknownKeyFor @NonNull @Initialized ResourceHints fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        ResourceHintsOptions resourceHintsOptions = options.as(ResourceHintsOptions.class);
        ResourceHints result = ResourceHints.create();
        List<String> hints = resourceHintsOptions.getResourceHints();
        Splitter splitter = Splitter.on('=').limit(2);
        for (String hint : hints) {
            String urn;
            List<String> parts = splitter.splitToList(hint);
            if (parts.size() != 2) {
                throw new IllegalArgumentException("Unparsable resource hint: " + hint);
            }
            String nameOrUrn = parts.get(0);
            String stringValue = parts.get(1);
            if (hintNameToUrn.containsKey(nameOrUrn)) {
                urn = hintNameToUrn.get(nameOrUrn);
            } else {
                if (!nameOrUrn.startsWith("beam:resources:")) {
                    throw new IllegalArgumentException("Unknown resource hint: " + hint);
                }
                urn = nameOrUrn;
            }
            ResourceHint value = Preconditions.checkNotNull(parsers.getOrDefault(urn, StringHint::new)).apply(stringValue);
            result = result.withHint(urn, value);
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints withMinRam(@UnknownKeyFor @NonNull @Initialized long ramBytes) {
        if (ramBytes <= 0L) {
            LOG.error("Encountered invalid non-positive minimum ram hint value {}.\nLikely cause is an (overflowing) int expression is passed in. The value is ignored. In the future, The method will require an object Long type and throw an IllegalArgumentException for invalid values.", (Object)ramBytes);
            return this;
        }
        if (ramBytes <= Integer.MAX_VALUE) {
            LOG.warn("Minimum available RAM size ({}) is set too small.\nLikely cause is an (overflowing) int expression is passed in.", (Object)ramBytes);
        }
        return this.withHint(MIN_RAM_URN, new BytesHint(ramBytes));
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints withMinRam(@UnknownKeyFor @NonNull @Initialized String ramBytes) {
        return this.withMinRam(BytesHint.parse(ramBytes));
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints withAccelerator(@UnknownKeyFor @NonNull @Initialized String accelerator) {
        return this.withHint(ACCELERATOR_URN, new StringHint(accelerator));
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints withHint(@UnknownKeyFor @NonNull @Initialized String urn, @UnknownKeyFor @NonNull @Initialized ResourceHint hint) {
        ImmutableMap.Builder<String, ResourceHint> newHints = ImmutableMap.builder();
        newHints.put(urn, hint);
        for (Map.Entry oldHint : this.hints.entrySet()) {
            if (((String)oldHint.getKey()).equals(urn)) continue;
            newHints.put((String)oldHint.getKey(), (ResourceHint)oldHint.getValue());
        }
        return new ResourceHints(newHints.build());
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints withCPUCount(@UnknownKeyFor @NonNull @Initialized int cpuCount) {
        if (cpuCount <= 0) {
            LOG.error("Encountered invalid non-positive cpu count hint value {}.\nThe value is ignored. In the future, The method will require an object Long type and throw an IllegalArgumentException for invalid values.", (Object)cpuCount);
            return this;
        }
        return this.withHint(CPU_COUNT_URN, new IntHint(cpuCount));
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ResourceHint> hints() {
        return this.hints;
    }

    public @UnknownKeyFor @NonNull @Initialized ResourceHints mergeWithOuter(@UnknownKeyFor @NonNull @Initialized ResourceHints outer) {
        if (outer.hints.isEmpty()) {
            return this;
        }
        if (this.hints.isEmpty()) {
            return outer;
        }
        ImmutableMap.Builder<String, ResourceHint> newHints = ImmutableMap.builder();
        for (Map.Entry<String, ResourceHint> outerHint : outer.hints().entrySet()) {
            if (this.hints.containsKey(outerHint.getKey())) {
                newHints.put(outerHint.getKey(), this.hints.get(outerHint.getKey()).mergeWithOuter(outerHint.getValue()));
                continue;
            }
            newHints.put(outerHint);
        }
        for (Map.Entry hint : this.hints.entrySet()) {
            if (outer.hints.containsKey(hint.getKey())) continue;
            newHints.put(hint);
        }
        return new ResourceHints(newHints.build());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ResourceHints) {
            return ((ResourceHints)other).hints.equals(this.hints);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hints.hashCode();
    }

    static {
        Preconditions.checkState(MIN_RAM_URN.equals(ResourceHints.getUrn((ProtocolMessageEnum)RunnerApi.StandardResourceHints.Enum.MIN_RAM_BYTES)));
        Preconditions.checkState(ACCELERATOR_URN.equals(ResourceHints.getUrn((ProtocolMessageEnum)RunnerApi.StandardResourceHints.Enum.ACCELERATOR)));
        Preconditions.checkState(CPU_COUNT_URN.equals(ResourceHints.getUrn((ProtocolMessageEnum)RunnerApi.StandardResourceHints.Enum.CPU_COUNT)));
        hintNameToUrn = ImmutableMap.builder().put("minRam", MIN_RAM_URN).put("min_ram", MIN_RAM_URN).put("accelerator", ACCELERATOR_URN).put("cpuCount", CPU_COUNT_URN).put("cpu_count", CPU_COUNT_URN).build();
        parsers = ImmutableMap.builder().put(MIN_RAM_URN, s -> new BytesHint(BytesHint.parse(s))).put(ACCELERATOR_URN, s -> new StringHint((String)s)).put(CPU_COUNT_URN, s -> new IntHint(IntHint.parse(s))).build();
        EMPTY = new ResourceHints(ImmutableMap.of());
    }

    static class IntHint
    extends ResourceHint {
        private final @UnknownKeyFor @NonNull @Initialized int value;

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof IntHint) {
                return ((IntHint)other).value == this.value;
            }
            return false;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Integer.hashCode(this.value);
        }

        public IntHint(@UnknownKeyFor @NonNull @Initialized int value) {
            this.value = value;
        }

        public static @UnknownKeyFor @NonNull @Initialized int parse(@UnknownKeyFor @NonNull @Initialized String s) {
            return Integer.parseInt(s, 10);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ResourceHint mergeWithOuter(@UnknownKeyFor @NonNull @Initialized ResourceHint outer) {
            return new IntHint(Math.max(this.value, ((IntHint)outer).value));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes() {
            return String.valueOf(this.value).getBytes(StandardCharsets.US_ASCII);
        }
    }

    static class StringHint
    extends ResourceHint {
        private final @UnknownKeyFor @NonNull @Initialized String value;

        public StringHint(@UnknownKeyFor @NonNull @Initialized String value) {
            this.value = value;
        }

        public static @UnknownKeyFor @NonNull @Initialized String parse(@UnknownKeyFor @NonNull @Initialized String s) {
            return s;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes() {
            return this.value.getBytes(StandardCharsets.US_ASCII);
        }

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof StringHint) {
                return ((StringHint)other).value.equals(this.value);
            }
            return false;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.value.hashCode();
        }
    }

    static class BytesHint
    extends ResourceHint {
        private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> suffixes = ImmutableMap.builder().put("B", 1L).put("KB", 1000L).put("MB", 1000000L).put("GB", 1000000000L).put("TB", 1000000000000L).put("PB", 1000000000000000L).put("KiB", 1024L).put("MiB", 0x100000L).put("GiB", 0x40000000L).put("TiB", 0x10000000000L).put("PiB", 0x4000000000000L).build();
        private final @UnknownKeyFor @NonNull @Initialized long value;

        @Override
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof BytesHint) {
                return ((BytesHint)other).value == this.value;
            }
            return false;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Long.hashCode(this.value);
        }

        public BytesHint(@UnknownKeyFor @NonNull @Initialized long value) {
            this.value = value;
        }

        public static @UnknownKeyFor @NonNull @Initialized long parse(@UnknownKeyFor @NonNull @Initialized String s) {
            Matcher m = Pattern.compile("([\\d.]+)[\\s]?([\\D]+$)").matcher(s);
            if (m.find()) {
                String number = m.group(1);
                String suffix = m.group(2);
                if (number != null && suffix != null && suffixes.containsKey(suffix)) {
                    return (long)(Double.valueOf(number) * (double)suffixes.get(suffix).longValue());
                }
            }
            throw new IllegalArgumentException("Unable to parse '" + s + "' as a byte value.");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ResourceHint mergeWithOuter(@UnknownKeyFor @NonNull @Initialized ResourceHint outer) {
            return new BytesHint(Math.max(this.value, ((BytesHint)outer).value));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes() {
            return String.valueOf(this.value).getBytes(StandardCharsets.US_ASCII);
        }
    }
}

