/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public abstract class TypedSchemaTransformProvider<@UnknownKeyFor ConfigT>
implements SchemaTransformProvider {
    protected @UnknownKeyFor @NonNull @Initialized Class<ConfigT> configurationClass() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Preconditions.checkStateNotNull(parameterizedType, "Could not get the TypedSchemaTransformProvider's parameterized type.");
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument(parameterizedType.getActualTypeArguments().length == 1, String.format("Expected one parameterized type, but got %s.", parameterizedType.getActualTypeArguments().length));
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized SchemaTransform from(ConfigT var1);

    @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> dependencies(ConfigT configuration, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return Optional.empty();
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Schema configurationSchema() {
        try {
            return SchemaRegistry.createDefault().getSchema(this.configurationClass()).sorted().toSnakeCase();
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + " SchemaTransformProvider's configuration.");
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        return this.from(this.configFromRow(configuration));
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> dependencies(@UnknownKeyFor @NonNull @Initialized Row configuration, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return this.dependencies(this.configFromRow(configuration), options);
    }

    private ConfigT configFromRow(@UnknownKeyFor @NonNull @Initialized Row configuration) {
        try {
            SchemaRegistry registry = SchemaRegistry.createDefault();
            SerializableFunction<Row, ConfigT> rowToConfigT = registry.getFromRowFunction(this.configurationClass());
            SchemaProvider schemaProvider = registry.getSchemaProvider(this.configurationClass());
            if (schemaProvider.getClass().equals(DefaultSchema.DefaultSchemaProvider.class) && org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(((DefaultSchema.DefaultSchemaProvider)schemaProvider).getUnderlyingSchemaProvider(this.configurationClass())).getClass().equals(AutoValueSchema.class)) {
                configuration = configuration.toCamelCase();
            }
            return rowToConfigT.apply(configuration);
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + "SchemaTransformProvider's config");
        }
    }
}

