/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public final class GenericDlq {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized GenericDlqProvider> PROVIDERS = Providers.loadProviders(GenericDlqProvider.class);

    private GenericDlq() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Failure>, @UnknownKeyFor @NonNull @Initialized PDone> getDlqTransform(@UnknownKeyFor @NonNull @Initialized String fullConfig) {
        List<String> strings = Splitter.on(":").limit(2).splitToList(fullConfig);
        Preconditions.checkArgument(strings.size() == 2, "Invalid config, must start with `identifier:`. %s", (Object)fullConfig);
        String key = strings.get(0);
        String config = strings.get(1).trim();
        GenericDlqProvider provider = PROVIDERS.get(key);
        Preconditions.checkArgument(provider != null, "Invalid config, no DLQ provider exists with identifier `%s`.", (Object)key);
        return provider.newDlqTransform(config);
    }
}

