/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ProxyInvocationHandler;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.TreeMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineOptionsValidator {
    public static <T extends PipelineOptions> T validate(@UnknownKeyFor @NonNull @Initialized Class<T> klass, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return PipelineOptionsValidator.validate(klass, options, false);
    }

    public static <T extends PipelineOptions> T validateCli(@UnknownKeyFor @NonNull @Initialized Class<T> klass, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return PipelineOptionsValidator.validate(klass, options, true);
    }

    private static <T extends PipelineOptions> T validate(@UnknownKeyFor @NonNull @Initialized Class<T> klass, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized boolean isCli) {
        Preconditions.checkNotNull(klass);
        Preconditions.checkNotNull(options);
        Preconditions.checkArgument(Proxy.isProxyClass(options.getClass()));
        Preconditions.checkArgument(Proxy.getInvocationHandler(options) instanceof ProxyInvocationHandler);
        T asClassOptions = options.as(klass);
        ProxyInvocationHandler handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(asClassOptions);
        TreeMultimap requiredGroups = TreeMultimap.create(Ordering.natural(), PipelineOptionsFactory.MethodNameComparator.INSTANCE);
        for (Method method : ReflectHelpers.getClosureOfMethodsOnInterface(klass)) {
            Validation.Required requiredAnnotation = method.getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            if (requiredAnnotation.groups().length > 0) {
                for (String requiredGroup : requiredAnnotation.groups()) {
                    requiredGroups.put(requiredGroup, method);
                }
                continue;
            }
            if (isCli) {
                Preconditions.checkArgument(handler.invoke(asClassOptions, method, null) != null, "Missing required value for [--%s, \"%s\"]. ", (Object)handler.getOptionName(method), (Object)PipelineOptionsValidator.getDescription(method));
                continue;
            }
            Preconditions.checkArgument(handler.invoke(asClassOptions, method, null) != null, "Missing required value for [%s, \"%s\"]. ", (Object)method, (Object)PipelineOptionsValidator.getDescription(method));
        }
        for (String requiredGroup : requiredGroups.keySet()) {
            if (PipelineOptionsValidator.verifyGroup(handler, asClassOptions, requiredGroups.get(requiredGroup))) continue;
            throw new IllegalArgumentException("Missing required value for group [" + requiredGroup + "]. At least one of the following properties " + Collections2.transform(requiredGroups.get(requiredGroup), ReflectHelpers::formatMethod) + " required. Run with --help=" + klass.getSimpleName() + " for more information.");
        }
        return asClassOptions;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean verifyGroup(@UnknownKeyFor @NonNull @Initialized ProxyInvocationHandler handler, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Method> requiredGroup) {
        for (Method m : requiredGroup) {
            if (handler.invoke(options, m, null) == null) continue;
            return true;
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getDescription(@UnknownKeyFor @NonNull @Initialized Method method) {
        Description description = method.getAnnotation(Description.class);
        return description == null ? "" : description.value();
    }
}

