/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.metrics.AutoValue_LabeledMetricNameUtils_ParsedMetricName;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class LabeledMetricNameUtils {
    private static final @UnknownKeyFor @NonNull @Initialized char LABEL_DELIMITER = ';';
    private static final @UnknownKeyFor @NonNull @Initialized char METRIC_KV_DELIMITER = ':';
    private static final @UnknownKeyFor @NonNull @Initialized char METRIC_NAME_DELIMITER = '*';

    public static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ParsedMetricName> parseMetricName(@UnknownKeyFor @NonNull @Initialized String metricName) {
        if (metricName.isEmpty()) {
            return Optional.empty();
        }
        List<String> metricNameSplit = Splitter.on('*').limit(2).splitToList(metricName);
        if (metricNameSplit.size() == 0 || metricNameSplit.get(0).isEmpty()) {
            return Optional.empty();
        }
        if (metricNameSplit.size() == 1) {
            return Optional.of(ParsedMetricName.create(metricNameSplit.get(0)));
        }
        Splitter.MapSplitter splitter = Splitter.on(';').omitEmptyStrings().withKeyValueSeparator(':');
        try {
            Map<String, String> labels = splitter.split(metricNameSplit.get(1));
            return Optional.of(ParsedMetricName.create(metricNameSplit.get(0), labels));
        }
        catch (IllegalArgumentException e) {
            return Optional.of(ParsedMetricName.create(metricNameSplit.get(0)));
        }
    }

    @AutoValue
    public static abstract class ParsedMetricName {
        public abstract @UnknownKeyFor @NonNull @Initialized String getBaseName();

        public abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getMetricLabels();

        public static @UnknownKeyFor @NonNull @Initialized ParsedMetricName create(@UnknownKeyFor @NonNull @Initialized String baseName, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> metricLabels) {
            return new AutoValue_LabeledMetricNameUtils_ParsedMetricName(baseName, metricLabels);
        }

        public static @UnknownKeyFor @NonNull @Initialized ParsedMetricName create(@UnknownKeyFor @NonNull @Initialized String baseName) {
            ImmutableMap<String, String> emptyMap = ImmutableMap.of();
            return new AutoValue_LabeledMetricNameUtils_ParsedMetricName(baseName, emptyMap);
        }
    }

    public static class MetricNameBuilder {
        private final @UnknownKeyFor @NonNull @Initialized StringBuilder labeledNameBuilder;

        private MetricNameBuilder(@UnknownKeyFor @NonNull @Initialized String baseName) {
            this.labeledNameBuilder = new StringBuilder(baseName + '*');
        }

        public static @UnknownKeyFor @NonNull @Initialized MetricNameBuilder baseNameBuilder(@UnknownKeyFor @NonNull @Initialized String baseName) {
            return new MetricNameBuilder(baseName);
        }

        public void addLabel(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String value) {
            this.labeledNameBuilder.append(key).append(':').append(value).append(';');
        }

        public @UnknownKeyFor @NonNull @Initialized MetricName build(@UnknownKeyFor @NonNull @Initialized String metricNamespace) {
            return MetricName.named(metricNamespace, this.labeledNameBuilder.toString());
        }
    }
}

