/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.actions.constraint.ConstraintType;
import org.apache.hop.neo4j.actions.constraint.ConstraintUpdate;
import org.apache.hop.neo4j.actions.constraint.Neo4jConstraint;
import org.apache.hop.neo4j.actions.constraint.ObjectType;
import org.apache.hop.neo4j.actions.index.IndexUpdate;
import org.apache.hop.neo4j.actions.index.Neo4jIndex;
import org.apache.hop.neo4j.actions.index.UpdateType;
import org.apache.hop.neo4j.core.Neo4jUtil;
import org.apache.hop.neo4j.model.AreaOwner;
import org.apache.hop.neo4j.model.AreaType;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphPresentation;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.apache.hop.neo4j.model.arrows.ArrowsAppImporter;
import org.apache.hop.neo4j.model.sw.SolutionsWorkbenchImporter;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterListDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GraphModelEditor
extends MetadataEditor<GraphModel> {
    private static final Class<?> PKG = GraphModelEditor.class;
    public static final String CONST_ERROR = "ERROR";
    public static final String CONST_DESCRIPTION = "Description";
    public static final String CONST_ERROR_IMPORTING_JSON = "Error importing JSON";
    private CTabFolder wTabs;
    private PropsUi props;
    private Text wModelDescription;
    private Text wModelName;
    private org.eclipse.swt.widgets.List wNodesList;
    private Text wNodeName;
    private Text wNodeDescription;
    private TableView wNodeLabels;
    private boolean monitorLabels = true;
    private TableView wNodeProperties;
    private boolean monitorNodeProperties = true;
    private org.eclipse.swt.widgets.List wRelationshipsList;
    private Text wRelName;
    private Text wRelDescription;
    private Text wRelLabel;
    private CCombo wRelSource;
    private CCombo wRelTarget;
    private TableView wRelProperties;
    private boolean monitorRelProperties = true;
    private GraphModel graphModel;
    private GraphNode activeNode;
    private GraphRelationship activeRelationship;
    private Point mouseDownPoint;
    private Canvas wCanvas;
    private Label wlNodeName;
    private Label wlNodeDescription;
    private Label wlNodeProperties;
    private Label wlRelName;
    private Label wlRelDescription;
    private Label wlRelLabel;
    private Label wlRelSource;
    private Label wlRelTarget;
    private Label wlRelProperties;
    private int middle;
    private int margin;
    private Map<String, Integer> nodeCache;
    private Random random = new Random();
    private List<AreaOwner> areaOwners;

    public GraphModelEditor(HopGui hopGui, MetadataManager<GraphModel> manager, GraphModel metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
        this.props = PropsUi.getInstance();
        this.graphModel = new GraphModel(metadata);
        this.mouseDownPoint = new Point(-1, -1);
    }

    public void createControl(Composite composite) {
        this.wTabs = new CTabFolder(composite, 2048);
        FormData fdTabs = new FormData();
        fdTabs.left = new FormAttachment(0, 0);
        fdTabs.right = new FormAttachment(100, 0);
        fdTabs.top = new FormAttachment(0, 0);
        fdTabs.bottom = new FormAttachment(100, 0);
        this.wTabs.setLayoutData((Object)fdTabs);
        this.addModelTab();
        this.addNodesTab();
        this.addRelationshipsTab();
        this.addGraphTab();
        this.setWidgetsContent();
        this.clearChanged();
        this.wTabs.setSelection(0);
    }

    public void setWidgetsContent() {
        this.wModelName.setText(Const.NVL((String)this.graphModel.getName(), (String)""));
        this.wModelDescription.setText(Const.NVL((String)this.graphModel.getDescription(), (String)""));
        this.refreshNodesList();
        if (!this.graphModel.getNodes().isEmpty()) {
            String activeName = this.graphModel.getNodeNames()[0];
            this.setActiveNode(activeName);
            this.wNodesList.setSelection(new String[]{activeName});
            this.refreshNodeFields();
        }
        this.refreshRelationshipsList();
        if (!this.graphModel.getRelationships().isEmpty()) {
            String activeRelationshipName = this.graphModel.getRelationshipNames()[0];
            this.setActiveRelationship(activeRelationshipName);
            this.wRelationshipsList.setSelection(new String[]{activeRelationshipName});
            this.refreshRelationshipsFields();
        }
        this.enableFields();
    }

    public void getWidgetsContent(GraphModel gm) {
        gm.replace(this.graphModel);
    }

    private void enableFields() {
        boolean nodeSelected = this.activeNode != null;
        this.wlNodeName.setEnabled(nodeSelected);
        this.wNodeName.setEnabled(nodeSelected);
        this.wlNodeDescription.setEnabled(nodeSelected);
        this.wNodeDescription.setEnabled(nodeSelected);
        this.wNodeLabels.setEnabled(nodeSelected);
        this.wlNodeProperties.setEnabled(nodeSelected);
        this.wNodeProperties.setEnabled(nodeSelected);
        boolean relationshipSelected = this.activeRelationship != null;
        this.wlRelName.setEnabled(relationshipSelected);
        this.wRelName.setEnabled(relationshipSelected);
        this.wlRelDescription.setEnabled(relationshipSelected);
        this.wRelDescription.setEnabled(relationshipSelected);
        this.wlRelLabel.setEnabled(relationshipSelected);
        this.wRelLabel.setEnabled(relationshipSelected);
        this.wlRelSource.setEnabled(relationshipSelected);
        this.wRelSource.setEnabled(relationshipSelected);
        this.wlRelTarget.setEnabled(relationshipSelected);
        this.wRelTarget.setEnabled(relationshipSelected);
        this.wlRelProperties.setEnabled(relationshipSelected);
        this.wRelProperties.setEnabled(relationshipSelected);
    }

    private void setActiveNode(String nodeName) {
        this.activeNode = this.graphModel.findNode(nodeName);
        this.enableFields();
    }

    private void setActiveRelationship(String relationshipName) {
        this.activeRelationship = this.graphModel.findRelationship(relationshipName);
        this.enableFields();
    }

    private void refreshNodeFields() {
        int i;
        if (this.activeNode == null) {
            return;
        }
        this.wNodeName.setText(Const.NVL((String)this.activeNode.getName(), (String)""));
        this.wNodeDescription.setText(Const.NVL((String)this.activeNode.getDescription(), (String)""));
        this.monitorLabels = false;
        this.wNodeLabels.clearAll();
        for (i = 0; i < this.activeNode.getLabels().size(); ++i) {
            TableItem item = new TableItem(this.wNodeLabels.table, 0);
            item.setText(1, this.activeNode.getLabels().get(i));
        }
        this.wNodeLabels.removeEmptyRows(1);
        this.wNodeLabels.setRowNums();
        this.wNodeLabels.optWidth(true);
        this.monitorLabels = true;
        this.monitorNodeProperties = false;
        this.wNodeProperties.clearAll();
        for (i = 0; i < this.activeNode.getProperties().size(); ++i) {
            GraphProperty property = this.activeNode.getProperties().get(i);
            TableItem item = new TableItem(this.wNodeProperties.table, 0);
            int col = 1;
            item.setText(col++, Const.NVL((String)property.getName(), (String)""));
            item.setText(col++, GraphPropertyType.getCode(property.getType()));
            item.setText(col++, Const.NVL((String)property.getDescription(), (String)""));
            item.setText(col++, property.isPrimary() ? "Y" : "N");
            item.setText(col++, property.isMandatory() ? "Y" : "N");
            item.setText(col++, property.isUnique() ? "Y" : "N");
            item.setText(col++, property.isIndexed() ? "Y" : "N");
        }
        this.wNodeProperties.removeEmptyRows(1);
        this.wNodeProperties.setRowNums();
        this.wNodeProperties.optWidth(true);
        this.wNodeName.setFocus();
        this.monitorNodeProperties = true;
    }

    private void refreshRelationshipsFields() {
        if (this.activeRelationship == null) {
            return;
        }
        this.wRelName.setText(Const.NVL((String)this.activeRelationship.getName(), (String)""));
        this.wRelDescription.setText(Const.NVL((String)this.activeRelationship.getDescription(), (String)""));
        this.wRelLabel.setText(Const.NVL((String)this.activeRelationship.getLabel(), (String)""));
        this.wRelSource.setText(Const.NVL((String)this.activeRelationship.getNodeSource(), (String)""));
        this.wRelTarget.setText(Const.NVL((String)this.activeRelationship.getNodeTarget(), (String)""));
        this.monitorRelProperties = false;
        this.wRelProperties.clearAll();
        for (int i = 0; i < this.activeRelationship.getProperties().size(); ++i) {
            GraphProperty property = this.activeRelationship.getProperties().get(i);
            TableItem item = new TableItem(this.wRelProperties.table, 0);
            int col = 1;
            item.setText(col++, Const.NVL((String)property.getName(), (String)""));
            item.setText(col++, GraphPropertyType.getCode(property.getType()));
            item.setText(col++, Const.NVL((String)property.getDescription(), (String)""));
            item.setText(col++, property.isPrimary() ? "Y" : "N");
            item.setText(col++, property.isMandatory() ? "Y" : "N");
            item.setText(col++, property.isUnique() ? "Y" : "N");
            item.setText(col++, property.isIndexed() ? "Y" : "N");
        }
        this.wRelProperties.removeEmptyRows(1);
        this.wRelProperties.setRowNums();
        this.wRelProperties.optWidth(true);
        this.wRelName.setFocus();
        this.monitorRelProperties = true;
    }

    private void refreshNodesList() {
        String[] nodeNames = this.graphModel.getNodeNames();
        this.wNodesList.setItems(nodeNames);
        if (this.activeNode != null) {
            this.wNodesList.setSelection(new String[]{this.activeNode.getName()});
        }
        this.wRelSource.setItems(nodeNames);
        this.wRelTarget.setItems(nodeNames);
    }

    private void refreshRelationshipsList() {
        this.wRelationshipsList.setItems(this.graphModel.getRelationshipNames());
    }

    private void addModelTab() {
        CTabItem wModelTab = new CTabItem(this.wTabs, 0);
        wModelTab.setFont(GuiResource.getInstance().getFontDefault());
        wModelTab.setText("Model");
        ScrolledComposite wModelSComp = new ScrolledComposite((Composite)this.wTabs, 768);
        wModelSComp.setLayout((Layout)new FillLayout());
        Composite wModelComp = new Composite((Composite)wModelSComp, 0);
        PropsUi.setLook((Widget)wModelComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wModelComp.setLayout((Layout)formLayout);
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        Label wlName = new Label(wModelComp, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlModelName = new FormData();
        fdlModelName.left = new FormAttachment(0, 0);
        fdlModelName.right = new FormAttachment(this.middle, 0);
        fdlModelName.top = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlModelName);
        this.wModelName = new Text(wModelComp, 18436);
        PropsUi.setLook((Widget)this.wModelName);
        FormData fdModelName = new FormData();
        fdModelName.left = new FormAttachment(this.middle, this.margin);
        fdModelName.right = new FormAttachment(100, 0);
        fdModelName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        this.wModelName.setLayoutData((Object)fdModelName);
        this.wModelName.addModifyListener(e -> {
            this.setChanged();
            this.graphModel.setName(this.wModelName.getText());
        });
        Text lastControl = this.wModelName;
        Label wlModelDescription = new Label(wModelComp, 131072);
        wlModelDescription.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.Description.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlModelDescription);
        FormData fdlModelDescription = new FormData();
        fdlModelDescription.left = new FormAttachment(0, 0);
        fdlModelDescription.right = new FormAttachment(this.middle, 0);
        fdlModelDescription.top = new FormAttachment((Control)lastControl, this.margin);
        wlModelDescription.setLayoutData((Object)fdlModelDescription);
        this.wModelDescription = new Text(wModelComp, 18436);
        PropsUi.setLook((Widget)this.wModelDescription);
        FormData fdModelDescription = new FormData();
        fdModelDescription.left = new FormAttachment(this.middle, this.margin);
        fdModelDescription.right = new FormAttachment(100, 0);
        fdModelDescription.top = new FormAttachment((Control)wlModelDescription, 0, 0x1000000);
        this.wModelDescription.setLayoutData((Object)fdModelDescription);
        this.wModelDescription.addModifyListener(e -> {
            this.setChanged();
            this.graphModel.setDescription(this.wModelDescription.getText());
        });
        lastControl = this.wModelDescription;
        Button wImportGraph = new Button(wModelComp, 8);
        wImportGraph.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.ImportGraph.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)wImportGraph);
        FormData fdImportGraph = new FormData();
        fdImportGraph.left = new FormAttachment(this.middle, 0);
        fdImportGraph.right = new FormAttachment(75, 0);
        fdImportGraph.top = new FormAttachment((Control)lastControl, 50);
        wImportGraph.setLayoutData((Object)fdImportGraph);
        wImportGraph.addListener(13, e -> this.importGraphFromFile());
        lastControl = wImportGraph;
        Button wExportGraph = new Button(wModelComp, 8);
        wExportGraph.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.ExportGraph.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)wExportGraph);
        FormData fdExportGraph = new FormData();
        fdExportGraph.left = new FormAttachment(this.middle, 0);
        fdExportGraph.right = new FormAttachment(75, 0);
        fdExportGraph.top = new FormAttachment((Control)lastControl, this.margin);
        wExportGraph.setLayoutData((Object)fdExportGraph);
        wExportGraph.addListener(13, e -> this.exportGraphToFile());
        lastControl = wExportGraph;
        Button wSolutionsWorkbenchImportGraph = new Button(wModelComp, 8);
        wSolutionsWorkbenchImportGraph.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.ImportGraphSW.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)wSolutionsWorkbenchImportGraph);
        FormData fdSolutionsWorkbenchImportGraph = new FormData();
        fdSolutionsWorkbenchImportGraph.left = new FormAttachment(this.middle, 0);
        fdSolutionsWorkbenchImportGraph.right = new FormAttachment(75, 0);
        fdSolutionsWorkbenchImportGraph.top = new FormAttachment((Control)lastControl, 50);
        wSolutionsWorkbenchImportGraph.setLayoutData((Object)fdSolutionsWorkbenchImportGraph);
        wSolutionsWorkbenchImportGraph.addListener(13, e -> this.importGraphFromSolutionsWorkbench());
        lastControl = wSolutionsWorkbenchImportGraph;
        Button wArrowsAppImportGraph = new Button(wModelComp, 8);
        wArrowsAppImportGraph.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.ImportArrowsApp.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)wArrowsAppImportGraph);
        FormData fdArrowsAppImportGraph = new FormData();
        fdArrowsAppImportGraph.left = new FormAttachment(this.middle, 0);
        fdArrowsAppImportGraph.right = new FormAttachment(75, 0);
        fdArrowsAppImportGraph.top = new FormAttachment((Control)lastControl, this.margin);
        wArrowsAppImportGraph.setLayoutData((Object)fdArrowsAppImportGraph);
        wArrowsAppImportGraph.addListener(13, e -> this.importGraphFromArrowsApp());
        lastControl = wArrowsAppImportGraph;
        Button wCreateIndexAction = new Button(wModelComp, 8);
        wCreateIndexAction.setText(BaseMessages.getString(PKG, (String)"GraphModelDialog.CreateIndexAction.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)wCreateIndexAction);
        FormData fdCreateIndexAction = new FormData();
        fdCreateIndexAction.left = new FormAttachment(this.middle, 0);
        fdCreateIndexAction.right = new FormAttachment(75, 0);
        fdCreateIndexAction.top = new FormAttachment((Control)lastControl, 50);
        wCreateIndexAction.setLayoutData((Object)fdCreateIndexAction);
        wCreateIndexAction.addListener(13, e -> this.copyIndexActionToClipboard());
        FormData fdModelComp = new FormData();
        fdModelComp.left = new FormAttachment(0, 0);
        fdModelComp.top = new FormAttachment(0, 0);
        fdModelComp.right = new FormAttachment(100, 0);
        fdModelComp.bottom = new FormAttachment(100, 0);
        wModelComp.setLayoutData((Object)fdModelComp);
        wModelComp.pack();
        Rectangle bounds = wModelComp.getBounds();
        wModelSComp.setContent((Control)wModelComp);
        wModelSComp.setExpandHorizontal(true);
        wModelSComp.setExpandVertical(true);
        wModelSComp.setMinWidth(bounds.width);
        wModelSComp.setMinHeight(bounds.height);
        wModelTab.setControl((Control)wModelSComp);
    }

    private void addNodesTab() {
        CTabItem wNodesTab = new CTabItem(this.wTabs, 0);
        wNodesTab.setFont(GuiResource.getInstance().getFontDefault());
        wNodesTab.setText("Nodes");
        ScrolledComposite wNodesSComp = new ScrolledComposite((Composite)this.wTabs, 768);
        wNodesSComp.setLayout((Layout)new FillLayout());
        Composite wNodesComp = new Composite((Composite)wNodesSComp, 0);
        PropsUi.setLook((Widget)wNodesComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        wNodesComp.setLayout((Layout)formLayout);
        Button wNewNode = new Button(wNodesComp, 8);
        wNewNode.setText("New node");
        wNewNode.addListener(13, e -> this.newNode());
        Button wDeleteNode = new Button(wNodesComp, 8);
        wDeleteNode.setText("Delete node");
        wDeleteNode.addListener(13, e -> this.deleteNode());
        Button wCopyNode = new Button(wNodesComp, 8);
        wCopyNode.setText("Copy node");
        wCopyNode.addListener(13, e -> this.copyNode());
        Button wImportNode = new Button(wNodesComp, 8);
        wImportNode.setText("Import properties");
        wImportNode.addListener(13, e -> this.importNodeProperties());
        Button wNewRelationshipNode = new Button(wNodesComp, 8);
        wNewRelationshipNode.setText("New relationship");
        wNewRelationshipNode.addListener(13, e -> this.newRelationshipFromNode());
        BaseTransformDialog.positionBottomButtons((Composite)wNodesComp, (Button[])new Button[]{wNewNode, wDeleteNode, wCopyNode, wImportNode, wNewRelationshipNode}, (int)this.margin, null);
        Label wlNodesList = new Label(wNodesComp, 16384);
        wlNodesList.setText("Nodes list");
        PropsUi.setLook((Widget)wlNodesList);
        FormData fdlNodesList = new FormData();
        fdlNodesList.left = new FormAttachment(0, 0);
        fdlNodesList.right = new FormAttachment(this.middle, 0);
        fdlNodesList.top = new FormAttachment(0, 0);
        wlNodesList.setLayoutData((Object)fdlNodesList);
        this.wNodesList = new org.eclipse.swt.widgets.List(wNodesComp, 2564);
        PropsUi.setLook((Widget)this.wNodesList);
        FormData fdNodesList = new FormData();
        fdNodesList.left = new FormAttachment(0, 0);
        fdNodesList.right = new FormAttachment(this.middle, 0);
        fdNodesList.top = new FormAttachment((Control)wlNodesList, this.margin);
        fdNodesList.bottom = new FormAttachment((Control)wNewNode, -this.margin * 2);
        this.wNodesList.setLayoutData((Object)fdNodesList);
        this.wNodesList.addListener(13, event -> {
            this.getNodeLabelsFromView();
            this.setActiveNode(this.wNodesList.getSelection()[0]);
            this.refreshNodeFields();
        });
        this.wlNodeName = new Label(wNodesComp, 131072);
        this.wlNodeName.setText("Name");
        PropsUi.setLook((Widget)this.wlNodeName);
        FormData fdlNodeName = new FormData();
        fdlNodeName.left = new FormAttachment(this.middle, this.margin);
        fdlNodeName.top = new FormAttachment((Control)wlNodesList, this.margin * 2);
        this.wlNodeName.setLayoutData((Object)fdlNodeName);
        this.wNodeName = new Text(wNodesComp, 18436);
        this.wNodeName.addListener(24, event -> {
            if (this.activeNode != null) {
                String nodeName = this.wNodeName.getText();
                this.activeNode.setName(nodeName);
                String[] nodeNames = this.graphModel.getNodeNames();
                this.wNodesList.setItems(nodeNames);
                this.wNodesList.setSelection(Const.indexOfString((String)nodeName, (String[])nodeNames));
                this.setChanged();
            }
        });
        PropsUi.setLook((Widget)this.wNodeName);
        FormData fdNodeName = new FormData();
        fdNodeName.left = new FormAttachment((Control)this.wlNodeName, this.margin * 2);
        fdNodeName.right = new FormAttachment(100, 0);
        fdNodeName.top = new FormAttachment((Control)this.wlNodeName, 0, 0x1000000);
        this.wNodeName.setLayoutData((Object)fdNodeName);
        this.wlNodeDescription = new Label(wNodesComp, 131072);
        this.wlNodeDescription.setText(CONST_DESCRIPTION);
        PropsUi.setLook((Widget)this.wlNodeDescription);
        FormData fdlNodeDescription = new FormData();
        fdlNodeDescription.left = new FormAttachment(this.middle, this.margin);
        fdlNodeDescription.top = new FormAttachment((Control)this.wNodeName, this.margin);
        this.wlNodeDescription.setLayoutData((Object)fdlNodeDescription);
        this.wNodeDescription = new Text(wNodesComp, 18436);
        this.wNodeDescription.addListener(24, event -> {
            if (this.activeNode != null) {
                this.activeNode.setDescription(this.wNodeDescription.getText());
                this.setChanged();
            }
        });
        PropsUi.setLook((Widget)this.wNodeDescription);
        FormData fdNodeDescription = new FormData();
        fdNodeDescription.left = new FormAttachment((Control)this.wlNodeDescription, this.margin * 2);
        fdNodeDescription.right = new FormAttachment(100, 0);
        fdNodeDescription.top = new FormAttachment((Control)this.wlNodeDescription, 0, 0x1000000);
        this.wNodeDescription.setLayoutData((Object)fdNodeDescription);
        ColumnInfo[] labelColumns = new ColumnInfo[]{new ColumnInfo("Labels", 1, false)};
        ModifyListener labelModifyListener = modifyEvent -> this.getNodeLabelsFromView();
        this.wNodeLabels = new TableView((IVariables)new Variables(), wNodesComp, 67586, labelColumns, 1, labelModifyListener, this.props);
        PropsUi.setLook((Widget)this.wNodeLabels);
        FormData fdNodeLabels = new FormData();
        fdNodeLabels.left = new FormAttachment(this.middle, this.margin);
        fdNodeLabels.right = new FormAttachment(100, 0);
        fdNodeLabels.top = new FormAttachment((Control)this.wNodeDescription, this.margin);
        fdNodeLabels.bottom = new FormAttachment((Control)this.wNodeDescription, 250 + this.margin);
        this.wNodeLabels.setLayoutData((Object)fdNodeLabels);
        this.wlNodeProperties = new Label(wNodesComp, 16384);
        this.wlNodeProperties.setText("Properties:");
        PropsUi.setLook((Widget)this.wlNodeProperties);
        FormData fdlNodeProperties = new FormData();
        fdlNodeProperties.left = new FormAttachment(this.middle, this.margin);
        fdlNodeProperties.top = new FormAttachment((Control)this.wNodeLabels, this.margin);
        this.wlNodeProperties.setLayoutData((Object)fdlNodeProperties);
        ColumnInfo[] propertyColumns = new ColumnInfo[]{new ColumnInfo("Property key", 1, false), new ColumnInfo("Property Type", 2, GraphPropertyType.getNames(), false), new ColumnInfo(CONST_DESCRIPTION, 1, false), new ColumnInfo("Primary?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Mandatory?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Unique?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Indexed?", 2, new String[]{"Y", "N"}, false)};
        ModifyListener propertyModifyListener = modifyEvent -> this.getNodePropertiesFromView();
        this.wNodeProperties = new TableView((IVariables)new Variables(), wNodesComp, 67586, propertyColumns, 1, propertyModifyListener, this.props);
        this.wNodeProperties.table.addListener(16, event -> this.getNodePropertiesFromView());
        PropsUi.setLook((Widget)this.wNodeProperties);
        FormData fdNodeProperties = new FormData();
        fdNodeProperties.left = new FormAttachment(this.middle, this.margin);
        fdNodeProperties.right = new FormAttachment(100, 0);
        fdNodeProperties.top = new FormAttachment((Control)this.wlNodeProperties, this.margin);
        fdNodeProperties.bottom = new FormAttachment((Control)wNewNode, -2 * this.margin);
        this.wNodeProperties.setLayoutData((Object)fdNodeProperties);
        FormData fdNodesComp = new FormData();
        fdNodesComp.left = new FormAttachment(0, 0);
        fdNodesComp.top = new FormAttachment(0, 0);
        fdNodesComp.right = new FormAttachment(100, 0);
        fdNodesComp.bottom = new FormAttachment(100, 0);
        wNodesComp.setLayoutData((Object)fdNodesComp);
        wNodesComp.pack();
        Rectangle bounds = wNodesComp.getBounds();
        wNodesSComp.setContent((Control)wNodesComp);
        wNodesSComp.setExpandHorizontal(true);
        wNodesSComp.setExpandVertical(true);
        wNodesSComp.setMinWidth(bounds.width);
        wNodesSComp.setMinHeight(bounds.height);
        wNodesTab.setControl((Control)wNodesSComp);
    }

    private void newRelationshipFromNode() {
        String relBaseName;
        if (this.activeNode == null) {
            return;
        }
        if (this.graphModel.getNodes().size() < 2) {
            return;
        }
        Object[] nodeNames = new String[this.graphModel.getNodes().size() - 1];
        int index = 0;
        for (GraphNode graphNode : this.graphModel.getNodes()) {
            if (graphNode.equals(this.activeNode)) continue;
            nodeNames[index++] = graphNode.getName();
        }
        Arrays.sort(nodeNames);
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.hopGui.getShell(), (String[])nodeNames, "Select 2nd node", "Select the second node for the new relationship");
        dialog.setMulti(false);
        String targetNodeName = dialog.open();
        if (targetNodeName == null) {
            return;
        }
        this.getRelationshipPropertiesFromView();
        String relName = relBaseName = this.activeNode.getName() + " - " + targetNodeName;
        int relNr = 2;
        while (this.graphModel.findRelationship(relName) != null) {
            relName = relBaseName + " " + relNr++;
        }
        GraphRelationship rel = new GraphRelationship(relName, "", "", new ArrayList<GraphProperty>(), this.activeNode.getName(), targetNodeName);
        this.graphModel.getRelationships().add(rel);
        this.setActiveRelationship(relName);
        this.refreshRelationshipsList();
        this.wRelationshipsList.setSelection(Const.indexOfString((String)relName, (String[])this.graphModel.getRelationshipNames()));
        this.refreshRelationshipsFields();
    }

    private void getNodeLabelsFromView() {
        if (this.activeNode != null) {
            this.setChanged();
            if (this.monitorLabels) {
                Text text;
                ArrayList<String> labels = new ArrayList<String>();
                for (int i = 0; i < this.wNodeLabels.nrNonEmpty(); ++i) {
                    labels.add(this.wNodeLabels.getNonEmpty(i).getText(1));
                }
                TableEditor editor = this.wNodeLabels.getEditor();
                if (editor != null && editor.getEditor() != null && editor.getEditor() instanceof Text && !(text = (Text)editor.getEditor()).isDisposed() && !labels.contains(text.getText())) {
                    labels.add(text.getText());
                }
                this.activeNode.setLabels(labels);
            }
        }
    }

    private void getNodePropertiesFromView() {
        if (this.activeNode != null) {
            this.setChanged();
            if (this.monitorNodeProperties) {
                ArrayList<GraphProperty> properties = new ArrayList<GraphProperty>();
                for (int i = 0; i < this.wNodeProperties.nrNonEmpty(); ++i) {
                    TableItem item = this.wNodeProperties.getNonEmpty(i);
                    int col = 1;
                    String propertyKey = item.getText(col++);
                    GraphPropertyType propertyType = GraphPropertyType.parseCode(item.getText(col++));
                    String propertyDescription = item.getText(col++);
                    boolean propertyPrimary = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyMandatory = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyUnique = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyIndexed = "Y".equalsIgnoreCase(item.getText(col++));
                    properties.add(new GraphProperty(propertyKey, propertyDescription, propertyType, propertyPrimary, propertyMandatory, propertyUnique, propertyIndexed));
                }
                this.activeNode.setProperties(properties);
            }
        }
    }

    private void importNodeProperties() {
        try {
            if (this.activeNode == null) {
                return;
            }
            HopGuiPipelineGraph activePipelineGraph = HopGui.getActivePipelineGraph();
            if (activePipelineGraph == null) {
                MessageBox messageBox = new MessageBox(this.getShell(), 34);
                messageBox.setText("Sorry");
                messageBox.setMessage("Sorry, I couldn't find an active pipeline to use to import output fields from a transform");
                messageBox.open();
                return;
            }
            PipelineMeta pipelineMeta = activePipelineGraph.getPipelineMeta();
            String[] transformNames = pipelineMeta.getTransformNames();
            EnterSelectionDialog enterSelectionDialog = new EnterSelectionDialog(this.getShell(), transformNames, "Select transform", "Enter the transform to use for the fields to input");
            String transformName = enterSelectionDialog.open();
            if (transformName == null) {
                return;
            }
            IRowMeta inputRowMeta = pipelineMeta.getTransformFields(this.manager.getVariables(), transformName);
            String[] fieldNames = inputRowMeta.getFieldNames();
            EnterListDialog dialog = new EnterListDialog(this.hopGui.getShell(), 2160, fieldNames);
            String[] fields = dialog.open();
            if (fields != null) {
                for (String field : fields) {
                    IValueMeta valueMeta = inputRowMeta.searchValueMeta(field);
                    GraphPropertyType propertyType = switch (valueMeta.getType()) {
                        case 5 -> GraphPropertyType.Integer;
                        case 1 -> GraphPropertyType.Float;
                        case 3 -> GraphPropertyType.LocalDateTime;
                        case 4 -> GraphPropertyType.Boolean;
                        case 9 -> GraphPropertyType.LocalDateTime;
                        case 8 -> GraphPropertyType.ByteArray;
                        default -> GraphPropertyType.String;
                    };
                    String propertyName = Neo4jUtil.standardizePropertyName(valueMeta);
                    this.activeNode.getProperties().add(new GraphProperty(propertyName, "", propertyType, false, false, false, false));
                }
                this.refreshNodeFields();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error importing transform fields as properties", e);
        }
    }

    private void copyNode() {
        if (this.activeNode == null) {
            return;
        }
        GraphNode graphNode = new GraphNode(this.activeNode);
        graphNode.setName(this.activeNode.getName() + " (copy)");
        this.graphModel.getNodes().add(graphNode);
        this.activeNode = graphNode;
        this.refreshNodesList();
        this.wNodesList.setSelection(new String[]{graphNode.getName()});
        this.refreshNodeFields();
        this.enableFields();
    }

    private void deleteNode() {
        if (this.activeNode == null) {
            return;
        }
        int selectionIndex = this.wNodesList.getSelectionIndex();
        this.graphModel.getNodes().remove(this.activeNode);
        this.refreshNodesList();
        if (selectionIndex >= 0) {
            if (selectionIndex >= this.wNodesList.getItemCount()) {
                selectionIndex = this.wNodesList.getItemCount() - 1;
            }
            this.wNodesList.setSelection(selectionIndex);
            if (this.wNodesList.getSelection().length > 0) {
                this.setActiveNode(this.wNodesList.getSelection()[0]);
            } else {
                this.setActiveNode(null);
            }
            this.refreshNodeFields();
        }
        this.enableFields();
    }

    private void newNode() {
        GraphNode node = new GraphNode();
        node.setName("Node " + (this.graphModel.getNodes().size() + 1));
        this.graphModel.getNodes().add(node);
        this.setActiveNode(node.getName());
        this.refreshNodesList();
        this.refreshNodeFields();
    }

    private void addRelationshipsTab() {
        CTabItem wRelTab = new CTabItem(this.wTabs, 0);
        wRelTab.setFont(GuiResource.getInstance().getFontDefault());
        wRelTab.setText("Relationships");
        ScrolledComposite wRelSComp = new ScrolledComposite((Composite)this.wTabs, 768);
        wRelSComp.setLayout((Layout)new FillLayout());
        Composite wRelComp = new Composite((Composite)wRelSComp, 0);
        PropsUi.setLook((Widget)wRelComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wRelComp.setLayout((Layout)formLayout);
        Button wNewRelationship = new Button(wRelComp, 8);
        wNewRelationship.setText("New relationship");
        wNewRelationship.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphModelEditor.this.newRelationship();
            }
        });
        Button wDeleteRelationship = new Button(wRelComp, 8);
        wDeleteRelationship.setText("Delete relationship");
        wDeleteRelationship.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphModelEditor.this.deleteRelationship();
            }
        });
        Button wCopyRelationship = new Button(wRelComp, 8);
        wCopyRelationship.setText("Copy relationship");
        wCopyRelationship.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraphModelEditor.this.copyRelationship();
            }
        });
        BaseTransformDialog.positionBottomButtons((Composite)wRelComp, (Button[])new Button[]{wNewRelationship, wDeleteRelationship, wCopyRelationship}, (int)this.margin, null);
        Label wlRelationshipsList = new Label(wRelComp, 16384);
        wlRelationshipsList.setText("Relationships list");
        PropsUi.setLook((Widget)wlRelationshipsList);
        FormData fdlRelationshipsList = new FormData();
        fdlRelationshipsList.left = new FormAttachment(0, 0);
        fdlRelationshipsList.right = new FormAttachment(this.middle, 0);
        fdlRelationshipsList.top = new FormAttachment(0, this.margin);
        wlRelationshipsList.setLayoutData((Object)fdlRelationshipsList);
        this.wRelationshipsList = new org.eclipse.swt.widgets.List(wRelComp, 2564);
        PropsUi.setLook((Widget)this.wRelationshipsList);
        FormData fdRelationshipsList = new FormData();
        fdRelationshipsList.left = new FormAttachment(0, 0);
        fdRelationshipsList.right = new FormAttachment(this.middle, 0);
        fdRelationshipsList.top = new FormAttachment((Control)wlRelationshipsList, this.margin);
        fdRelationshipsList.bottom = new FormAttachment((Control)wNewRelationship, -this.margin * 2);
        this.wRelationshipsList.setLayoutData((Object)fdRelationshipsList);
        this.wRelationshipsList.addListener(13, event -> {
            this.setActiveRelationship(this.wRelationshipsList.getSelection()[0]);
            this.refreshRelationshipsFields();
        });
        this.wlRelName = new Label(wRelComp, 16384);
        this.wlRelName.setText("Name");
        PropsUi.setLook((Widget)this.wlRelName);
        FormData fdlRelName = new FormData();
        fdlRelName.left = new FormAttachment(this.middle, this.margin);
        fdlRelName.top = new FormAttachment((Control)wlRelationshipsList, 2 * this.margin);
        this.wlRelName.setLayoutData((Object)fdlRelName);
        this.wRelName = new Text(wRelComp, 18436);
        PropsUi.setLook((Widget)this.wRelName);
        FormData fdRelName = new FormData();
        fdRelName.left = new FormAttachment((Control)this.wlRelName, this.margin * 2);
        fdRelName.right = new FormAttachment(100, 0);
        fdRelName.top = new FormAttachment((Control)this.wlRelName, 0, 0x1000000);
        this.wRelName.setLayoutData((Object)fdRelName);
        this.wRelName.addListener(24, event -> {
            if (this.activeRelationship != null) {
                String relationshipName = this.wRelName.getText();
                this.activeRelationship.setName(relationshipName);
                String[] relationshipNames = this.graphModel.getRelationshipNames();
                this.wRelationshipsList.setItems(relationshipNames);
                this.wRelationshipsList.setSelection(Const.indexOfString((String)relationshipName, (String[])relationshipNames));
                this.setChanged();
            }
        });
        this.wlRelDescription = new Label(wRelComp, 16384);
        this.wlRelDescription.setText(CONST_DESCRIPTION);
        PropsUi.setLook((Widget)this.wlRelDescription);
        FormData fdlRelDescription = new FormData();
        fdlRelDescription.left = new FormAttachment(this.middle, this.margin);
        fdlRelDescription.top = new FormAttachment((Control)this.wRelName, this.margin);
        this.wlRelDescription.setLayoutData((Object)fdlRelDescription);
        this.wRelDescription = new Text(wRelComp, 18436);
        PropsUi.setLook((Widget)this.wRelDescription);
        FormData fdRelDescription = new FormData();
        fdRelDescription.left = new FormAttachment((Control)this.wlRelDescription, this.margin * 2);
        fdRelDescription.right = new FormAttachment(100, 0);
        fdRelDescription.top = new FormAttachment((Control)this.wlRelDescription, 0, 0x1000000);
        this.wRelDescription.setLayoutData((Object)fdRelDescription);
        this.wRelDescription.addListener(24, event -> {
            if (this.activeRelationship != null) {
                this.activeRelationship.setDescription(this.wRelDescription.getText());
                this.setChanged();
            }
        });
        this.wlRelLabel = new Label(wRelComp, 16384);
        this.wlRelLabel.setText("Label");
        PropsUi.setLook((Widget)this.wlRelLabel);
        FormData fdlRelLabel = new FormData();
        fdlRelLabel.left = new FormAttachment(this.middle, this.margin);
        fdlRelLabel.top = new FormAttachment((Control)this.wRelDescription, this.margin);
        this.wlRelLabel.setLayoutData((Object)fdlRelLabel);
        this.wRelLabel = new Text(wRelComp, 18436);
        PropsUi.setLook((Widget)this.wRelLabel);
        FormData fdRelLabel = new FormData();
        fdRelLabel.left = new FormAttachment((Control)this.wlRelLabel, this.margin * 2);
        fdRelLabel.right = new FormAttachment(100, 0);
        fdRelLabel.top = new FormAttachment((Control)this.wlRelLabel, 0, 0x1000000);
        this.wRelLabel.setLayoutData((Object)fdRelLabel);
        this.wRelLabel.addListener(24, event -> {
            if (this.activeRelationship != null) {
                this.activeRelationship.setLabel(this.wRelLabel.getText());
                this.setChanged();
            }
        });
        this.wlRelSource = new Label(wRelComp, 16384);
        this.wlRelSource.setText("Source");
        PropsUi.setLook((Widget)this.wlRelSource);
        FormData fdlRelSource = new FormData();
        fdlRelSource.left = new FormAttachment(this.middle, this.margin);
        fdlRelSource.top = new FormAttachment((Control)this.wRelLabel, this.margin);
        this.wlRelSource.setLayoutData((Object)fdlRelSource);
        this.wRelSource = new CCombo(wRelComp, 18436);
        PropsUi.setLook((Widget)this.wRelSource);
        FormData fdRelSource = new FormData();
        fdRelSource.left = new FormAttachment((Control)this.wlRelSource, this.margin * 2);
        fdRelSource.right = new FormAttachment(100, 0);
        fdRelSource.top = new FormAttachment((Control)this.wlRelSource, 0, 0x1000000);
        this.wRelSource.setLayoutData((Object)fdRelSource);
        this.wRelSource.addListener(24, event -> {
            if (this.activeRelationship != null) {
                this.activeRelationship.setNodeSource(this.wRelSource.getText());
                this.setChanged();
            }
        });
        this.wlRelTarget = new Label(wRelComp, 16384);
        this.wlRelTarget.setText("Target");
        PropsUi.setLook((Widget)this.wlRelTarget);
        FormData fdlRelTarget = new FormData();
        fdlRelTarget.left = new FormAttachment(this.middle, this.margin);
        fdlRelTarget.top = new FormAttachment((Control)this.wRelSource, this.margin);
        this.wlRelTarget.setLayoutData((Object)fdlRelTarget);
        this.wRelTarget = new CCombo(wRelComp, 18436);
        PropsUi.setLook((Widget)this.wRelTarget);
        FormData fdRelTarget = new FormData();
        fdRelTarget.left = new FormAttachment((Control)this.wlRelTarget, this.margin * 2);
        fdRelTarget.right = new FormAttachment(100, 0);
        fdRelTarget.top = new FormAttachment((Control)this.wlRelTarget, 0, 0x1000000);
        this.wRelTarget.setLayoutData((Object)fdRelTarget);
        this.wRelTarget.addListener(24, event -> {
            if (this.activeRelationship != null) {
                this.activeRelationship.setNodeTarget(this.wRelTarget.getText());
                this.setChanged();
            }
        });
        this.wlRelProperties = new Label(wRelComp, 16384);
        this.wlRelProperties.setText("Properties:");
        PropsUi.setLook((Widget)this.wlRelProperties);
        FormData fdlRelProperties = new FormData();
        fdlRelProperties.left = new FormAttachment(this.middle, this.margin);
        fdlRelProperties.top = new FormAttachment((Control)this.wRelTarget, this.margin);
        this.wlRelProperties.setLayoutData((Object)fdlRelProperties);
        ColumnInfo[] propertyColumns = new ColumnInfo[]{new ColumnInfo("Property key", 1, false), new ColumnInfo("Property Type", 2, GraphPropertyType.getNames(), false), new ColumnInfo(CONST_DESCRIPTION, 1, false), new ColumnInfo("Primary?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Mandatory?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Unique?", 2, new String[]{"Y", "N"}, false), new ColumnInfo("Indexed?", 2, new String[]{"Y", "N"}, false)};
        ModifyListener propertyModifyListener = modifyEvent -> this.getRelationshipPropertiesFromView();
        this.wRelProperties = new TableView((IVariables)new Variables(), wRelComp, 67586, propertyColumns, 1, propertyModifyListener, this.props);
        this.wRelProperties.table.addListener(16, event -> this.getRelationshipPropertiesFromView());
        PropsUi.setLook((Widget)this.wRelProperties);
        FormData fdRelProperties = new FormData();
        fdRelProperties.left = new FormAttachment(this.middle, this.margin);
        fdRelProperties.right = new FormAttachment(100, 0);
        fdRelProperties.top = new FormAttachment((Control)this.wlRelProperties, this.margin);
        fdRelProperties.bottom = new FormAttachment((Control)wNewRelationship, -2 * this.margin);
        this.wRelProperties.setLayoutData((Object)fdRelProperties);
        FormData fdRelComp = new FormData();
        fdRelComp.left = new FormAttachment(0, 0);
        fdRelComp.top = new FormAttachment(0, 0);
        fdRelComp.right = new FormAttachment(100, 0);
        fdRelComp.bottom = new FormAttachment(100, 0);
        wRelComp.setLayoutData((Object)fdRelComp);
        wRelComp.pack();
        Rectangle bounds = wRelComp.getBounds();
        wRelSComp.setContent((Control)wRelComp);
        wRelSComp.setExpandHorizontal(true);
        wRelSComp.setExpandVertical(true);
        wRelSComp.setMinWidth(bounds.width);
        wRelSComp.setMinHeight(bounds.height);
        wRelTab.setControl((Control)wRelSComp);
    }

    private void getRelationshipPropertiesFromView() {
        if (this.activeRelationship != null) {
            this.setChanged();
            if (this.monitorRelProperties) {
                ArrayList<GraphProperty> properties = new ArrayList<GraphProperty>();
                for (int i = 0; i < this.wRelProperties.nrNonEmpty(); ++i) {
                    TableItem item = this.wRelProperties.getNonEmpty(i);
                    int col = 1;
                    String propertyKey = item.getText(col++);
                    GraphPropertyType propertyType = GraphPropertyType.parseCode(item.getText(col++));
                    String propertyDescription = item.getText(col++);
                    boolean propertyPrimary = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyMandatory = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyUnique = "Y".equalsIgnoreCase(item.getText(col++));
                    boolean propertyIndexed = "Y".equalsIgnoreCase(item.getText(col++));
                    properties.add(new GraphProperty(propertyKey, propertyDescription, propertyType, propertyPrimary, propertyMandatory, propertyUnique, propertyIndexed));
                }
                this.activeRelationship.setProperties(properties);
            }
        }
    }

    private void copyRelationship() {
        if (this.activeRelationship == null) {
            return;
        }
        GraphRelationship graphRelationship = new GraphRelationship(this.activeRelationship);
        graphRelationship.setName(this.activeRelationship.getName() + " (copy)");
        this.graphModel.getRelationships().add(graphRelationship);
        this.setActiveRelationship(graphRelationship.getName());
        this.refreshRelationshipsList();
        this.wRelationshipsList.setSelection(new String[]{graphRelationship.getName()});
        this.refreshRelationshipsFields();
    }

    private void deleteRelationship() {
        if (this.activeRelationship == null) {
            return;
        }
        int selectionIndex = this.wRelationshipsList.getSelectionIndex();
        this.graphModel.getRelationships().remove(this.activeRelationship);
        this.refreshRelationshipsList();
        if (selectionIndex >= 0) {
            if (selectionIndex >= this.wRelationshipsList.getItemCount()) {
                selectionIndex = this.wRelationshipsList.getItemCount() - 1;
            }
            this.wRelationshipsList.setSelection(selectionIndex);
            if (this.wRelationshipsList.getSelection().length > 0) {
                this.setActiveRelationship(this.wRelationshipsList.getSelection()[0]);
            } else {
                this.setActiveRelationship(null);
            }
            this.refreshRelationshipsFields();
        }
    }

    private void newRelationship() {
        GraphRelationship relationship = new GraphRelationship();
        relationship.setName("Relationship " + (this.graphModel.getRelationships().size() + 1));
        this.graphModel.getRelationships().add(relationship);
        this.setActiveRelationship(relationship.getName());
        this.refreshRelationshipsList();
        this.refreshRelationshipsFields();
    }

    private void addGraphTab() {
        CTabItem wGraphTab = new CTabItem(this.wTabs, 0);
        wGraphTab.setFont(GuiResource.getInstance().getFontDefault());
        wGraphTab.setText("Graph");
        ScrolledComposite wGraphSComp = new ScrolledComposite((Composite)this.wTabs, 768);
        wGraphSComp.setLayout((Layout)new FillLayout());
        Composite wGraphComp = new Composite((Composite)wGraphSComp, 0);
        PropsUi.setLook((Widget)wGraphComp);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wGraphComp.setLayout((Layout)formLayout);
        Button wAuto = new Button(wGraphComp, 8);
        wAuto.setText("Auto");
        FormData fdAuto = new FormData();
        fdAuto.right = new FormAttachment(100, 0);
        fdAuto.bottom = new FormAttachment(100, 0);
        wAuto.setLayoutData((Object)fdAuto);
        wAuto.addListener(13, this::autoModelLayout);
        this.wCanvas = new Canvas(wGraphComp, 0);
        PropsUi.setLook((Widget)this.wCanvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.wCanvas.setLayoutData((Object)fdCanvas);
        this.wCanvas.addPaintListener(this::paintCanvas);
        this.wCanvas.addListener(3, this::graphMouseDown);
        this.wCanvas.addListener(4, this::graphMouseUp);
        this.wCanvas.addListener(5, this::moveGraphObject);
        this.wCanvas.addListener(8, this::editGraphObject);
        FormData fdGraphComp = new FormData();
        fdGraphComp.left = new FormAttachment(0, 0);
        fdGraphComp.top = new FormAttachment(0, 0);
        fdGraphComp.right = new FormAttachment(100, 0);
        fdGraphComp.bottom = new FormAttachment((Control)wAuto, -this.margin);
        wGraphComp.setLayoutData((Object)fdGraphComp);
        wGraphComp.pack();
        Rectangle bounds = wGraphComp.getBounds();
        wGraphSComp.setContent((Control)wGraphComp);
        wGraphSComp.setExpandHorizontal(true);
        wGraphSComp.setExpandVertical(true);
        wGraphSComp.setMinWidth(bounds.width);
        wGraphSComp.setMinHeight(bounds.height);
        wGraphTab.setControl((Control)wGraphSComp);
    }

    private void autoModelLayout(Event event) {
        Rectangle bounds = this.wCanvas.getBounds();
        this.nodeCache = new HashMap<String, Integer>();
        int optDistance = (int)((double)(bounds.width + bounds.height) * 1.5 / (double)(this.graphModel.getNodes().size() + 1));
        int nrNodes = this.graphModel.getNodes().size();
        List<Point> nodesizes = this.getNodeSizes();
        List<Point> bestCoordinates = this.generateRandomPoints(bounds, nrNodes);
        Scoring bestScore = this.calculateGraphScore(bestCoordinates, bounds, optDistance, nodesizes);
        System.out.println(">>>>>>>>>>> optDistance=" + optDistance + ", nrNodes=" + nrNodes + ", startscore=" + bestScore);
        for (int iteration = 0; iteration < 10000; ++iteration) {
            List<Point> testCoordinates = this.modifyRandomPoints(bestCoordinates, bounds, 2);
            Scoring testScore = this.calculateGraphScore(testCoordinates, bounds, optDistance, nodesizes);
            if (!(testScore.score < bestScore.score)) continue;
            bestScore = testScore;
            bestCoordinates = testCoordinates;
        }
        for (int n = 0; n < nrNodes; ++n) {
            Point point = bestCoordinates.get(n);
            GraphPresentation presentation = this.graphModel.getNodes().get(n).getPresentation();
            presentation.setX(point.x);
            presentation.setY(point.y);
        }
        System.out.println("<<<<<<<<<<<<< Best score found : " + bestScore);
        this.wCanvas.redraw();
    }

    private List<Point> getNodeSizes() {
        ArrayList<Point> sizes = new ArrayList<Point>();
        Image image = new Image((Device)this.getShell().getDisplay(), 100, 100);
        GC gc = new GC((Drawable)image);
        gc.setFont(GuiResource.getInstance().getFontMediumBold());
        for (GraphNode node : this.graphModel.getNodes()) {
            Point textExtent = gc.textExtent(node.getName());
            int width = textExtent.x + 20;
            int height = textExtent.y + 20;
            sizes.add(new Point(width, height));
        }
        gc.dispose();
        image.dispose();
        return sizes;
    }

    private int lookupNode(String nodeName) {
        Integer index = this.nodeCache.get(nodeName);
        if (index == null) {
            GraphNode node = this.graphModel.findNode(nodeName);
            index = this.graphModel.getNodes().indexOf(node);
            this.nodeCache.put(nodeName, index);
        }
        return index;
    }

    private Scoring calculateGraphScore(List<Point> coordinates, Rectangle bounds, int optDistance, List<Point> nodeSizes) {
        Scoring scoring = new Scoring();
        Point center = new Point(bounds.width / 2, bounds.height / 2);
        for (int n = 0; n < this.graphModel.getNodes().size(); ++n) {
            GraphNode node = this.graphModel.getNodes().get(n);
            Point nodePoint = coordinates.get(n);
            List<GraphNode> otherNodes = this.graphModel.getNodes();
            for (int o = 0; o < otherNodes.size(); ++o) {
                GraphNode otherNode = otherNodes.get(o);
                Point otherNodePoint = coordinates.get(o);
                if (node.equals(otherNode)) continue;
                double distanceToOtherNode = this.calculateDistance(nodePoint, otherNodePoint);
                scoring.distanceToOthers += (distanceToOtherNode - (double)optDistance) * (distanceToOtherNode - (double)optDistance);
            }
            scoring.distanceToCenter += 25.0 * this.calculateDistance(center, nodePoint);
        }
        for (GraphRelationship vertex : this.graphModel.getRelationships()) {
            int fromIndex = this.lookupNode(vertex.getNodeSource());
            Point vFrom = coordinates.get(fromIndex);
            int toIndex = this.lookupNode(vertex.getNodeTarget());
            Point vTo = coordinates.get(toIndex);
            scoring.vertexLength += this.calculateDistance(vFrom, vTo);
            for (GraphRelationship otherVertex : this.graphModel.getRelationships()) {
                if (vertex.equals(otherVertex)) continue;
                int fromOtherIndex = this.lookupNode(otherVertex.getNodeSource());
                Point oFrom = coordinates.get(fromOtherIndex);
                int toOtherIndex = this.lookupNode(otherVertex.getNodeTarget());
                Point oTo = coordinates.get(toOtherIndex);
                Line2D.Double one = new Line2D.Double(vFrom.x, vFrom.y, vTo.x, vTo.y);
                Line2D.Double two = new Line2D.Double(oFrom.x, oFrom.y, oTo.x, oTo.y);
                if (!one.intersectsLine(two)) continue;
                scoring.crossedVertices += 20000.0;
            }
        }
        ArrayList<Rectangle> labels = new ArrayList<Rectangle>();
        for (int s = 0; s < nodeSizes.size(); ++s) {
            Point nodePoint = coordinates.get(s);
            Point size = nodeSizes.get(s);
            labels.add(new Rectangle(nodePoint.x, nodePoint.y, size.x, size.y));
        }
        for (int a = 0; a < labels.size(); ++a) {
            Rectangle labelA = (Rectangle)labels.get(a);
            for (int b = 0; b < labels.size(); ++b) {
                Rectangle labelB;
                if (a == b || !labelA.intersects(labelB = (Rectangle)labels.get(b))) continue;
                scoring.overlappingLabels += 30000.0;
            }
            if (labelA.x + labelA.width > bounds.width) {
                scoring.overlappingLabels += 50000.0;
            }
            if (labelA.y + labelA.height <= bounds.height) continue;
            scoring.overlappingLabels += 50000.0;
        }
        scoring.calculateTotal();
        return scoring;
    }

    private double calculateDistance(Point a, Point b) {
        return this.calculateDistance(a.x, a.y, b.x, b.y);
    }

    private Point getNodePoint(GraphNode node) {
        return new Point(node.getPresentation().getX(), node.getPresentation().getY());
    }

    private List<Point> generateRandomPoints(Rectangle bounds, int size) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            Point point = this.generateRandomPoint(bounds);
            points.add(point);
        }
        return points;
    }

    private Point generateRandomPoint(Rectangle bounds) {
        int x = (int)(this.random.nextDouble() * (double)bounds.width * 0.7 + 0.15 * (double)bounds.width);
        int y = (int)(this.random.nextDouble() * (double)bounds.height * 0.7 + 0.15 * (double)bounds.height);
        return new Point(x, y);
    }

    private List<Point> modifyRandomPoints(List<Point> original, Rectangle bounds, int count) {
        int i;
        int size = original.size();
        ArrayList<Point> points = new ArrayList<Point>();
        for (i = 0; i < size; ++i) {
            Point point = original.get(i);
            points.add(new Point(point.x, point.y));
        }
        for (i = 0; i < count; ++i) {
            int index = (int)(this.random.nextDouble() * (double)size);
            Point point = this.generateRandomPoint(bounds);
            points.set(index, point);
        }
        return points;
    }

    protected List<GraphNode> findNodesInCircle(GraphNode centerNode, int radius) {
        int xc = centerNode.getPresentation().getX();
        int yc = centerNode.getPresentation().getY();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        for (GraphNode node : this.graphModel.getNodes()) {
            int yn;
            int xn;
            double distance;
            if (node.equals(centerNode) || !((distance = this.calculateDistance(xc, yc, xn = node.getPresentation().getX(), yn = node.getPresentation().getY())) < (double)radius)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private double calculateDistance(int xc, int yc, int xn, int yn) {
        return Math.sqrt((xn - xc) * (xn - xc) + (yn - yc) * (yn - yc));
    }

    private void graphMouseUp(Event e) {
        this.mouseDownPoint.x = -1;
        this.mouseDownPoint.y = -1;
    }

    private void graphMouseDown(Event e) {
        this.mouseDownPoint.x = e.x;
        this.mouseDownPoint.y = e.y;
    }

    private void moveGraphObject(Event e) {
        if (this.mouseDownPoint.x > 0 && this.mouseDownPoint.y > 0) {
            AreaOwner areaOwner = AreaOwner.findArea(this.areaOwners, this.mouseDownPoint.x, this.mouseDownPoint.y);
            if (areaOwner != null) {
                int offsetX = this.mouseDownPoint.x - areaOwner.getX();
                int offsetY = this.mouseDownPoint.y - areaOwner.getY();
                switch (areaOwner.getAreaType()) {
                    case NODE: {
                        GraphNode graphNode = (GraphNode)areaOwner.getSubject();
                        GraphPresentation p = new GraphPresentation(e.x - offsetX, e.y - offsetY);
                        graphNode.setPresentation(p);
                        this.mouseDownPoint.x = e.x;
                        this.mouseDownPoint.y = e.y;
                        this.wCanvas.redraw();
                        this.setChanged();
                        break;
                    }
                }
            } else {
                int offsetX = this.mouseDownPoint.x - e.x;
                int offsetY = this.mouseDownPoint.y - e.y;
                for (GraphNode graphNode : this.graphModel.getNodes()) {
                    GraphPresentation p = graphNode.getPresentation();
                    p.setX(p.getX() - offsetX);
                    p.setY(p.getY() - offsetY);
                }
                this.mouseDownPoint.x = e.x;
                this.mouseDownPoint.y = e.y;
                this.wCanvas.redraw();
            }
        }
    }

    private void editGraphObject(Event e) {
        this.mouseDownPoint.x = -1;
        this.mouseDownPoint.y = -1;
        AreaOwner areaOwner = AreaOwner.findArea(this.areaOwners, e.x, e.y);
        if (areaOwner == null) {
            return;
        }
        switch (areaOwner.getAreaType()) {
            case NODE: {
                this.wTabs.setSelection(1);
                GraphNode graphNode = (GraphNode)areaOwner.getSubject();
                int nodeIndex = Const.indexOfString((String)graphNode.getName(), (String[])this.wNodesList.getItems());
                if (nodeIndex < 0) break;
                this.getNodeLabelsFromView();
                this.setActiveNode(graphNode.getName());
                this.wNodesList.setSelection(nodeIndex);
                this.refreshNodeFields();
                break;
            }
            case RELATIONSHIP_LABEL: {
                this.wTabs.setSelection(2);
                GraphRelationship rel = (GraphRelationship)areaOwner.getSubject();
                int relIndex = Const.indexOfString((String)rel.getName(), (String[])this.wRelationshipsList.getItems());
                if (relIndex < 0) break;
                this.setActiveRelationship(rel.getName());
                this.wRelationshipsList.setSelection(relIndex);
                this.refreshRelationshipsFields();
                break;
            }
        }
    }

    private synchronized void paintCanvas(PaintEvent e) {
        this.areaOwners = new ArrayList<AreaOwner>();
        GC gc = e.gc;
        gc.setForeground(GuiResource.getInstance().getColorLightGray());
        gc.fillRectangle(0, 0, e.width, e.height);
        int margin = 10;
        for (GraphRelationship relationship : this.graphModel.getRelationships()) {
            GraphNode sourceNode = this.graphModel.findNode(relationship.getNodeSource());
            GraphNode targetNode = this.graphModel.findNode(relationship.getNodeTarget());
            if (sourceNode == null || targetNode == null) continue;
            gc.setFont(GuiResource.getInstance().getFontMedium());
            Point sourceExtent = gc.textExtent(sourceNode.getName());
            Point targetExtent = gc.textExtent(targetNode.getName());
            int fromX = sourceNode.getPresentation().getX() + margin + sourceExtent.x / 2;
            int fromY = sourceNode.getPresentation().getY() + margin + sourceExtent.y / 2;
            int toX = targetNode.getPresentation().getX() + margin + targetExtent.x / 2;
            int toY = targetNode.getPresentation().getY() + margin + targetExtent.y / 2;
            gc.setForeground(GuiResource.getInstance().getColorLightBlue());
            gc.drawLine(fromX, fromY, toX, toY);
            gc.setFont(GuiResource.getInstance().getFontMedium());
            Point relExtent = gc.textExtent(relationship.getName());
            int middleX = fromX + (toX - fromX) / 2 - relExtent.x / 2;
            int middleY = fromY + (toY - fromY) / 2 - relExtent.y / 2;
            gc.setForeground(GuiResource.getInstance().getColorBlack());
            gc.drawText(relationship.getName(), middleX, middleY);
            this.areaOwners.add(new AreaOwner(middleX, middleY, relExtent.x, relExtent.y, AreaType.RELATIONSHIP_LABEL, relationship));
        }
        gc.setFont(GuiResource.getInstance().getFontMediumBold());
        for (GraphNode graphNode : this.graphModel.getNodes()) {
            GraphPresentation presentation = graphNode.getPresentation();
            Point textExtent = gc.textExtent(graphNode.getName());
            int x = presentation.getX();
            int y = presentation.getY();
            int width = textExtent.x + 2 * margin;
            int height = textExtent.y + 2 * margin;
            gc.setForeground(GuiResource.getInstance().getColorBackground());
            gc.fillRoundRectangle(x, y, width, height, margin, margin);
            gc.setForeground(GuiResource.getInstance().getColorBlue());
            gc.drawRoundRectangle(x, y, width, height, height / 3, height / 3);
            this.areaOwners.add(new AreaOwner(x, y, width, height, AreaType.NODE, graphNode));
            gc.setForeground(GuiResource.getInstance().getColorBlack());
            gc.drawText(graphNode.getName(), x + margin, y + margin);
        }
    }

    private void importGraphFromFile() {
        try {
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "Model JSON", "This is the JSON of the graph model", this.graphModel.getJSONString(), true);
            String jsonModelString = dialog.open();
            if (jsonModelString == null) {
                return;
            }
            this.graphModel = new GraphModel(jsonModelString);
            this.setWidgetsContent();
            this.setChanged();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, CONST_ERROR_IMPORTING_JSON, e);
        }
    }

    private void exportGraphToFile() {
        try {
            String prettyJsonString = this.getModelJson();
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "Model JSON", "This is the JSON of the graph model", prettyJsonString, true);
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error serializing to JSON", e);
        }
    }

    private void importGraphFromSolutionsWorkbench() {
        try {
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "Solutions Workbench Export", "Paste the Solutions Workbench model export (JSON) below", "{}", true);
            String jsonModelString = dialog.open();
            if (jsonModelString == null) {
                return;
            }
            GraphModel importedModel = SolutionsWorkbenchImporter.importFromCwJson(jsonModelString);
            this.graphModel = SolutionsWorkbenchImporter.changeNamesToLabels(importedModel);
            this.setWidgetsContent();
            this.setChanged();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, CONST_ERROR_IMPORTING_JSON, e);
        }
    }

    private void importGraphFromArrowsApp() {
        try {
            EnterTextDialog dialog = new EnterTextDialog(this.getShell(), "Arrows JSON", "Paste the Arrows application export in JSON format below", "{}", true);
            String jsonModelString = dialog.open();
            if (jsonModelString == null) {
                return;
            }
            this.graphModel = ArrowsAppImporter.importFromArrowsJson(jsonModelString);
            this.setWidgetsContent();
            this.setChanged();
            MessageBox box = new MessageBox(this.getShell(), 34);
            box.setText("Import successful");
            box.setMessage("The import from the Arrows JSON was successful.  Please make sure to give this model a name and indicate the primary key fields of nodes.");
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, CONST_ERROR_IMPORTING_JSON, e);
        }
    }

    private String getModelJson() throws HopException {
        return this.graphModel.getJSONString();
    }

    private void copyIndexActionToClipboard() {
        try {
            IHopMetadataSerializer connectionSerializer = this.getMetadataManager().getMetadataProvider().getSerializer(NeoConnection.class);
            List connectionNames = connectionSerializer.listObjectNames();
            EnterSelectionDialog enterSelectionDialog = new EnterSelectionDialog(this.getShell(), connectionNames.toArray(new String[0]), "Select connection", "Select the Neo4j Connection to create indexes and constraints on in the generated actions:");
            String connectionName = enterSelectionDialog.open();
            if (connectionName == null) {
                return;
            }
            NeoConnection connection = (NeoConnection)connectionSerializer.load(connectionName);
            Neo4jIndex neo4jIndex = new Neo4jIndex();
            neo4jIndex.setConnection(connection);
            for (GraphNode node : this.graphModel.getNodes()) {
                for (String string : node.getLabels()) {
                    for (GraphProperty graphProperty : node.getProperties()) {
                        if (!graphProperty.isIndexed() && !graphProperty.isPrimary() || graphProperty.isUnique()) continue;
                        neo4jIndex.getIndexUpdates().add(new IndexUpdate(UpdateType.CREATE, org.apache.hop.neo4j.actions.index.ObjectType.NODE, "IDX_" + string.toUpperCase() + "_" + graphProperty.getName().toUpperCase(), string, graphProperty.getName()));
                    }
                }
            }
            ActionMeta indexMeta = new ActionMeta((IAction)neo4jIndex);
            indexMeta.setName("Create indexes for graph model " + this.graphModel.getName());
            indexMeta.setLocation(50, 50);
            String xmlIndex = indexMeta.getXml();
            Neo4jConstraint neo4jConstraint = new Neo4jConstraint();
            neo4jConstraint.setConnection(connection);
            for (GraphNode node : this.graphModel.getNodes()) {
                for (String label : node.getLabels()) {
                    String constraintName = label.toUpperCase();
                    String properties = "";
                    for (GraphProperty property : node.getProperties()) {
                        if (!property.isUnique()) continue;
                        neo4jConstraint.getConstraintUpdates().add(new ConstraintUpdate(org.apache.hop.neo4j.actions.constraint.UpdateType.CREATE, ObjectType.NODE, ConstraintType.UNIQUE, "COU_" + label.toUpperCase() + "_" + property.getName().toUpperCase(), label, property.getName()));
                    }
                }
            }
            ActionMeta actionMeta = new ActionMeta((IAction)neo4jConstraint);
            actionMeta.setName("Create constraints for graph model " + this.graphModel.getName());
            actionMeta.setLocation(100, 50);
            String xmlConstraint = actionMeta.getXml();
            GuiResource.getInstance().toClipboard("<workflow-actions><actions>" + xmlIndex + xmlConstraint + "</actions></workflow-actions>");
            MessageBox messageBox = new MessageBox(this.getShell(), 34);
            messageBox.setText("Copied to clipboard");
            messageBox.setMessage("An Neo4j Index/Constraint actions were copied to the clipboard to create the required indexes and constraints for this model.  You can paste these actions in a workflow.");
            messageBox.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error serializing to JSON", e);
        }
    }

    public void clearChanged() {
        this.resetChanged();
        MetadataPerspective.getInstance().updateEditor((MetadataEditor)this);
    }

    private class Scoring {
        double score = 0.0;
        double distanceToOthers = 0.0;
        double distanceToCenter = 0.0;
        double vertexLength = 0.0;
        double crossedVertices = 0.0;
        double overlappingLabels = 0.0;

        public void calculateTotal() {
            this.score = this.distanceToOthers + this.distanceToCenter + this.vertexLength + this.crossedVertices + this.overlappingLabels;
        }

        public String toString() {
            return "Score: " + (long)this.score + " [distanceToOthers=" + (long)this.distanceToOthers + ", distanceToCenter" + (long)this.distanceToCenter + ", vertexLength=" + (long)this.vertexLength + ", crossedVertices=" + (long)this.crossedVertices + ", overlappingLabels=" + this.overlappingLabels + "]";
        }
    }
}

