/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.CombineContextFactory;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class FlinkBroadcastStateInternals<@UnknownKeyFor K>
implements StateInternals {
    private @UnknownKeyFor @NonNull @Initialized int indexInSubtaskGroup;
    private final @UnknownKeyFor @NonNull @Initialized OperatorStateBackend stateBackend;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> stateForNonZeroOperator;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;

    public FlinkBroadcastStateInternals(@UnknownKeyFor @NonNull @Initialized int indexInSubtaskGroup, @UnknownKeyFor @NonNull @Initialized OperatorStateBackend stateBackend, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
        this.stateBackend = stateBackend;
        this.indexInSubtaskGroup = indexInSubtaskGroup;
        this.pipelineOptions = pipelineOptions;
        if (indexInSubtaskGroup != 0) {
            this.stateForNonZeroOperator = new HashMap();
        }
    }

    public @Nullable K getKey() {
        return null;
    }

    public <T extends State> T state(final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> context) {
        return (T)address.bind(new StateTag.StateBinder(){

            public <T2> @UnknownKeyFor @NonNull @Initialized ValueState<T2> bindValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T2>> address, @UnknownKeyFor @NonNull @Initialized Coder<T2> coder) {
                return new FlinkBroadcastValueState<T2>(FlinkBroadcastStateInternals.this.stateBackend, address, namespace, coder, FlinkBroadcastStateInternals.this.pipelineOptions);
            }

            public <T2> @UnknownKeyFor @NonNull @Initialized BagState<T2> bindBag(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T2>> address, @UnknownKeyFor @NonNull @Initialized Coder<T2> elemCoder) {
                return new FlinkBroadcastBagState<T2>(FlinkBroadcastStateInternals.this.stateBackend, address, namespace, elemCoder, FlinkBroadcastStateInternals.this.pipelineOptions);
            }

            public <T2> @UnknownKeyFor @NonNull @Initialized SetState<T2> bindSet(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized SetState<T2>> address, @UnknownKeyFor @NonNull @Initialized Coder<T2> elemCoder) {
                throw new UnsupportedOperationException(String.format("%s is not supported", SetState.class.getSimpleName()));
            }

            public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
                throw new UnsupportedOperationException(String.format("%s is not supported", MapState.class.getSimpleName()));
            }

            public <ElemT> @UnknownKeyFor @NonNull @Initialized OrderedListState<ElemT> bindOrderedList(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized OrderedListState<ElemT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<ElemT> elemCoder) {
                throw new UnsupportedOperationException(String.format("%s is not supported", OrderedListState.class.getSimpleName()));
            }

            public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
                throw new UnsupportedOperationException(String.format("%s is not supported", MultimapState.class.getSimpleName()));
            }

            public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValue(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                return new FlinkCombiningState<InputT, AccumT, OutputT>(FlinkBroadcastStateInternals.this.stateBackend, address, combineFn, namespace, accumCoder, FlinkBroadcastStateInternals.this.pipelineOptions);
            }

            public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningValueWithContext(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
                return new FlinkCombiningStateWithContext(FlinkBroadcastStateInternals.this.stateBackend, address, combineFn, namespace, accumCoder, CombineContextFactory.createFromStateContext((StateContext)context));
            }

            public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> address, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
                throw new UnsupportedOperationException(String.format("%s is not supported", WatermarkHoldState.class.getSimpleName()));
            }
        });
    }

    private class FlinkCombiningStateWithContext<@UnknownKeyFor K2, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends AbstractBroadcastState<AccumT>
    implements CombiningState<InputT, AccumT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CombineWithContext.Context context;

        FlinkCombiningStateWithContext(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized OperatorStateBackend flinkStateBackend, @UnknownKeyFor @NonNull @Initialized StateTag<CombiningState<InputT, AccumT, OutputT>> address, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, CombineWithContext.Context context) {
            super(flinkStateBackend, address.getId(), namespace, accumCoder, FlinkBroadcastStateInternals.this.pipelineOptions);
            this.namespace = namespace;
            this.address = address;
            this.combineFn = combineFn;
            this.context = context;
        }

        public @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> readLater() {
            return this;
        }

        public void add(InputT value) {
            try {
                Object current = this.readInternal();
                if (current == null) {
                    current = this.combineFn.createAccumulator(this.context);
                }
                current = this.combineFn.addInput(current, value, this.context);
                this.writeInternal(current);
            }
            catch (Exception e) {
                throw new RuntimeException("Error adding to state.", e);
            }
        }

        public void addAccum(AccumT accum) {
            try {
                Object current = this.readInternal();
                if (current == null) {
                    this.writeInternal(accum);
                } else {
                    current = this.combineFn.mergeAccumulators(Arrays.asList(current, accum), this.context);
                    this.writeInternal(current);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error adding to state.", e);
            }
        }

        public AccumT getAccum() {
            try {
                Object accum = this.readInternal();
                return (AccumT)(accum != null ? accum : this.combineFn.createAccumulator(this.context));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading state.", e);
            }
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators, this.context);
        }

        public OutputT read() {
            try {
                Object accum = this.readInternal();
                if (accum == null) {
                    accum = this.combineFn.createAccumulator(this.context);
                }
                return (OutputT)this.combineFn.extractOutput(accum, this.context);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading state.", e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    try {
                        return FlinkCombiningStateWithContext.this.readInternal() == null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading state.", e);
                    }
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }
            };
        }

        public void clear() {
            this.clearInternal();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlinkCombiningStateWithContext that = (FlinkCombiningStateWithContext)o;
            return this.namespace.equals(that.namespace) && this.address.equals(that.address);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }
    }

    private class FlinkCombiningState<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends AbstractBroadcastState<AccumT>
    implements CombiningState<InputT, AccumT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> address;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        FlinkCombiningState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized OperatorStateBackend flinkStateBackend, @UnknownKeyFor @NonNull @Initialized StateTag<CombiningState<InputT, AccumT, OutputT>> address, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, SerializablePipelineOptions pipelineOptions) {
            super(flinkStateBackend, address.getId(), namespace, accumCoder, pipelineOptions);
            this.namespace = namespace;
            this.address = address;
            this.combineFn = combineFn;
        }

        public @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> readLater() {
            return this;
        }

        public void add(InputT value) {
            Object current = this.readInternal();
            if (current == null) {
                current = this.combineFn.createAccumulator();
            }
            current = this.combineFn.addInput(current, value);
            this.writeInternal(current);
        }

        public void addAccum(AccumT accum) {
            Object current = this.readInternal();
            if (current == null) {
                this.writeInternal(accum);
            } else {
                current = this.combineFn.mergeAccumulators(Arrays.asList(current, accum));
                this.writeInternal(current);
            }
        }

        public AccumT getAccum() {
            Object accum = this.readInternal();
            return (AccumT)(accum != null ? accum : this.combineFn.createAccumulator());
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }

        public OutputT read() {
            Object accum = this.readInternal();
            if (accum != null) {
                return (OutputT)this.combineFn.extractOutput(accum);
            }
            return (OutputT)this.combineFn.extractOutput(this.combineFn.createAccumulator());
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    try {
                        return FlinkCombiningState.this.readInternal() == null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading state.", e);
                    }
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }
            };
        }

        public void clear() {
            this.clearInternal();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlinkCombiningState that = (FlinkCombiningState)o;
            return this.namespace.equals(that.namespace) && this.address.equals(that.address);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }
    }

    private class FlinkBroadcastBagState<@UnknownKeyFor T>
    extends AbstractBroadcastState<List<T>>
    implements BagState<T> {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<T>> address;

        FlinkBroadcastBagState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized OperatorStateBackend flinkStateBackend, @UnknownKeyFor @NonNull @Initialized StateTag<BagState<T>> address, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, SerializablePipelineOptions pipelineOptions) {
            super(flinkStateBackend, address.getId(), namespace, ListCoder.of(coder), pipelineOptions);
            this.namespace = namespace;
            this.address = address;
        }

        public void add(T input) {
            ArrayList<T> list = (ArrayList<T>)this.readInternal();
            if (list == null) {
                list = new ArrayList<T>();
            }
            list.add(input);
            this.writeInternal(list);
        }

        public @UnknownKeyFor @NonNull @Initialized BagState<T> readLater() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<T> read() {
            List result = (List)this.readInternal();
            return result != null ? result : Collections.emptyList();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    try {
                        List result = (List)FlinkBroadcastBagState.this.readInternal();
                        return result == null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error reading state.", e);
                    }
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }
            };
        }

        public void clear() {
            this.clearInternal();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlinkBroadcastBagState that = (FlinkBroadcastBagState)o;
            return this.namespace.equals(that.namespace) && this.address.equals(that.address);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }
    }

    private class FlinkBroadcastValueState<@UnknownKeyFor T>
    extends AbstractBroadcastState<T>
    implements ValueState<T> {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<T>> address;

        FlinkBroadcastValueState(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized OperatorStateBackend flinkStateBackend, @UnknownKeyFor @NonNull @Initialized StateTag<ValueState<T>> address, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, SerializablePipelineOptions pipelineOptions) {
            super(flinkStateBackend, address.getId(), namespace, coder, pipelineOptions);
            this.namespace = namespace;
            this.address = address;
        }

        public void write(T input) {
            this.writeInternal(input);
        }

        public @UnknownKeyFor @NonNull @Initialized ValueState<T> readLater() {
            return this;
        }

        public T read() {
            return this.readInternal();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlinkBroadcastValueState that = (FlinkBroadcastValueState)o;
            return this.namespace.equals(that.namespace) && this.address.equals(that.address);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.address.hashCode();
            return result;
        }

        public void clear() {
            this.clearInternal();
        }
    }

    private abstract class AbstractBroadcastState<@UnknownKeyFor T> {
        private @UnknownKeyFor @NonNull @Initialized String name;
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final @UnknownKeyFor @NonNull @Initialized ListStateDescriptor<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T>> flinkStateDescriptor;
        private final @UnknownKeyFor @NonNull @Initialized OperatorStateStore flinkStateBackend;

        AbstractBroadcastState(@UnknownKeyFor @NonNull @Initialized OperatorStateBackend flinkStateBackend, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, SerializablePipelineOptions pipelineOptions) {
            this.name = name;
            this.namespace = namespace;
            this.flinkStateBackend = flinkStateBackend;
            CoderTypeInformation typeInfo = new CoderTypeInformation(MapCoder.of((Coder)StringUtf8Coder.of(), coder), pipelineOptions);
            this.flinkStateDescriptor = new ListStateDescriptor(name, typeInfo.createSerializer(new ExecutionConfig()));
        }

        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> getMap() throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (FlinkBroadcastStateInternals.this.indexInSubtaskGroup == 0) {
                return this.getMapFromBroadcastState();
            }
            Map<String, T> result = (Map<String, T>)FlinkBroadcastStateInternals.this.stateForNonZeroOperator.get(this.name);
            if (result == null && (result = this.getMapFromBroadcastState()) != null) {
                FlinkBroadcastStateInternals.this.stateForNonZeroOperator.put(this.name, result);
                this.flinkStateBackend.getUnionListState(this.flinkStateDescriptor).clear();
            }
            return result;
        }

        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> getMapFromBroadcastState() throws @UnknownKeyFor @NonNull @Initialized Exception {
            Iterator iterator;
            ListState state = this.flinkStateBackend.getUnionListState(this.flinkStateDescriptor);
            Iterable iterable = (Iterable)state.get();
            Map ret = null;
            if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
                ret = (Map)iterator.next();
            }
            return ret;
        }

        void updateMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, T> map) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (FlinkBroadcastStateInternals.this.indexInSubtaskGroup == 0) {
                ListState state = this.flinkStateBackend.getUnionListState(this.flinkStateDescriptor);
                state.clear();
                if (map.size() > 0) {
                    state.add(map);
                }
            } else if (map.isEmpty()) {
                FlinkBroadcastStateInternals.this.stateForNonZeroOperator.remove(this.name);
            } else {
                FlinkBroadcastStateInternals.this.stateForNonZeroOperator.put(this.name, map);
            }
        }

        void writeInternal(T input) {
            try {
                Map<String, T> map = this.getMap();
                if (map == null) {
                    map = new HashMap<String, T>();
                }
                map.put(this.namespace.stringKey(), input);
                this.updateMap(map);
            }
            catch (Exception e) {
                throw new RuntimeException("Error updating state.", e);
            }
        }

        T readInternal() {
            try {
                Map<String, T> map = this.getMap();
                if (map == null) {
                    return null;
                }
                return map.get(this.namespace.stringKey());
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading state.", e);
            }
        }

        void clearInternal() {
            try {
                Map<String, T> map = this.getMap();
                if (map != null) {
                    map.remove(this.namespace.stringKey());
                    this.updateMap(map);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error clearing state.", e);
            }
        }
    }
}

