/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sort;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sort.RowTempFile;
import org.apache.hop.pipeline.transforms.sort.SortRowsData;
import org.apache.hop.pipeline.transforms.sort.SortRowsField;
import org.apache.hop.pipeline.transforms.sort.SortRowsMeta;

public class SortRows
extends BaseTransform<SortRowsMeta, SortRowsData> {
    private static final Class<?> PKG = SortRows.class;

    public SortRows(TransformMeta transformMeta, SortRowsMeta meta, SortRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    void addBuffer(IRowMeta rowMeta, Object[] r) throws HopException {
        if (((SortRowsData)this.data).convertKeysToNative != null) {
            for (int i = 0; i < ((SortRowsData)this.data).convertKeysToNative.length; ++i) {
                int index = ((SortRowsData)this.data).convertKeysToNative[i];
                r[index] = rowMeta.getValueMeta(index).convertBinaryStringToNativeType((byte[])r[index]);
            }
        }
        ((SortRowsData)this.data).buffer.add(r);
        ++((SortRowsData)this.data).freeCounter;
        if (((SortRowsData)this.data).sortSize <= 0 && ((SortRowsData)this.data).freeCounter >= 1000) {
            ((SortRowsData)this.data).freeMemoryPct = Const.getPercentageFreeMemory();
            ((SortRowsData)this.data).freeCounter = 0;
            if (this.log.isDetailed()) {
                ++((SortRowsData)this.data).memoryReporting;
                if (((SortRowsData)this.data).memoryReporting >= 10) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SortRows.Detailed.AvailableMemory", (Object[])new Object[]{((SortRowsData)this.data).freeMemoryPct}));
                    }
                    ((SortRowsData)this.data).memoryReporting = 0;
                }
            }
        }
        boolean doSort = ((SortRowsData)this.data).buffer.size() == ((SortRowsData)this.data).sortSize;
        doSort |= ((SortRowsData)this.data).freeMemoryPctLimit > 0 && ((SortRowsData)this.data).freeMemoryPct < ((SortRowsData)this.data).freeMemoryPctLimit && ((SortRowsData)this.data).buffer.size() >= ((SortRowsData)this.data).minSortSize;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SortRows.Debug.StartDumpToDisk", (Object[])new Object[]{((SortRowsData)this.data).freeMemoryPct, ((SortRowsData)this.data).buffer.size()}));
        }
        if (doSort) {
            this.sortExternalRows();
        }
    }

    void sortExternalRows() throws HopException {
        if (((SortRowsData)this.data).buffer.isEmpty()) {
            return;
        }
        this.quickSort(((SortRowsData)this.data).buffer);
        try {
            DataOutputStream dos;
            GZIPOutputStream gzos;
            FileObject fileObject = HopVfs.createTempFile((String)((SortRowsMeta)this.meta).getPrefix(), (String)".tmp", (String)this.resolve(((SortRowsMeta)this.meta).getDirectory()), (IVariables)this.variables);
            ((SortRowsData)this.data).files.add(fileObject);
            OutputStream outputStream = HopVfs.getOutputStream((FileObject)fileObject, (boolean)false);
            if (((SortRowsData)this.data).compressFiles) {
                gzos = new GZIPOutputStream(new BufferedOutputStream(outputStream));
                dos = new DataOutputStream(gzos);
            } else {
                dos = new DataOutputStream(new BufferedOutputStream(outputStream, 500000));
                gzos = null;
            }
            ArrayList<Integer> duplicates = new ArrayList<Integer>();
            Object[] previousRow = null;
            if (((SortRowsMeta)this.meta).isOnlyPassingUniqueRows()) {
                for (int index = 0; index < ((SortRowsData)this.data).buffer.size(); ++index) {
                    int result;
                    Object[] row = ((SortRowsData)this.data).buffer.get(index);
                    if (previousRow != null && (result = ((SortRowsData)this.data).outputRowMeta.compare(row, previousRow, ((SortRowsData)this.data).fieldnrs)) == 0) {
                        duplicates.add(index);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(BaseMessages.getString(PKG, (String)"SortRows.RowLevel.DuplicateRowRemoved", (String[])new String[]{((SortRowsData)this.data).outputRowMeta.getString(row)}));
                        }
                    }
                    previousRow = row;
                }
            }
            ((SortRowsData)this.data).bufferSizes.add(((SortRowsData)this.data).buffer.size() - duplicates.size());
            int duplicatesIndex = 0;
            for (int p = 0; p < ((SortRowsData)this.data).buffer.size(); ++p) {
                boolean skip = false;
                if (duplicatesIndex < duplicates.size() && p == (Integer)duplicates.get(duplicatesIndex)) {
                    skip = true;
                    ++duplicatesIndex;
                }
                if (skip) continue;
                ((SortRowsData)this.data).outputRowMeta.writeData(dos, ((SortRowsData)this.data).buffer.get(p));
            }
            if (((SortRowsData)this.data).sortSize < 0 && ((SortRowsData)this.data).buffer.size() > ((SortRowsData)this.data).minSortSize) {
                ((SortRowsData)this.data).minSortSize = ((SortRowsData)this.data).buffer.size();
                ((SortRowsData)this.data).minSortSize = (int)Math.round((double)((SortRowsData)this.data).minSortSize * 0.9);
            }
            ((SortRowsData)this.data).buffer.clear();
            dos.close();
            if (gzos != null) {
                gzos.close();
            }
            outputStream.close();
            ((SortRowsData)this.data).freeMemoryPct = Const.getPercentageFreeMemory();
            ((SortRowsData)this.data).freeCounter = 0;
            if (((SortRowsData)this.data).sortSize <= 0 && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SortRows.Detailed.AvailableMemory", (Object[])new Object[]{((SortRowsData)this.data).freeMemoryPct}));
            }
        }
        catch (Exception e) {
            throw new HopException("Error processing temp-file!", (Throwable)e);
        }
        ((SortRowsData)this.data).getBufferIndex = 0;
    }

    private DataInputStream getDataInputStream(GZIPInputStream gzipInputStream) {
        DataInputStream result = new DataInputStream(gzipInputStream);
        ((SortRowsData)this.data).gzis.add(gzipInputStream);
        return result;
    }

    Object[] getBuffer() throws HopValueException {
        Object[] retval;
        if (CollectionUtils.isNotEmpty(((SortRowsData)this.data).files) && (((SortRowsData)this.data).dis.isEmpty() || ((SortRowsData)this.data).fis.isEmpty())) {
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"SortRows.Basic.OpeningTempFiles", (Object[])new Object[]{((SortRowsData)this.data).files.size()}));
            }
            try {
                for (int f = 0; f < ((SortRowsData)this.data).files.size() && !this.isStopped(); ++f) {
                    FileObject fileObject = ((SortRowsData)this.data).files.get(f);
                    String filename = HopVfs.getFilename((FileObject)fileObject);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SortRows.Detailed.OpeningTempFile", (String[])new String[]{filename}));
                    }
                    InputStream fi = HopVfs.getInputStream((FileObject)fileObject);
                    ((SortRowsData)this.data).fis.add(fi);
                    DataInputStream di = ((SortRowsData)this.data).compressFiles ? this.getDataInputStream(new GZIPInputStream(new BufferedInputStream(fi))) : new DataInputStream(new BufferedInputStream(fi, 50000));
                    ((SortRowsData)this.data).dis.add(di);
                    int buffersize = ((SortRowsData)this.data).bufferSizes.get(f);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SortRows.Detailed.FromFileExpectingRows", (Object[])new Object[]{filename, buffersize}));
                    }
                    if (buffersize <= 0) continue;
                    Object[] row = ((SortRowsData)this.data).outputRowMeta.readData(di);
                    ((SortRowsData)this.data).rowbuffer.add(row);
                    ((SortRowsData)this.data).tempRows.add(new RowTempFile(row, f));
                }
                Collections.sort(((SortRowsData)this.data).tempRows, ((SortRowsData)this.data).comparator);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SortRows.Error.ErrorReadingBackTempFiles", (String[])new String[0]), e);
            }
        }
        if (((SortRowsData)this.data).files.isEmpty()) {
            if (((SortRowsData)this.data).getBufferIndex < ((SortRowsData)this.data).buffer.size()) {
                retval = ((SortRowsData)this.data).buffer.get(((SortRowsData)this.data).getBufferIndex);
                ++((SortRowsData)this.data).getBufferIndex;
            } else {
                retval = null;
            }
        } else if (((SortRowsData)this.data).rowbuffer.isEmpty()) {
            retval = null;
        } else {
            if (this.log.isRowLevel()) {
                for (int i = 0; i < ((SortRowsData)this.data).rowbuffer.size() && !this.isStopped(); ++i) {
                    Object[] b = ((SortRowsData)this.data).rowbuffer.get(i);
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"SortRows.RowLevel.PrintRow", (Object[])new Object[]{i, ((SortRowsData)this.data).outputRowMeta.getString(b)}));
                }
            }
            RowTempFile rowTempFile = ((SortRowsData)this.data).tempRows.remove(0);
            retval = rowTempFile.row;
            int smallest = rowTempFile.fileNumber;
            FileObject file = ((SortRowsData)this.data).files.get(smallest);
            DataInputStream di = ((SortRowsData)this.data).dis.get(smallest);
            InputStream fi = ((SortRowsData)this.data).fis.get(smallest);
            try {
                Object[] row2 = ((SortRowsData)this.data).outputRowMeta.readData(di);
                RowTempFile extra = new RowTempFile(row2, smallest);
                int index = Collections.binarySearch(((SortRowsData)this.data).tempRows, extra, ((SortRowsData)this.data).comparator);
                if (index < 0) {
                    ((SortRowsData)this.data).tempRows.add(index * -1 - 1, extra);
                } else {
                    ((SortRowsData)this.data).tempRows.add(index, extra);
                }
            }
            catch (HopFileException fe) {
                GZIPInputStream gzfi = ((SortRowsData)this.data).compressFiles ? ((SortRowsData)this.data).gzis.get(smallest) : null;
                try {
                    di.close();
                    fi.close();
                    if (gzfi != null) {
                        gzfi.close();
                    }
                    file.delete();
                }
                catch (IOException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"SortRows.Error.UnableToCloseFile", (Object[])new Object[]{smallest, file.toString()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
                ((SortRowsData)this.data).files.remove(smallest);
                ((SortRowsData)this.data).dis.remove(smallest);
                ((SortRowsData)this.data).fis.remove(smallest);
                if (gzfi != null) {
                    ((SortRowsData)this.data).gzis.remove(smallest);
                }
                for (RowTempFile rtf : ((SortRowsData)this.data).tempRows) {
                    if (rtf.fileNumber <= smallest) continue;
                    --rtf.fileNumber;
                }
            }
            catch (SocketTimeoutException e) {
                throw new HopValueException((Throwable)e);
            }
        }
        return retval;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        List<SortRowsField> groupFields = null;
        if (this.first) {
            int i;
            this.first = false;
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            IRowMeta inputRowMeta = this.getInputRowMeta();
            if (((SortRowsMeta)this.meta).isGroupSortEnabled()) {
                int i2;
                ((SortRowsData)this.data).newBatch = true;
                groupFields = ((SortRowsMeta)this.meta).getGroupFields();
                ((SortRowsData)this.data).groupnrs = new int[groupFields.size()];
                for (i2 = 0; i2 < ((SortRowsData)this.data).groupnrs.length; ++i2) {
                }
                for (i2 = 0; i2 < groupFields.size(); ++i2) {
                    ((SortRowsData)this.data).groupnrs[i2] = inputRowMeta.indexOfValue(groupFields.get(i2).getFieldName());
                    if (((SortRowsData)this.data).groupnrs[i2] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SortRows.Error.PresortedFieldNotFound", (Object[])new Object[]{groupFields.get(i2)}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            String[] fieldNames = new String[((SortRowsMeta)this.meta).getSortFields().size()];
            for (int i3 = 0; i3 < fieldNames.length; ++i3) {
                fieldNames[i3] = ((SortRowsMeta)this.meta).getSortFields().get(i3).getFieldName();
            }
            ((SortRowsData)this.data).fieldnrs = new int[fieldNames.length];
            ArrayList<Integer> toConvert = new ArrayList<Integer>();
            ((SortRowsData)this.data).outputRowMeta = inputRowMeta.clone();
            ((SortRowsMeta)this.meta).getFields(((SortRowsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SortRowsData)this.data).comparator = new RowTemapFileComparator(((SortRowsData)this.data).outputRowMeta, ((SortRowsData)this.data).fieldnrs);
            for (i = 0; i < ((SortRowsMeta)this.meta).getSortFields().size(); ++i) {
                ((SortRowsData)this.data).fieldnrs[i] = inputRowMeta.indexOfValue(((SortRowsMeta)this.meta).getSortFields().get(i).getFieldName());
                if (((SortRowsData)this.data).fieldnrs[i] < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.TransformFieldNotInInputStream", (String[])new String[]{((SortRowsMeta)this.meta).getSortFields().get(i).getFieldName(), this.getTransformName()}));
                }
                if (!inputRowMeta.getValueMeta(((SortRowsData)this.data).fieldnrs[i]).isStorageBinaryString()) continue;
                toConvert.add(((SortRowsData)this.data).fieldnrs[i]);
            }
            ((SortRowsData)this.data).convertKeysToNative = toConvert.isEmpty() ? null : new int[toConvert.size()];
            i = 0;
            for (Integer in : toConvert) {
                ((SortRowsData)this.data).convertKeysToNative[i] = in;
                ++i;
            }
            ((SortRowsData)this.data).rowComparator = new RowObjectArrayComparator(((SortRowsData)this.data).outputRowMeta, ((SortRowsData)this.data).fieldnrs);
        }
        if (r == null) {
            this.preSortBeforeFlush();
            this.passBuffer();
            this.setOutputDone();
            return false;
        }
        if (!((SortRowsMeta)this.meta).isGroupSortEnabled()) {
            this.addBuffer(this.getInputRowMeta(), r);
        } else if (((SortRowsData)this.data).newBatch) {
            ((SortRowsData)this.data).newBatch = false;
            this.setPrevious(r);
            this.addBuffer(this.getInputRowMeta(), r);
        } else if (this.sameGroup(((SortRowsData)this.data).previous, r)) {
            this.addBuffer(this.getInputRowMeta(), r);
        } else {
            this.preSortBeforeFlush();
            this.passBuffer();
            this.setPrevious(r);
            ((SortRowsData)this.data).newBatch = true;
            this.addBuffer(this.getInputRowMeta(), r);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    void passBuffer() throws HopException {
        Object[] r = this.getBuffer();
        Object[] previousRow = null;
        if (this.log.isDebug() && !((SortRowsData)this.data).files.isEmpty()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SortRows.Debug.ExternalMergeStarted", (String[])new String[0]));
        }
        while (r != null && !this.isStopped()) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SortRows.RowLevel.ReadRow", (String[])new String[]{((SortRowsData)this.data).outputRowMeta.getString(r)}));
            }
            if (((SortRowsMeta)this.meta).isOnlyPassingUniqueRows()) {
                if (previousRow != null) {
                    int result = ((SortRowsData)this.data).outputRowMeta.compare(r, previousRow, ((SortRowsData)this.data).fieldnrs);
                    if (result != 0) {
                        this.putRow(((SortRowsData)this.data).outputRowMeta, r);
                    }
                } else {
                    this.putRow(((SortRowsData)this.data).outputRowMeta, r);
                }
                previousRow = r;
            } else {
                this.putRow(((SortRowsData)this.data).outputRowMeta, r);
            }
            r = this.getBuffer();
        }
        if (this.log.isDebug() && !((SortRowsData)this.data).files.isEmpty()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SortRows.Debug.ExternalMergeFinished", (String[])new String[0]));
        }
        this.clearBuffers();
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        ((SortRowsData)this.data).sortSize = Const.toInt((String)this.resolve(((SortRowsMeta)this.meta).getSortSize()), (int)-1);
        ((SortRowsData)this.data).freeMemoryPctLimit = Const.toInt((String)((SortRowsMeta)this.meta).getFreeMemoryLimit(), (int)-1);
        if (((SortRowsData)this.data).sortSize <= 0 && ((SortRowsData)this.data).freeMemoryPctLimit <= 0) {
            ((SortRowsData)this.data).freeMemoryPctLimit = 25;
        }
        ((SortRowsData)this.data).buffer = new ArrayList<Object[]>(5000);
        ((SortRowsData)this.data).rowbuffer = new ArrayList<Object[]>(5000);
        ((SortRowsData)this.data).compressFiles = this.getVariableBoolean(((SortRowsMeta)this.meta).getCompressFilesVariable(), ((SortRowsMeta)this.meta).isCompressFiles());
        ((SortRowsData)this.data).tempRows = new ArrayList<RowTempFile>();
        ((SortRowsData)this.data).minSortSize = 5000;
        return true;
    }

    public void dispose() {
        this.clearBuffers();
        super.dispose();
    }

    private void clearBuffers() {
        ((SortRowsData)this.data).buffer.clear();
        ((SortRowsData)this.data).getBufferIndex = 0;
        ((SortRowsData)this.data).rowbuffer.clear();
        if (CollectionUtils.isNotEmpty(((SortRowsData)this.data).dis)) {
            for (DataInputStream dis : ((SortRowsData)this.data).dis) {
                BaseTransform.closeQuietly((Closeable)dis);
            }
        }
        if (CollectionUtils.isNotEmpty(((SortRowsData)this.data).fis)) {
            for (InputStream is : ((SortRowsData)this.data).fis) {
                BaseTransform.closeQuietly((Closeable)is);
            }
        }
        for (int f = 0; f < ((SortRowsData)this.data).files.size(); ++f) {
            FileObject fileToDelete = ((SortRowsData)this.data).files.get(f);
            try {
                if (fileToDelete == null || !fileToDelete.exists()) continue;
                fileToDelete.delete();
                continue;
            }
            catch (FileSystemException e) {
                this.logError(e.getLocalizedMessage(), e);
            }
        }
    }

    void quickSort(List<Object[]> elements) {
        if (CollectionUtils.isNotEmpty(elements)) {
            Collections.sort(elements, ((SortRowsData)this.data).rowComparator);
            long nrConversions = 0L;
            for (IValueMeta valueMeta : ((SortRowsData)this.data).outputRowMeta.getValueMetaList()) {
                nrConversions += valueMeta.getNumberOfBinaryStringConversions();
                valueMeta.setNumberOfBinaryStringConversions(0L);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SortRows.Detailed.ReportNumberOfBinaryStringConv", (Object[])new Object[]{nrConversions}));
            }
        }
    }

    public void startBundle() throws HopException {
    }

    public void batchComplete() throws HopException {
        if (!((SortRowsData)this.data).isBeamContext()) {
            this.preSortBeforeFlush();
            this.passBuffer();
            this.setOutputDone();
            this.setOutputDone();
        }
    }

    public void finishBundle() throws HopException {
        this.preSortBeforeFlush();
        this.passBuffer();
        this.setOutputDone();
    }

    private void preSortBeforeFlush() throws HopException {
        if (!((SortRowsData)this.data).files.isEmpty()) {
            this.sortExternalRows();
        } else {
            this.quickSort(((SortRowsData)this.data).buffer);
        }
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws HopValueException {
        if (r == null) {
            return false;
        }
        return this.getInputRowMeta().compare(previous, r, ((SortRowsData)this.data).groupnrs) == 0;
    }

    private void setPrevious(Object[] r) throws HopException {
        if (r != null) {
            ((SortRowsData)this.data).previous = this.getInputRowMeta().cloneRow(r);
        }
    }

    private class RowTemapFileComparator
    extends SortRowsComparator
    implements Comparator<RowTempFile> {
        RowTemapFileComparator(IRowMeta rowMeta, int[] fieldNrs) {
            super(rowMeta, fieldNrs);
        }

        @Override
        public int compare(RowTempFile o1, RowTempFile o2) {
            try {
                return this.rowMeta.compare(o1.row, o2.row, this.fieldNrs);
            }
            catch (HopValueException e) {
                SortRows.this.logError("Error comparing rows: " + e.toString());
                return 0;
            }
        }
    }

    private class RowObjectArrayComparator
    extends SortRowsComparator
    implements Comparator<Object[]> {
        RowObjectArrayComparator(IRowMeta rowMeta, int[] fieldNrs) {
            super(rowMeta, fieldNrs);
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            try {
                return this.rowMeta.compare(o1, o2, this.fieldNrs);
            }
            catch (HopValueException e) {
                SortRows.this.logError("Error comparing rows: " + e.toString());
                return 0;
            }
        }
    }

    private class SortRowsComparator {
        protected IRowMeta rowMeta;
        protected int[] fieldNrs;

        SortRowsComparator(IRowMeta rowMeta, int[] fieldNrs) {
            this.rowMeta = rowMeta;
            this.fieldNrs = fieldNrs;
        }
    }
}

