/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.workflowexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutor;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorData;
import org.apache.hop.pipeline.transforms.workflowexecutor.WorkflowExecutorParameters;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.w3c.dom.Node;

@Transform(id="WorkflowExecutor", image="ui/images/workflowexecutor.svg", name="i18n::WorkflowExecutor.Name", description="i18n::WorkflowExecutor.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/workflow-executor.html", keywords={"i18n::WorkflowExecutorMeta.keyword"})
public class WorkflowExecutorMeta
extends BaseTransformMeta<WorkflowExecutor, WorkflowExecutorData> {
    private static final Class<?> PKG = WorkflowExecutorMeta.class;
    public static final String CONST_FILENAME = "filename";
    public static final String CONST_RESULT_ROWS_FIELD = "result_rows_field";
    public static final String CONST_SPACES = "      ";
    private String runConfigurationName;
    private String filename;
    private String groupSize;
    private String groupField;
    private String groupTime;
    private WorkflowExecutorParameters parameters = new WorkflowExecutorParameters();
    private String executionResultTargetTransform;
    private TransformMeta executionResultTargetTransformMeta;
    private String executionTimeField;
    private String executionResultField;
    private String executionNrErrorsField;
    private String executionLinesReadField;
    private String executionLinesWrittenField;
    private String executionLinesInputField;
    private String executionLinesOutputField;
    private String executionLinesRejectedField;
    private String executionLinesUpdatedField;
    private String executionLinesDeletedField;
    private String executionFilesRetrievedField;
    private String executionExitStatusField;
    private String executionLogTextField;
    private String executionLogChannelIdField;
    private String resultRowsTargetTransform;
    private TransformMeta resultRowsTargetTransformMeta;
    private String[] resultRowsField = new String[0];
    private int[] resultRowsType;
    private int[] resultRowsLength;
    private int[] resultRowsPrecision;
    private String resultFilesTargetTransform;
    private TransformMeta resultFilesTargetTransformMeta;
    private String resultFilesFileNameField;
    private IHopMetadataProvider metadataProvider;

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfigurationName));
        retval.append("    ").append(XmlHandler.addTagValue((String)CONST_FILENAME, (String)this.filename));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_size", (String)this.groupSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_field", (String)this.groupField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"group_time", (String)this.groupTime));
        retval.append(this.parameters.getXml());
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_result_target_transform", this.executionResultTargetTransformMeta == null ? null : this.executionResultTargetTransformMeta.getName()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_time_field", (String)this.executionTimeField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_result_field", (String)this.executionResultField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_errors_field", (String)this.executionNrErrorsField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_read_field", (String)this.executionLinesReadField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_written_field", (String)this.executionLinesWrittenField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_input_field", (String)this.executionLinesInputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_output_field", (String)this.executionLinesOutputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_rejected_field", (String)this.executionLinesRejectedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_updated_field", (String)this.executionLinesUpdatedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_lines_deleted_field", (String)this.executionLinesDeletedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_files_retrieved_field", (String)this.executionFilesRetrievedField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_exit_status_field", (String)this.executionExitStatusField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_log_text_field", (String)this.executionLogTextField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execution_log_channelid_field", (String)this.executionLogChannelIdField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"result_rows_target_transform", this.resultRowsTargetTransformMeta == null ? null : this.resultRowsTargetTransformMeta.getName()));
        for (int i = 0; i < this.resultRowsField.length; ++i) {
            retval.append("    ").append(XmlHandler.openTag((String)CONST_RESULT_ROWS_FIELD)).append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.resultRowsField[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.resultRowsType[i])));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"length", (int)this.resultRowsLength[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"precision", (int)this.resultRowsPrecision[i]));
            retval.append("    ").append(XmlHandler.closeTag((String)CONST_RESULT_ROWS_FIELD)).append(Const.CR);
        }
        retval.append("    ").append(XmlHandler.addTagValue((String)"result_files_target_transform", this.resultFilesTargetTransformMeta == null ? null : this.resultFilesTargetTransformMeta.getName()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"result_files_file_name_field", (String)this.resultFilesFileNameField));
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.runConfigurationName = XmlHandler.getTagValue((Node)transformNode, (String)"run_configuration");
            this.filename = XmlHandler.getTagValue((Node)transformNode, (String)CONST_FILENAME);
            this.groupSize = XmlHandler.getTagValue((Node)transformNode, (String)"group_size");
            this.groupField = XmlHandler.getTagValue((Node)transformNode, (String)"group_field");
            this.groupTime = XmlHandler.getTagValue((Node)transformNode, (String)"group_time");
            Node mappingParametersNode = XmlHandler.getSubNode((Node)transformNode, (String)"parameters");
            this.parameters = new WorkflowExecutorParameters(mappingParametersNode);
            this.executionResultTargetTransform = XmlHandler.getTagValue((Node)transformNode, (String)"execution_result_target_transform");
            this.executionTimeField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_time_field");
            this.executionResultField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_result_field");
            this.executionNrErrorsField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_errors_field");
            this.executionLinesReadField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_read_field");
            this.executionLinesWrittenField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_written_field");
            this.executionLinesInputField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_input_field");
            this.executionLinesOutputField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_output_field");
            this.executionLinesRejectedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_rejected_field");
            this.executionLinesUpdatedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_updated_field");
            this.executionLinesDeletedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_lines_deleted_field");
            this.executionFilesRetrievedField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_files_retrieved_field");
            this.executionExitStatusField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_exit_status_field");
            this.executionLogTextField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_log_text_field");
            this.executionLogChannelIdField = XmlHandler.getTagValue((Node)transformNode, (String)"execution_log_channelid_field");
            this.resultRowsTargetTransform = XmlHandler.getTagValue((Node)transformNode, (String)"result_rows_target_transform");
            int nrFields = XmlHandler.countNodes((Node)transformNode, (String)CONST_RESULT_ROWS_FIELD);
            this.resultRowsField = new String[nrFields];
            this.resultRowsType = new int[nrFields];
            this.resultRowsLength = new int[nrFields];
            this.resultRowsPrecision = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)CONST_RESULT_ROWS_FIELD, (int)i);
                this.resultRowsField[i] = XmlHandler.getTagValue((Node)fieldNode, (String)"name");
                this.resultRowsType[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fieldNode, (String)"type"));
                this.resultRowsLength[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fieldNode, (String)"length"), (int)-1);
                this.resultRowsPrecision[i] = Const.toInt((String)XmlHandler.getTagValue((Node)fieldNode, (String)"precision"), (int)-1);
            }
            this.resultFilesTargetTransform = XmlHandler.getTagValue((Node)transformNode, (String)"result_files_target_transform");
            this.resultFilesFileNameField = XmlHandler.getTagValue((Node)transformNode, (String)"result_files_file_name_field");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.Exception.ErrorLoadingJobExecutorDetailsFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.parameters = new WorkflowExecutorParameters();
        this.parameters.setInheritingAllVariables(true);
        this.groupSize = "1";
        this.groupField = "";
        this.groupTime = "";
        this.executionTimeField = "ExecutionTime";
        this.executionResultField = "ExecutionResult";
        this.executionNrErrorsField = "ExecutionNrErrors";
        this.executionLinesReadField = "ExecutionLinesRead";
        this.executionLinesWrittenField = "ExecutionLinesWritten";
        this.executionLinesInputField = "ExecutionLinesInput";
        this.executionLinesOutputField = "ExecutionLinesOutput";
        this.executionLinesRejectedField = "ExecutionLinesRejected";
        this.executionLinesUpdatedField = "ExecutionLinesUpdated";
        this.executionLinesDeletedField = "ExecutionLinesDeleted";
        this.executionFilesRetrievedField = "ExecutionFilesRetrieved";
        this.executionExitStatusField = "ExecutionExitStatus";
        this.executionLogTextField = "ExecutionLogText";
        this.executionLogChannelIdField = "ExecutionLogChannelId";
        this.resultFilesFileNameField = "FileName";
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        row.clear();
        if (nextTransform != null && nextTransform.equals((Object)this.resultRowsTargetTransformMeta)) {
            for (int i = 0; i < this.resultRowsField.length; ++i) {
                ValueMetaNone value;
                try {
                    value = ValueMetaFactory.createValueMeta((String)this.resultRowsField[i], (int)this.resultRowsType[i], (int)this.resultRowsLength[i], (int)this.resultRowsPrecision[i]);
                }
                catch (HopPluginException e) {
                    value = new ValueMetaNone(this.resultRowsField[i]);
                    value.setLength(this.resultRowsLength[i], this.resultRowsPrecision[i]);
                }
                row.addValueMeta((IValueMeta)value);
            }
        } else if (nextTransform != null && nextTransform.equals((Object)this.resultFilesTargetTransformMeta)) {
            if (!Utils.isEmpty((CharSequence)this.resultFilesFileNameField)) {
                ValueMetaString value = new ValueMetaString(CONST_FILENAME, 255, 0);
                row.addValueMeta((IValueMeta)value);
            }
        } else if (nextTransform != null && nextTransform.equals((Object)this.executionResultTargetTransformMeta)) {
            ValueMetaInteger value;
            if (!Utils.isEmpty((CharSequence)this.executionTimeField)) {
                value = new ValueMetaInteger(this.executionTimeField, 15, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionResultField)) {
                value = new ValueMetaBoolean(this.executionResultField);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionNrErrorsField)) {
                value = new ValueMetaInteger(this.executionNrErrorsField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesReadField)) {
                value = new ValueMetaInteger(this.executionLinesReadField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesWrittenField)) {
                value = new ValueMetaInteger(this.executionLinesWrittenField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesInputField)) {
                value = new ValueMetaInteger(this.executionLinesInputField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesOutputField)) {
                value = new ValueMetaInteger(this.executionLinesOutputField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesRejectedField)) {
                value = new ValueMetaInteger(this.executionLinesRejectedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesUpdatedField)) {
                value = new ValueMetaInteger(this.executionLinesUpdatedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLinesDeletedField)) {
                value = new ValueMetaInteger(this.executionLinesDeletedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionFilesRetrievedField)) {
                value = new ValueMetaInteger(this.executionFilesRetrievedField, 9, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionExitStatusField)) {
                value = new ValueMetaInteger(this.executionExitStatusField, 3, 0);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogTextField)) {
                value = new ValueMetaString(this.executionLogTextField);
                value.setLargeTextField(true);
                row.addValueMeta((IValueMeta)value);
            }
            if (!Utils.isEmpty((CharSequence)this.executionLogChannelIdField)) {
                value = new ValueMetaString(this.executionLogChannelIdField, 50, 0);
                row.addValueMeta((IValueMeta)value);
            }
        }
    }

    public String[] getInfoTransforms() {
        String[] infoTransforms = this.getTransformIOMeta().getInfoTransformNames();
        return infoTransforms.length == 0 ? null : infoTransforms;
    }

    public String[] getTargetTransforms() {
        ArrayList<String> targetTransforms = new ArrayList<String>();
        if (!Utils.isEmpty((CharSequence)this.resultFilesTargetTransform)) {
            targetTransforms.add(this.resultFilesTargetTransform);
        }
        if (!Utils.isEmpty((CharSequence)this.resultRowsTargetTransform)) {
            targetTransforms.add(this.resultRowsTargetTransform);
        }
        if (targetTransforms.isEmpty()) {
            return null;
        }
        return targetTransforms.toArray(new String[targetTransforms.size()]);
    }

    public static final synchronized WorkflowMeta loadWorkflowMeta(WorkflowExecutorMeta executorMeta, IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(executorMeta, metadataProvider, variables);
    }

    public static final synchronized WorkflowMeta loadWorkflowMeta(WorkflowExecutorMeta executorMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        WorkflowMeta mappingWorkflowMeta = null;
        CurrentDirectoryResolver r = new CurrentDirectoryResolver();
        IVariables tmpSpace = r.resolveCurrentDirectory(variables, executorMeta.getParentTransformMeta(), executorMeta.getFilename());
        String realFilename = tmpSpace.resolve(executorMeta.getFilename());
        mappingWorkflowMeta = new WorkflowMeta(variables, realFilename, metadataProvider);
        LogChannel.GENERAL.logDetailed("Loaded workflow", new Object[]{"Workflow was loaded from XML file [" + realFilename + "]"});
        mappingWorkflowMeta.setMetadataProvider(metadataProvider);
        mappingWorkflowMeta.setFilename(mappingWorkflowMeta.getFilename());
        return mappingWorkflowMeta;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.NotReceivingAnyFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.TransformReceivingFieldsFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.filename);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        if (StringUtils.isNotEmpty((String)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    WorkflowMeta loadWorkflowMetaProxy(WorkflowExecutorMeta executorMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(executorMeta, metadataProvider, variables);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            WorkflowMeta executorWorkflowMeta = this.loadWorkflowMetaProxy(this, metadataProvider, variables);
            String proposedNewFilename = executorWorkflowMeta.exportResources(variables, definitions, iResourceNaming, metadataProvider);
            String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
            executorWorkflowMeta.setFilename(newFilename);
            this.filename = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.Exception.UnableToLoadWorkflow", (String[])new String[]{this.filename}));
        }
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, true, false, true, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.executionResultTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultRowsTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultRowsStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, this.resultFilesTargetTransformMeta, BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ResultFilesStream.Description", (String[])new String[0]), StreamIcon.TARGET, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void handleStreamSelection(IStream stream) {
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        TransformMeta transform = ((IStream)targets.get(index)).getTransformMeta();
        switch (index) {
            case 0: {
                this.setExecutionResultTargetTransformMeta(transform);
                break;
            }
            case 1: {
                this.setResultRowsTargetTransformMeta(transform);
                break;
            }
            case 2: {
                this.setResultFilesTargetTransformMeta(transform);
                break;
            }
        }
    }

    public void resetTransformIoMeta() {
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.executionResultTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.executionResultTargetTransform);
        this.resultRowsTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultRowsTargetTransform);
        this.resultFilesTargetTransformMeta = TransformMeta.findTransform(transforms, (String)this.resultFilesTargetTransform);
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public WorkflowExecutorParameters getMappingParameters() {
        return this.parameters;
    }

    public void setMappingParameters(WorkflowExecutorParameters mappingParameters) {
        this.parameters = mappingParameters;
    }

    public WorkflowExecutorParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(WorkflowExecutorParameters parameters) {
        this.parameters = parameters;
    }

    public String getExecutionTimeField() {
        return this.executionTimeField;
    }

    public void setExecutionTimeField(String executionTimeField) {
        this.executionTimeField = executionTimeField;
    }

    public String getExecutionResultField() {
        return this.executionResultField;
    }

    public void setExecutionResultField(String executionResultField) {
        this.executionResultField = executionResultField;
    }

    public String getExecutionNrErrorsField() {
        return this.executionNrErrorsField;
    }

    public void setExecutionNrErrorsField(String executionNrErrorsField) {
        this.executionNrErrorsField = executionNrErrorsField;
    }

    public String getExecutionLinesReadField() {
        return this.executionLinesReadField;
    }

    public void setExecutionLinesReadField(String executionLinesReadField) {
        this.executionLinesReadField = executionLinesReadField;
    }

    public String getExecutionLinesWrittenField() {
        return this.executionLinesWrittenField;
    }

    public void setExecutionLinesWrittenField(String executionLinesWrittenField) {
        this.executionLinesWrittenField = executionLinesWrittenField;
    }

    public String getExecutionLinesInputField() {
        return this.executionLinesInputField;
    }

    public void setExecutionLinesInputField(String executionLinesInputField) {
        this.executionLinesInputField = executionLinesInputField;
    }

    public String getExecutionLinesOutputField() {
        return this.executionLinesOutputField;
    }

    public void setExecutionLinesOutputField(String executionLinesOutputField) {
        this.executionLinesOutputField = executionLinesOutputField;
    }

    public String getExecutionLinesRejectedField() {
        return this.executionLinesRejectedField;
    }

    public void setExecutionLinesRejectedField(String executionLinesRejectedField) {
        this.executionLinesRejectedField = executionLinesRejectedField;
    }

    public String getExecutionLinesUpdatedField() {
        return this.executionLinesUpdatedField;
    }

    public void setExecutionLinesUpdatedField(String executionLinesUpdatedField) {
        this.executionLinesUpdatedField = executionLinesUpdatedField;
    }

    public String getExecutionLinesDeletedField() {
        return this.executionLinesDeletedField;
    }

    public void setExecutionLinesDeletedField(String executionLinesDeletedField) {
        this.executionLinesDeletedField = executionLinesDeletedField;
    }

    public String getExecutionFilesRetrievedField() {
        return this.executionFilesRetrievedField;
    }

    public void setExecutionFilesRetrievedField(String executionFilesRetrievedField) {
        this.executionFilesRetrievedField = executionFilesRetrievedField;
    }

    public String getExecutionExitStatusField() {
        return this.executionExitStatusField;
    }

    public void setExecutionExitStatusField(String executionExitStatusField) {
        this.executionExitStatusField = executionExitStatusField;
    }

    public String getExecutionLogTextField() {
        return this.executionLogTextField;
    }

    public void setExecutionLogTextField(String executionLogTextField) {
        this.executionLogTextField = executionLogTextField;
    }

    public String getExecutionLogChannelIdField() {
        return this.executionLogChannelIdField;
    }

    public void setExecutionLogChannelIdField(String executionLogChannelIdField) {
        this.executionLogChannelIdField = executionLogChannelIdField;
    }

    public String getResultRowsTargetTransform() {
        return this.resultRowsTargetTransform;
    }

    public void setResultRowsTargetTransform(String resultRowsTargetTransform) {
        this.resultRowsTargetTransform = resultRowsTargetTransform;
    }

    public String[] getResultRowsField() {
        return this.resultRowsField;
    }

    public void setResultRowsField(String[] resultRowsField) {
        this.resultRowsField = resultRowsField;
    }

    public int[] getResultRowsType() {
        return this.resultRowsType;
    }

    public void setResultRowsType(int[] resultRowsType) {
        this.resultRowsType = resultRowsType;
    }

    public int[] getResultRowsLength() {
        return this.resultRowsLength;
    }

    public void setResultRowsLength(int[] resultRowsLength) {
        this.resultRowsLength = resultRowsLength;
    }

    public int[] getResultRowsPrecision() {
        return this.resultRowsPrecision;
    }

    public void setResultRowsPrecision(int[] resultRowsPrecision) {
        this.resultRowsPrecision = resultRowsPrecision;
    }

    public String getResultFilesTargetTransform() {
        return this.resultFilesTargetTransform;
    }

    public void setResultFilesTargetTransform(String resultFilesTargetTransform) {
        this.resultFilesTargetTransform = resultFilesTargetTransform;
    }

    public TransformMeta getResultRowsTargetTransformMeta() {
        return this.resultRowsTargetTransformMeta;
    }

    public void setResultRowsTargetTransformMeta(TransformMeta resultRowsTargetTransformMeta) {
        this.resultRowsTargetTransformMeta = resultRowsTargetTransformMeta;
    }

    public TransformMeta getResultFilesTargetTransformMeta() {
        return this.resultFilesTargetTransformMeta;
    }

    public void setResultFilesTargetTransformMeta(TransformMeta resultFilesTargetTransformMeta) {
        this.resultFilesTargetTransformMeta = resultFilesTargetTransformMeta;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public String getGroupTime() {
        return this.groupTime;
    }

    public void setGroupTime(String groupTime) {
        this.groupTime = groupTime;
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public String getExecutionResultTargetTransform() {
        return this.executionResultTargetTransform;
    }

    public void setExecutionResultTargetTransform(String executionResultTargetTransform) {
        this.executionResultTargetTransform = executionResultTargetTransform;
    }

    public TransformMeta getExecutionResultTargetTransformMeta() {
        return this.executionResultTargetTransformMeta;
    }

    public void setExecutionResultTargetTransformMeta(TransformMeta executionResultTargetTransformMeta) {
        this.executionResultTargetTransformMeta = executionResultTargetTransformMeta;
    }

    public String getResultFilesFileNameField() {
        return this.resultFilesFileNameField;
    }

    public void setResultFilesFileNameField(String resultFilesFileNameField) {
        this.resultFilesFileNameField = resultFilesFileNameField;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"WorkflowExecutorMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isJobDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isJobDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return WorkflowExecutorMeta.loadWorkflowMeta(this, metadataProvider, variables);
    }

    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public boolean cleanAfterHopFromRemove() {
        this.setExecutionResultTargetTransformMeta(null);
        this.setResultRowsTargetTransformMeta(null);
        this.setResultFilesTargetTransformMeta(null);
        return true;
    }

    public boolean cleanAfterHopFromRemove(TransformMeta toTransform) {
        if (null == toTransform || null == toTransform.getName()) {
            return false;
        }
        boolean hasChanged = false;
        String toTransformName = toTransform.getName();
        if (this.getExecutionResultTargetTransformMeta() != null && toTransformName.equals(this.getExecutionResultTargetTransformMeta().getName())) {
            this.setExecutionResultTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getResultRowsTargetTransformMeta() != null && toTransformName.equals(this.getResultRowsTargetTransformMeta().getName())) {
            this.setResultRowsTargetTransformMeta(null);
            hasChanged = true;
        } else if (this.getResultFilesTargetTransformMeta() != null && toTransformName.equals(this.getResultFilesTargetTransformMeta().getName())) {
            this.setResultFilesTargetTransformMeta(null);
            hasChanged = true;
        }
        return hasChanged;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }
}

