/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.TreeWalker;
import net.sf.saxon.pull.UnconstructedParent;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;

public class PullFromIterator
implements PullProvider {
    private SequenceIterator base;
    private PullProvider treeWalker = null;
    private PipelineConfiguration pipe;
    private int currentEvent = 0;

    public PullFromIterator(SequenceIterator sequenceIterator) {
        this.base = sequenceIterator;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        if (this.treeWalker == null) {
            Item item = this.base.next();
            if (item == null) {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            if (item instanceof UnconstructedParent) {
                this.treeWalker = ((UnconstructedParent)item).getPuller();
                this.treeWalker.setPipelineConfiguration(this.pipe);
                this.currentEvent = this.treeWalker.next();
                return this.currentEvent;
            }
            if (item instanceof AtomicValue) {
                this.currentEvent = 1;
                return this.currentEvent;
            }
            switch (((NodeInfo)item).getNodeKind()) {
                case 3: {
                    this.currentEvent = 8;
                    return this.currentEvent;
                }
                case 8: {
                    this.currentEvent = 9;
                    return this.currentEvent;
                }
                case 7: {
                    this.currentEvent = 10;
                    return this.currentEvent;
                }
                case 2: {
                    this.currentEvent = 6;
                    return this.currentEvent;
                }
                case 13: {
                    this.currentEvent = 7;
                    return this.currentEvent;
                }
                case 1: 
                case 9: {
                    this.treeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                    this.treeWalker.setPipelineConfiguration(this.pipe);
                    this.currentEvent = this.treeWalker.next();
                    return this.currentEvent;
                }
            }
            throw new IllegalStateException();
        }
        int n = this.treeWalker.next();
        if (n == -1) {
            this.treeWalker = null;
            this.currentEvent = this.next();
        } else {
            this.currentEvent = n;
        }
        return this.currentEvent;
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getAttributes();
        }
        throw new IllegalStateException();
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getNamespaceDeclarations();
        }
        throw new IllegalStateException();
    }

    public int skipToMatchingEnd() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.skipToMatchingEnd();
        }
        throw new IllegalStateException();
    }

    public void close() {
        if (this.treeWalker != null) {
            this.treeWalker.close();
        }
    }

    public int getNameCode() {
        if (this.treeWalker != null) {
            return this.treeWalker.getNameCode();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getNameCode();
        }
        throw new IllegalStateException();
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public CharSequence getStringValue() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getStringValue();
        }
        Item item = this.base.current();
        return item.getStringValueCS();
    }

    public AtomicValue getAtomicValue() {
        if (this.currentEvent == 1) {
            return (AtomicValue)this.base.current();
        }
        throw new IllegalStateException();
    }

    public int getTypeAnnotation() {
        if (this.treeWalker != null) {
            return this.treeWalker.getTypeAnnotation();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getTypeAnnotation();
        }
        TypeHierarchy typeHierarchy = this.pipe.getConfiguration().getNamePool().getTypeHierarchy();
        return ((AtomicType)((AtomicValue)item).getItemType(typeHierarchy)).getFingerprint();
    }

    public SourceLocator getSourceLocator() {
        if (this.treeWalker != null) {
            return this.treeWalker.getSourceLocator();
        }
        return null;
    }
}

