/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookup;
import org.apache.hop.pipeline.transforms.databaselookup.DatabaseLookupData;
import org.apache.hop.pipeline.transforms.databaselookup.KeyField;
import org.apache.hop.pipeline.transforms.databaselookup.Lookup;
import org.apache.hop.pipeline.transforms.databaselookup.ReturnValue;

@Transform(id="DBLookup", image="dblookup.svg", name="i18n::DatabaseLookup.Name", description="i18n::DatabaseLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::DatabaseLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/databaselookup.html", actionTransformTypes={ActionTransformType.LOOKUP, ActionTransformType.RDBMS})
public class DatabaseLookupMeta
extends BaseTransformMeta<DatabaseLookup, DatabaseLookupData> {
    private static final Class<?> PKG = DatabaseLookupMeta.class;
    public static final String[] conditionStrings = new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"};
    public static final int CONDITION_EQ = 0;
    public static final int CONDITION_NE = 1;
    public static final int CONDITION_LT = 2;
    public static final int CONDITION_LE = 3;
    public static final int CONDITION_GT = 4;
    public static final int CONDITION_GE = 5;
    public static final int CONDITION_LIKE = 6;
    public static final int CONDITION_BETWEEN = 7;
    public static final int CONDITION_IS_NULL = 8;
    public static final int CONDITION_IS_NOT_NULL = 9;
    @HopMetadataProperty(injectionKeyDescription="DatabaseLookupMeta.Injection.Connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="cache", injectionKeyDescription="DatabaseLookupMeta.Injection.Cache")
    private boolean cached;
    @HopMetadataProperty(key="cache_size", injectionKeyDescription="DatabaseLookupMeta.Injection.CacheSize")
    private int cacheSize;
    @HopMetadataProperty(key="cache_load_all", injectionKeyDescription="DatabaseLookupMeta.Injection.CacheLoadAll")
    private boolean loadingAllDataInCache;
    @HopMetadataProperty(key="lookup")
    private Lookup lookup;

    public DatabaseLookupMeta() {
        this.lookup = new Lookup();
    }

    public DatabaseLookupMeta(DatabaseLookupMeta m) {
        this.cached = m.cached;
        this.cacheSize = m.cacheSize;
        this.loadingAllDataInCache = m.loadingAllDataInCache;
        this.lookup = new Lookup(m.lookup);
    }

    public DatabaseLookupMeta clone() {
        return new DatabaseLookupMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (Utils.isEmpty((Object[])info) || info[0] == null) {
            for (ReturnValue returnValue : this.lookup.getReturnValues()) {
                try {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)(!Utils.isEmpty((CharSequence)returnValue.getNewName()) ? returnValue.getNewName() : returnValue.getTableField()), (int)ValueMetaFactory.getIdForValueMeta((String)returnValue.getDefaultType()));
                    v.setOrigin(name);
                    row.addValueMeta(v);
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        } else {
            for (ReturnValue returnValue : this.lookup.getReturnValues()) {
                IValueMeta v = info[0].searchValueMeta(returnValue.getTableField());
                if (v == null) continue;
                IValueMeta copy = v.clone();
                copy.setName(!Utils.isEmpty((CharSequence)returnValue.getNewName()) ? returnValue.getNewName() : returnValue.getTableField());
                copy.setOrigin(name);
                row.addValueMeta(copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        Database db = null;
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (databaseMeta != null) {
                boolean errorFound;
                boolean first;
                db = new Database(loggingObject, variables, databaseMeta);
                this.databases = new Database[]{db};
                db.connect();
                List<KeyField> keyFields = this.lookup.getKeyFields();
                if (!Utils.isEmpty((CharSequence)this.lookup.getTableName())) {
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookup.getSchemaName(), this.lookup.getTableName());
                    IRowMeta r = db.getTableFields(schemaTable);
                    if (r != null) {
                        for (int i = 0; i < keyFields.size(); ++i) {
                            KeyField keyField = keyFields.get(i);
                            String luField = keyField.getTableField();
                            IValueMeta v = r.searchValueMeta(luField);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingCompareFieldsInLookupTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + luField + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllLookupFieldsFoundInTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        List<ReturnValue> returnValues = this.lookup.getReturnValues();
                        for (int i = 0; i < returnValues.size(); ++i) {
                            ReturnValue returnValue = returnValues.get(i);
                            String luField = returnValue.getTableField();
                            IValueMeta v = r.searchValueMeta(luField);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingReturnFieldsInLookupTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + luField + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllReturnFieldsFoundInTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (int i = 0; i < keyFields.size(); ++i) {
                        KeyField keyField = keyFields.get(i);
                        IValueMeta v = prev.searchValueMeta(keyField.getStreamField1());
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingFieldsNotFoundInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + keyField.getStreamField1() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.CouldNotReadFromPreviousTransforms", (String[])new String[0]) + Const.CR;
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.MissingConnectionError", (String[])new String[0]);
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        catch (HopException dbe) {
            errorMessage = BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.DatabaseErrorWhileChecking", (String[])new String[0]) + dbe.getMessage();
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        finally {
            db.disconnect();
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.TransformIsReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Check.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getTableFields(IVariables variables) {
        IRowMeta fields = null;
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.lookup.getSchemaName(), this.lookup.getTableName());
                fields = db.getTableFields(schemaTable);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.ERROR0004.ErrorGettingTableFields", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = null;
        try {
            DatabaseImpact ii;
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            List<KeyField> keyFields = this.lookup.getKeyFields();
            for (int i = 0; i < keyFields.size(); ++i) {
                KeyField keyField = keyFields.get(i);
                IValueMeta v = prev.searchValueMeta(keyField.getStreamField1());
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transforminfo.getName(), databaseMeta.getDatabaseName(), this.lookup.getTableName(), keyField.getTableField(), keyField.getStreamField1(), v != null ? v.getOrigin() : "?", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.Key", (String[])new String[0]));
                impact.add(ii);
            }
            List<ReturnValue> returnValues = this.lookup.getReturnValues();
            for (int i = 0; i < returnValues.size(); ++i) {
                ReturnValue returnValue = returnValues.get(i);
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transforminfo.getName(), databaseMeta.getDatabaseName(), this.lookup.getTableName(), returnValue.getTableField(), "", "", "", BaseMessages.getString(PKG, (String)"DatabaseLookupMeta.Impact.ReturnValue", (String[])new String[0]));
                impact.add(ii);
            }
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection));
        }
    }

    public String getTableName() {
        return this.lookup.getTableName();
    }

    public String getSchemaName() {
        return this.lookup.getSchemaName();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isLoadingAllDataInCache() {
        return this.loadingAllDataInCache;
    }

    public void setLoadingAllDataInCache(boolean loadingAllDataInCache) {
        this.loadingAllDataInCache = loadingAllDataInCache;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void setLookup(Lookup lookup) {
        this.lookup = lookup;
    }
}

