/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.orabulkloader;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoader;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderData;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMappingMeta;

@Transform(id="OraBulkLoader", image="orabulkloader.svg", description="i18n::OraBulkLoader.Description", name="i18n::OraBulkLoader.Name", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Bulk", keywords={"i18n::OraBulkLoader.Keywords"}, documentationUrl="/pipeline/transforms/orabulkloader.html")
public class OraBulkLoaderMeta
extends BaseTransformMeta<OraBulkLoader, OraBulkLoaderData> {
    private static final Class<?> PKG = OraBulkLoaderMeta.class;
    private static final int DEFAULT_COMMIT_SIZE = 100000;
    private static final int DEFAULT_BIND_SIZE = 0;
    private static final int DEFAULT_READ_SIZE = 0;
    private static final int DEFAULT_MAX_ERRORS = 50;
    @HopMetadataProperty(key="connection", injectionKeyDescription="OraBulkLoader.Injection.Connection")
    private String connection;
    @HopMetadataProperty(key="shema", injectionKey="SCHEMA_NAME", injectionKeyDescription="OraBulkLoader.Injection.Schema")
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKey="TABLE_NAME", injectionKeyDescription="OraBulkLoader.Injection.Table")
    private String tableName;
    @HopMetadataProperty(key="sqlldr", injectionKey="SQLLDR_PATH", injectionKeyDescription="OraBulkLoader.Injection.Sqlldr")
    private String sqlldr;
    @HopMetadataProperty(key="control_file", injectionKey="CONTROL_FILE", injectionKeyDescription="OraBulkLoader.Injection.ControlFile")
    private String controlFile;
    @HopMetadataProperty(key="data_file", injectionKey="DATA_FILE", injectionKeyDescription="OraBulkLoader.Injection.DataFile")
    private String dataFile;
    @HopMetadataProperty(key="log_file", injectionKey="LOG_FILE", injectionKeyDescription="OraBulkLoader.Injection.LogFile")
    private String logFile;
    @HopMetadataProperty(key="bad_file", injectionKey="BAD_FILE", injectionKeyDescription="OraBulkLoader.Injection.BadFile")
    private String badFile;
    @HopMetadataProperty(key="discard_file", injectionKey="DISCARD_FILE", injectionKeyDescription="OraBulkLoader.Injection.DiscardFile")
    private String discardFile;
    @HopMetadataProperty(key="commit", injectionKey="COMMIT_SIZE", injectionKeyDescription="OraBulkLoader.Injection.CommitSize")
    private String commitSize;
    @HopMetadataProperty(key="bind_size", injectionKey="BIND_SIZE", injectionKeyDescription="OraBulkLoader.Injection.BindSize")
    private String bindSize;
    @HopMetadataProperty(key="read_size", injectionKey="READ_SIZE", injectionKeyDescription="OraBulkLoader.Injection.ReadSize")
    private String readSize;
    @HopMetadataProperty(key="errors", injectionKey="MAX_ERRORS", injectionKeyDescription="OraBulkLoader.Injection.MaxErros")
    private String maxErrors;
    @HopMetadataProperty(key="load_method", injectionKey="LOAD_METHOD", injectionKeyDescription="OraBulkLoader.Injection.LoadMethod")
    private String loadMethod;
    @HopMetadataProperty(key="load_action", injectionKey="LOAD_ACTION", injectionKeyDescription="OraBulkLoader.Injection.LoadAction")
    private String loadAction;
    @HopMetadataProperty(key="encoding", injectionKey="ENCODING", injectionKeyDescription="OraBulkLoader.Injection.Encoding")
    private String encoding;
    @HopMetadataProperty(key="character_set", injectionKey="ORACLE_CHARSET_NAME", injectionKeyDescription="OraBulkLoader.Injection.CharacterSet")
    private String characterSetName;
    @HopMetadataProperty(key="direct_path", injectionKey="DIRECT_PATH", injectionKeyDescription="OraBulkLoader.Injection.DirectPath")
    private boolean directPath;
    @HopMetadataProperty(key="erase_files", injectionKey="ERASE_FILES", injectionKeyDescription="OraBulkLoader.Injection.EraseFiles")
    private boolean eraseFiles;
    @HopMetadataProperty(key="fail_on_warning", injectionKey="FAIL_ON_WARNING", injectionKeyDescription="OraBulkLoader.Injection.FailOnWarning")
    private boolean failOnWarning;
    @HopMetadataProperty(key="fail_on_error", injectionKey="FAIL_ON_ERROR", injectionKeyDescription="OraBulkLoader.Injection.FailOnError")
    private boolean failOnError;
    @HopMetadataProperty(key="parallel", injectionKey="PARALLEL", injectionKeyDescription="OraBulkLoader.Injection.Parallel")
    private boolean parallel;
    @HopMetadataProperty(key="alt_rec_term", injectionKey="RECORD_TERMINATOR", injectionKeyDescription="OraBulkLoader.Injection.RecordTerminator")
    private String altRecordTerm;
    @HopMetadataProperty(key="mapping", injectionGroupKey="DATABASE_FIELDS", injectionGroupDescription="OraBulkLoader.Injection.Mapping")
    private List<OraBulkLoaderMappingMeta> mappings;
    public static final String ACTION_APPEND = "APPEND";
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_REPLACE = "REPLACE";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String METHOD_AUTO_CONCURRENT = "AUTO_CONCURRENT";
    public static final String METHOD_AUTO_END = "AUTO_END";
    public static final String METHOD_MANUAL = "MANUAL";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";

    public int getCommitSizeAsInt(IVariables variables) {
        try {
            return Integer.valueOf(variables.resolve(this.getCommitSize()));
        }
        catch (NumberFormatException ex) {
            return 100000;
        }
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSqlldr() {
        return this.sqlldr;
    }

    public void setSqlldr(String sqlldr) {
        this.sqlldr = sqlldr;
    }

    public List<OraBulkLoaderMappingMeta> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<OraBulkLoaderMappingMeta> mappings) {
        this.mappings = mappings;
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getAltRecordTerm() {
        return this.altRecordTerm;
    }

    public void setAltRecordTerm(String altRecordTerm) {
        this.altRecordTerm = altRecordTerm;
    }

    public void setDefault() {
        this.connection = null;
        this.commitSize = Integer.toString(100000);
        this.bindSize = Integer.toString(0);
        this.readSize = Integer.toString(0);
        this.maxErrors = Integer.toString(50);
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.loadMethod = METHOD_AUTO_END;
        this.loadAction = ACTION_APPEND;
        this.sqlldr = "sqlldr";
        this.controlFile = "control${Internal.Transform.CopyNr}.cfg";
        this.dataFile = "load${Internal.Transform.CopyNr}.dat";
        this.logFile = "";
        this.badFile = "";
        this.discardFile = "";
        this.encoding = "";
        this.directPath = false;
        this.eraseFiles = true;
        this.characterSetName = "";
        this.failOnWarning = false;
        this.failOnError = false;
        this.parallel = false;
        this.altRecordTerm = "";
        this.mappings = new ArrayList<OraBulkLoaderMappingMeta>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, variables, databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    IRowMeta rowMeta = db.getTableFields(schemaTable);
                    if (rowMeta != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (int i = 0; i < this.mappings.size(); ++i) {
                            String field = this.mappings.get(i).getFieldTable();
                            IValueMeta v = rowMeta.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = (String)errorMessage + "\t\t" + field + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (int i = 0; i < this.mappings.size(); ++i) {
                        IValueMeta valueMeta = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                        if (valueMeta != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = (String)errorMessage + "\t\t" + this.mappings.get(i).getFieldStream() + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block11: {
            DatabaseMeta databaseMeta = pipelineMeta.findDatabase(this.connection, variables);
            retval = new SqlStatement(transformMeta.getName(), databaseMeta, null);
            if (databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.mappings.size(); ++i) {
                        IValueMeta v = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                        if (v == null) {
                            throw new HopTransformException("Unable to find field [" + this.mappings.get(i).getFieldTable() + "] in the input rows");
                        }
                        IValueMeta tableField = v.clone();
                        tableField.setName(this.mappings.get(i).getFieldTable());
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, variables, databaseMeta);
                        try {
                            db.connect();
                            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            String sql = db.getDDL(schemaTable, (IRowMeta)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSql(null);
                                break block11;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (prev != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                IValueMeta valueMeta = prev.searchValueMeta(this.mappings.get(i).getFieldStream());
                DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), variables.resolve(this.tableName), this.mappings.get(i).getFieldTable(), this.mappings.get(i).getFieldStream(), valueMeta != null ? valueMeta.getOrigin() : "?", "", "Type = " + valueMeta.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public boolean isDirectPath() {
        return this.directPath;
    }

    public void setDirectPath(boolean directPath) {
        this.directPath = directPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        DatabaseMeta databaseMeta = this.getParentTransformMeta().getParentPipelineMeta().findDatabase(this.connection, variables);
        if (databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database database = new Database(loggingObject, variables, databaseMeta);
        try {
            database.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(variables, realSchemaName, realTableName);
            if (database.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = database.getTableFields(schemaTable);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            database.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getBadFile() {
        return this.badFile;
    }

    public void setBadFile(String badFile) {
        this.badFile = badFile;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getDiscardFile() {
        return this.discardFile;
    }

    public void setDiscardFile(String discardFile) {
        this.discardFile = discardFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public void setLoadMethod(String method) {
        this.loadMethod = method;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ",";
    }

    public String getEnclosure() {
        return "\"";
    }

    public boolean isEraseFiles() {
        return this.eraseFiles;
    }

    public void setEraseFiles(boolean eraseFiles) {
        this.eraseFiles = eraseFiles;
    }

    public int getBindSizeAsInt(IVariables variables) {
        try {
            return Integer.valueOf(variables.resolve(this.getBindSize()));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public String getBindSize() {
        return this.bindSize;
    }

    public void setBindSize(String bindSize) {
        this.bindSize = bindSize;
    }

    public int getMaxErrorsAsInt(IVariables variables) {
        try {
            return Integer.valueOf(variables.resolve(this.getMaxErrors()));
        }
        catch (NumberFormatException ex) {
            return 50;
        }
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public int getReadSizeAsInt(IVariables variables) {
        try {
            return Integer.valueOf(variables.resolve(this.getReadSize()));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public String getReadSize() {
        return this.readSize;
    }

    public void setReadSize(String readSize) {
        this.readSize = readSize;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }
}

