/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.shaded.dev.failsafe.internal;

import java.util.concurrent.CompletableFuture;
import software.amazon.s3.shaded.dev.failsafe.ExecutionContext;
import software.amazon.s3.shaded.dev.failsafe.Fallback;
import software.amazon.s3.shaded.dev.failsafe.FallbackConfig;
import software.amazon.s3.shaded.dev.failsafe.event.ExecutionAttemptedEvent;
import software.amazon.s3.shaded.dev.failsafe.internal.FallbackExecutor;
import software.amazon.s3.shaded.dev.failsafe.spi.FailurePolicy;
import software.amazon.s3.shaded.dev.failsafe.spi.PolicyExecutor;

public class FallbackImpl<R>
implements Fallback<R>,
FailurePolicy<R> {
    public static Fallback<Void> NONE = Fallback.builder(() -> null).build();
    private final FallbackConfig<R> config;

    public FallbackImpl(FallbackConfig<R> config) {
        this.config = config;
    }

    @Override
    public FallbackConfig<R> getConfig() {
        return this.config;
    }

    protected R apply(R result, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, exception, context);
        return this.config.getFallback() != null ? this.config.getFallback().apply(event) : this.config.getFallbackStage().apply(event).get();
    }

    protected CompletableFuture<R> applyStage(R result, Throwable exception, ExecutionContext<R> context) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, exception, context);
        return this.config.getFallback() != null ? CompletableFuture.completedFuture(this.config.getFallback().apply(event)) : this.config.getFallbackStage().apply(event);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new FallbackExecutor(this, policyIndex);
    }
}

