/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.request.Range;

public class IOPlan {
    private final ArrayList<Range> prefetchRanges;
    public static final IOPlan EMPTY_PLAN = new IOPlan(Collections.emptyList());

    public IOPlan(@NonNull Range prefetchRange) {
        if (prefetchRange == null) {
            throw new NullPointerException("prefetchRange is marked non-null but is null");
        }
        this.prefetchRanges = new ArrayList(1);
        this.prefetchRanges.add(prefetchRange);
    }

    public IOPlan(@NonNull Collection<Range> prefetchRanges) {
        if (prefetchRanges == null) {
            throw new NullPointerException("prefetchRanges is marked non-null but is null");
        }
        this.prefetchRanges = new ArrayList<Range>(prefetchRanges);
    }

    public String toString() {
        return "[" + this.prefetchRanges.stream().map(Range::toString).collect(Collectors.joining(",")) + "]";
    }

    public void coalesce(long tolerance) {
        if (this.prefetchRanges.size() < 2) {
            return;
        }
        Collections.sort(this.prefetchRanges);
        int writeIndex = 0;
        Range currentRange = this.prefetchRanges.get(0);
        for (int i = 1; i < this.prefetchRanges.size(); ++i) {
            Range nextRange = this.prefetchRanges.get(i);
            if (currentRange.getEnd() + tolerance >= nextRange.getStart()) {
                currentRange = new Range(currentRange.getStart(), Math.max(currentRange.getEnd(), nextRange.getEnd()));
                continue;
            }
            this.prefetchRanges.set(writeIndex++, currentRange);
            currentRange = nextRange;
        }
        this.prefetchRanges.set(writeIndex++, currentRange);
        while (this.prefetchRanges.size() > writeIndex) {
            this.prefetchRanges.remove(this.prefetchRanges.size() - 1);
        }
    }

    @Generated
    public ArrayList<Range> getPrefetchRanges() {
        return this.prefetchRanges;
    }
}

