/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class BaseAuthorizationTokenProvider
implements AuthorizationTokenProvider {
    private static final String AUTH_PREFIX = "type=master&ver=1.0&sig=";
    private final String masterKey;
    private final Mac macInstance;

    public BaseAuthorizationTokenProvider(String masterKey) {
        this.masterKey = masterKey;
        byte[] masterKeyDecodedBytes = Utils.Base64Decoder.decode(this.masterKey.getBytes());
        SecretKeySpec signingKey = new SecretKeySpec(masterKeyDecodedBytes, "HMACSHA256");
        try {
            this.macInstance = Mac.getInstance("HMACSHA256");
            this.macInstance.init(signingKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getResourceSegment(ResourceType resourceType) {
        switch (resourceType) {
            case Attachment: {
                return "attachments";
            }
            case Database: {
                return "dbs";
            }
            case Conflict: {
                return "conflicts";
            }
            case Document: {
                return "docs";
            }
            case DocumentCollection: {
                return "colls";
            }
            case Offer: {
                return "offers";
            }
            case Permission: {
                return "permissions";
            }
            case StoredProcedure: {
                return "sprocs";
            }
            case Trigger: {
                return "triggers";
            }
            case UserDefinedFunction: {
                return "udfs";
            }
            case User: {
                return "users";
            }
            case PartitionKeyRange: {
                return "pkranges";
            }
            case Media: {
                return "media";
            }
            case DatabaseAccount: {
                return "";
            }
        }
        return null;
    }

    @Override
    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers) {
        return this.generateKeyAuthorizationSignature(verb, resourceIdOrFullName, BaseAuthorizationTokenProvider.getResourceSegment(resourceType).toLowerCase(), headers);
    }

    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, String resourceSegment, Map<String, String> headers) {
        if (verb == null || verb.isEmpty()) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceSegment == null) {
            throw new IllegalArgumentException("resourceSegment");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (this.masterKey == null || this.masterKey.isEmpty()) {
            throw new IllegalArgumentException("masterKey");
        }
        if (!PathsHelper.isNameBased((String)resourceIdOrFullName)) {
            resourceIdOrFullName = resourceIdOrFullName.toLowerCase(Locale.ROOT);
        }
        StringBuilder body = new StringBuilder();
        body.append(verb.toLowerCase()).append('\n').append(resourceSegment).append('\n').append(resourceIdOrFullName).append('\n');
        if (headers.containsKey("x-ms-date")) {
            body.append(headers.get("x-ms-date").toLowerCase());
        }
        body.append('\n');
        if (headers.containsKey("date")) {
            body.append(headers.get("date").toLowerCase());
        }
        body.append('\n');
        Mac mac = null;
        try {
            mac = (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = mac.doFinal(body.toString().getBytes());
        String auth = Utils.encodeBase64String((byte[])digest);
        return AUTH_PREFIX + auth;
    }

    @Override
    public String getAuthorizationTokenUsingResourceTokens(Map<String, String> resourceTokens, String path, String resourceId) {
        if (resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (resourceTokens.containsKey(resourceId) && resourceTokens.get(resourceId) != null) {
            resourceToken = resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)resourceId)) {
            if (resourceTokens.size() > 0) {
                resourceToken = resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet resourceTypesSet = new HashSet();
            Collections.addAll(resourceTypesSet, resourceTypes);
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }

    public String generateKeyAuthorizationSignature(String verb, URI uri, Map<String, String> headers) {
        if (StringUtils.isEmpty((CharSequence)verb)) {
            throw new IllegalArgumentException(String.format("String agument %s is null or empty", "verb"));
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        PathInfo pathInfo = new PathInfo(false, "", "", false);
        this.getResourceTypeAndIdOrFullName(uri, pathInfo);
        return this.generateKeyAuthorizationSignatureNew(verb, pathInfo.resourceIdOrFullName, pathInfo.resourcePath, headers);
    }

    public String generateKeyAuthorizationSignatureNew(String verb, String resourceIdValue, String resourceType, Map<String, String> headers) {
        if (StringUtils.isEmpty((CharSequence)verb)) {
            throw new IllegalArgumentException(String.format("String agument %s is null or empty", "verb"));
        }
        if (resourceType == null) {
            throw new IllegalArgumentException(String.format("String agument %s is null or empty", "resourceType"));
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        String verbInput = verb;
        String resourceIdInput = resourceIdValue;
        String resourceTypeInput = resourceType;
        String authResourceId = this.getAuthorizationResourceIdOrFullName(resourceTypeInput, resourceIdInput);
        String payLoad = this.generateMessagePayload(verbInput, authResourceId, resourceTypeInput, headers);
        Mac mac = null;
        try {
            mac = (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = mac.doFinal(payLoad.getBytes());
        String authorizationToken = Utils.encodeBase64String((byte[])digest);
        String authtoken = AUTH_PREFIX + authorizationToken;
        return HttpUtils.urlEncode((String)authtoken);
    }

    private String generateMessagePayload(String verb, String resourceId, String resourceType, Map<String, String> headers) {
        String xDate = headers.get("x-ms-date");
        String date = headers.get("date");
        if (StringUtils.isEmpty((CharSequence)xDate) && (StringUtils.isEmpty((CharSequence)date) || StringUtils.isWhitespace((CharSequence)date))) {
            headers.put("x-ms-date", Utils.nowAsRFC1123());
            xDate = Utils.nowAsRFC1123();
        }
        if (!PathsHelper.isNameBased((String)resourceId)) {
            resourceId = resourceId.toLowerCase();
        }
        StringBuilder payload = new StringBuilder();
        payload.append(verb.toLowerCase()).append('\n').append(resourceType.toLowerCase()).append('\n').append(resourceId).append('\n').append(xDate.toLowerCase()).append('\n').append(StringUtils.isEmpty((CharSequence)xDate) ? date.toLowerCase() : "").append('\n');
        return payload.toString();
    }

    private String getAuthorizationResourceIdOrFullName(String resourceType, String resourceIdOrFullName) {
        if (StringUtils.isEmpty((CharSequence)resourceType) || StringUtils.isEmpty((CharSequence)resourceIdOrFullName)) {
            return resourceIdOrFullName;
        }
        if (PathsHelper.isNameBased((String)resourceIdOrFullName)) {
            return resourceIdOrFullName;
        }
        if (resourceType.equalsIgnoreCase("offers") || resourceType.equalsIgnoreCase("partitions") || resourceType.equalsIgnoreCase("topology") || resourceType.equalsIgnoreCase("ridranges")) {
            return resourceIdOrFullName;
        }
        ResourceId parsedRId = ResourceId.parse((String)resourceIdOrFullName);
        if (resourceType.equalsIgnoreCase("dbs")) {
            return parsedRId.getDatabaseId().toString();
        }
        if (resourceType.equalsIgnoreCase("users")) {
            return parsedRId.getUserId().toString();
        }
        if (resourceType.equalsIgnoreCase("colls")) {
            return parsedRId.getDocumentCollectionId().toString();
        }
        if (resourceType.equalsIgnoreCase("docs")) {
            return parsedRId.getDocumentId().toString();
        }
        return resourceIdOrFullName;
    }

    private void getResourceTypeAndIdOrFullName(URI uri, PathInfo pathInfo) {
        if (uri == null) {
            throw new IllegalArgumentException("uri");
        }
        pathInfo.resourcePath = "";
        pathInfo.resourceIdOrFullName = "";
        String[] segments = StringUtils.split((String)uri.toString(), (String)"/");
        if (segments == null || segments.length < 1) {
            throw new IllegalArgumentException("InvalidUrl");
        }
        String pathAndQuery = "";
        if (StringUtils.isNotEmpty((CharSequence)uri.getPath())) {
            pathAndQuery = pathAndQuery + uri.getPath();
        }
        if (StringUtils.isNotEmpty((CharSequence)uri.getQuery())) {
            pathAndQuery = pathAndQuery + "?";
            pathAndQuery = pathAndQuery + uri.getQuery();
        }
        if (!PathsHelper.tryParsePathSegments((String)pathAndQuery, (PathInfo)pathInfo, null)) {
            pathInfo.resourcePath = "";
            pathInfo.resourceIdOrFullName = "";
        }
    }
}

