/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.LightWeightCache;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRetryCacheWithHA {
    private static final Logger LOG = LoggerFactory.getLogger(TestRetryCacheWithHA.class);
    private static final int BlockSize = 1024;
    private static ErasureCodingPolicy defaultEcPolicy = SystemErasureCodingPolicies.getByID((byte)1);
    private static final short DataNodes = (short)(defaultEcPolicy.getNumDataUnits() + defaultEcPolicy.getNumParityUnits() + 1);
    private static final int CHECKTIMES = 10;
    private static final int ResponseSize = 3;
    @Rule
    public TemporaryFolder baseDir = new TemporaryFolder();
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private final Configuration conf = new HdfsConfiguration();

    @Before
    public void setup() throws Exception {
        this.conf.setLong("dfs.blocksize", 1024L);
        this.conf.setInt("dfs.namenode.list.cache.directives.num.responses", 3);
        this.conf.setInt("dfs.namenode.list.cache.pools.num.responses", 3);
        this.conf.setBoolean("dfs.namenode.acls.enabled", true);
        this.conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf, this.baseDir.getRoot()).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(DataNodes).build();
        this.cluster.waitActive();
        this.cluster.transitionToActive(0);
        HATestUtil.setFailoverConfigurations(this.cluster, this.conf);
        this.dfs = HATestUtil.configureFailoverFs(this.cluster, this.conf);
    }

    @After
    public void cleanup() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testRetryCacheOnStandbyNN() throws Exception {
        DFSTestUtil.runOperations(this.cluster, this.dfs, this.conf, 1024L, 0);
        FSNamesystem fsn0 = this.cluster.getNamesystem(0);
        LightWeightCache cacheSet = (LightWeightCache)fsn0.getRetryCache().getCacheSet();
        Assert.assertEquals((String)"Retry cache size is wrong", (long)39L, (long)cacheSet.size());
        HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry> oldEntries = new HashMap<RetryCache.CacheEntry, RetryCache.CacheEntry>();
        for (RetryCache.CacheEntry entry : cacheSet) {
            oldEntries.put(entry, entry);
        }
        this.cluster.getNameNode(0).getRpcServer().rollEditLog();
        this.cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
        this.cluster.shutdownNameNode(0);
        this.cluster.transitionToActive(1);
        FSNamesystem fsn1 = this.cluster.getNamesystem(1);
        cacheSet = (LightWeightCache)fsn1.getRetryCache().getCacheSet();
        Assert.assertEquals((String)"Retry cache size is wrong", (long)39L, (long)cacheSet.size());
        for (RetryCache.CacheEntry entry : cacheSet) {
            Assert.assertTrue((boolean)oldEntries.containsKey(entry));
        }
    }

    private DFSClient genClientWithDummyHandler() throws IOException {
        URI nnUri = this.dfs.getUri();
        AbstractNNFailoverProxyProvider failoverProxyProvider = NameNodeProxiesClient.createFailoverProxyProvider((Configuration)this.conf, (URI)nnUri, ClientProtocol.class, (boolean)true, null);
        DummyRetryInvocationHandler dummyHandler = new DummyRetryInvocationHandler((FailoverProxyProvider<ClientProtocol>)failoverProxyProvider, RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)Integer.MAX_VALUE, (long)500L, (long)15000L));
        ClientProtocol proxy = (ClientProtocol)Proxy.newProxyInstance(failoverProxyProvider.getInterface().getClassLoader(), new Class[]{ClientProtocol.class}, (InvocationHandler)((Object)dummyHandler));
        DFSClient client = new DFSClient(null, proxy, this.conf, null);
        return client;
    }

    @Test(timeout=60000L)
    public void testCreateSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateSnapshotOp op = new CreateSnapshotOp(client, "/test", "s1");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testDeleteSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        DeleteSnapshotOp op = new DeleteSnapshotOp(client, "/test", "s1");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRenameSnapshot() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RenameSnapshotOp op = new RenameSnapshotOp(client, "/test", "s1", "s2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testCreate() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateOp op = new CreateOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testAppend() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        AppendOp op = new AppendOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRename() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RenameOp op = new RenameOp(client, "/file1", "/file2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRename2() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        Rename2Op op = new Rename2Op(client, "/file1", "/file2");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testConcat() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        ConcatOp op = new ConcatOp(client, new Path("/test/file"), 5);
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testDelete() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        DeleteOp op = new DeleteOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testCreateSymlink() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        CreateSymlinkOp op = new CreateSymlinkOp(client, "/testfile", "/testlink");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testUpdatePipeline() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        UpdatePipelineOp op = new UpdatePipelineOp(client, "/testfile");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testAddCacheDirectiveInfo() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        AddCacheDirectiveInfoOp op = new AddCacheDirectiveInfoOp(client, new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/path")).build());
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testModifyCacheDirectiveInfo() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        ModifyCacheDirectiveInfoOp op = new ModifyCacheDirectiveInfoOp(client, new CacheDirectiveInfo.Builder().setPool("pool").setPath(new Path("/path")).setReplication(Short.valueOf((short)1)).build(), 555);
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRemoveCacheDescriptor() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RemoveCacheDirectiveInfoOp op = new RemoveCacheDirectiveInfoOp(client, "pool", "/path");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testAddCachePool() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        AddCachePoolOp op = new AddCachePoolOp(client, "pool");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testModifyCachePool() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        ModifyCachePoolOp op = new ModifyCachePoolOp(client, "pool");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRemoveCachePool() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RemoveCachePoolOp op = new RemoveCachePoolOp(client, "pool");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testSetXAttr() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        SetXAttrOp op = new SetXAttrOp(client, "/setxattr");
        this.testClientRetryWithFailover(op);
    }

    @Test(timeout=60000L)
    public void testRemoveXAttr() throws Exception {
        DFSClient client = this.genClientWithDummyHandler();
        RemoveXAttrOp op = new RemoveXAttrOp(client, "/removexattr");
        this.testClientRetryWithFailover(op);
    }

    public void testClientRetryWithFailover(final AtMostOnceOp op) throws Exception {
        final ConcurrentHashMap results = new ConcurrentHashMap();
        op.prepare();
        DummyRetryInvocationHandler.block.set(true);
        new Thread(){

            @Override
            public void run() {
                try {
                    op.invoke();
                    Object result = op.getResult();
                    LOG.info("Operation " + op.name + " finished");
                    results.put(op.name, result == null ? "SUCCESS" : result);
                }
                catch (Exception e) {
                    try {
                        LOG.info("Got Exception while calling " + op.name, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{op.client});
                        throw throwable;
                    }
                    IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{op.client});
                }
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{op.client});
            }
        }.start();
        Assert.assertTrue((String)("After waiting the operation " + op.name + " still has not taken effect on NN yet"), (boolean)op.checkNamenodeBeforeReturn());
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        LOG.info("Setting block to false");
        DummyRetryInvocationHandler.block.set(false);
        GenericTestUtils.waitFor(() -> results.containsKey(op.name), (long)5L, (long)10000L);
        LOG.info("Got the result of " + op.name + ": " + results.get(op.name));
        GenericTestUtils.waitFor(() -> !this.cluster.getNamesystem(1).isInStandbyState(), (long)5L, (long)10000L);
        long[] hitsNN = new long[]{0L, 0L};
        GenericTestUtils.waitFor(() -> {
            hitsNN[0] = this.cluster.getNamesystem(0).getRetryCache().getMetricsForTests().getCacheHit();
            hitsNN[1] = this.cluster.getNamesystem(1).getRetryCache().getMetricsForTests().getCacheHit();
            return hitsNN[0] + hitsNN[1] > 0L;
        }, (long)5L, (long)10000L);
        Assert.assertTrue((String)("CacheHit: " + hitsNN[0] + ", " + hitsNN[1]), (hitsNN[0] + hitsNN[1] > 0L ? 1 : 0) != 0);
        long[] updatesNN = new long[]{0L, 0L};
        GenericTestUtils.waitFor(() -> {
            updatesNN[0] = this.cluster.getNamesystem(0).getRetryCache().getMetricsForTests().getCacheUpdated();
            updatesNN[1] = this.cluster.getNamesystem(1).getRetryCache().getMetricsForTests().getCacheUpdated();
            return updatesNN[0] > 0L && updatesNN[1] > 0L;
        }, (long)5L, (long)10000L);
        Assert.assertTrue((String)("CacheUpdated on NN0: " + updatesNN[0]), (updatesNN[0] > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)("CacheUpdated on NN1: " + updatesNN[1]), (updatesNN[1] > 0L ? 1 : 0) != 0);
        long expectedUpdateCount = op.getExpectedCacheUpdateCount();
        if (expectedUpdateCount > 0L) {
            Assert.assertEquals((String)("CacheUpdated on NN0: " + updatesNN[0]), (long)expectedUpdateCount, (long)updatesNN[0]);
            Assert.assertEquals((String)("CacheUpdated on NN0: " + updatesNN[1]), (long)expectedUpdateCount, (long)updatesNN[1]);
        }
    }

    @Test(timeout=60000L)
    public void testListCachePools() throws Exception {
        int poolCount = 7;
        HashSet<String> poolNames = new HashSet<String>(7);
        for (int i = 0; i < 7; ++i) {
            String poolName = "testListCachePools-" + i;
            this.dfs.addCachePool(new CachePoolInfo(poolName));
            poolNames.add(poolName);
        }
        this.listCachePools(poolNames, 0);
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        this.cluster.waitActive(1);
        this.listCachePools(poolNames, 1);
    }

    @Test(timeout=60000L)
    public void testListCacheDirectives() throws Exception {
        int poolCount = 7;
        HashSet<String> poolNames = new HashSet<String>(7);
        Path path = new Path("/p");
        for (int i = 0; i < 7; ++i) {
            String poolName = "testListCacheDirectives-" + i;
            CacheDirectiveInfo directiveInfo = new CacheDirectiveInfo.Builder().setPool(poolName).setPath(path).build();
            this.dfs.addCachePool(new CachePoolInfo(poolName));
            this.dfs.addCacheDirective(directiveInfo, EnumSet.of(CacheFlag.FORCE));
            poolNames.add(poolName);
        }
        this.listCacheDirectives(poolNames, 0);
        this.cluster.transitionToStandby(0);
        this.cluster.transitionToActive(1);
        this.cluster.waitActive(1);
        this.listCacheDirectives(poolNames, 1);
    }

    private void listCachePools(HashSet<String> poolNames, int active) throws Exception {
        HashSet tmpNames = (HashSet)poolNames.clone();
        RemoteIterator pools = this.dfs.listCachePools();
        int poolCount = poolNames.size();
        for (int i = 0; i < poolCount; ++i) {
            CachePoolEntry pool = (CachePoolEntry)pools.next();
            String pollName = pool.getInfo().getPoolName();
            Assert.assertTrue((String)"The pool name should be expected", (boolean)tmpNames.remove(pollName));
            if (i % 2 != 0) continue;
            int standby = active;
            active = standby == 0 ? 1 : 0;
            this.cluster.transitionToStandby(standby);
            this.cluster.transitionToActive(active);
            this.cluster.waitActive(active);
        }
        Assert.assertTrue((String)"All pools must be found", (boolean)tmpNames.isEmpty());
    }

    private void listCacheDirectives(HashSet<String> poolNames, int active) throws Exception {
        HashSet tmpNames = (HashSet)poolNames.clone();
        RemoteIterator directives = this.dfs.listCacheDirectives(null);
        int poolCount = poolNames.size();
        for (int i = 0; i < poolCount; ++i) {
            CacheDirectiveEntry directive = (CacheDirectiveEntry)directives.next();
            String pollName = directive.getInfo().getPool();
            Assert.assertTrue((String)"The pool name should be expected", (boolean)tmpNames.remove(pollName));
            if (i % 2 != 0) continue;
            int standby = active;
            active = standby == 0 ? 1 : 0;
            this.cluster.transitionToStandby(standby);
            this.cluster.transitionToActive(active);
            this.cluster.waitActive(active);
        }
        Assert.assertTrue((String)"All pools must be found", (boolean)tmpNames.isEmpty());
    }

    class RemoveXAttrOp
    extends AtMostOnceOp {
        private final String src;

        RemoveXAttrOp(DFSClient client, String src) {
            super("removeXAttr", client);
            this.src = src;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.src);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                ++this.expectedUpdateCount;
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, DataNodes, 0L);
                ++this.expectedUpdateCount;
                this.client.setXAttr(this.src, "user.key", "value".getBytes(), EnumSet.of(XAttrSetFlag.CREATE));
            }
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.removeXAttr(this.src, "user.key");
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                Map iter = TestRetryCacheWithHA.this.dfs.getXAttrs(new Path(this.src));
                Set keySet = iter.keySet();
                if (!keySet.contains("user.key")) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class SetXAttrOp
    extends AtMostOnceOp {
        private final String src;

        SetXAttrOp(DFSClient client, String src) {
            super("setXAttr", client);
            this.src = src;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.src);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                ++this.expectedUpdateCount;
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.setXAttr(this.src, "user.key", "value".getBytes(), EnumSet.of(XAttrSetFlag.CREATE));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                Map iter = TestRetryCacheWithHA.this.dfs.getXAttrs(new Path(this.src));
                Set keySet = iter.keySet();
                if (keySet.contains("user.key")) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class RemoveCachePoolOp
    extends AtMostOnceOp {
        private final String pool;

        RemoveCachePoolOp(DFSClient client, String pool) {
            super("removeCachePool", client);
            this.pool = pool;
        }

        @Override
        void prepare() throws Exception {
            ++this.expectedUpdateCount;
            this.client.addCachePool(new CachePoolInfo(this.pool));
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.removeCachePool(this.pool);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCachePools();
                if (!iter.hasNext()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class ModifyCachePoolOp
    extends AtMostOnceOp {
        final String pool;

        ModifyCachePoolOp(DFSClient client, String pool) {
            super("modifyCachePool", client);
            this.pool = pool;
        }

        @Override
        void prepare() throws Exception {
            ++this.expectedUpdateCount;
            this.client.addCachePool(new CachePoolInfo(this.pool).setLimit(Long.valueOf(10L)));
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.modifyCachePool(new CachePoolInfo(this.pool).setLimit(Long.valueOf(99L)));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCachePools();
                if (iter.hasNext() && ((CachePoolEntry)iter.next()).getInfo().getLimit() == 99L) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class AddCachePoolOp
    extends AtMostOnceOp {
        private final String pool;

        AddCachePoolOp(DFSClient client, String pool) {
            super("addCachePool", client);
            this.pool = pool;
        }

        @Override
        void prepare() throws Exception {
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.addCachePool(new CachePoolInfo(this.pool));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCachePools();
                if (iter.hasNext()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class RemoveCacheDirectiveInfoOp
    extends AtMostOnceOp {
        private final CacheDirectiveInfo directive;
        private long id;

        RemoveCacheDirectiveInfoOp(DFSClient client, String pool, String path) {
            super("removeCacheDirective", client);
            this.directive = new CacheDirectiveInfo.Builder().setPool(pool).setPath(new Path(path)).build();
        }

        @Override
        void prepare() throws Exception {
            ++this.expectedUpdateCount;
            TestRetryCacheWithHA.this.dfs.addCachePool(new CachePoolInfo(this.directive.getPool()));
            ++this.expectedUpdateCount;
            this.id = TestRetryCacheWithHA.this.dfs.addCacheDirective(this.directive, EnumSet.of(CacheFlag.FORCE));
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.removeCacheDirective(this.id);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool(this.directive.getPool()).setPath(this.directive.getPath()).build());
                if (!iter.hasNext()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class ModifyCacheDirectiveInfoOp
    extends AtMostOnceOp {
        private final CacheDirectiveInfo directive;
        private final short newReplication;
        private long id;

        ModifyCacheDirectiveInfoOp(DFSClient client, CacheDirectiveInfo directive, short newReplication) {
            super("modifyCacheDirective", client);
            this.directive = directive;
            this.newReplication = newReplication;
        }

        @Override
        void prepare() throws Exception {
            ++this.expectedUpdateCount;
            TestRetryCacheWithHA.this.dfs.addCachePool(new CachePoolInfo(this.directive.getPool()));
            ++this.expectedUpdateCount;
            this.id = this.client.addCacheDirective(this.directive, EnumSet.of(CacheFlag.FORCE));
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.modifyCacheDirective(new CacheDirectiveInfo.Builder().setId(Long.valueOf(this.id)).setReplication(Short.valueOf(this.newReplication)).build(), EnumSet.of(CacheFlag.FORCE));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool(this.directive.getPool()).setPath(this.directive.getPath()).build());
                while (iter.hasNext()) {
                    CacheDirectiveInfo result = ((CacheDirectiveEntry)iter.next()).getInfo();
                    if (result.getId() != this.id || result.getReplication() != this.newReplication) continue;
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class AddCacheDirectiveInfoOp
    extends AtMostOnceOp {
        private final CacheDirectiveInfo directive;
        private Long result;

        AddCacheDirectiveInfoOp(DFSClient client, CacheDirectiveInfo directive) {
            super("addCacheDirective", client);
            this.directive = directive;
        }

        @Override
        void prepare() throws Exception {
            ++this.expectedUpdateCount;
            TestRetryCacheWithHA.this.dfs.addCachePool(new CachePoolInfo(this.directive.getPool()));
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.result = this.client.addCacheDirective(this.directive, EnumSet.of(CacheFlag.FORCE));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            for (int i = 0; i < 10; ++i) {
                RemoteIterator iter = TestRetryCacheWithHA.this.dfs.listCacheDirectives(new CacheDirectiveInfo.Builder().setPool(this.directive.getPool()).setPath(this.directive.getPath()).build());
                if (iter.hasNext()) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        @Override
        Object getResult() {
            return this.result;
        }
    }

    class UpdatePipelineOp
    extends AtMostOnceOp {
        private final String file;
        private ExtendedBlock oldBlock;
        private ExtendedBlock newBlock;
        private DatanodeInfo[] nodes;
        private FSDataOutputStream out;

        public UpdatePipelineOp(DFSClient client, String file) {
            super("updatePipeline", client);
            this.file = file;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.file);
            DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, DataNodes, 0L);
            this.out = this.client.append(this.file, 1024, EnumSet.of(CreateFlag.APPEND), null, null);
            byte[] appendContent = new byte[100];
            new Random().nextBytes(appendContent);
            this.out.write(appendContent);
            ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
            LocatedBlocks blks = TestRetryCacheWithHA.this.dfs.getClient().getLocatedBlocks(this.file, 1025L);
            Assert.assertEquals((long)1L, (long)blks.getLocatedBlocks().size());
            this.nodes = blks.get(0).getLocations();
            this.oldBlock = blks.get(0).getBlock();
            LocatedBlock newLbk = this.client.getNamenode().updateBlockForPipeline(this.oldBlock, this.client.getClientName());
            this.newBlock = new ExtendedBlock(this.oldBlock.getBlockPoolId(), this.oldBlock.getBlockId(), this.oldBlock.getNumBytes(), newLbk.getBlock().getGenerationStamp());
        }

        @Override
        void invoke() throws Exception {
            DatanodeInfo[] newNodes = new DatanodeInfo[]{this.nodes[0], this.nodes[1]};
            DatanodeManager dm = TestRetryCacheWithHA.this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager();
            String storageID1 = dm.getDatanode((DatanodeID)newNodes[0]).getStorageInfos()[0].getStorageID();
            String storageID2 = dm.getDatanode((DatanodeID)newNodes[1]).getStorageInfos()[0].getStorageID();
            String[] storageIDs = new String[]{storageID1, storageID2};
            this.client.getNamenode().updatePipeline(this.client.getClientName(), this.oldBlock, this.newBlock, (DatanodeID[])newNodes, storageIDs);
            DFSTestUtil.abortStream((DFSOutputStream)this.out.getWrappedStream());
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            INodeFile fileNode = TestRetryCacheWithHA.this.cluster.getNamesystem(0).getFSDirectory().getINode4Write(this.file).asFile();
            BlockInfo blkUC = fileNode.getBlocks()[1];
            int datanodeNum = blkUC.getUnderConstructionFeature().getExpectedStorageLocations().length;
            for (int i = 0; i < 10 && datanodeNum != 2; ++i) {
                Thread.sleep(1000L);
                datanodeNum = blkUC.getUnderConstructionFeature().getExpectedStorageLocations().length;
            }
            return datanodeNum == 2;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class CreateSymlinkOp
    extends AtMostOnceOp {
        private final String target;
        private final String link;

        public CreateSymlinkOp(DFSClient client, String target, String link) {
            super("createSymlink", client);
            this.target = target;
            this.link = link;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.target);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                ++this.expectedUpdateCount;
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.client.createSymlink(this.target, this.link, false);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path linkPath = new Path(this.link);
            FileStatus linkStatus = null;
            for (int i = 0; i < 10 && linkStatus == null; ++i) {
                try {
                    linkStatus = TestRetryCacheWithHA.this.dfs.getFileLinkStatus(linkPath);
                    continue;
                }
                catch (FileNotFoundException fnf) {
                    Thread.sleep(1000L);
                }
            }
            return linkStatus != null;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class DeleteOp
    extends AtMostOnceOp {
        private final String target;
        private boolean deleted;

        DeleteOp(DFSClient client, String target) {
            super("delete", client);
            this.target = target;
        }

        @Override
        void prepare() throws Exception {
            Path p = new Path(this.target);
            if (!TestRetryCacheWithHA.this.dfs.exists(p)) {
                ++this.expectedUpdateCount;
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, p, 1024L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            ++this.expectedUpdateCount;
            this.deleted = this.client.delete(this.target, true);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.target);
            boolean del = !TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !del; ++i) {
                Thread.sleep(1000L);
                del = !TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return del;
        }

        @Override
        Object getResult() {
            return new Boolean(this.deleted);
        }
    }

    class ConcatOp
    extends AtMostOnceOp {
        private final String target;
        private final String[] srcs;
        private final Path[] srcPaths;

        ConcatOp(DFSClient client, Path target, int numSrc) {
            super("concat", client);
            this.target = target.toString();
            this.srcs = new String[numSrc];
            this.srcPaths = new Path[numSrc];
            Path parent = target.getParent();
            for (int i = 0; i < numSrc; ++i) {
                this.srcPaths[i] = new Path(parent, "srcfile" + i);
                this.srcs[i] = this.srcPaths[i].toString();
            }
        }

        @Override
        void prepare() throws Exception {
            Path targetPath = new Path(this.target);
            DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, targetPath, 1024L, DataNodes, 0L);
            for (int i = 0; i < this.srcPaths.length; ++i) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, this.srcPaths[i], 1024L, DataNodes, 0L);
            }
            Assert.assertEquals((long)1024L, (long)TestRetryCacheWithHA.this.dfs.getFileStatus(targetPath).getLen());
        }

        @Override
        void invoke() throws Exception {
            this.client.concat(this.target, this.srcs);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.target);
            boolean done = TestRetryCacheWithHA.this.dfs.getFileStatus(targetPath).getLen() == (long)(1024 * (this.srcs.length + 1));
            for (int i = 0; i < 10 && !done; ++i) {
                Thread.sleep(1000L);
                done = TestRetryCacheWithHA.this.dfs.getFileStatus(targetPath).getLen() == (long)(1024 * (this.srcs.length + 1));
            }
            return done;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class Rename2Op
    extends AtMostOnceOp {
        private final String oldName;
        private final String newName;

        Rename2Op(DFSClient client, String oldName, String newName) {
            super("rename2", client);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.rename(this.oldName, this.newName, new Options.Rename[]{Options.Rename.OVERWRITE});
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.newName);
            boolean renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !renamed; ++i) {
                Thread.sleep(1000L);
                renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return renamed;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class RenameOp
    extends AtMostOnceOp {
        private final String oldName;
        private final String newName;
        private boolean renamed;

        RenameOp(DFSClient client, String oldName, String newName) {
            super("rename", client);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 1024L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.renamed = this.client.rename(this.oldName, this.newName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path targetPath = new Path(this.newName);
            boolean renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            for (int i = 0; i < 10 && !renamed; ++i) {
                Thread.sleep(1000L);
                renamed = TestRetryCacheWithHA.this.dfs.exists(targetPath);
            }
            return renamed;
        }

        @Override
        Object getResult() {
            return new Boolean(this.renamed);
        }
    }

    class AppendOp
    extends AtMostOnceOp {
        private final String fileName;
        private LastBlockWithStatus lbk;

        AppendOp(DFSClient client, String fileName) {
            super("append", client);
            this.fileName = fileName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.fileName);
            if (!TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                DFSTestUtil.createFile((FileSystem)TestRetryCacheWithHA.this.dfs, filePath, 512L, DataNodes, 0L);
            }
        }

        @Override
        void invoke() throws Exception {
            this.lbk = this.client.getNamenode().append(this.fileName, this.client.getClientName(), new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            INodeFile fileNode = TestRetryCacheWithHA.this.cluster.getNameNode(0).getNamesystem().getFSDirectory().getINode4Write(this.fileName).asFile();
            boolean fileIsUC = fileNode.isUnderConstruction();
            for (int i = 0; i < 10 && !fileIsUC; ++i) {
                Thread.sleep(1000L);
                fileNode = TestRetryCacheWithHA.this.cluster.getNameNode(0).getNamesystem().getFSDirectory().getINode4Write(this.fileName).asFile();
                fileIsUC = fileNode.isUnderConstruction();
            }
            return fileIsUC;
        }

        @Override
        Object getResult() {
            return this.lbk;
        }
    }

    class CreateOp
    extends AtMostOnceOp {
        private final String fileName;
        private HdfsFileStatus status;

        CreateOp(DFSClient client, String fileName) {
            super("create", client);
            this.fileName = fileName;
        }

        @Override
        void prepare() throws Exception {
            Path filePath = new Path(this.fileName);
            if (TestRetryCacheWithHA.this.dfs.exists(filePath)) {
                TestRetryCacheWithHA.this.dfs.delete(filePath, true);
            }
            Path fileParent = filePath.getParent();
            if (!TestRetryCacheWithHA.this.dfs.exists(fileParent)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(fileParent);
            }
        }

        @Override
        void invoke() throws Exception {
            EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
            this.status = this.client.getNamenode().create(this.fileName, FsPermission.getFileDefault(), this.client.getClientName(), new EnumSetWritable(createFlag), false, DataNodes, 1024L, new CryptoProtocolVersion[]{CryptoProtocolVersion.ENCRYPTION_ZONES}, null, null);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path filePath = new Path(this.fileName);
            boolean fileCreated = TestRetryCacheWithHA.this.dfs.exists(filePath);
            for (int i = 0; i < 10 && !fileCreated; ++i) {
                Thread.sleep(1000L);
                fileCreated = TestRetryCacheWithHA.this.dfs.exists(filePath);
            }
            return fileCreated;
        }

        @Override
        Object getResult() {
            return this.status;
        }
    }

    class RenameSnapshotOp
    extends AtMostOnceOp {
        private final String dir;
        private final String oldName;
        private final String newName;

        RenameSnapshotOp(DFSClient client, String dir, String oldName, String newName) {
            super("renameSnapshot", client);
            this.dir = dir;
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
            }
            Path sPath = SnapshotTestHelper.getSnapshotRoot(dirPath, this.oldName);
            if (!TestRetryCacheWithHA.this.dfs.exists(sPath)) {
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
                TestRetryCacheWithHA.this.dfs.createSnapshot(dirPath, this.oldName);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.renameSnapshot(this.dir, this.oldName, this.newName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.newName);
            boolean snapshotRenamed = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && !snapshotRenamed; ++i) {
                Thread.sleep(1000L);
                snapshotRenamed = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return snapshotRenamed;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class DeleteSnapshotOp
    extends AtMostOnceOp {
        private final String dir;
        private final String snapshotName;

        DeleteSnapshotOp(DFSClient client, String dir, String snapshotName) {
            super("deleteSnapshot", client);
            this.dir = dir;
            this.snapshotName = snapshotName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
            }
            Path sPath = SnapshotTestHelper.getSnapshotRoot(dirPath, this.snapshotName);
            if (!TestRetryCacheWithHA.this.dfs.exists(sPath)) {
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
                TestRetryCacheWithHA.this.dfs.createSnapshot(dirPath, this.snapshotName);
            }
        }

        @Override
        void invoke() throws Exception {
            this.client.deleteSnapshot(this.dir, this.snapshotName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.snapshotName);
            boolean snapshotNotDeleted = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && snapshotNotDeleted; ++i) {
                Thread.sleep(1000L);
                snapshotNotDeleted = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return !snapshotNotDeleted;
        }

        @Override
        Object getResult() {
            return null;
        }
    }

    class CreateSnapshotOp
    extends AtMostOnceOp {
        private String snapshotPath;
        private final String dir;
        private final String snapshotName;

        CreateSnapshotOp(DFSClient client, String dir, String snapshotName) {
            super("createSnapshot", client);
            this.dir = dir;
            this.snapshotName = snapshotName;
        }

        @Override
        void prepare() throws Exception {
            Path dirPath = new Path(this.dir);
            if (!TestRetryCacheWithHA.this.dfs.exists(dirPath)) {
                TestRetryCacheWithHA.this.dfs.mkdirs(dirPath);
                TestRetryCacheWithHA.this.dfs.allowSnapshot(dirPath);
            }
        }

        @Override
        void invoke() throws Exception {
            this.snapshotPath = this.client.createSnapshot(this.dir, this.snapshotName);
        }

        @Override
        boolean checkNamenodeBeforeReturn() throws Exception {
            Path sPath = SnapshotTestHelper.getSnapshotRoot(new Path(this.dir), this.snapshotName);
            boolean snapshotCreated = TestRetryCacheWithHA.this.dfs.exists(sPath);
            for (int i = 0; i < 10 && !snapshotCreated; ++i) {
                Thread.sleep(1000L);
                snapshotCreated = TestRetryCacheWithHA.this.dfs.exists(sPath);
            }
            return snapshotCreated;
        }

        @Override
        Object getResult() {
            return this.snapshotPath;
        }
    }

    abstract class AtMostOnceOp {
        private final String name;
        final DFSClient client;
        int expectedUpdateCount = 0;

        AtMostOnceOp(String name, DFSClient client) {
            this.name = name;
            this.client = client;
        }

        abstract void prepare() throws Exception;

        abstract void invoke() throws Exception;

        abstract boolean checkNamenodeBeforeReturn() throws Exception;

        abstract Object getResult();

        int getExpectedCacheUpdateCount() {
            return this.expectedUpdateCount;
        }
    }

    private static class DummyRetryInvocationHandler
    extends RetryInvocationHandler<ClientProtocol> {
        static final AtomicBoolean block = new AtomicBoolean(false);

        DummyRetryInvocationHandler(FailoverProxyProvider<ClientProtocol> proxyProvider, RetryPolicy retryPolicy) {
            super(proxyProvider, retryPolicy);
        }

        protected Object invokeMethod(Method method, Object[] args) throws Throwable {
            Object result = super.invokeMethod(method, args);
            if (block.get()) {
                throw new UnknownHostException("Fake Exception");
            }
            return result;
        }
    }
}

