/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi;

import java.io.IOException;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTConfiguration;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectInputNoShared;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutput;
import org.apache.hadoop.shaded.org.nustaq.serialization.FSTObjectOutputNoShared;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTBufferTooSmallException;
import org.apache.hadoop.shaded.org.nustaq.serialization.simpleapi.FSTCoder;
import org.apache.hadoop.shaded.org.nustaq.serialization.util.FSTUtil;

public class DefaultCoder
implements FSTCoder {
    protected FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();
    FSTObjectInput input;
    FSTObjectOutput output;

    public DefaultCoder(boolean shared, Class ... toPreRegister) {
        this.conf.setShareReferences(shared);
        if (toPreRegister != null && toPreRegister.length > 0) {
            this.conf.registerClass(toPreRegister);
        }
        if (shared) {
            this.input = new FSTObjectInput(this.conf);
            this.output = new FSTObjectOutput(this.conf);
        } else {
            this.input = new FSTObjectInputNoShared(this.conf);
            this.output = new FSTObjectOutputNoShared(this.conf);
        }
    }

    public DefaultCoder(Class ... preregister) {
        this(true, preregister);
    }

    public DefaultCoder() {
        this(true, new Class[0]);
    }

    @Override
    public int toByteArray(Object obj, byte[] result, int resultOffset, int avaiableSize) {
        this.output.resetForReUse();
        try {
            this.output.writeObject(obj);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        int written = this.output.getWritten();
        if (written > avaiableSize) {
            throw FSTBufferTooSmallException.Instance;
        }
        System.arraycopy(this.output.getBuffer(), 0, result, resultOffset, written);
        return written;
    }

    @Override
    public byte[] toByteArray(Object o) {
        this.output.resetForReUse();
        try {
            this.output.writeObject(o);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        return this.output.getCopyOfWrittenBuffer();
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }

    @Override
    public Object toObject(byte[] arr, int off, int len) {
        try {
            if (off == 0) {
                this.input.resetForReuseUseArray(arr);
            } else {
                this.input.resetForReuseCopyArray(arr, off, len);
            }
            return this.input.readObject();
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    @Override
    public Object toObject(byte[] arr) {
        return this.toObject(arr, 0, arr.length);
    }
}

