/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.AbstractTransformer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.Attribute;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;

public class StringDecoder
extends AbstractTransformer<Buffer, String> {
    private static final Logger logger = Grizzly.logger(StringDecoder.class);
    protected Charset charset;
    protected final Attribute<Integer> lengthAttribute;
    protected byte[] stringTerminateBytes = null;

    public StringDecoder() {
        this(null, null);
    }

    public StringDecoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), stringTerminator);
    }

    public StringDecoder(Charset charset) {
        this(charset, null);
    }

    public StringDecoder(Charset charset, String stringTerminator) {
        this.charset = charset != null ? charset : Charset.defaultCharset();
        if (stringTerminator != null) {
            try {
                this.stringTerminateBytes = stringTerminator.getBytes(this.charset.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.lengthAttribute = this.attributeBuilder.createAttribute("StringDecoder.StringSize");
    }

    @Override
    public String getName() {
        return "StringDecoder";
    }

    @Override
    protected TransformationResult<Buffer, String> transformImpl(AttributeStorage storage, Buffer input) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input could not be null");
        }
        TransformationResult<Buffer, String> result = this.stringTerminateBytes == null ? this.parseWithLengthPrefix(storage, input) : this.parseWithTerminatingSeq(storage, input);
        return result;
    }

    protected TransformationResult<Buffer, String> parseWithLengthPrefix(AttributeStorage storage, Buffer input) {
        Integer stringSize = this.lengthAttribute.get(storage);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "StringDecoder decode stringSize={0} buffer={1} content={2}", new Object[]{stringSize, input, input.toStringContent()});
        }
        if (stringSize == null) {
            if (input.remaining() < 4) {
                return TransformationResult.createIncompletedResult(input);
            }
            stringSize = input.getInt();
            this.lengthAttribute.set(storage, stringSize);
        }
        if (input.remaining() < stringSize) {
            return TransformationResult.createIncompletedResult(input);
        }
        int tmpLimit = input.limit();
        input.limit(input.position() + stringSize);
        String stringMessage = input.toStringContent(this.charset);
        input.position(input.limit());
        input.limit(tmpLimit);
        return TransformationResult.createCompletedResult(stringMessage, input);
    }

    protected TransformationResult<Buffer, String> parseWithTerminatingSeq(AttributeStorage storage, Buffer input) {
        int terminationBytesLength = this.stringTerminateBytes.length;
        int checkIndex = 0;
        int termIndex = -1;
        Integer offsetInt = this.lengthAttribute.get(storage);
        int offset = 0;
        if (offsetInt != null) {
            offset = offsetInt;
        }
        for (int i = input.position() + offset; i < input.limit(); ++i) {
            if (input.get(i) != this.stringTerminateBytes[checkIndex] || ++checkIndex < terminationBytesLength) continue;
            termIndex = i - terminationBytesLength + 1;
            break;
        }
        if (termIndex >= 0) {
            int tmpLimit = input.limit();
            input.limit(termIndex);
            String stringMessage = input.toStringContent(this.charset);
            input.limit(tmpLimit);
            input.position(termIndex + terminationBytesLength);
            return TransformationResult.createCompletedResult(stringMessage, input);
        }
        offset = input.remaining() - terminationBytesLength;
        if (offset < 0) {
            offset = 0;
        }
        this.lengthAttribute.set(storage, (Integer)offset);
        return TransformationResult.createIncompletedResult(input);
    }

    @Override
    public void release(AttributeStorage storage) {
        this.lengthAttribute.remove(storage);
        super.release(storage);
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input != null && input.hasRemaining();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

