/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.config.builders;

import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.org.ehcache.config.Builder;
import org.apache.hadoop.shaded.org.ehcache.expiry.ExpiryPolicy;

public final class ExpiryPolicyBuilder<K, V>
implements Builder<ExpiryPolicy<K, V>> {
    private final BiFunction<? super K, ? super V, Duration> create;
    private final BiFunction<? super K, ? super Supplier<? extends V>, Duration> access;
    private final TriFunction<? super K, ? super Supplier<? extends V>, ? super V, Duration> update;

    public static ExpiryPolicy<Object, Object> noExpiration() {
        return ExpiryPolicy.NO_EXPIRY;
    }

    public static ExpiryPolicy<Object, Object> timeToLiveExpiration(Duration timeToLive) {
        Objects.requireNonNull(timeToLive, "TTL duration cannot be null");
        if (timeToLive.isNegative()) {
            throw new IllegalArgumentException("TTL duration cannot be negative");
        }
        return new TimeToLiveExpiryPolicy(timeToLive);
    }

    public static ExpiryPolicy<Object, Object> timeToIdleExpiration(Duration timeToIdle) {
        Objects.requireNonNull(timeToIdle, "TTI duration cannot be null");
        if (timeToIdle.isNegative()) {
            throw new IllegalArgumentException("TTI duration cannot be negative");
        }
        return new TimeToIdleExpiryPolicy(timeToIdle);
    }

    public static ExpiryPolicyBuilder<Object, Object> expiry() {
        return new ExpiryPolicyBuilder<Object, Object>();
    }

    private ExpiryPolicyBuilder() {
        this((k, v) -> ExpiryPolicy.INFINITE, (k, v) -> null, (k, oldV, newV) -> null);
    }

    private ExpiryPolicyBuilder(BiFunction<? super K, ? super V, Duration> create, BiFunction<? super K, ? super Supplier<? extends V>, Duration> access, TriFunction<? super K, ? super Supplier<? extends V>, ? super V, Duration> update) {
        this.create = create;
        this.access = access;
        this.update = update;
    }

    public ExpiryPolicyBuilder<K, V> create(Duration create) {
        Objects.requireNonNull(create, "Create duration cannot be null");
        if (create.isNegative()) {
            throw new IllegalArgumentException("Create duration must be positive");
        }
        return this.create((K2 a, V2 b) -> create);
    }

    public <K2 extends K, V2 extends V> ExpiryPolicyBuilder<K2, V2> create(BiFunction<K2, V2, Duration> create) {
        return new ExpiryPolicyBuilder<K, V>(Objects.requireNonNull(create), this.access, this.update);
    }

    public ExpiryPolicyBuilder<K, V> access(Duration access) {
        if (access != null && access.isNegative()) {
            throw new IllegalArgumentException("Access duration must be positive");
        }
        return this.access((K2 a, Supplier<? extends V2> b) -> access);
    }

    public <K2 extends K, V2 extends V> ExpiryPolicyBuilder<K2, V2> access(BiFunction<K2, Supplier<? extends V2>, Duration> access) {
        return new ExpiryPolicyBuilder<K, V>(this.create, Objects.requireNonNull(access), this.update);
    }

    public ExpiryPolicyBuilder<K, V> update(Duration update) {
        if (update != null && update.isNegative()) {
            throw new IllegalArgumentException("Update duration must be positive");
        }
        return this.update((K2 a, Supplier<? extends V2> b, V2 c) -> update);
    }

    public <K2 extends K, V2 extends V> ExpiryPolicyBuilder<K2, V2> update(TriFunction<K2, Supplier<? extends V2>, V2, Duration> update) {
        return new ExpiryPolicyBuilder<K, V2>(this.create, this.access, Objects.requireNonNull(update));
    }

    @Override
    public ExpiryPolicy<K, V> build() {
        return new BaseExpiryPolicy<K, V>(this.create, this.access, this.update);
    }

    private static final class TimeToIdleExpiryPolicy
    extends BaseExpiryPolicy<Object, Object> {
        private final Duration tti;

        TimeToIdleExpiryPolicy(Duration tti) {
            super((a, b) -> tti, (a, b) -> tti, (a, b, c) -> tti);
            this.tti = tti;
        }

        public int hashCode() {
            return this.tti.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TimeToIdleExpiryPolicy && this.tti.equals(((TimeToIdleExpiryPolicy)obj).tti);
        }

        public String toString() {
            return "TTI of " + this.tti;
        }
    }

    private static final class TimeToLiveExpiryPolicy
    extends BaseExpiryPolicy<Object, Object> {
        private final Duration ttl;

        TimeToLiveExpiryPolicy(Duration ttl) {
            super((a, b) -> ttl, (a, b) -> null, (a, b, c) -> ttl);
            this.ttl = ttl;
        }

        public int hashCode() {
            return this.ttl.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TimeToLiveExpiryPolicy && this.ttl.equals(((TimeToLiveExpiryPolicy)obj).ttl);
        }

        public String toString() {
            return "TTL of " + this.ttl;
        }
    }

    private static class BaseExpiryPolicy<K, V>
    implements ExpiryPolicy<K, V> {
        private final BiFunction<? super K, ? super V, Duration> create;
        private final BiFunction<? super K, ? super Supplier<? extends V>, Duration> access;
        private final TriFunction<? super K, ? super Supplier<? extends V>, ? super V, Duration> update;

        BaseExpiryPolicy(BiFunction<? super K, ? super V, Duration> create, BiFunction<? super K, ? super Supplier<? extends V>, Duration> access, TriFunction<? super K, ? super Supplier<? extends V>, ? super V, Duration> update) {
            this.create = create;
            this.access = access;
            this.update = update;
        }

        @Override
        public Duration getExpiryForCreation(K key, V value) {
            return this.create.apply(key, value);
        }

        @Override
        public Duration getExpiryForAccess(K key, Supplier<? extends V> value) {
            return this.access.apply(key, value);
        }

        @Override
        public Duration getExpiryForUpdate(K key, Supplier<? extends V> oldValue, V newValue) {
            return this.update.apply(key, oldValue, newValue);
        }
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

